/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class AmqpAnyCastDistinctQueueTest
extends AmqpClientTestSupport {
    @Override
    protected void addAdditionalAcceptors(ActiveMQServer server) throws Exception {
    }

    @Test
    @Timeout(value=60L)
    public void testDistinctQueueAddressAnyCast() throws Exception {
        String ADDRESS_NAME = "DISTINCT_ADDRESS_testDistinctAddressAnyCast";
        String QUEUE_NAME = "DISTINCT_QUEUE_testDistinctQUEUE_AnyCast";
        this.server.addAddressInfo(new AddressInfo(ADDRESS_NAME).setAutoCreated(false).addRoutingType(RoutingType.ANYCAST));
        this.server.createQueue(QueueConfiguration.of((String)QUEUE_NAME).setAddress(ADDRESS_NAME).setDurable(Boolean.valueOf(true)).setRoutingType(RoutingType.ANYCAST));
        int NUMBER_OF_MESSAGES = 100;
        ConnectionFactory jmsCF = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
        try (Connection connection = jmsCF.createConnection();){
            Session session = connection.createSession();
            Queue queueSending = session.createQueue(ADDRESS_NAME);
            MessageProducer producer = session.createProducer((Destination)queueSending);
            for (int i = 0; i < 100; ++i) {
                producer.send((Message)session.createTextMessage("hello " + i));
            }
            Queue queueReceiving = session.createQueue(QUEUE_NAME);
            connection.start();
            MessageConsumer consumer = session.createConsumer((Destination)queueReceiving);
            for (int i = 0; i < 100; ++i) {
                TextMessage message = (TextMessage)consumer.receive(5000L);
                Assertions.assertNotNull((Object)message);
                Assertions.assertEquals((Object)("hello " + i), (Object)message.getText());
            }
            Assertions.assertNull((Object)consumer.receiveNoWait());
        }
    }
}

