/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.transport.amqp.AmqpSupport;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpFrameValidator;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSender;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.DescribedType;
import org.apache.qpid.proton.amqp.messaging.Source;
import org.apache.qpid.proton.amqp.messaging.TerminusDurability;
import org.apache.qpid.proton.amqp.messaging.TerminusExpiryPolicy;
import org.apache.qpid.proton.amqp.transport.Detach;
import org.apache.qpid.proton.engine.Receiver;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpDurableReceiverTest
extends AmqpClientTestSupport {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final String SELECTOR_STRING = "color = red";

    @Test
    @Timeout(value=60L)
    public void testCreateDurableReceiver() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.createConnection());
        connection.setContainerId(this.getContainerID());
        connection.connect();
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createDurableReceiver(this.getTopicName(), this.getSubscriptionName());
        receiver.flow(1);
        Assertions.assertEquals((Object)this.getTopicName(), (Object)this.lookupSubscription());
        AmqpSender sender = session.createSender(this.getTopicName());
        AmqpMessage message = new AmqpMessage();
        message.setMessageId("message:1");
        sender.send(message);
        message = receiver.receive(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)message);
        connection.close();
        Assertions.assertEquals((Object)this.getTopicName(), (Object)this.lookupSubscription());
    }

    @Test
    @Timeout(value=60L)
    public void testDetachedDurableReceiverRemainsActive() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.createConnection());
        connection.setContainerId(this.getContainerID());
        connection.connect();
        connection.setReceivedFrameInspector(new AmqpFrameValidator(){

            @Override
            public void inspectDetach(Detach detach, Binary encoded) {
                if (detach.getClosed()) {
                    this.markAsInvalid("Remote should have detached but closed instead.");
                }
            }
        });
        connection.setSentFrameInspector(new AmqpFrameValidator(){

            @Override
            public void inspectDetach(Detach detach, Binary encoded) {
                if (detach.getClosed()) {
                    this.markAsInvalid("Client should have detached but closed instead.");
                }
            }
        });
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createDurableReceiver(this.getTopicName(), this.getSubscriptionName());
        Assertions.assertEquals((Object)this.getTopicName(), (Object)this.lookupSubscription());
        receiver.detach();
        Assertions.assertEquals((Object)this.getTopicName(), (Object)this.lookupSubscription());
        connection.getSentFrameInspector().assertValid();
        connection.getReceivedFrameInspector().assertValid();
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testCloseDurableReceiverRemovesSubscription() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.createConnection());
        connection.setContainerId(this.getContainerID());
        connection.connect();
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createDurableReceiver(this.getTopicName(), this.getSubscriptionName());
        Assertions.assertEquals((Object)this.getTopicName(), (Object)this.lookupSubscription());
        receiver.close();
        Assertions.assertNull((Object)this.lookupSubscription());
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testReattachToDurableNode() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.createConnection());
        connection.setContainerId(this.getContainerID());
        connection.connect();
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createDurableReceiver(this.getTopicName(), this.getSubscriptionName());
        receiver.detach();
        receiver = session.createDurableReceiver(this.getTopicName(), this.getSubscriptionName());
        receiver.close();
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testLookupExistingSubscription() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.createConnection());
        connection.setContainerId(this.getContainerID());
        connection.connect();
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createDurableReceiver(this.getTopicName(), this.getSubscriptionName());
        receiver.detach();
        receiver = session.lookupSubscription(this.getSubscriptionName());
        Assertions.assertNotNull((Object)receiver);
        Receiver protonReceiver = receiver.getReceiver();
        Assertions.assertNotNull((Object)protonReceiver.getRemoteSource());
        Source remoteSource = (Source)protonReceiver.getRemoteSource();
        if (remoteSource.getFilter() != null) {
            Assertions.assertFalse((boolean)remoteSource.getFilter().containsKey(AmqpSupport.NO_LOCAL_NAME));
            Assertions.assertFalse((boolean)remoteSource.getFilter().containsKey(AmqpSupport.JMS_SELECTOR_NAME));
        }
        Assertions.assertEquals((Object)TerminusExpiryPolicy.NEVER, (Object)remoteSource.getExpiryPolicy());
        Assertions.assertEquals((Object)TerminusDurability.UNSETTLED_STATE, (Object)remoteSource.getDurable());
        Assertions.assertEquals((Object)AmqpSupport.COPY, (Object)remoteSource.getDistributionMode());
        receiver.close();
        try {
            receiver = session.lookupSubscription(this.getSubscriptionName());
            Assertions.fail((String)"Should not be able to lookup the subscription");
        }
        catch (Exception exception) {
            // empty catch block
        }
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testLookupExistingSubscriptionWithSelector() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.createConnection());
        connection.setContainerId(this.getContainerID());
        connection.connect();
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createDurableReceiver(this.getTopicName(), this.getSubscriptionName(), "color = red", false);
        receiver.detach();
        receiver = session.lookupSubscription(this.getSubscriptionName());
        Assertions.assertNotNull((Object)receiver);
        Receiver protonReceiver = receiver.getReceiver();
        Assertions.assertNotNull((Object)protonReceiver.getRemoteSource());
        Source remoteSource = (Source)protonReceiver.getRemoteSource();
        Assertions.assertNotNull((Object)remoteSource.getFilter());
        Assertions.assertFalse((boolean)remoteSource.getFilter().containsKey(AmqpSupport.NO_LOCAL_NAME));
        Assertions.assertTrue((boolean)remoteSource.getFilter().containsKey(AmqpSupport.JMS_SELECTOR_NAME));
        String selector = (String)((DescribedType)remoteSource.getFilter().get(AmqpSupport.JMS_SELECTOR_NAME)).getDescribed();
        Assertions.assertEquals((Object)"color = red", (Object)selector);
        Assertions.assertEquals((Object)TerminusExpiryPolicy.NEVER, (Object)remoteSource.getExpiryPolicy());
        Assertions.assertEquals((Object)TerminusDurability.UNSETTLED_STATE, (Object)remoteSource.getDurable());
        Assertions.assertEquals((Object)AmqpSupport.COPY, (Object)remoteSource.getDistributionMode());
        receiver.close();
        try {
            receiver = session.lookupSubscription(this.getSubscriptionName());
            Assertions.fail((String)"Should not be able to lookup the subscription");
        }
        catch (Exception exception) {
            // empty catch block
        }
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testLookupExistingSubscriptionWithNoLocal() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.createConnection());
        connection.setContainerId(this.getContainerID());
        connection.connect();
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createDurableReceiver(this.getTopicName(), this.getSubscriptionName(), null, true);
        receiver.detach();
        receiver = session.lookupSubscription(this.getSubscriptionName());
        Assertions.assertNotNull((Object)receiver);
        Receiver protonReceiver = receiver.getReceiver();
        Assertions.assertNotNull((Object)protonReceiver.getRemoteSource());
        Source remoteSource = (Source)protonReceiver.getRemoteSource();
        Assertions.assertNotNull((Object)remoteSource.getFilter());
        Assertions.assertTrue((boolean)remoteSource.getFilter().containsKey(AmqpSupport.NO_LOCAL_NAME));
        Assertions.assertFalse((boolean)remoteSource.getFilter().containsKey(AmqpSupport.JMS_SELECTOR_NAME));
        Assertions.assertEquals((Object)TerminusExpiryPolicy.NEVER, (Object)remoteSource.getExpiryPolicy());
        Assertions.assertEquals((Object)TerminusDurability.UNSETTLED_STATE, (Object)remoteSource.getDurable());
        Assertions.assertEquals((Object)AmqpSupport.COPY, (Object)remoteSource.getDistributionMode());
        receiver.close();
        try {
            receiver = session.lookupSubscription(this.getSubscriptionName());
            Assertions.fail((String)"Should not be able to lookup the subscription");
        }
        catch (Exception exception) {
            // empty catch block
        }
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testLookupExistingSubscriptionWithSelectorAndNoLocal() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.createConnection());
        connection.setContainerId(this.getContainerID());
        connection.connect();
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createDurableReceiver(this.getTopicName(), this.getSubscriptionName(), "color = red", true);
        receiver.detach();
        receiver = session.lookupSubscription(this.getSubscriptionName());
        Assertions.assertNotNull((Object)receiver);
        Receiver protonReceiver = receiver.getReceiver();
        Assertions.assertNotNull((Object)protonReceiver.getRemoteSource());
        Source remoteSource = (Source)protonReceiver.getRemoteSource();
        Assertions.assertNotNull((Object)remoteSource.getFilter());
        Assertions.assertTrue((boolean)remoteSource.getFilter().containsKey(AmqpSupport.NO_LOCAL_NAME));
        Assertions.assertTrue((boolean)remoteSource.getFilter().containsKey(AmqpSupport.JMS_SELECTOR_NAME));
        String selector = (String)((DescribedType)remoteSource.getFilter().get(AmqpSupport.JMS_SELECTOR_NAME)).getDescribed();
        Assertions.assertEquals((Object)"color = red", (Object)selector);
        Assertions.assertEquals((Object)TerminusExpiryPolicy.NEVER, (Object)remoteSource.getExpiryPolicy());
        Assertions.assertEquals((Object)TerminusDurability.UNSETTLED_STATE, (Object)remoteSource.getDurable());
        Assertions.assertEquals((Object)AmqpSupport.COPY, (Object)remoteSource.getDistributionMode());
        receiver.close();
        try {
            receiver = session.lookupSubscription(this.getSubscriptionName());
            Assertions.fail((String)"Should not be able to lookup the subscription");
        }
        catch (Exception exception) {
            // empty catch block
        }
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testLookupNonExistingSubscription() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.createConnection());
        connection.setContainerId(this.getContainerID());
        connection.connect();
        AmqpSession session = connection.createSession();
        try {
            session.lookupSubscription(this.getSubscriptionName());
            Assertions.fail((String)"Should throw an exception since there is not subscription");
        }
        catch (Exception e) {
            logger.debug("Error on lookup: {}", (Object)e.getMessage());
        }
        connection.close();
    }

    public String lookupSubscription() {
        Binding binding = this.server.getPostOffice().getBinding(SimpleString.of((String)(this.getContainerID() + "." + this.getSubscriptionName())));
        if (binding != null) {
            return binding.getAddress().toString();
        }
        return null;
    }

    private String getContainerID() {
        return "myContainerID";
    }

    private String getSubscriptionName() {
        return "mySubscription";
    }
}

