/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSender;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.apache.activemq.transport.amqp.client.AmqpValidator;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.message.impl.MessageImpl;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpMaxFrameSizeTest
extends AmqpClientTestSupport {
    protected static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private boolean maxFrameSizeConfigSet = false;
    private static final int CONFIGURED_FRAME_SIZE = 4321;

    @Override
    protected void configureAMQPAcceptorParameters(Map<String, Object> params) {
        if ("testBrokerAdvertisedConfiguredMaxFrameSize".equals(this.getTestName())) {
            this.maxFrameSizeConfigSet = true;
            params.put("maxFrameSize", 4321);
        }
    }

    @Override
    protected void addConfiguration(ActiveMQServer server) {
        server.getConfiguration().setJournalFileSize(0x200000);
    }

    @Test
    @Timeout(value=60L)
    public void testBrokerAdvertisedDefaultMaxFrameSize() throws Exception {
        Assertions.assertFalse((boolean)this.maxFrameSizeConfigSet, (String)"maxFrameSize should not be explicitly configured");
        AmqpClient client = this.createAmqpClient();
        Assertions.assertNotNull((Object)client);
        client.setValidator(new AmqpValidator(){

            @Override
            public void inspectOpenedResource(Connection connection) {
                int brokerMaxFrameSize = connection.getTransport().getRemoteMaxFrameSize();
                if (brokerMaxFrameSize != 131072) {
                    this.markAsInvalid("Broker did not send the expected max Frame Size");
                }
            }
        });
        try (AmqpConnection connection = this.addConnection(client.connect());){
            Assertions.assertNotNull((Object)connection);
            connection.getStateInspector().assertValid();
        }
    }

    @Test
    @Timeout(value=60L)
    public void testBrokerAdvertisedConfiguredMaxFrameSize() throws Exception {
        Assertions.assertTrue((boolean)this.maxFrameSizeConfigSet, (String)"maxFrameSize should be explicitly configured");
        AmqpClient client = this.createAmqpClient();
        Assertions.assertNotNull((Object)client);
        client.setValidator(new AmqpValidator(){

            @Override
            public void inspectOpenedResource(Connection connection) {
                int brokerMaxFrameSize = connection.getTransport().getRemoteMaxFrameSize();
                if (brokerMaxFrameSize != 4321) {
                    this.markAsInvalid("Broker did not send the expected max Frame Size");
                }
            }
        });
        try (AmqpConnection connection = this.addConnection(client.connect());){
            Assertions.assertNotNull((Object)connection);
            connection.getStateInspector().assertValid();
        }
    }

    @Test
    @Timeout(value=60L)
    public void testManyMultiFrameTransfersWithClientMaxFrameSizeSmallerThanBrokers() throws Exception {
        int clientMaxFrameSize = 1024;
        int brokerMaxFrameSize = 131072;
        int messageSize = 262149;
        Assertions.assertTrue((boolean)true, (String)"Client maxFrameSize should be smaller than brokers");
        this.doManyMultiFrameTransfersTestImpl(1024, 262149, 131072);
    }

    @Test
    @Timeout(value=60L)
    public void testManyMultiFrameTransfersWithClientMaxFrameSizeLargerThanBrokers() throws Exception {
        int clientMaxFrameSize = 262144;
        int brokerMaxFrameSize = 131072;
        int messageSize = 262149;
        Assertions.assertTrue((boolean)true, (String)"Client maxFrameSize should be larger than brokers");
        this.doManyMultiFrameTransfersTestImpl(262144, 262149, 131072);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doManyMultiFrameTransfersTestImpl(int maxFrameSize, int payloadSize, int brokerMaxFrameSize) throws Exception {
        this.server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setDefaultAddressRoutingType(RoutingType.ANYCAST));
        int numMsgs = 200;
        String testQueueName = this.getTestName();
        AmqpClient client = this.createAmqpClient();
        client.setValidator(new AmqpValidator(){

            @Override
            public void inspectOpenedResource(Connection connection) {
                int brokerMaxFrameSize = connection.getTransport().getRemoteMaxFrameSize();
                if (brokerMaxFrameSize != 131072) {
                    this.markAsInvalid("Broker did not send the expected max Frame Size");
                }
            }
        });
        AmqpConnection connection = client.createConnection();
        connection.setMaxFrameSize(maxFrameSize);
        connection.connect();
        this.addConnection(connection);
        try {
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender(testQueueName);
            for (int i = 0; i < numMsgs; ++i) {
                AmqpMessage message = this.createAmqpMessage(payloadSize);
                sender.send(message);
            }
            Wait.assertEquals((int)numMsgs, () -> this.getMessageCount(this.server.getPostOffice(), testQueueName), (long)5000L, (long)10L);
            AmqpReceiver receiver = session.createReceiver(testQueueName);
            receiver.flow(numMsgs);
            for (int i = 1; i <= numMsgs; ++i) {
                AmqpMessage receivedMessage = receiver.receive(5L, TimeUnit.SECONDS);
                Assertions.assertNotNull((Object)receivedMessage, (String)("Did not recieve message " + i));
                this.verifyMessage(receivedMessage, payloadSize);
                logger.trace("received : message {}", (Object)i);
                receivedMessage.accept();
            }
        }
        finally {
            connection.close();
        }
    }

    @Test
    @Timeout(value=60L)
    public void testSingleAndMultiFrameTransferClientMaxFrameSizeSmallerThanBrokers() throws Exception {
        int clientMaxFrameSize = 1024;
        int brokerMaxFrameSize = 131072;
        Assertions.assertTrue((boolean)true, (String)"Client maxFrameSize should be smaller than brokers");
        this.doSingleAndMultiFrameTransferTestImpl(1024, 131072);
    }

    @Test
    @Timeout(value=60L)
    public void testSingleAndMultiFrameTransferWithClientMaxFrameSizeLargerThanBrokers() throws Exception {
        int clientMaxFrameSize = 262144;
        int brokerMaxFrameSize = 131072;
        Assertions.assertTrue((boolean)true, (String)"Client maxFrameSize should be larger than brokers");
        this.doSingleAndMultiFrameTransferTestImpl(262144, 131072);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSingleAndMultiFrameTransferTestImpl(int maxFrameSize, int brokerMaxFrameSize) throws Exception {
        int messageSize1 = 128;
        int messageSize2 = 262149;
        Assertions.assertTrue((128 < maxFrameSize / 2 && 128 < brokerMaxFrameSize / 2 ? 1 : 0) != 0, (String)"messageSize1 should be much smaller than both of the maxFrameSizes");
        Assertions.assertTrue((262149 > maxFrameSize || 262149 > brokerMaxFrameSize ? 1 : 0) != 0, (String)"messageSize2 should be larger than one of the maxFrameSizes");
        this.server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setDefaultAddressRoutingType(RoutingType.ANYCAST));
        String testQueueName = this.getTestName();
        AmqpClient client = this.createAmqpClient();
        client.setValidator(new AmqpValidator(){

            @Override
            public void inspectOpenedResource(Connection connection) {
                int brokerMaxFrameSize = connection.getTransport().getRemoteMaxFrameSize();
                if (brokerMaxFrameSize != 131072) {
                    this.markAsInvalid("Broker did not send the expected max Frame Size");
                }
            }
        });
        AmqpConnection connection = client.createConnection();
        connection.setMaxFrameSize(maxFrameSize);
        connection.connect();
        this.addConnection(connection);
        try {
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender(testQueueName);
            AmqpMessage message1 = this.createAmqpMessage(128);
            AmqpMessage message2 = this.createAmqpMessage(262149);
            sender.send(message1);
            sender.send(message2);
            Wait.assertEquals((int)2, () -> this.getMessageCount(this.server.getPostOffice(), testQueueName), (long)5000L, (long)10L);
            AmqpReceiver receiver = session.createReceiver(testQueueName);
            receiver.flow(2);
            AmqpMessage receivedMessage1 = receiver.receive(5L, TimeUnit.SECONDS);
            Assertions.assertNotNull((Object)receivedMessage1, (String)"Did not recieve message 1");
            this.verifyMessage(receivedMessage1, 128);
            receivedMessage1.accept();
            AmqpMessage receivedMessage2 = receiver.receive(5L, TimeUnit.SECONDS);
            Assertions.assertNotNull((Object)receivedMessage2, (String)"Did not recieve message 2");
            this.verifyMessage(receivedMessage2, 262149);
            receivedMessage2.accept();
        }
        finally {
            connection.close();
        }
    }

    private AmqpMessage createAmqpMessage(int payloadSize) {
        AmqpMessage message = new AmqpMessage();
        byte[] payload = new byte[payloadSize];
        for (int i = 0; i < payload.length; ++i) {
            int offset = i % 7;
            payload[i] = (byte)(48 + offset);
        }
        message.setBytes(payload);
        return message;
    }

    private void verifyMessage(AmqpMessage message, int payloadSize) {
        MessageImpl wrapped = (MessageImpl)message.getWrappedMessage();
        Assertions.assertNotNull((Object)wrapped.getBody(), (String)"Message has no body");
        Assertions.assertTrue((boolean)(wrapped.getBody() instanceof Data), (String)("Unexpected body type: " + wrapped.getBody().getClass()));
        Data data = (Data)wrapped.getBody();
        Binary binary = data.getValue();
        Assertions.assertNotNull((Object)binary, (String)"Data section has no content");
        Assertions.assertEquals((int)payloadSize, (int)binary.getLength(), (String)"Unexpected payload length");
        byte[] binaryContent = binary.getArray();
        int offset = binary.getArrayOffset();
        for (int i = 0; i < payloadSize; ++i) {
            byte expected = (byte)(48 + i % 7);
            Assertions.assertEquals((byte)expected, (byte)binaryContent[i + offset], (String)("Unexpected content at payload index " + i));
        }
    }
}

