/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.apache.qpid.proton.message.Message;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class AmqpReceiverDispositionTest
extends AmqpClientTestSupport {
    @Test
    @Timeout(value=30L)
    public void testReleasedDisposition() throws Exception {
        this.sendMessages(this.getQueueName(), 1);
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver1 = session.createReceiver(this.getQueueName());
        receiver1.flow(1);
        AmqpMessage message = receiver1.receive(5L, TimeUnit.SECONDS);
        AmqpReceiver receiver2 = session.createReceiver(this.getQueueName());
        Assertions.assertNotNull((Object)message, (String)"did not receive message first time");
        Assertions.assertEquals((Object)"MessageID:0", (Object)message.getMessageId());
        Message protonMessage = message.getWrappedMessage();
        Assertions.assertNotNull((Object)protonMessage);
        Assertions.assertEquals((long)0L, (long)protonMessage.getDeliveryCount(), (String)"Unexpected initial value for AMQP delivery-count");
        receiver2.flow(1);
        message.release();
        message = receiver2.receive(10L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)message, (String)"did not receive message again");
        Assertions.assertEquals((Object)"MessageID:0", (Object)message.getMessageId());
        message.accept();
        protonMessage = message.getWrappedMessage();
        Assertions.assertNotNull((Object)protonMessage);
        Assertions.assertEquals((long)0L, (long)protonMessage.getDeliveryCount(), (String)"Unexpected updated value for AMQP delivery-count");
        connection.close();
    }

    @Test
    @Timeout(value=30L)
    public void testRejectedDisposition() throws Exception {
        this.sendMessages(this.getQueueName(), 1);
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver1 = session.createReceiver(this.getQueueName());
        receiver1.flow(1);
        AmqpMessage message = receiver1.receive(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)message, (String)"did not receive message first time");
        Assertions.assertEquals((Object)"MessageID:0", (Object)message.getMessageId());
        Message protonMessage = message.getWrappedMessage();
        Assertions.assertNotNull((Object)protonMessage);
        Assertions.assertEquals((long)0L, (long)protonMessage.getDeliveryCount(), (String)"Unexpected initial value for AMQP delivery-count");
        message.reject();
        receiver1.flow(1);
        message = receiver1.receiveNoWait();
        Assertions.assertNull((Object)message, (String)"Should not receive message again");
        AmqpReceiver receiver2 = session.createReceiver(this.getQueueName());
        receiver2.flow(1);
        Assertions.assertNull((Object)receiver2.receiveNoWait());
        connection.close();
    }

    @Test
    @Timeout(value=30L)
    public void testModifiedDispositionWithDeliveryFailedWithoutUndeliverableHereFieldsSet() throws Exception {
        this.doModifiedDispositionTestImpl(Boolean.TRUE, null);
    }

    @Test
    @Timeout(value=30L)
    public void testModifiedDispositionWithoutDeliveryFailedWithoutUndeliverableHereFieldsSet() throws Exception {
        this.doModifiedDispositionTestImpl(null, null);
    }

    @Test
    @Timeout(value=30L)
    public void testModifiedDispositionWithoutDeliveryFailedWithUndeliverableHereFieldsSet() throws Exception {
        this.doModifiedDispositionTestImpl(null, Boolean.TRUE);
    }

    @Test
    @Timeout(value=30L)
    public void testModifiedDispositionWithDeliveryFailedWithUndeliverableHereFieldsSet() throws Exception {
        this.doModifiedDispositionTestImpl(Boolean.TRUE, Boolean.TRUE);
    }

    private void doModifiedDispositionTestImpl(Boolean deliveryFailed, Boolean undeliverableHere) throws Exception {
        this.sendMessages(this.getQueueName(), 1);
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver1 = session.createReceiver(this.getQueueName());
        receiver1.flow(1);
        AmqpMessage message = receiver1.receive(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)message, (String)"did not receive message first time");
        Message protonMessage = message.getWrappedMessage();
        Assertions.assertNotNull((Object)protonMessage);
        Assertions.assertEquals((long)0L, (long)protonMessage.getDeliveryCount(), (String)"Unexpected initial value for AMQP delivery-count");
        message.modified(deliveryFailed, undeliverableHere);
        if (Boolean.TRUE.equals(undeliverableHere)) {
            receiver1.flow(1);
            message = receiver1.receive(1L, TimeUnit.SECONDS);
            Assertions.assertNull((Object)message, (String)"Should not receive message again");
        }
        AmqpReceiver receiver2 = session.createReceiver(this.getQueueName());
        receiver2.flow(1);
        message = receiver2.receive(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)message, (String)"did not receive message again");
        int expectedDeliveryCount = 0;
        if (Boolean.TRUE.equals(deliveryFailed)) {
            expectedDeliveryCount = 1;
        }
        message.accept();
        Message protonMessage2 = message.getWrappedMessage();
        Assertions.assertNotNull((Object)protonMessage2);
        Assertions.assertEquals((long)expectedDeliveryCount, (long)protonMessage2.getDeliveryCount(), (String)"Unexpected updated value for AMQP delivery-count");
        connection.close();
    }
}

