/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import jakarta.jms.JMSException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.transport.amqp.AmqpSupport;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.apache.activemq.transport.amqp.client.AmqpUnknownFilterType;
import org.apache.activemq.transport.amqp.client.AmqpValidator;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Source;
import org.apache.qpid.proton.amqp.messaging.TerminusDurability;
import org.apache.qpid.proton.amqp.messaging.TerminusExpiryPolicy;
import org.apache.qpid.proton.amqp.transport.ReceiverSettleMode;
import org.apache.qpid.proton.amqp.transport.SenderSettleMode;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.engine.Session;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class AmqpReceiverTest
extends AmqpClientTestSupport {
    @Test
    @Timeout(value=60L)
    public void testCreateQueueReceiver() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        Queue queue = this.getProxyToQueue(this.getQueueName());
        Assertions.assertNotNull((Object)queue);
        receiver.close();
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testCreateTopicReceiver() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createReceiver(this.getTopicName());
        Queue queue = this.getProxyToQueue(this.getQueueName());
        Assertions.assertNotNull((Object)queue);
        receiver.close();
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testCreateQueueReceiverWithNoLocalSet() throws Exception {
        AmqpClient client = this.createAmqpClient();
        client.setValidator(new AmqpValidator(){

            @Override
            public void inspectOpenedResource(Receiver receiver) {
                Source source;
                Map filters;
                if (receiver.getRemoteSource() == null) {
                    this.markAsInvalid("Link opened with null source.");
                }
                if (AmqpSupport.findFilter(filters = (source = (Source)receiver.getRemoteSource()).getFilter(), AmqpSupport.NO_LOCAL_FILTER_IDS) != null) {
                    this.markAsInvalid("Broker did not return the NoLocal Filter on Attach");
                }
            }
        });
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        session.createReceiver(this.getQueueName(), null, true);
        connection.getStateInspector().assertValid();
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testCreateQueueReceiverWithJMSSelector() throws Exception {
        AmqpClient client = this.createAmqpClient();
        client.setValidator(new AmqpValidator(){

            @Override
            public void inspectOpenedResource(Receiver receiver) {
                Source source;
                Map filters;
                if (receiver.getRemoteSource() == null) {
                    this.markAsInvalid("Link opened with null source.");
                }
                if (AmqpSupport.findFilter(filters = (source = (Source)receiver.getRemoteSource()).getFilter(), AmqpSupport.JMS_SELECTOR_FILTER_IDS) == null) {
                    this.markAsInvalid("Broker did not return the JMS Filter on Attach");
                }
            }
        });
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        session.createReceiver(this.getQueueName(), "JMSPriority > 8");
        connection.getStateInspector().assertValid();
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testInvalidFilter() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        try {
            session.createReceiver(this.getQueueName(), "null = 'f''", true);
            Assertions.fail((String)"should throw exception");
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)(e.getCause() instanceof JMSException));
        }
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testSenderSettlementModeSettledIsHonored() throws Exception {
        this.doTestSenderSettlementModeIsHonored(SenderSettleMode.SETTLED);
    }

    @Test
    @Timeout(value=60L)
    public void testSenderSettlementModeUnsettledIsHonored() throws Exception {
        this.doTestSenderSettlementModeIsHonored(SenderSettleMode.UNSETTLED);
    }

    @Test
    @Timeout(value=60L)
    public void testSenderSettlementModeMixedIsHonored() throws Exception {
        this.doTestSenderSettlementModeIsHonored(SenderSettleMode.MIXED);
    }

    public void doTestSenderSettlementModeIsHonored(SenderSettleMode settleMode) throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createReceiver("queue://" + this.getTestName(), settleMode, ReceiverSettleMode.FIRST);
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        Assertions.assertNotNull((Object)queueView);
        Assertions.assertEquals((long)0L, (long)queueView.getMessageCount());
        Assertions.assertEquals((long)1L, (long)this.server.getTotalConsumerCount());
        Assertions.assertEquals((Object)settleMode, (Object)((Receiver)receiver.getEndpoint()).getRemoteSenderSettleMode());
        receiver.close();
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testReceiverSettlementModeSetToFirst() throws Exception {
        this.doTestReceiverSettlementModeForcedToFirst(ReceiverSettleMode.FIRST);
    }

    @Test
    @Timeout(value=60L)
    public void testReceiverSettlementModeSetToSecond() throws Exception {
        this.doTestReceiverSettlementModeForcedToFirst(ReceiverSettleMode.SECOND);
    }

    private void doTestReceiverSettlementModeForcedToFirst(ReceiverSettleMode modeToUse) throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createReceiver("queue://" + this.getTestName(), SenderSettleMode.MIXED, modeToUse);
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        Assertions.assertNotNull((Object)queueView);
        Assertions.assertEquals((long)0L, (long)queueView.getMessageCount());
        Assertions.assertEquals((long)1L, (long)this.server.getTotalConsumerCount());
        Assertions.assertEquals((Object)ReceiverSettleMode.FIRST, (Object)((Receiver)receiver.getEndpoint()).getRemoteReceiverSettleMode());
        receiver.close();
        connection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60L)
    public void testClientIdIsSetInSubscriptionList() throws Exception {
        this.server.addAddressInfo(new AddressInfo(SimpleString.of((String)"mytopic"), RoutingType.ANYCAST));
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        connection.setContainerId("testClient");
        connection.connect();
        try {
            AmqpSession session = connection.createSession();
            Source source = new Source();
            source.setDurable(TerminusDurability.UNSETTLED_STATE);
            source.setCapabilities(new Symbol[]{Symbol.getSymbol((String)"topic")});
            source.setAddress("mytopic");
            session.createReceiver(source, "testSub");
            SimpleString fo = SimpleString.of((String)"testClient.testSub:mytopic");
            Assertions.assertNotNull((Object)this.server.locateQueue(fo));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60L)
    public void testLinkDetachSentWhenQueueDeleted() throws Exception {
        AmqpClient client = this.createAmqpClient();
        try (AmqpConnection connection = this.addConnection(client.connect());){
            AmqpSession session = connection.createSession();
            AmqpReceiver receiver = session.createReceiver(this.getQueueName());
            this.server.destroyQueue(SimpleString.of((String)this.getQueueName()), null, false, true);
            Wait.assertTrue((String)"Receiver should have closed", receiver::isClosed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60L)
    public void testLinkDetatchErrorIsCorrectWhenQueueDoesNotExists() throws Exception {
        AddressSettings value = new AddressSettings();
        value.setAutoCreateQueues(Boolean.valueOf(false));
        value.setAutoCreateAddresses(Boolean.valueOf(false));
        this.server.getAddressSettingsRepository().addMatch("AnAddressThatDoesNotExist", (Object)value);
        AmqpClient client = this.createAmqpClient();
        try (AmqpConnection connection = this.addConnection(client.connect());){
            AmqpSession session = connection.createSession();
            Exception expectedException = null;
            try {
                session.createSender("AnAddressThatDoesNotExist");
                Assertions.fail((String)"Creating a sender here on an address that doesn't exist should fail");
            }
            catch (Exception e) {
                expectedException = e;
            }
            Assertions.assertNotNull((Object)expectedException);
            Assertions.assertTrue((boolean)expectedException.getMessage().contains("amqp:not-found"));
            Assertions.assertTrue((boolean)expectedException.getMessage().contains("target address AnAddressThatDoesNotExist does not exist"));
        }
    }

    @Test
    @Timeout(value=60L)
    public void testUnsupportedFiltersAreNotListedAsSupported() throws Exception {
        AmqpClient client = this.createAmqpClient();
        client.setValidator(new AmqpValidator(){

            @Override
            public void inspectOpenedResource(Receiver receiver) {
                Source source;
                Map filters;
                if (receiver.getRemoteSource() == null) {
                    this.markAsInvalid("Link opened with null source.");
                }
                if (AmqpSupport.findFilter(filters = (source = (Source)receiver.getRemoteSource()).getFilter(), AmqpUnknownFilterType.UNKNOWN_FILTER_IDS) != null) {
                    this.markAsInvalid("Broker should not return unsupported filter on attach.");
                }
            }
        });
        HashMap<Symbol, AmqpUnknownFilterType> filters = new HashMap<Symbol, AmqpUnknownFilterType>();
        filters.put(AmqpUnknownFilterType.UNKNOWN_FILTER_NAME, AmqpUnknownFilterType.UNKNOWN_FILTER);
        Source source = new Source();
        source.setAddress(this.getQueueName());
        source.setFilter(filters);
        source.setDurable(TerminusDurability.NONE);
        source.setExpiryPolicy(TerminusExpiryPolicy.LINK_DETACH);
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        Assertions.assertEquals((long)0L, (long)this.server.getTotalConsumerCount());
        session.createReceiver(source);
        Assertions.assertEquals((long)1L, (long)this.server.getTotalConsumerCount());
        connection.getStateInspector().assertValid();
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testReceiverCloseSendsRemoteClose() throws Exception {
        AmqpClient client = this.createAmqpClient();
        Assertions.assertNotNull((Object)client);
        final AtomicBoolean closed = new AtomicBoolean();
        client.setValidator(new AmqpValidator(){

            @Override
            public void inspectClosedResource(Session session) {
            }

            @Override
            public void inspectDetachedResource(Receiver receiver) {
                this.markAsInvalid("Broker should not detach receiver linked to closed session.");
            }

            @Override
            public void inspectClosedResource(Receiver receiver) {
                closed.set(true);
            }
        });
        AmqpConnection connection = this.addConnection(client.connect());
        Assertions.assertNotNull((Object)connection);
        AmqpSession session = connection.createSession();
        Assertions.assertNotNull((Object)session);
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        Assertions.assertNotNull((Object)receiver);
        receiver.close();
        Assertions.assertTrue((boolean)closed.get(), (String)"Did not process remote close as expected");
        connection.getStateInspector().assertValid();
        connection.close();
    }
}

