/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp.connect;

import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Map;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.DivertConfiguration;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectConfiguration;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectionElement;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPFederatedBrokerConnectionElement;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPFederationAddressPolicyElement;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPFederationQueuePolicyElement;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ComponentConfigurationRoutingType;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.utils.Wait;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQPFederationServerToServerTest
extends AmqpClientTestSupport {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int SERVER_PORT = 5672;
    private static final int SERVER_PORT_REMOTE = 5673;
    private static final int SERVER2_PORT_REMOTE = 5674;
    private static final int MIN_LARGE_MESSAGE_SIZE = 10240;
    protected ActiveMQServer remoteServer;
    protected ActiveMQServer remoteServer2;

    @Override
    protected String getConfiguredProtocols() {
        return "AMQP,CORE";
    }

    @Override
    protected ActiveMQServer createServer() throws Exception {
        this.remoteServer = this.createServer(5673, false);
        return this.createServer(5672, false);
    }

    @Override
    protected void configureAMQPAcceptorParameters(Map<String, Object> params) {
        params.put("amqpMinLargeMessageSize", 10240);
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        super.tearDown();
        try {
            if (this.remoteServer != null) {
                this.remoteServer.stop();
                this.remoteServer = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.remoteServer2 != null) {
                this.remoteServer2.stop();
                this.remoteServer2 = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    @Timeout(value=20L)
    public void testAddresDemandOnLocalBrokerFederatesMessagesFromRemoteAMQP() throws Exception {
        this.testAddresDemandOnLocalBrokerFederatesMessagesFromRemote("AMQP");
    }

    @Test
    @Timeout(value=20L)
    public void testAddresDemandOnLocalBrokerFederatesMessagesFromRemoteCORE() throws Exception {
        this.testAddresDemandOnLocalBrokerFederatesMessagesFromRemote("CORE");
    }

    private void testAddresDemandOnLocalBrokerFederatesMessagesFromRemote(String clientProtocol) throws Exception {
        logger.info("Test started: {}", (Object)this.getTestName());
        AMQPFederationAddressPolicyElement localAddressPolicy = new AMQPFederationAddressPolicyElement();
        localAddressPolicy.setName("test-policy");
        localAddressPolicy.addToIncludes("test");
        localAddressPolicy.setAutoDelete(Boolean.valueOf(false));
        localAddressPolicy.setAutoDeleteDelay(Long.valueOf(-1L));
        localAddressPolicy.setAutoDeleteMessageCount(Long.valueOf(-1L));
        AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
        element.setName(this.getTestName());
        element.addLocalAddressPolicy(localAddressPolicy);
        AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://localhost:5673");
        amqpConnection.setReconnectAttempts(10);
        amqpConnection.addElement((AMQPBrokerConnectionElement)element);
        this.server.getConfiguration().addAMQPConnection(amqpConnection);
        this.remoteServer.start();
        this.server.start();
        ConnectionFactory factoryLocal = CFUtil.createConnectionFactory(clientProtocol, "tcp://localhost:5672");
        ConnectionFactory factoryRemote = CFUtil.createConnectionFactory(clientProtocol, "tcp://localhost:5673");
        try (Connection connectionL = factoryLocal.createConnection();
             Connection connectionR = factoryRemote.createConnection();){
            Session sessionL = connectionL.createSession(1);
            Session sessionR = connectionR.createSession(1);
            Topic topic = sessionL.createTopic("test");
            MessageConsumer consumerL = sessionL.createConsumer((Destination)topic);
            connectionL.start();
            connectionR.start();
            Wait.assertTrue(() -> this.server.addressQuery(SimpleString.of((String)"test")).isExists());
            Wait.assertTrue(() -> this.remoteServer.addressQuery(SimpleString.of((String)"test")).isExists());
            Wait.assertTrue(() -> this.server.bindingQuery(SimpleString.of((String)"test"), false).getQueueNames().size() >= 1);
            Wait.assertTrue(() -> this.remoteServer.bindingQuery(SimpleString.of((String)"test"), false).getQueueNames().size() >= 1);
            MessageProducer producerR = sessionR.createProducer((Destination)topic);
            TextMessage message = sessionR.createTextMessage("Hello World");
            message.setStringProperty("testProperty", "testValue");
            producerR.send((Message)message);
            Message received = consumerL.receive(5000L);
            Assertions.assertNotNull((Object)received);
            Assertions.assertTrue((boolean)(received instanceof TextMessage));
            Assertions.assertEquals((Object)"Hello World", (Object)((TextMessage)received).getText());
            Assertions.assertTrue((boolean)message.propertyExists("testProperty"));
            Assertions.assertEquals((Object)"testValue", (Object)received.getStringProperty("testProperty"));
        }
    }

    @Test
    @Timeout(value=20L)
    public void testDivertAddressDemandOnLocalBrokerFederatesMessagesFromRemoteAMQP() throws Exception {
        this.testDivertAddresDemandOnLocalBrokerFederatesMessagesFromRemote("AMQP");
    }

    @Test
    @Timeout(value=20L)
    public void testDivertAddresDemandOnLocalBrokerFederatesMessagesFromRemoteCORE() throws Exception {
        this.testDivertAddresDemandOnLocalBrokerFederatesMessagesFromRemote("CORE");
    }

    private void testDivertAddresDemandOnLocalBrokerFederatesMessagesFromRemote(String clientProtocol) throws Exception {
        logger.info("Test started: {}", (Object)this.getTestName());
        AMQPFederationAddressPolicyElement localAddressPolicy = new AMQPFederationAddressPolicyElement();
        localAddressPolicy.setName("test-policy");
        localAddressPolicy.addToIncludes("source");
        localAddressPolicy.setAutoDelete(Boolean.valueOf(false));
        localAddressPolicy.setAutoDeleteDelay(Long.valueOf(-1L));
        localAddressPolicy.setAutoDeleteMessageCount(Long.valueOf(-1L));
        localAddressPolicy.setEnableDivertBindings(Boolean.valueOf(true));
        AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
        element.setName(this.getTestName());
        element.addLocalAddressPolicy(localAddressPolicy);
        AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://localhost:5673");
        amqpConnection.setReconnectAttempts(10);
        amqpConnection.addElement((AMQPBrokerConnectionElement)element);
        DivertConfiguration divert = new DivertConfiguration();
        divert.setName("test-divert");
        divert.setAddress("source");
        divert.setForwardingAddress("target");
        divert.setRoutingType(ComponentConfigurationRoutingType.MULTICAST);
        this.server.getConfiguration().addAMQPConnection(amqpConnection);
        this.remoteServer.start();
        this.server.start();
        this.server.deployDivert(divert);
        this.server.addAddressInfo(new AddressInfo(SimpleString.of((String)"source"), RoutingType.MULTICAST));
        ConnectionFactory factoryLocal = CFUtil.createConnectionFactory(clientProtocol, "tcp://localhost:5672");
        ConnectionFactory factoryRemote = CFUtil.createConnectionFactory(clientProtocol, "tcp://localhost:5673");
        try (Connection connectionL = factoryLocal.createConnection();
             Connection connectionR = factoryRemote.createConnection();){
            Session sessionL = connectionL.createSession(1);
            Session sessionR = connectionR.createSession(1);
            Topic target = sessionL.createTopic("target");
            Topic source = sessionL.createTopic("source");
            MessageConsumer consumerL = sessionL.createConsumer((Destination)target);
            connectionL.start();
            connectionR.start();
            Wait.assertTrue(() -> this.remoteServer.addressQuery(SimpleString.of((String)"source")).isExists());
            Wait.assertTrue(() -> this.server.bindingQuery(SimpleString.of((String)"target"), false).getQueueNames().size() >= 1);
            Wait.assertTrue(() -> this.remoteServer.bindingQuery(SimpleString.of((String)"source"), false).getQueueNames().size() >= 1);
            MessageProducer producerR = sessionR.createProducer((Destination)source);
            TextMessage message = sessionR.createTextMessage("Hello World");
            message.setStringProperty("testProperty", "testValue");
            producerR.send((Message)message);
            Message received = consumerL.receive(5000L);
            Assertions.assertNotNull((Object)received);
            Assertions.assertTrue((boolean)(received instanceof TextMessage));
            Assertions.assertEquals((Object)"Hello World", (Object)((TextMessage)received).getText());
            Assertions.assertTrue((boolean)message.propertyExists("testProperty"));
            Assertions.assertEquals((Object)"testValue", (Object)received.getStringProperty("testProperty"));
        }
    }

    @Test
    @Timeout(value=20L)
    public void testQueueDemandOnLocalBrokerFederatesMessagesFromRemoteAMQP() throws Exception {
        this.testQueueDemandOnLocalBrokerFederatesMessagesFromRemote("AMQP");
    }

    @Test
    @Timeout(value=20L)
    public void testQueueDemandOnLocalBrokerFederatesMessagesFromRemoteCORE() throws Exception {
        this.testQueueDemandOnLocalBrokerFederatesMessagesFromRemote("CORE");
    }

    private void testQueueDemandOnLocalBrokerFederatesMessagesFromRemote(String clientProtocol) throws Exception {
        logger.info("Test started: {}", (Object)this.getTestName());
        AMQPFederationQueuePolicyElement localQueuePolicy = new AMQPFederationQueuePolicyElement();
        localQueuePolicy.setName("test-policy");
        localQueuePolicy.addToIncludes("#", "test");
        AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
        element.setName(this.getTestName());
        element.addLocalQueuePolicy(localQueuePolicy);
        AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://localhost:5673");
        amqpConnection.setReconnectAttempts(10);
        amqpConnection.addElement((AMQPBrokerConnectionElement)element);
        this.server.getConfiguration().addAMQPConnection(amqpConnection);
        this.remoteServer.start();
        this.remoteServer.createQueue(QueueConfiguration.of((String)"test").setRoutingType(RoutingType.ANYCAST).setAddress("test").setAutoCreated(Boolean.valueOf(false)));
        this.server.start();
        ConnectionFactory factoryLocal = CFUtil.createConnectionFactory(clientProtocol, "tcp://localhost:5672");
        ConnectionFactory factoryRemote = CFUtil.createConnectionFactory(clientProtocol, "tcp://localhost:5673");
        try (Connection connectionL = factoryLocal.createConnection();
             Connection connectionR = factoryRemote.createConnection();){
            Session sessionL = connectionL.createSession(1);
            Session sessionR = connectionR.createSession(1);
            Queue queue = sessionL.createQueue("test");
            MessageConsumer consumerL = sessionL.createConsumer((Destination)queue);
            connectionL.start();
            connectionR.start();
            Wait.assertTrue(() -> this.server.queueQuery(SimpleString.of((String)"test")).isExists());
            MessageProducer producerR = sessionR.createProducer((Destination)queue);
            TextMessage message = sessionR.createTextMessage("Hello World");
            message.setStringProperty("testProperty", "testValue");
            producerR.send((Message)message);
            Message received = consumerL.receive(5000L);
            Assertions.assertNotNull((Object)received);
            Assertions.assertTrue((boolean)(received instanceof TextMessage));
            Assertions.assertEquals((Object)"Hello World", (Object)((TextMessage)received).getText());
            Assertions.assertTrue((boolean)message.propertyExists("testProperty"));
            Assertions.assertEquals((Object)"testValue", (Object)received.getStringProperty("testProperty"));
        }
    }

    @Test
    @Timeout(value=20L)
    public void testAddresDemandOnRemoteBrokerFederatesMessagesFromLocalAMQP() throws Exception {
        this.testAddresDemandOnRemoteBrokerFederatesMessagesFromLocal("AMQP");
    }

    @Test
    @Timeout(value=20L)
    public void testAddresDemandOnRemoteBrokerFederatesMessagesFromLocalCORE() throws Exception {
        this.testAddresDemandOnRemoteBrokerFederatesMessagesFromLocal("CORE");
    }

    private void testAddresDemandOnRemoteBrokerFederatesMessagesFromLocal(String clientProtocol) throws Exception {
        logger.info("Test started: {}", (Object)this.getTestName());
        AMQPFederationAddressPolicyElement remoteAddressPolicy = new AMQPFederationAddressPolicyElement();
        remoteAddressPolicy.setName("test-policy");
        remoteAddressPolicy.addToIncludes("test");
        remoteAddressPolicy.setAutoDelete(Boolean.valueOf(false));
        remoteAddressPolicy.setAutoDeleteDelay(Long.valueOf(-1L));
        remoteAddressPolicy.setAutoDeleteMessageCount(Long.valueOf(-1L));
        AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
        element.setName(this.getTestName());
        element.addRemoteAddressPolicy(remoteAddressPolicy);
        AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://localhost:5673");
        amqpConnection.setReconnectAttempts(10);
        amqpConnection.addElement((AMQPBrokerConnectionElement)element);
        this.server.getConfiguration().addAMQPConnection(amqpConnection);
        this.remoteServer.start();
        this.server.start();
        ConnectionFactory factoryLocal = CFUtil.createConnectionFactory(clientProtocol, "tcp://localhost:5672");
        ConnectionFactory factoryRemote = CFUtil.createConnectionFactory(clientProtocol, "tcp://localhost:5673");
        try (Connection connectionL = factoryLocal.createConnection();
             Connection connectionR = factoryRemote.createConnection();){
            Session sessionL = connectionL.createSession(1);
            Session sessionR = connectionR.createSession(1);
            Topic topic = sessionL.createTopic("test");
            MessageConsumer consumerR = sessionR.createConsumer((Destination)topic);
            connectionL.start();
            connectionR.start();
            Wait.assertTrue(() -> this.server.addressQuery(SimpleString.of((String)"test")).isExists());
            Wait.assertTrue(() -> this.remoteServer.addressQuery(SimpleString.of((String)"test")).isExists());
            Wait.assertTrue(() -> this.server.bindingQuery(SimpleString.of((String)"test"), false).getQueueNames().size() >= 1);
            Wait.assertTrue(() -> this.remoteServer.bindingQuery(SimpleString.of((String)"test"), false).getQueueNames().size() >= 1);
            MessageProducer producerL = sessionL.createProducer((Destination)topic);
            TextMessage message = sessionL.createTextMessage("Hello World");
            message.setStringProperty("testProperty", "testValue");
            producerL.send((Message)message);
            Message received = consumerR.receive(5000L);
            Assertions.assertNotNull((Object)received);
            Assertions.assertTrue((boolean)(received instanceof TextMessage));
            Assertions.assertEquals((Object)"Hello World", (Object)((TextMessage)received).getText());
            Assertions.assertTrue((boolean)message.propertyExists("testProperty"));
            Assertions.assertEquals((Object)"testValue", (Object)received.getStringProperty("testProperty"));
        }
    }

    @Test
    @Timeout(value=20L)
    public void testQueueDemandOnRemoteWithRemoteConfigrationLeadsToMessageBeingFederatedAMQP() throws Exception {
        this.testQueueDemandOnRemoteWithRemoteConfigrationLeadsToMessageBeingFederated("AMQP");
    }

    @Test
    @Timeout(value=20L)
    public void testQueueDemandOnRemoteWithRemoteConfigrationLeadsToMessageBeingFederatedCORE() throws Exception {
        this.testQueueDemandOnRemoteWithRemoteConfigrationLeadsToMessageBeingFederated("CORE");
    }

    public void testQueueDemandOnRemoteWithRemoteConfigrationLeadsToMessageBeingFederated(String clientProtocol) throws Exception {
        logger.info("Test started: {}", (Object)this.getTestName());
        AMQPFederationQueuePolicyElement remoteQueuePolicy = new AMQPFederationQueuePolicyElement();
        remoteQueuePolicy.setName("test-policy");
        remoteQueuePolicy.addToIncludes("#", "test");
        AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
        element.setName(this.getTestName());
        element.addRemoteQueuePolicy(remoteQueuePolicy);
        AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://localhost:5673");
        amqpConnection.setReconnectAttempts(10);
        amqpConnection.addElement((AMQPBrokerConnectionElement)element);
        this.server.getConfiguration().addAMQPConnection(amqpConnection);
        this.remoteServer.start();
        this.server.start();
        this.server.createQueue(QueueConfiguration.of((String)"test").setRoutingType(RoutingType.ANYCAST).setAddress("test").setAutoCreated(Boolean.valueOf(false)));
        ConnectionFactory factoryLocal = CFUtil.createConnectionFactory(clientProtocol, "tcp://localhost:5672");
        ConnectionFactory factoryRemote = CFUtil.createConnectionFactory(clientProtocol, "tcp://localhost:5673");
        try (Connection connectionL = factoryLocal.createConnection();
             Connection connectionR = factoryRemote.createConnection();){
            Session sessionL = connectionL.createSession(1);
            Session sessionR = connectionR.createSession(1);
            Queue queue = sessionL.createQueue("test");
            MessageConsumer consumerR = sessionR.createConsumer((Destination)queue);
            connectionL.start();
            connectionR.start();
            Wait.assertTrue(() -> this.remoteServer.queueQuery(SimpleString.of((String)"test")).isExists());
            MessageProducer producerL = sessionL.createProducer((Destination)queue);
            TextMessage message = sessionL.createTextMessage("Hello World");
            message.setStringProperty("testProperty", "testValue");
            producerL.send((Message)message);
            Message received = consumerR.receive(5000L);
            Assertions.assertNotNull((Object)received);
            Assertions.assertTrue((boolean)(received instanceof TextMessage));
            Assertions.assertEquals((Object)"Hello World", (Object)((TextMessage)received).getText());
            Assertions.assertTrue((boolean)message.propertyExists("testProperty"));
            Assertions.assertEquals((Object)"testValue", (Object)received.getStringProperty("testProperty"));
        }
    }

    @Test
    @Timeout(value=20L)
    public void testDivertAddresDemandOnRemoteBrokerFederatesMessagesFromLocalAMQP() throws Exception {
        this.testDivertAddresDemandOnRemoteBrokerFederatesMessagesFromLocal("AMQP");
    }

    @Test
    @Timeout(value=20L)
    public void testDivertAddresDemandOnRemoteBrokerFederatesMessagesFromLocalCORE() throws Exception {
        this.testDivertAddresDemandOnRemoteBrokerFederatesMessagesFromLocal("CORE");
    }

    private void testDivertAddresDemandOnRemoteBrokerFederatesMessagesFromLocal(String clientProtocol) throws Exception {
        logger.info("Test started: {}", (Object)this.getTestName());
        AMQPFederationAddressPolicyElement remoteAddressPolicy = new AMQPFederationAddressPolicyElement();
        remoteAddressPolicy.setName("test-policy");
        remoteAddressPolicy.addToIncludes("source");
        remoteAddressPolicy.setAutoDelete(Boolean.valueOf(false));
        remoteAddressPolicy.setAutoDeleteDelay(Long.valueOf(-1L));
        remoteAddressPolicy.setAutoDeleteMessageCount(Long.valueOf(-1L));
        remoteAddressPolicy.setEnableDivertBindings(Boolean.valueOf(true));
        AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
        element.setName(this.getTestName());
        element.addRemoteAddressPolicy(remoteAddressPolicy);
        AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://localhost:5673");
        amqpConnection.setReconnectAttempts(10);
        amqpConnection.addElement((AMQPBrokerConnectionElement)element);
        DivertConfiguration divert = new DivertConfiguration();
        divert.setName("test-divert");
        divert.setAddress("source");
        divert.setForwardingAddress("target");
        divert.setRoutingType(ComponentConfigurationRoutingType.MULTICAST);
        this.remoteServer.start();
        this.remoteServer.deployDivert(divert);
        this.remoteServer.addAddressInfo(new AddressInfo(SimpleString.of((String)"source"), RoutingType.MULTICAST));
        this.server.getConfiguration().addAMQPConnection(amqpConnection);
        this.server.start();
        ConnectionFactory factoryLocal = CFUtil.createConnectionFactory(clientProtocol, "tcp://localhost:5672");
        ConnectionFactory factoryRemote = CFUtil.createConnectionFactory(clientProtocol, "tcp://localhost:5673");
        try (Connection connectionL = factoryLocal.createConnection();
             Connection connectionR = factoryRemote.createConnection();){
            Session sessionL = connectionL.createSession(1);
            Session sessionR = connectionR.createSession(1);
            Topic target = sessionL.createTopic("target");
            Topic source = sessionL.createTopic("source");
            MessageConsumer consumerR = sessionR.createConsumer((Destination)target);
            connectionL.start();
            connectionR.start();
            Wait.assertTrue(() -> this.server.addressQuery(SimpleString.of((String)"source")).isExists());
            Wait.assertTrue(() -> this.server.bindingQuery(SimpleString.of((String)"source"), false).getQueueNames().size() >= 1);
            Wait.assertTrue(() -> this.remoteServer.bindingQuery(SimpleString.of((String)"target"), false).getQueueNames().size() >= 1);
            MessageProducer producerL = sessionL.createProducer((Destination)source);
            TextMessage message = sessionL.createTextMessage("Hello World");
            message.setStringProperty("testProperty", "testValue");
            producerL.send((Message)message);
            Message received = consumerR.receive(5000L);
            Assertions.assertTrue((boolean)(received instanceof TextMessage));
            Assertions.assertEquals((Object)"Hello World", (Object)((TextMessage)received).getText());
            Assertions.assertTrue((boolean)message.propertyExists("testProperty"));
            Assertions.assertEquals((Object)"testValue", (Object)received.getStringProperty("testProperty"));
        }
    }

    @Test
    @Timeout(value=20L)
    public void testAddresDemandOnLocalBrokerFederatesLargeMessagesFromRemoteAMQP() throws Exception {
        this.testAddresDemandOnLocalBrokerFederatesLargeMessagesFromRemote("AMQP", true);
    }

    @Test
    @Timeout(value=20L)
    public void testAddresDemandOnLocalBrokerFederatesLargeMessagesFromRemoteCORENoTunneling() throws Exception {
        this.testAddresDemandOnLocalBrokerFederatesLargeMessagesFromRemote("CORE", false);
    }

    @Test
    @Timeout(value=20L)
    public void testAddresDemandOnLocalBrokerFederatesLargeMessagesFromRemoteCOREWithTunneling() throws Exception {
        this.testAddresDemandOnLocalBrokerFederatesLargeMessagesFromRemote("CORE", true);
    }

    private void testAddresDemandOnLocalBrokerFederatesLargeMessagesFromRemote(String clientProtocol, boolean enableCoreTunneling) throws Exception {
        logger.info("Test started: {}", (Object)this.getTestName());
        AMQPFederationAddressPolicyElement localAddressPolicy = new AMQPFederationAddressPolicyElement();
        localAddressPolicy.setName("test-policy");
        localAddressPolicy.addToIncludes("test");
        localAddressPolicy.setAutoDelete(Boolean.valueOf(false));
        localAddressPolicy.setAutoDeleteDelay(Long.valueOf(-1L));
        localAddressPolicy.setAutoDeleteMessageCount(Long.valueOf(-1L));
        localAddressPolicy.addProperty("tunnel-core-messages", Boolean.toString(enableCoreTunneling));
        AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
        element.setName(this.getTestName());
        element.addLocalAddressPolicy(localAddressPolicy);
        AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://localhost:5673");
        amqpConnection.setReconnectAttempts(10);
        amqpConnection.addElement((AMQPBrokerConnectionElement)element);
        this.server.getConfiguration().addAMQPConnection(amqpConnection);
        this.remoteServer.start();
        this.server.start();
        ConnectionFactory factoryLocal = CFUtil.createConnectionFactory(clientProtocol, "tcp://localhost:5672");
        ConnectionFactory factoryRemote = clientProtocol.equals("CORE") ? CFUtil.createConnectionFactory(clientProtocol, "tcp://localhost:5673?minLargeMessageSize=10240") : CFUtil.createConnectionFactory(clientProtocol, "tcp://localhost:5673");
        try (Connection connectionL = factoryLocal.createConnection();
             Connection connectionR = factoryRemote.createConnection();){
            Session sessionL = connectionL.createSession(1);
            Session sessionR = connectionR.createSession(1);
            Topic topic = sessionL.createTopic("test");
            MessageConsumer consumerL = sessionL.createConsumer((Destination)topic);
            connectionL.start();
            connectionR.start();
            Wait.assertTrue(() -> this.server.addressQuery(SimpleString.of((String)"test")).isExists());
            Wait.assertTrue(() -> this.remoteServer.addressQuery(SimpleString.of((String)"test")).isExists());
            Wait.assertTrue(() -> this.server.bindingQuery(SimpleString.of((String)"test"), false).getQueueNames().size() >= 1);
            Wait.assertTrue(() -> this.remoteServer.bindingQuery(SimpleString.of((String)"test"), false).getQueueNames().size() >= 1);
            MessageProducer producerR = sessionR.createProducer((Destination)topic);
            BytesMessage message = sessionR.createBytesMessage();
            byte[] bodyBytes = new byte[15360];
            Arrays.fill(bodyBytes, (byte)1);
            message.writeBytes(bodyBytes);
            message.setStringProperty("testProperty", "testValue");
            producerR.send((Message)message);
            Message received = consumerL.receive(5000L);
            Assertions.assertNotNull((Object)received);
            Assertions.assertTrue((boolean)(received instanceof BytesMessage));
            byte[] receivedBytes = new byte[bodyBytes.length];
            BytesMessage receivedBytesMsg = (BytesMessage)received;
            receivedBytesMsg.readBytes(receivedBytes);
            Assertions.assertArrayEquals((byte[])bodyBytes, (byte[])receivedBytes);
            Assertions.assertTrue((boolean)message.propertyExists("testProperty"));
            Assertions.assertEquals((Object)"testValue", (Object)received.getStringProperty("testProperty"));
        }
    }

    @Test
    @Timeout(value=20L)
    public void testQueueDemandOnLocalBrokerFederatesLargeMessagesFromRemoteAMQP() throws Exception {
        this.testQueueDemandOnLocalBrokerFederatesLargeMessagesFromRemote("AMQP", true);
    }

    @Test
    @Timeout(value=20L)
    public void testQueueDemandOnLocalBrokerFederatesLargeMessagesFromRemoteCORENoTunneling() throws Exception {
        this.testQueueDemandOnLocalBrokerFederatesLargeMessagesFromRemote("CORE", false);
    }

    @Test
    public void testQueueDemandOnLocalBrokerFederatesLargeMessagesFromRemoteCOREWithTunneling() throws Exception {
        this.testQueueDemandOnLocalBrokerFederatesLargeMessagesFromRemote("CORE", true);
    }

    private void testQueueDemandOnLocalBrokerFederatesLargeMessagesFromRemote(String clientProtocol, boolean enableCoreTunneling) throws Exception {
        logger.info("Test started: {}", (Object)this.getTestName());
        AMQPFederationQueuePolicyElement localQueuePolicy = new AMQPFederationQueuePolicyElement();
        localQueuePolicy.setName("test-policy");
        localQueuePolicy.addToIncludes("test", "test");
        localQueuePolicy.addProperty("tunnel-core-messages", Boolean.toString(enableCoreTunneling));
        AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
        element.setName(this.getTestName());
        element.addLocalQueuePolicy(localQueuePolicy);
        AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://localhost:5673");
        amqpConnection.setReconnectAttempts(10);
        amqpConnection.addElement((AMQPBrokerConnectionElement)element);
        this.server.getConfiguration().addAMQPConnection(amqpConnection);
        this.remoteServer.start();
        this.remoteServer.createQueue(QueueConfiguration.of((String)"test").setRoutingType(RoutingType.ANYCAST).setAddress("test").setAutoCreated(Boolean.valueOf(false)));
        this.server.start();
        ConnectionFactory factoryLocal = CFUtil.createConnectionFactory(clientProtocol, "tcp://localhost:5672");
        ConnectionFactory factoryRemote = clientProtocol.equals("CORE") ? CFUtil.createConnectionFactory(clientProtocol, "tcp://localhost:5673?minLargeMessageSize=10240") : CFUtil.createConnectionFactory(clientProtocol, "tcp://localhost:5673");
        try (Connection connectionL = factoryLocal.createConnection();
             Connection connectionR = factoryRemote.createConnection();){
            Session sessionL = connectionL.createSession(1);
            Session sessionR = connectionR.createSession(1);
            Queue queue = sessionL.createQueue("test");
            MessageConsumer consumerL = sessionL.createConsumer((Destination)queue);
            connectionL.start();
            connectionR.start();
            Wait.assertTrue(() -> this.server.queueQuery(SimpleString.of((String)"test")).isExists());
            Wait.assertTrue(() -> this.remoteServer.queueQuery(SimpleString.of((String)"test")).isExists());
            MessageProducer producerR = sessionR.createProducer((Destination)queue);
            BytesMessage message = sessionR.createBytesMessage();
            byte[] bodyBytes = new byte[15360];
            Arrays.fill(bodyBytes, (byte)1);
            message.writeBytes(bodyBytes);
            message.setStringProperty("testProperty", "testValue");
            producerR.send((Message)message);
            Message received = consumerL.receive(500000L);
            Assertions.assertNotNull((Object)received);
            Assertions.assertTrue((boolean)(received instanceof BytesMessage));
            byte[] receivedBytes = new byte[bodyBytes.length];
            BytesMessage receivedBytesMsg = (BytesMessage)received;
            receivedBytesMsg.readBytes(receivedBytes);
            Assertions.assertArrayEquals((byte[])bodyBytes, (byte[])receivedBytes);
            Assertions.assertTrue((boolean)message.propertyExists("testProperty"));
            Assertions.assertEquals((Object)"testValue", (Object)received.getStringProperty("testProperty"));
        }
    }

    @Test
    @Timeout(value=20L)
    public void testCoreMessageCrossingAddressWithThreeBrokersWithoutTunneling() throws Exception {
        this.doTestCoreMessageCrossingAddressWithThreeBrokers(false);
    }

    @Test
    @Timeout(value=20L)
    public void testCoreMessageCrossingAddressWithThreeBrokersWithTunneling() throws Exception {
        this.doTestCoreMessageCrossingAddressWithThreeBrokers(true);
    }

    private void doTestCoreMessageCrossingAddressWithThreeBrokers(boolean enableCoreTunneling) throws Exception {
        logger.info("Test started: {}", (Object)this.getTestName());
        this.remoteServer2 = this.createServer(5674, false);
        String ADDRESS_NAME = "target";
        SimpleString ADDRESS_NAME_SS = SimpleString.of((String)"target");
        AMQPFederationAddressPolicyElement localAddressPolicy = new AMQPFederationAddressPolicyElement();
        localAddressPolicy.setName("two-hop-policy");
        localAddressPolicy.addToIncludes("target");
        localAddressPolicy.setAutoDelete(Boolean.valueOf(false));
        localAddressPolicy.setAutoDeleteDelay(Long.valueOf(-1L));
        localAddressPolicy.setAutoDeleteMessageCount(Long.valueOf(-1L));
        localAddressPolicy.setMaxHops(2);
        localAddressPolicy.addProperty("tunnel-core-messages", Boolean.toString(enableCoreTunneling));
        AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
        element.setName(this.getTestName());
        element.addLocalAddressPolicy(localAddressPolicy);
        AMQPBrokerConnectConfiguration amqpConnection1 = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://localhost:5673");
        amqpConnection1.setReconnectAttempts(10);
        amqpConnection1.setRetryInterval(100);
        amqpConnection1.addElement((AMQPBrokerConnectionElement)element);
        AMQPBrokerConnectConfiguration amqpConnection2 = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://localhost:5674");
        amqpConnection2.setReconnectAttempts(10);
        amqpConnection1.setRetryInterval(100);
        amqpConnection2.addElement((AMQPBrokerConnectionElement)element);
        AMQPBrokerConnectConfiguration amqpConnection3 = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://localhost:5672");
        amqpConnection3.setReconnectAttempts(10);
        amqpConnection1.setRetryInterval(100);
        amqpConnection3.addElement((AMQPBrokerConnectionElement)element);
        this.server.getConfiguration().addAMQPConnection(amqpConnection1);
        this.remoteServer.getConfiguration().addAMQPConnection(amqpConnection2);
        this.remoteServer2.getConfiguration().addAMQPConnection(amqpConnection3);
        this.server.start();
        this.remoteServer.start();
        this.remoteServer2.start();
        ConnectionFactory factory1 = CFUtil.createConnectionFactory("CORE", "tcp://localhost:5672");
        ConnectionFactory factory2 = CFUtil.createConnectionFactory("CORE", "tcp://localhost:5673");
        ConnectionFactory factory3 = CFUtil.createConnectionFactory("CORE", "tcp://localhost:5674");
        try (Connection connection1 = factory1.createConnection();
             Connection connection2 = factory2.createConnection();
             Connection connection3 = factory3.createConnection();){
            Session session1 = connection1.createSession(1);
            Session session2 = connection2.createSession(1);
            Session session3 = connection3.createSession(1);
            Topic topic = session1.createTopic("target");
            MessageConsumer consumer1 = session1.createConsumer((Destination)topic);
            MessageConsumer consumer2 = session2.createConsumer((Destination)topic);
            MessageConsumer consumer3 = session3.createConsumer((Destination)topic);
            MessageProducer producer1 = session1.createProducer((Destination)topic);
            MessageProducer producer2 = session2.createProducer((Destination)topic);
            MessageProducer producer3 = session3.createProducer((Destination)topic);
            TextMessage message1 = session1.createTextMessage("Message1");
            message1.setStringProperty("test", "1");
            TextMessage message2 = session2.createTextMessage("Message2");
            message2.setStringProperty("test", "2");
            TextMessage message3 = session3.createTextMessage("Message3");
            message3.setStringProperty("test", "3");
            connection1.start();
            connection2.start();
            connection3.start();
            Wait.assertTrue(() -> this.server.bindingQuery(ADDRESS_NAME_SS).getQueueNames().size() == 2);
            Wait.assertTrue(() -> this.remoteServer.bindingQuery(ADDRESS_NAME_SS).getQueueNames().size() == 2);
            Wait.assertTrue(() -> this.remoteServer2.bindingQuery(ADDRESS_NAME_SS).getQueueNames().size() == 2);
            producer1.send((Message)message1);
            Message received = consumer1.receive(2000L);
            Assertions.assertNotNull((Object)received);
            Assertions.assertTrue((boolean)(received instanceof TextMessage));
            Assertions.assertEquals((Object)"Message1", (Object)((TextMessage)received).getText());
            Assertions.assertTrue((boolean)received.propertyExists("test"));
            Assertions.assertEquals((Object)"1", (Object)received.getStringProperty("test"));
            received = consumer2.receive(2000L);
            Assertions.assertNotNull((Object)received);
            Assertions.assertTrue((boolean)(received instanceof TextMessage));
            Assertions.assertEquals((Object)"Message1", (Object)((TextMessage)received).getText());
            Assertions.assertTrue((boolean)received.propertyExists("test"));
            Assertions.assertEquals((Object)"1", (Object)received.getStringProperty("test"));
            received = consumer3.receive(2000L);
            Assertions.assertNotNull((Object)received);
            Assertions.assertTrue((boolean)(received instanceof TextMessage));
            Assertions.assertEquals((Object)"Message1", (Object)((TextMessage)received).getText());
            Assertions.assertTrue((boolean)received.propertyExists("test"));
            Assertions.assertEquals((Object)"1", (Object)received.getStringProperty("test"));
            Assertions.assertNull((Object)consumer1.receive(100L));
            Assertions.assertNull((Object)consumer2.receive(100L));
            Assertions.assertNull((Object)consumer3.receive(100L));
            producer2.send((Message)message2);
            received = consumer1.receive(2000L);
            Assertions.assertNotNull((Object)received);
            Assertions.assertTrue((boolean)(received instanceof TextMessage));
            Assertions.assertEquals((Object)"Message2", (Object)((TextMessage)received).getText());
            Assertions.assertTrue((boolean)received.propertyExists("test"));
            Assertions.assertEquals((Object)"2", (Object)received.getStringProperty("test"));
            received = consumer2.receive(2000L);
            Assertions.assertNotNull((Object)received);
            Assertions.assertTrue((boolean)(received instanceof TextMessage));
            Assertions.assertEquals((Object)"Message2", (Object)((TextMessage)received).getText());
            Assertions.assertTrue((boolean)received.propertyExists("test"));
            Assertions.assertEquals((Object)"2", (Object)received.getStringProperty("test"));
            received = consumer3.receive(2000L);
            Assertions.assertNotNull((Object)received);
            Assertions.assertTrue((boolean)(received instanceof TextMessage));
            Assertions.assertEquals((Object)"Message2", (Object)((TextMessage)received).getText());
            Assertions.assertTrue((boolean)received.propertyExists("test"));
            Assertions.assertEquals((Object)"2", (Object)received.getStringProperty("test"));
            Assertions.assertNull((Object)consumer1.receiveNoWait());
            Assertions.assertNull((Object)consumer2.receiveNoWait());
            Assertions.assertNull((Object)consumer3.receiveNoWait());
            producer3.send((Message)message3);
            received = consumer1.receive(2000L);
            Assertions.assertNotNull((Object)received);
            Assertions.assertTrue((boolean)(received instanceof TextMessage));
            Assertions.assertEquals((Object)"Message3", (Object)((TextMessage)received).getText());
            Assertions.assertTrue((boolean)received.propertyExists("test"));
            Assertions.assertEquals((Object)"3", (Object)received.getStringProperty("test"));
            received = consumer2.receive(2000L);
            Assertions.assertNotNull((Object)received);
            Assertions.assertTrue((boolean)(received instanceof TextMessage));
            Assertions.assertEquals((Object)"Message3", (Object)((TextMessage)received).getText());
            Assertions.assertTrue((boolean)received.propertyExists("test"));
            Assertions.assertEquals((Object)"3", (Object)received.getStringProperty("test"));
            received = consumer3.receive(2000L);
            Assertions.assertNotNull((Object)received);
            Assertions.assertTrue((boolean)(received instanceof TextMessage));
            Assertions.assertEquals((Object)"Message3", (Object)((TextMessage)received).getText());
            Assertions.assertTrue((boolean)received.propertyExists("test"));
            Assertions.assertEquals((Object)"3", (Object)received.getStringProperty("test"));
            Assertions.assertNull((Object)consumer1.receiveNoWait());
            Assertions.assertNull((Object)consumer2.receiveNoWait());
            Assertions.assertNull((Object)consumer3.receiveNoWait());
        }
    }

    @Test
    @Timeout(value=20L)
    public void testCoreConsumerDemandOnLocalBrokerFederatesMessageFromAMQPClient() throws Exception {
        this.testCoreConsumerDemandOnLocalBrokerFederatesMessageFromAMQPClient("CORE", "AMQP", false);
    }

    @Test
    @Timeout(value=20L)
    public void testCoreConsumerDemandOnLocalBrokerFederatesMessageFromCoreClientTunneled() throws Exception {
        this.testCoreConsumerDemandOnLocalBrokerFederatesMessageFromAMQPClient("CORE", "CORE", true);
    }

    @Test
    @Timeout(value=20L)
    public void testCoreConsumerDemandOnLocalBrokerFederatesMessageFromCoreClientUnTunneled() throws Exception {
        this.testCoreConsumerDemandOnLocalBrokerFederatesMessageFromAMQPClient("CORE", "CORE", false);
    }

    @Test
    @Timeout(value=20L)
    public void testAMQPConsumerDemandOnLocalBrokerFederatesMessageFromCoreClientTunneled() throws Exception {
        this.testCoreConsumerDemandOnLocalBrokerFederatesMessageFromAMQPClient("AMQP", "CORE", true);
    }

    @Test
    @Timeout(value=20L)
    public void testAMQPConsumerDemandOnLocalBrokerFederatesMessageFromCoreClientNotTunneled() throws Exception {
        this.testCoreConsumerDemandOnLocalBrokerFederatesMessageFromAMQPClient("AMQP", "CORE", false);
    }

    private void testCoreConsumerDemandOnLocalBrokerFederatesMessageFromAMQPClient(String localProtocol, String remoteProtocol, boolean enableCoreTunneling) throws Exception {
        logger.info("Test started: {}", (Object)this.getTestName());
        AMQPFederationQueuePolicyElement localQueuePolicy = new AMQPFederationQueuePolicyElement();
        localQueuePolicy.setName("test-policy");
        localQueuePolicy.addToIncludes("test", "test");
        localQueuePolicy.addProperty("tunnel-core-messages", Boolean.toString(enableCoreTunneling));
        AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
        element.setName(this.getTestName());
        element.addLocalQueuePolicy(localQueuePolicy);
        AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://localhost:5673");
        amqpConnection.setReconnectAttempts(10);
        amqpConnection.addElement((AMQPBrokerConnectionElement)element);
        this.server.getConfiguration().addAMQPConnection(amqpConnection);
        this.remoteServer.start();
        this.remoteServer.createQueue(QueueConfiguration.of((String)"test").setRoutingType(RoutingType.ANYCAST).setAddress("test").setAutoCreated(Boolean.valueOf(false)));
        this.server.start();
        ConnectionFactory factoryLocal = CFUtil.createConnectionFactory(localProtocol, "tcp://localhost:5672");
        ConnectionFactory factoryRemote = CFUtil.createConnectionFactory(remoteProtocol, "tcp://localhost:5673");
        try (Connection connectionL = factoryLocal.createConnection();
             Connection connectionR = factoryRemote.createConnection();){
            Session sessionL = connectionL.createSession(1);
            Session sessionR = connectionR.createSession(1);
            MessageConsumer consumerL = sessionL.createConsumer((Destination)sessionL.createQueue("test"));
            connectionL.start();
            connectionR.start();
            Wait.assertTrue(() -> this.server.queueQuery(SimpleString.of((String)"test")).isExists());
            Wait.assertTrue(() -> this.remoteServer.queueQuery(SimpleString.of((String)"test")).isExists());
            MessageProducer producerR = sessionR.createProducer((Destination)sessionR.createQueue("test"));
            BytesMessage message = sessionR.createBytesMessage();
            byte[] bodyBytes = new byte[15360];
            Arrays.fill(bodyBytes, (byte)1);
            message.writeBytes(bodyBytes);
            message.setStringProperty("testProperty", "testValue");
            message.setIntProperty("testIntProperty", 42);
            message.setJMSCorrelationID("myCorrelationId");
            message.setJMSReplyTo((Destination)sessionR.createTopic("reply-topic"));
            producerR.setDeliveryMode(2);
            producerR.send((Message)message);
            Message received = consumerL.receive(5000L);
            Assertions.assertNotNull((Object)received);
            Assertions.assertTrue((boolean)(received instanceof BytesMessage));
            byte[] receivedBytes = new byte[bodyBytes.length];
            BytesMessage receivedBytesMsg = (BytesMessage)received;
            receivedBytesMsg.readBytes(receivedBytes);
            Assertions.assertArrayEquals((byte[])bodyBytes, (byte[])receivedBytes);
            Assertions.assertTrue((boolean)message.propertyExists("testProperty"));
            Assertions.assertEquals((Object)"testValue", (Object)received.getStringProperty("testProperty"));
            Assertions.assertTrue((boolean)message.propertyExists("testIntProperty"));
            Assertions.assertEquals((int)42, (int)received.getIntProperty("testIntProperty"));
            Assertions.assertEquals((Object)"myCorrelationId", (Object)received.getJMSCorrelationID());
            Assertions.assertEquals((Object)"reply-topic", (Object)((Topic)received.getJMSReplyTo()).getTopicName());
            Assertions.assertEquals((int)2, (int)received.getJMSDeliveryMode());
        }
    }

    @Test
    @Timeout(value=20L)
    public void testQueueDemandOnLocalBrokerFederatesMatchingFilteredMessagesFromRemoteAMQP() throws Exception {
        this.testQueueDemandOnLocalBrokerFederatesMatchingFilteredMessagesFromRemote("AMQP");
    }

    @Test
    @Timeout(value=20L)
    public void testQueueDemandOnLocalBrokerFederatesMatchingFilteredMessagesFromRemoteCORE() throws Exception {
        this.testQueueDemandOnLocalBrokerFederatesMatchingFilteredMessagesFromRemote("CORE");
    }

    private void testQueueDemandOnLocalBrokerFederatesMatchingFilteredMessagesFromRemote(String clientProtocol) throws Exception {
        logger.info("Test started: {}", (Object)this.getTestName());
        AMQPFederationQueuePolicyElement localQueuePolicy = new AMQPFederationQueuePolicyElement();
        localQueuePolicy.setName("test-policy");
        localQueuePolicy.addToIncludes("#", "test");
        AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
        element.setName(this.getTestName());
        element.addLocalQueuePolicy(localQueuePolicy);
        AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://localhost:5673");
        amqpConnection.setReconnectAttempts(10);
        amqpConnection.addElement((AMQPBrokerConnectionElement)element);
        this.server.getConfiguration().addAMQPConnection(amqpConnection);
        this.remoteServer.start();
        this.remoteServer.createQueue(QueueConfiguration.of((String)"test").setRoutingType(RoutingType.ANYCAST).setAddress("test").setFilterString("color='red' OR color='green' OR color='blue'").setAutoCreated(Boolean.valueOf(false)));
        this.server.start();
        ConnectionFactory factoryLocal = CFUtil.createConnectionFactory(clientProtocol, "tcp://localhost:5672");
        ConnectionFactory factoryRemote = CFUtil.createConnectionFactory(clientProtocol, "tcp://localhost:5673");
        try (Connection connectionL = factoryLocal.createConnection();
             Connection connectionR = factoryRemote.createConnection();){
            Session sessionL = connectionL.createSession(1);
            Session sessionR = connectionR.createSession(1);
            Queue queue = sessionL.createQueue("test");
            MessageConsumer consumerL1 = sessionL.createConsumer((Destination)queue, "color='red'");
            MessageConsumer consumerL2 = sessionL.createConsumer((Destination)queue, "color='blue'");
            connectionL.start();
            connectionR.start();
            Wait.assertTrue(() -> this.server.queueQuery(SimpleString.of((String)"test")).isExists());
            MessageProducer producerR = sessionR.createProducer((Destination)queue);
            TextMessage message1 = sessionR.createTextMessage("Hello World 1");
            message1.setStringProperty("color", "green");
            TextMessage message2 = sessionR.createTextMessage("Hello World 2");
            message2.setStringProperty("color", "red");
            TextMessage message3 = sessionR.createTextMessage("Hello World 3");
            message3.setStringProperty("color", "blue");
            producerR.send((Message)message1);
            producerR.send((Message)message2);
            producerR.send((Message)message3);
            Message receivedL1 = consumerL1.receive(5000L);
            Assertions.assertNotNull((Object)receivedL1);
            Assertions.assertTrue((boolean)(receivedL1 instanceof TextMessage));
            Assertions.assertEquals((Object)"Hello World 2", (Object)((TextMessage)receivedL1).getText());
            Assertions.assertTrue((boolean)receivedL1.propertyExists("color"));
            Assertions.assertEquals((Object)"red", (Object)receivedL1.getStringProperty("color"));
            Message receivedL2 = consumerL2.receive(5000L);
            Assertions.assertNotNull((Object)receivedL2);
            Assertions.assertTrue((boolean)(receivedL2 instanceof TextMessage));
            Assertions.assertEquals((Object)"Hello World 3", (Object)((TextMessage)receivedL2).getText());
            Assertions.assertTrue((boolean)receivedL2.propertyExists("color"));
            Assertions.assertEquals((Object)"blue", (Object)receivedL2.getStringProperty("color"));
            MessageConsumer consumerR = sessionR.createConsumer((Destination)queue, "color='green'");
            Message receivedR = consumerR.receive(5000L);
            Assertions.assertNotNull((Object)receivedR);
            Assertions.assertTrue((boolean)(receivedR instanceof TextMessage));
            Assertions.assertEquals((Object)"Hello World 1", (Object)((TextMessage)receivedR).getText());
            Assertions.assertTrue((boolean)receivedR.propertyExists("color"));
            Assertions.assertEquals((Object)"green", (Object)receivedR.getStringProperty("color"));
        }
    }

    @Test
    @Timeout(value=20L)
    public void testAddressFederatedOverSingleConnectionNotReflectedBackToSendingNodeAMQP() throws Exception {
        this.doTestAddressFederatedOverSingleConnectionNotReflectedBackToSendingNode("AMQP");
    }

    @Test
    @Timeout(value=20L)
    public void testAddressFederatedOverSingleConnectionNotReflectedBackToSendingNodeCore() throws Exception {
        this.doTestAddressFederatedOverSingleConnectionNotReflectedBackToSendingNode("CORE");
    }

    private void doTestAddressFederatedOverSingleConnectionNotReflectedBackToSendingNode(String clientProtocol) throws Exception {
        logger.info("Test started: {}", (Object)this.getTestName());
        AMQPFederationAddressPolicyElement localAddressPolicy = new AMQPFederationAddressPolicyElement();
        localAddressPolicy.setName("local-test-policy");
        localAddressPolicy.addToIncludes("test");
        localAddressPolicy.setAutoDelete(Boolean.valueOf(false));
        localAddressPolicy.setAutoDeleteDelay(Long.valueOf(-1L));
        localAddressPolicy.setAutoDeleteMessageCount(Long.valueOf(-1L));
        localAddressPolicy.setMaxHops(0);
        AMQPFederationAddressPolicyElement remoteAddressPolicy = new AMQPFederationAddressPolicyElement();
        remoteAddressPolicy.setName("remote-test-policy");
        remoteAddressPolicy.addToIncludes("test");
        remoteAddressPolicy.setAutoDelete(Boolean.valueOf(false));
        remoteAddressPolicy.setAutoDeleteDelay(Long.valueOf(-1L));
        remoteAddressPolicy.setAutoDeleteMessageCount(Long.valueOf(-1L));
        remoteAddressPolicy.setMaxHops(0);
        AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
        element.setName(this.getTestName());
        element.addLocalAddressPolicy(localAddressPolicy);
        element.addRemoteAddressPolicy(remoteAddressPolicy);
        AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://localhost:5673");
        amqpConnection.setReconnectAttempts(10);
        amqpConnection.addElement((AMQPBrokerConnectionElement)element);
        this.server.getConfiguration().addAMQPConnection(amqpConnection);
        this.remoteServer.start();
        this.server.start();
        ConnectionFactory factoryLocal = CFUtil.createConnectionFactory(clientProtocol, "tcp://localhost:5672");
        ConnectionFactory factoryRemote = CFUtil.createConnectionFactory(clientProtocol, "tcp://localhost:5673");
        try (Connection connectionL = factoryLocal.createConnection();
             Connection connectionR = factoryRemote.createConnection();){
            Session sessionL = connectionL.createSession(1);
            Session sessionR = connectionR.createSession(1);
            Topic topic = sessionL.createTopic("test");
            MessageConsumer consumerL = sessionL.createConsumer((Destination)topic);
            MessageConsumer consumerR = sessionR.createConsumer((Destination)topic);
            MessageProducer producerL = sessionL.createProducer((Destination)topic);
            MessageProducer producerR = sessionR.createProducer((Destination)topic);
            TextMessage messageFromL = sessionL.createTextMessage("local");
            TextMessage messageFromR = sessionR.createTextMessage("remote");
            connectionL.start();
            connectionR.start();
            SimpleString addressName = SimpleString.of((String)"test");
            Wait.assertTrue(() -> this.server.addressQuery(addressName).isExists());
            Wait.assertTrue(() -> this.remoteServer.addressQuery(addressName).isExists());
            Assertions.assertNull((Object)consumerL.receiveNoWait());
            Assertions.assertNull((Object)consumerR.receiveNoWait());
            Wait.assertTrue(() -> this.server.bindingQuery(addressName, false).getQueueNames().size() >= 2);
            Wait.assertTrue(() -> this.remoteServer.bindingQuery(addressName, false).getQueueNames().size() >= 2);
            producerL.send((Message)messageFromL);
            Message messageL1 = consumerL.receive();
            Message messageR1 = consumerR.receive();
            Assertions.assertNotNull((Object)messageL1);
            Assertions.assertNotNull((Object)messageR1);
            Assertions.assertTrue((boolean)(messageL1 instanceof TextMessage));
            Assertions.assertTrue((boolean)(messageR1 instanceof TextMessage));
            Assertions.assertEquals((Object)"local", (Object)((TextMessage)messageL1).getText());
            Assertions.assertEquals((Object)"local", (Object)((TextMessage)messageR1).getText());
            producerR.send((Message)messageFromR);
            Message messageL2 = consumerL.receive();
            Message messageR2 = consumerR.receive();
            Assertions.assertNotNull((Object)messageL2);
            Assertions.assertNotNull((Object)messageR2);
            Assertions.assertTrue((boolean)(messageL2 instanceof TextMessage));
            Assertions.assertTrue((boolean)(messageR2 instanceof TextMessage));
            Assertions.assertEquals((Object)"remote", (Object)((TextMessage)messageL2).getText());
            Assertions.assertEquals((Object)"remote", (Object)((TextMessage)messageR2).getText());
            Assertions.assertNull((Object)consumerL.receiveNoWait());
            Assertions.assertNull((Object)consumerR.receiveNoWait());
        }
    }

    @Test
    @Timeout(value=20L)
    public void testAddressFederatedOnTwoConnectionsNotReflectedBackToSendingNodeAMQP() throws Exception {
        this.doTestAddressFederatedOverTwoConnectionNotReflectedBackToSendingNode("AMQP");
    }

    @Test
    @Timeout(value=20L)
    public void testAddressFederatedOnTwoConnectionsNotReflectedBackToSendingNodeCore() throws Exception {
        this.doTestAddressFederatedOverTwoConnectionNotReflectedBackToSendingNode("CORE");
    }

    private void doTestAddressFederatedOverTwoConnectionNotReflectedBackToSendingNode(String clientProtocol) throws Exception {
        logger.info("Test started: {}", (Object)this.getTestName());
        AMQPFederationAddressPolicyElement localAddressPolicy1 = new AMQPFederationAddressPolicyElement();
        localAddressPolicy1.setName("local-test-policy");
        localAddressPolicy1.addToIncludes("test");
        localAddressPolicy1.setAutoDelete(Boolean.valueOf(false));
        localAddressPolicy1.setAutoDeleteDelay(Long.valueOf(-1L));
        localAddressPolicy1.setAutoDeleteMessageCount(Long.valueOf(-1L));
        localAddressPolicy1.setMaxHops(0);
        AMQPFederationAddressPolicyElement localAddressPolicy2 = new AMQPFederationAddressPolicyElement();
        localAddressPolicy2.setName("remote-test-policy");
        localAddressPolicy2.addToIncludes("test");
        localAddressPolicy2.setAutoDelete(Boolean.valueOf(false));
        localAddressPolicy2.setAutoDeleteDelay(Long.valueOf(-1L));
        localAddressPolicy2.setAutoDeleteMessageCount(Long.valueOf(-1L));
        localAddressPolicy2.setMaxHops(0);
        AMQPFederatedBrokerConnectionElement element1 = new AMQPFederatedBrokerConnectionElement();
        element1.setName(this.getTestName() + ":1");
        element1.addLocalAddressPolicy(localAddressPolicy1);
        AMQPFederatedBrokerConnectionElement element2 = new AMQPFederatedBrokerConnectionElement();
        element2.setName(this.getTestName() + "2");
        element2.addLocalAddressPolicy(localAddressPolicy2);
        AMQPBrokerConnectConfiguration amqpConnection1 = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://localhost:5673");
        amqpConnection1.setReconnectAttempts(10);
        amqpConnection1.addElement((AMQPBrokerConnectionElement)element1);
        AMQPBrokerConnectConfiguration amqpConnection2 = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://localhost:5672");
        amqpConnection2.setReconnectAttempts(10);
        amqpConnection2.addElement((AMQPBrokerConnectionElement)element2);
        this.server.getConfiguration().addAMQPConnection(amqpConnection1);
        this.remoteServer.getConfiguration().addAMQPConnection(amqpConnection2);
        this.remoteServer.start();
        this.server.start();
        ConnectionFactory factoryLocal = CFUtil.createConnectionFactory(clientProtocol, "tcp://localhost:5672");
        ConnectionFactory factoryRemote = CFUtil.createConnectionFactory(clientProtocol, "tcp://localhost:5673");
        try (Connection connectionL = factoryLocal.createConnection();
             Connection connectionR = factoryRemote.createConnection();){
            Session sessionL = connectionL.createSession(1);
            Session sessionR = connectionR.createSession(1);
            Topic topic = sessionL.createTopic("test");
            MessageConsumer consumerL = sessionL.createConsumer((Destination)topic);
            MessageConsumer consumerR = sessionR.createConsumer((Destination)topic);
            MessageProducer producerL = sessionL.createProducer((Destination)topic);
            MessageProducer producerR = sessionR.createProducer((Destination)topic);
            TextMessage messageFromL = sessionL.createTextMessage("local");
            TextMessage messageFromR = sessionR.createTextMessage("remote");
            connectionL.start();
            connectionR.start();
            SimpleString addressName = SimpleString.of((String)"test");
            Wait.assertTrue(() -> this.server.addressQuery(addressName).isExists());
            Wait.assertTrue(() -> this.remoteServer.addressQuery(addressName).isExists());
            Assertions.assertNull((Object)consumerL.receiveNoWait());
            Assertions.assertNull((Object)consumerR.receiveNoWait());
            Wait.assertTrue(() -> this.server.bindingQuery(addressName, false).getQueueNames().size() >= 2);
            Wait.assertTrue(() -> this.remoteServer.bindingQuery(addressName, false).getQueueNames().size() >= 2);
            producerL.send((Message)messageFromL);
            Message messageL1 = consumerL.receive();
            Message messageR1 = consumerR.receive();
            Assertions.assertNotNull((Object)messageL1);
            Assertions.assertNotNull((Object)messageR1);
            Assertions.assertTrue((boolean)(messageL1 instanceof TextMessage));
            Assertions.assertTrue((boolean)(messageR1 instanceof TextMessage));
            Assertions.assertEquals((Object)"local", (Object)((TextMessage)messageL1).getText());
            Assertions.assertEquals((Object)"local", (Object)((TextMessage)messageR1).getText());
            producerR.send((Message)messageFromR);
            Message messageL2 = consumerL.receive();
            Message messageR2 = consumerR.receive();
            Assertions.assertNotNull((Object)messageL2);
            Assertions.assertNotNull((Object)messageR2);
            Assertions.assertTrue((boolean)(messageL2 instanceof TextMessage));
            Assertions.assertTrue((boolean)(messageR2 instanceof TextMessage));
            Assertions.assertEquals((Object)"remote", (Object)((TextMessage)messageL2).getText());
            Assertions.assertEquals((Object)"remote", (Object)((TextMessage)messageR2).getText());
            Assertions.assertNull((Object)consumerL.receiveNoWait());
            Assertions.assertNull((Object)consumerR.receiveNoWait());
        }
    }
}

