/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp.largemessages;

import java.util.NoSuchElementException;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPLargeMessage;
import org.apache.activemq.artemis.utils.Wait;
import org.apache.activemq.artemis.utils.collections.LinkedListIterator;
import org.junit.jupiter.api.Assertions;

public class AMQPLargeMessagesTestUtil {
    public static void validateAllTemporaryBuffers(ActiveMQServer server) {
        server.getPostOffice().getAllBindings().filter(QueueBinding.class::isInstance).forEach(binding -> AMQPLargeMessagesTestUtil.validateTemporaryBuffers(((QueueBinding)binding).getQueue()));
    }

    public static void validateTemporaryBuffers(Queue serverQueue) {
        LinkedListIterator totalIterator = serverQueue.browserIterator();
        while (totalIterator.hasNext()) {
            MessageReference ref;
            try {
                ref = (MessageReference)totalIterator.next();
            }
            catch (NoSuchElementException e) {
                break;
            }
            if (!(ref.getMessage() instanceof AMQPLargeMessage)) continue;
            AMQPLargeMessage amqpLargeMessage = (AMQPLargeMessage)ref.getMessage();
            Wait.waitFor(() -> amqpLargeMessage.inspectTemporaryBuffer() == null, (long)1000L, (long)10L);
            Assertions.assertNull((Object)amqpLargeMessage.inspectTemporaryBuffer(), (String)"Temporary buffers are being retained");
        }
        totalIterator.close();
    }
}

