/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import com.sun.management.UnixOperatingSystemMXBean;
import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.MessageHandler;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.client.impl.ClientConsumerInternal;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.DivertConfiguration;
import org.apache.activemq.artemis.core.config.StoreConfiguration;
import org.apache.activemq.artemis.core.paging.PagingManager;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.persistence.impl.journal.LargeServerMessageImpl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.LargeServerMessage;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.RoutingContext;
import org.apache.activemq.artemis.core.server.ServerProducer;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerBasePlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerMessagePlugin;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.transaction.impl.XidImpl;
import org.apache.activemq.artemis.logs.AssertionLoggerHandler;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.integration.largemessage.LargeMessageTestBase;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.collections.LinkedListIterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExtendWith(value={ParameterizedTestExtension.class})
public class LargeMessageTest
extends LargeMessageTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int RECEIVE_WAIT_TIME = 10000;
    protected ServerLocator locator;
    protected boolean isCompressedTest = false;
    private int largeMessageSize;

    protected boolean isNetty() {
        return false;
    }

    public LargeMessageTest(StoreConfiguration.StoreType storeType) {
        super(storeType);
        this.largeMessageSize = storeType == StoreConfiguration.StoreType.DATABASE ? 5120 : 102400;
    }

    @TestTemplate
    public void testRollbackPartiallyConsumedBuffer() throws Exception {
        for (int i = 0; i < 1; ++i) {
            logger.debug("#test {}", (Object)i);
            this.internalTestRollbackPartiallyConsumedBuffer(false);
            this.tearDown();
            this.setUp();
        }
    }

    @TestTemplate
    public void testRollbackPartiallyConsumedBufferWithRedeliveryDelay() throws Exception {
        this.internalTestRollbackPartiallyConsumedBuffer(true);
    }

    private void internalTestRollbackPartiallyConsumedBuffer(boolean redeliveryDelay) throws Exception {
        int messageSize = this.largeMessageSize;
        ActiveMQServer server = this.createServer(true, this.isNetty(), this.storeType);
        AddressSettings settings = new AddressSettings();
        if (redeliveryDelay) {
            settings.setRedeliveryDelay(100L);
            if (this.locator.isCompressLargeMessage()) {
                this.locator.setConsumerWindowSize(0);
            }
        }
        this.locator.setBlockOnNonDurableSend(false).setBlockOnNonDurableSend(false).setBlockOnAcknowledge(false);
        settings.setMaxDeliveryAttempts(-1);
        server.getAddressSettingsRepository().addMatch("#", (Object)settings);
        server.start();
        ClientSessionFactory sf = this.addSessionFactory(this.createSessionFactory(this.locator));
        final ClientSession session = sf.createSession(false, false, false);
        session.createQueue(QueueConfiguration.of((SimpleString)this.ADDRESS));
        ClientProducer producer = session.createProducer(this.ADDRESS);
        for (int i = 0; i < 20; ++i) {
            ClientMessage clientFile = this.createLargeClientMessageStreaming(session, messageSize, true);
            clientFile.putIntProperty("value", i);
            producer.send((org.apache.activemq.artemis.api.core.Message)clientFile);
        }
        session.commit();
        session.start();
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicInteger errors = new AtomicInteger(0);
        ClientConsumer consumer = session.createConsumer(this.ADDRESS);
        consumer.setMessageHandler(new MessageHandler(){
            int counter = 0;

            public void onMessage(ClientMessage message) {
                message.getBodyBuffer().readByte();
                try {
                    if (this.counter++ < 20) {
                        message.acknowledge();
                        session.rollback();
                    } else {
                        message.acknowledge();
                        session.commit();
                    }
                    if (this.counter == 40) {
                        latch.countDown();
                    }
                }
                catch (Exception e) {
                    latch.countDown();
                    e.printStackTrace();
                    errors.incrementAndGet();
                }
            }
        });
        Assertions.assertTrue((boolean)latch.await(40L, TimeUnit.SECONDS));
        consumer.close();
        session.close();
        this.validateNoFilesOnLargeDir();
    }

    @TestTemplate
    public void testCloseConsumer() throws Exception {
        int messageSize = 358400;
        ClientSession session = null;
        ActiveMQServer server = this.createServer(true, this.isNetty(), this.storeType);
        server.start();
        ClientSessionFactory sf = this.addSessionFactory(this.createSessionFactory(this.locator));
        session = this.addClientSession(sf.createSession(false, false, false));
        session.createQueue(QueueConfiguration.of((SimpleString)this.ADDRESS).setAddress(this.ADDRESS).setDurable(Boolean.valueOf(false)).setTemporary(Boolean.valueOf(true)));
        ClientProducer producer = session.createProducer(this.ADDRESS);
        ClientMessage clientFile = this.createLargeClientMessageStreaming(session, 358400L, true);
        producer.send((org.apache.activemq.artemis.api.core.Message)clientFile);
        session.commit();
        session.start();
        ClientConsumer consumer = session.createConsumer(this.ADDRESS);
        ClientMessage msg1 = consumer.receive(1000L);
        msg1.acknowledge();
        session.commit();
        Assertions.assertNotNull((Object)msg1);
        consumer.close();
        try {
            msg1.getBodyBuffer().readByte();
            Assertions.fail((String)"Exception was expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        session.close();
        this.validateNoFilesOnLargeDir();
    }

    @TestTemplate
    public void testDivertAndExpire() throws Exception {
        int messageSize = 358400;
        String DIVERTED = "diverted";
        ClientSession session = null;
        ActiveMQServer server = this.createServer(true, this.isNetty(), this.storeType);
        server.getConfiguration().setMessageExpiryScanPeriod(100L);
        server.start();
        server.createQueue(QueueConfiguration.of((String)"diverted"));
        server.getAddressSettingsRepository().addMatch("diverted", (Object)new AddressSettings().setExpiryDelay(Long.valueOf(250L)).setExpiryAddress(SimpleString.of((String)"divertedExpiry")).setAutoCreateExpiryResources(true));
        server.deployDivert(new DivertConfiguration().setName("myDivert").setAddress(this.ADDRESS.toString()).setForwardingAddress("diverted").setExclusive(true));
        ClientSessionFactory sf = this.addSessionFactory(this.createSessionFactory(this.locator));
        session = this.addClientSession(sf.createSession(false, false, false));
        session.createQueue(QueueConfiguration.of((SimpleString)this.ADDRESS).setDurable(Boolean.valueOf(false)).setTemporary(Boolean.valueOf(true)));
        ClientProducer producer = session.createProducer(this.ADDRESS);
        ClientMessage clientFile = this.createLargeClientMessageStreaming(session, 358400L, true);
        logger.debug("****** Send message");
        producer.send((org.apache.activemq.artemis.api.core.Message)clientFile);
        session.commit();
        session.start();
        Wait.waitFor(() -> server.locateQueue(AddressSettings.DEFAULT_EXPIRY_QUEUE_PREFIX + "diverted") != null, (long)1000L, (long)100L);
        ClientConsumer consumer = session.createConsumer(AddressSettings.DEFAULT_EXPIRY_QUEUE_PREFIX + "diverted");
        ClientMessage msg1 = consumer.receive(1000L);
        msg1.acknowledge();
        session.commit();
        Assertions.assertNotNull((Object)msg1);
        consumer.close();
        try {
            msg1.getBodyBuffer().readByte();
            Assertions.fail((String)"Exception was expected");
        }
        catch (Exception ignored) {
            logger.debug(ignored.getMessage(), (Throwable)ignored);
        }
        session.close();
        this.validateNoFilesOnLargeDir();
    }

    @TestTemplate
    public void testDeleteOnNoBinding() throws Exception {
        int messageSize = 358400;
        ActiveMQServer server = this.createServer(true, this.isNetty(), this.storeType);
        server.start();
        ClientSessionFactory sf = this.addSessionFactory(this.createSessionFactory(this.locator));
        ClientSession session = this.addClientSession(sf.createSession(false, true, false));
        ClientProducer producer = session.createProducer(UUID.randomUUID().toString());
        ClientMessage clientFile = this.createLargeClientMessageStreaming(session, 358400L, true);
        producer.send((org.apache.activemq.artemis.api.core.Message)clientFile);
        session.close();
        this.validateNoFilesOnLargeDir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    public void testFileRemovalOnFailure() throws Exception {
        final AtomicBoolean throwException = new AtomicBoolean(false);
        String queueName = RandomUtil.randomString();
        int messageSize = 358400;
        ActiveMQServer server = this.createServer(true, this.isNetty(), this.storeType);
        server.start();
        server.registerBrokerPlugin((ActiveMQServerBasePlugin)new ActiveMQServerMessagePlugin(){

            public void beforeMessageRoute(org.apache.activemq.artemis.api.core.Message message, RoutingContext context, boolean direct, boolean rejectDuplicates) throws ActiveMQException {
                if (throwException.get()) {
                    throw new ActiveMQException();
                }
            }
        });
        server.createQueue(QueueConfiguration.of((String)queueName));
        ClientSessionFactory sf = this.addSessionFactory(this.createSessionFactory(this.locator));
        ClientSession session = this.addClientSession(sf.createSession(false, true, false));
        ClientProducer producer = session.createProducer(queueName);
        ClientMessage clientFile = this.createLargeClientMessageStreaming(session, 358400L, true);
        try {
            throwException.set(true);
            producer.send((org.apache.activemq.artemis.api.core.Message)clientFile);
            Assertions.fail((String)"Should have thrown an exception here");
        }
        catch (Exception exception) {
        }
        finally {
            throwException.set(false);
        }
        Assertions.assertEquals((long)0L, (long)server.locateQueue(queueName).getMessageCount());
        session.close();
        this.validateNoFilesOnLargeDir();
    }

    @TestTemplate
    public void testDeleteUnreferencedMessage() throws Exception {
        int messageSize = 358400;
        ActiveMQServer server = this.createServer(true, this.isNetty(), this.storeType);
        server.start();
        server.createQueue(QueueConfiguration.of((String)this.getName()).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(true)));
        ClientSessionFactory sf = this.addSessionFactory(this.createSessionFactory(this.locator));
        ClientSession session = this.addClientSession(sf.createSession(false, true, false));
        ClientProducer producer = session.createProducer(this.getName());
        ClientMessage clientFile = this.createLargeClientMessageStreaming(session, 358400L, true);
        producer.send((org.apache.activemq.artemis.api.core.Message)clientFile);
        session.close();
        Queue queue = server.locateQueue(this.getName());
        queue.forEach(ref -> {
            if (ref.getMessage().isLargeMessage()) {
                try {
                    server.getStorageManager().storeAcknowledge(queue.getID().longValue(), ref.getMessageID());
                }
                catch (Exception e) {
                    logger.warn(e.getMessage(), (Throwable)e);
                }
            }
        });
        server.stop();
        try (AssertionLoggerHandler loggerHandler = new AssertionLoggerHandler();){
            server.start();
            Assertions.assertTrue((boolean)loggerHandler.findText(new String[]{"AMQ221019"}));
        }
        this.validateNoFilesOnLargeDir();
        this.runAfter(() -> ((ActiveMQServer)server).stop());
    }

    @TestTemplate
    public void testPendingRecord() throws Exception {
        ActiveMQServer server = this.createServer(true, this.isNetty(), this.storeType);
        server.start();
        int messageSize = 358400;
        ClientSessionFactory sf = this.addSessionFactory(this.createSessionFactory(this.locator));
        ClientSession session = this.addClientSession(sf.createSession(false, true, false));
        session.createQueue(QueueConfiguration.of((SimpleString)this.ADDRESS));
        ClientProducer producer = session.createProducer(this.ADDRESS);
        ClientMessage clientFile = this.createLargeClientMessageStreaming(session, 358400L, true);
        producer.send((org.apache.activemq.artemis.api.core.Message)clientFile);
        this.validateLargeMessageComplete(server);
        sf.close();
        server.stop();
        server = this.createServer(true, this.isNetty(), this.storeType);
        server.start();
        sf = this.addSessionFactory(this.createSessionFactory(this.locator));
        session = this.addClientSession(sf.createSession(false, true, false));
        ClientConsumer consumer = session.createConsumer(this.ADDRESS);
        session.start();
        ClientMessage message = consumer.receiveImmediate();
        Assertions.assertNotNull((Object)message);
        for (int i = 0; i < 358400; ++i) {
            Assertions.assertEquals((byte)LargeMessageTest.getSamplebyte(i), (byte)message.getBodyBuffer().readByte(), (String)("position = " + i));
        }
        message.acknowledge();
        session.commit();
        this.validateNoFilesOnLargeDir();
    }

    protected void validateLargeMessageComplete(ActiveMQServer server) throws Exception {
        Queue queue = server.locateQueue(this.ADDRESS);
        Wait.assertEquals((long)1L, () -> ((Queue)queue).getMessageCount());
        LinkedListIterator browserIterator = queue.browserIterator();
        while (browserIterator.hasNext()) {
            MessageReference ref = (MessageReference)browserIterator.next();
            org.apache.activemq.artemis.api.core.Message message = ref.getMessage();
            Assertions.assertNotNull((Object)message);
            Assertions.assertTrue((boolean)(message instanceof LargeServerMessage));
        }
        browserIterator.close();
    }

    @TestTemplate
    public void testDeleteOnDrop() throws Exception {
        this.fillAddress();
        int messageSize = 358400;
        ClientSessionFactory sf = this.addSessionFactory(this.createSessionFactory(this.locator));
        ClientSession session = this.addClientSession(sf.createSession(false, true, false));
        ClientProducer producer = session.createProducer(this.ADDRESS);
        ClientMessage clientFile = this.createLargeClientMessageStreaming(session, 358400L, true);
        producer.send((org.apache.activemq.artemis.api.core.Message)clientFile);
        this.validateNoFilesOnLargeDir();
    }

    private void fillAddress() throws Exception {
        int PAGE_MAX = 102400;
        int PAGE_SIZE = 10240;
        int MESSAGE_SIZE = 1024;
        Configuration config = this.createDefaultInVMConfig().setJournalSyncNonTransactional(false);
        ActiveMQServer server = this.createServer(true, config, 10240, 102400L, new HashMap<String, AddressSettings>(), this.storeType);
        server.start();
        ((AddressSettings)server.getAddressSettingsRepository().getMatch("#")).setAddressFullMessagePolicy(AddressFullMessagePolicy.DROP);
        this.locator = this.createInVMNonHALocator().setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true);
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(false, false, false);
        session.createQueue(QueueConfiguration.of((SimpleString)this.ADDRESS));
        ClientProducer producer = session.createProducer(this.ADDRESS);
        byte[] body = new byte[1024];
        ByteBuffer bb = ByteBuffer.wrap(body);
        for (int j = 1; j <= 1024; ++j) {
            bb.put(LargeMessageTest.getSamplebyte(j));
        }
        for (int i = 0; i < 5000; ++i) {
            ClientMessage message = session.createMessage(true);
            ActiveMQBuffer bodyLocal = message.getBodyBuffer();
            bodyLocal.writeBytes(body);
            message.putIntProperty(SimpleString.of((String)"id"), i);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
            if (i % 1000 != 0) continue;
            session.commit();
        }
        session.commit();
        session.close();
    }

    @TestTemplate
    public void testLargeBufferTransacted() throws Exception {
        this.doTestLargeBuffer(true);
    }

    @TestTemplate
    public void testLargeBufferNotTransacted() throws Exception {
        this.doTestLargeBuffer(false);
    }

    public void doTestLargeBuffer(boolean transacted) throws Exception {
        int journalsize = 102400;
        int messageSize = 307200;
        ClientSession session = null;
        Configuration config = this.storeType == StoreConfiguration.StoreType.DATABASE ? this.createDefaultJDBCConfig(this.isNetty()) : this.createDefaultConfig(this.isNetty());
        config.setJournalFileSize(102400).setJournalBufferSize_AIO(10240).setJournalBufferSize_NIO(10240);
        ActiveMQServer server = this.createServer(true, config);
        server.start();
        ClientSessionFactory sf = this.addSessionFactory(this.createSessionFactory(this.locator));
        session = this.addClientSession(sf.createSession(!transacted, !transacted, 0));
        session.createQueue(QueueConfiguration.of((SimpleString)this.ADDRESS));
        ClientProducer producer = session.createProducer(this.ADDRESS);
        ClientMessage clientFile = session.createMessage(true);
        for (int i = 0; i < 307200; ++i) {
            clientFile.getBodyBuffer().writeByte(LargeMessageTest.getSamplebyte(i));
        }
        producer.send((org.apache.activemq.artemis.api.core.Message)clientFile);
        if (transacted) {
            session.commit();
        }
        session.start();
        ClientConsumer consumer = session.createConsumer(this.ADDRESS);
        ClientMessage msg1 = consumer.receive(5000L);
        Assertions.assertNotNull((Object)msg1);
        Assertions.assertNotNull((Object)msg1);
        for (int i = 0; i < 307200; ++i) {
            Assertions.assertEquals((byte)LargeMessageTest.getSamplebyte(i), (byte)msg1.getBodyBuffer().readByte(), (String)("position = " + i));
        }
        msg1.acknowledge();
        consumer.close();
        if (transacted) {
            session.commit();
        }
        session.close();
        this.validateNoFilesOnLargeDir();
    }

    @TestTemplate
    public void testDLALargeMessage() throws Exception {
        int i;
        int messageSize = 358400;
        ClientSession session = null;
        ActiveMQServer server = this.createServer(true, this.isNetty(), this.storeType);
        server.start();
        ClientSessionFactory sf = this.addSessionFactory(this.createSessionFactory(this.locator));
        session = this.addClientSession(sf.createSession(false, false, false));
        session.createQueue(QueueConfiguration.of((SimpleString)this.ADDRESS));
        session.createQueue(QueueConfiguration.of((SimpleString)this.ADDRESS.concat("-2")).setAddress(this.ADDRESS));
        SimpleString ADDRESS_DLA = this.ADDRESS.concat("-dla");
        AddressSettings addressSettings = new AddressSettings().setDeadLetterAddress(ADDRESS_DLA).setMaxDeliveryAttempts(1);
        server.getAddressSettingsRepository().addMatch("*", (Object)addressSettings);
        session.createQueue(QueueConfiguration.of((SimpleString)ADDRESS_DLA));
        ClientProducer producer = session.createProducer(this.ADDRESS);
        ClientMessage clientFile = this.createLargeClientMessageStreaming(session, 358400L, true);
        producer.send((org.apache.activemq.artemis.api.core.Message)clientFile);
        session.commit();
        session.start();
        ClientConsumer consumer = session.createConsumer(ADDRESS_DLA);
        ClientConsumer consumerRollback = session.createConsumer(this.ADDRESS);
        ClientMessage msg1 = consumerRollback.receive(1000L);
        Assertions.assertNotNull((Object)msg1);
        msg1.acknowledge();
        session.rollback();
        consumerRollback.close();
        msg1 = consumer.receive(10000L);
        Assertions.assertNotNull((Object)msg1);
        for (i = 0; i < 358400; ++i) {
            Assertions.assertEquals((byte)ActiveMQTestBase.getSamplebyte(i), (byte)msg1.getBodyBuffer().readByte());
        }
        session.close();
        server.stop();
        server = this.createServer(true, this.isNetty(), this.storeType);
        server.start();
        sf = this.createSessionFactory(this.locator);
        session = sf.createSession(false, false, false);
        session.start();
        consumer = session.createConsumer(ADDRESS_DLA);
        msg1 = consumer.receive(10000L);
        Assertions.assertNotNull((Object)msg1);
        for (i = 0; i < 358400; ++i) {
            Assertions.assertEquals((byte)ActiveMQTestBase.getSamplebyte(i), (byte)msg1.getBodyBuffer().readByte());
        }
        msg1.acknowledge();
        session.commit();
        if (this.storeType != StoreConfiguration.StoreType.DATABASE) {
            this.validateNoFilesOnLargeDir(server.getConfiguration().getLargeMessagesDirectory(), this.isCompressedTest ? 0 : 1);
        }
        consumer = session.createConsumer(this.ADDRESS.concat("-2"));
        msg1 = consumer.receive(10000L);
        Assertions.assertNotNull((Object)msg1);
        for (i = 0; i < 358400; ++i) {
            Assertions.assertEquals((byte)ActiveMQTestBase.getSamplebyte(i), (byte)msg1.getBodyBuffer().readByte());
        }
        msg1.acknowledge();
        session.commit();
        session.close();
        if (this.storeType != StoreConfiguration.StoreType.DATABASE) {
            this.validateNoFilesOnLargeDir();
        }
    }

    @TestTemplate
    public void testDeliveryCount() throws Exception {
        int i;
        int messageSize = 358400;
        ClientSession session = null;
        ActiveMQServer server = this.createServer(true, this.isNetty(), this.storeType);
        server.start();
        ClientSessionFactory sf = this.addSessionFactory(this.createSessionFactory(this.locator));
        session = sf.createSession(false, false, false);
        session.createQueue(QueueConfiguration.of((SimpleString)this.ADDRESS));
        ClientProducer producer = session.createProducer(this.ADDRESS);
        ClientMessage clientFile = this.createLargeClientMessageStreaming(session, 358400L, true);
        producer.send((org.apache.activemq.artemis.api.core.Message)clientFile);
        session.commit();
        session.start();
        ClientConsumer consumer = session.createConsumer(this.ADDRESS);
        ClientMessage msg = consumer.receive(10000L);
        Assertions.assertNotNull((Object)msg);
        msg.acknowledge();
        Assertions.assertEquals((int)1, (int)msg.getDeliveryCount());
        logger.debug("body buffer is {}", (Object)msg.getBodyBuffer());
        for (i = 0; i < 358400; ++i) {
            Assertions.assertEquals((byte)ActiveMQTestBase.getSamplebyte(i), (byte)msg.getBodyBuffer().readByte());
        }
        session.rollback();
        session.close();
        session = sf.createSession(false, false, false);
        session.start();
        consumer = session.createConsumer(this.ADDRESS);
        msg = consumer.receive(10000L);
        Assertions.assertNotNull((Object)msg);
        msg.acknowledge();
        for (i = 0; i < 358400; ++i) {
            Assertions.assertEquals((byte)ActiveMQTestBase.getSamplebyte(i), (byte)msg.getBodyBuffer().readByte());
        }
        Assertions.assertEquals((int)2, (int)msg.getDeliveryCount());
        msg.acknowledge();
        consumer.close();
        session.commit();
        this.validateNoFilesOnLargeDir();
    }

    @TestTemplate
    public void testDLQAlmostLarge() throws Exception {
        SimpleString addressName = SimpleString.of((String)"SomewhatHugeNameToBeUsedxxxxxxxxxxxxxxxxxxxiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiixxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx");
        SimpleString dlqName = SimpleString.of((String)("DLQ" + addressName.toString()));
        ClientSession session = null;
        ActiveMQServer server = this.createServer(true, this.isNetty(), this.storeType);
        server.getConfiguration().setJournalFileSize(0x100000);
        server.getConfiguration().setJournalBufferSize_AIO(102400);
        server.start();
        server.getAddressSettingsRepository().clear();
        AddressSettings settings = new AddressSettings().setDeadLetterAddress(dlqName).setMaxDeliveryAttempts(1);
        server.getAddressSettingsRepository().addMatch("#", (Object)settings);
        this.createAnycastPair(server, dlqName.toString());
        this.createAnycastPair(server, addressName.toString());
        this.locator.setMinLargeMessageSize(0x100000);
        ClientSessionFactory sf = this.addSessionFactory(this.createSessionFactory(this.locator));
        session = sf.createSession(false, false, false);
        ClientProducer producer = session.createProducer(addressName);
        ClientMessage clientMessage = session.createMessage(true);
        clientMessage.getBodyBuffer().writeBytes(new byte[101500]);
        producer.send((org.apache.activemq.artemis.api.core.Message)clientMessage);
        session.commit();
        session.start();
        ClientConsumer consumer = session.createConsumer(addressName);
        for (int i = 0; i < 2; ++i) {
            ClientMessage msg;
            if (i == 0) {
                msg = consumer.receive(10000L);
                Assertions.assertNotNull((Object)msg);
                msg.acknowledge();
                session.rollback();
                continue;
            }
            msg = consumer.receiveImmediate();
            Assertions.assertNull((Object)msg);
        }
        consumer.close();
        consumer = session.createConsumer(dlqName);
        ClientMessage msg = consumer.receive(1000L);
        Assertions.assertNotNull((Object)msg);
    }

    @TestTemplate
    public void testDLAOnExpiryNonDurableMessage() throws Exception {
        int i;
        int messageSize = 358400;
        ClientSession session = null;
        ActiveMQServer server = this.createServer(true, this.isNetty(), this.storeType);
        server.start();
        ClientSessionFactory sf = this.addSessionFactory(this.createSessionFactory(this.locator));
        SimpleString ADDRESS_DLA = this.ADDRESS.concat("-dla");
        SimpleString ADDRESS_EXPIRY = this.ADDRESS.concat("-expiry");
        AddressSettings addressSettings = new AddressSettings().setDeadLetterAddress(ADDRESS_DLA).setExpiryAddress(ADDRESS_EXPIRY).setMaxDeliveryAttempts(1);
        server.getAddressSettingsRepository().addMatch("*", (Object)addressSettings);
        session = sf.createSession(false, false, false);
        session.createQueue(QueueConfiguration.of((SimpleString)this.ADDRESS));
        session.createQueue(QueueConfiguration.of((SimpleString)ADDRESS_DLA));
        session.createQueue(QueueConfiguration.of((SimpleString)ADDRESS_EXPIRY));
        ClientProducer producer = session.createProducer(this.ADDRESS);
        ClientMessage clientFile = this.createLargeClientMessageStreaming(session, 358400L, false);
        clientFile.setExpiration(System.currentTimeMillis());
        producer.send((org.apache.activemq.artemis.api.core.Message)clientFile);
        session.commit();
        session.start();
        ClientConsumer consumerExpired = session.createConsumer(this.ADDRESS);
        Assertions.assertNull((Object)consumerExpired.receiveImmediate());
        consumerExpired.close();
        ClientConsumer consumerExpiry = session.createConsumer(ADDRESS_EXPIRY);
        ClientMessage msg1 = consumerExpiry.receive(5000L);
        Assertions.assertTrue((boolean)msg1.isLargeMessage());
        Assertions.assertNotNull((Object)msg1);
        msg1.acknowledge();
        for (int j = 0; j < 358400; ++j) {
            Assertions.assertEquals((byte)ActiveMQTestBase.getSamplebyte(j), (byte)msg1.getBodyBuffer().readByte());
        }
        session.rollback();
        consumerExpiry.close();
        for (i = 0; i < 10; ++i) {
            consumerExpiry = session.createConsumer(ADDRESS_DLA);
            msg1 = consumerExpiry.receive(5000L);
            Assertions.assertNotNull((Object)msg1);
            msg1.acknowledge();
            for (int j = 0; j < 358400; ++j) {
                Assertions.assertEquals((byte)ActiveMQTestBase.getSamplebyte(j), (byte)msg1.getBodyBuffer().readByte());
            }
            session.rollback();
            consumerExpiry.close();
        }
        session.close();
        session = sf.createSession(false, false, false);
        session.start();
        consumerExpiry = session.createConsumer(ADDRESS_DLA);
        msg1 = consumerExpiry.receive(5000L);
        Assertions.assertNotNull((Object)msg1);
        msg1.acknowledge();
        for (i = 0; i < 358400; ++i) {
            Assertions.assertEquals((byte)ActiveMQTestBase.getSamplebyte(i), (byte)msg1.getBodyBuffer().readByte());
        }
        session.commit();
        consumerExpiry.close();
        session.commit();
        session.close();
        server.stop();
        server.start();
        this.validateNoFilesOnLargeDir();
    }

    @TestTemplate
    public void testDLAOnExpiry() throws Exception {
        int i;
        int messageSize = 358400;
        ClientSession session = null;
        ActiveMQServer server = this.createServer(true, this.isNetty(), this.storeType);
        server.start();
        ClientSessionFactory sf = this.addSessionFactory(this.createSessionFactory(this.locator));
        SimpleString ADDRESS_DLA = this.ADDRESS.concat("-dla");
        SimpleString ADDRESS_EXPIRY = this.ADDRESS.concat("-expiry");
        AddressSettings addressSettings = new AddressSettings().setDeadLetterAddress(ADDRESS_DLA).setExpiryAddress(ADDRESS_EXPIRY).setMaxDeliveryAttempts(1);
        server.getAddressSettingsRepository().addMatch("*", (Object)addressSettings);
        session = sf.createSession(false, false, false);
        session.createQueue(QueueConfiguration.of((SimpleString)this.ADDRESS));
        session.createQueue(QueueConfiguration.of((SimpleString)ADDRESS_DLA));
        session.createQueue(QueueConfiguration.of((SimpleString)ADDRESS_EXPIRY));
        ClientProducer producer = session.createProducer(this.ADDRESS);
        ClientMessage clientFile = this.createLargeClientMessageStreaming(session, 358400L, true);
        clientFile.setExpiration(System.currentTimeMillis());
        producer.send((org.apache.activemq.artemis.api.core.Message)clientFile);
        session.commit();
        session.start();
        ClientConsumer consumerExpired = session.createConsumer(this.ADDRESS);
        Assertions.assertNull((Object)consumerExpired.receiveImmediate());
        consumerExpired.close();
        ClientConsumer consumerExpiry = session.createConsumer(ADDRESS_EXPIRY);
        ClientMessage msg1 = consumerExpiry.receive(5000L);
        Assertions.assertNotNull((Object)msg1);
        msg1.acknowledge();
        for (int j = 0; j < 358400; ++j) {
            Assertions.assertEquals((byte)ActiveMQTestBase.getSamplebyte(j), (byte)msg1.getBodyBuffer().readByte());
        }
        session.rollback();
        consumerExpiry.close();
        for (i = 0; i < 10; ++i) {
            consumerExpiry = session.createConsumer(ADDRESS_DLA);
            msg1 = consumerExpiry.receive(5000L);
            Assertions.assertNotNull((Object)msg1);
            msg1.acknowledge();
            for (int j = 0; j < 358400; ++j) {
                Assertions.assertEquals((byte)ActiveMQTestBase.getSamplebyte(j), (byte)msg1.getBodyBuffer().readByte());
            }
            session.rollback();
            consumerExpiry.close();
        }
        session.close();
        server.stop();
        server = this.createServer(true, this.isNetty(), this.storeType);
        server.start();
        sf = this.createSessionFactory(this.locator);
        session = sf.createSession(false, false, false);
        session.start();
        consumerExpiry = session.createConsumer(ADDRESS_DLA);
        msg1 = consumerExpiry.receive(5000L);
        Assertions.assertNotNull((Object)msg1);
        msg1.acknowledge();
        for (i = 0; i < 358400; ++i) {
            Assertions.assertEquals((byte)ActiveMQTestBase.getSamplebyte(i), (byte)msg1.getBodyBuffer().readByte());
        }
        session.commit();
        consumerExpiry.close();
        session.commit();
        session.close();
        this.validateNoFilesOnLargeDir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    public void testExpiryLargeMessage() throws Exception {
        int messageSize = 307200;
        ClientSession session = null;
        try {
            int i;
            ActiveMQServer server = this.createServer(true, this.isNetty(), this.storeType);
            server.start();
            SimpleString ADDRESS_EXPIRY = this.ADDRESS.concat("-expiry");
            AddressSettings addressSettings = new AddressSettings().setExpiryAddress(ADDRESS_EXPIRY);
            server.getAddressSettingsRepository().addMatch("*", (Object)addressSettings);
            ClientSessionFactory sf = this.addSessionFactory(this.createSessionFactory(this.locator));
            session = sf.createSession(false, false, false);
            session.createQueue(QueueConfiguration.of((SimpleString)this.ADDRESS));
            session.createQueue(QueueConfiguration.of((SimpleString)ADDRESS_EXPIRY));
            ClientProducer producer = session.createProducer(this.ADDRESS);
            ClientMessage clientFile = this.createLargeClientMessageStreaming(session, 307200L, true);
            clientFile.setExpiration(System.currentTimeMillis());
            producer.send((org.apache.activemq.artemis.api.core.Message)clientFile);
            session.commit();
            session.start();
            ClientConsumer consumer = session.createConsumer(ADDRESS_EXPIRY);
            ClientConsumer consumer2 = session.createConsumer(this.ADDRESS);
            Assertions.assertNull((Object)consumer2.receiveImmediate());
            ClientMessage msg1 = consumer.receive(50000L);
            Assertions.assertNotNull((Object)msg1);
            for (i = 0; i < 307200; ++i) {
                Assertions.assertEquals((byte)ActiveMQTestBase.getSamplebyte(i), (byte)msg1.getBodyBuffer().readByte());
            }
            session.close();
            server.stop();
            server = this.createServer(true, this.isNetty(), this.storeType);
            server.start();
            sf = this.createSessionFactory(this.locator);
            session = sf.createSession(false, false, false);
            session.start();
            consumer = session.createConsumer(ADDRESS_EXPIRY);
            msg1 = consumer.receive(10000L);
            Assertions.assertNotNull((Object)msg1);
            for (i = 0; i < 307200; ++i) {
                Assertions.assertEquals((byte)ActiveMQTestBase.getSamplebyte(i), (byte)msg1.getBodyBuffer().readByte());
            }
            msg1.acknowledge();
            session.commit();
            session.close();
            this.validateNoFilesOnLargeDir();
        }
        finally {
            try {
                session.close();
            }
            catch (Throwable throwable) {}
        }
    }

    @TestTemplate
    public void testSentWithDuplicateIDBridge() throws Exception {
        this.internalTestSentWithDuplicateID(true);
    }

    @TestTemplate
    public void testSentWithDuplicateID() throws Exception {
        this.internalTestSentWithDuplicateID(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalTestSentWithDuplicateID(boolean isSimulateBridge) throws Exception {
        int messageSize = 307200;
        ClientSession session = null;
        try {
            ActiveMQServer server = this.createServer(true, this.isNetty(), this.storeType);
            server.start();
            ClientSessionFactory sf = this.addSessionFactory(this.createSessionFactory(this.locator));
            session = sf.createSession(true, true, 0);
            session.createQueue(QueueConfiguration.of((SimpleString)this.ADDRESS));
            ClientProducer producer = session.createProducer(this.ADDRESS);
            String someDuplicateInfo = "Anything";
            for (int i = 0; i < 10; ++i) {
                ClientMessage clientFile = this.createLargeClientMessageStreaming(session, 307200L, true);
                if (isSimulateBridge) {
                    clientFile.putBytesProperty(org.apache.activemq.artemis.api.core.Message.HDR_BRIDGE_DUPLICATE_ID, someDuplicateInfo.getBytes());
                } else {
                    clientFile.putBytesProperty(org.apache.activemq.artemis.api.core.Message.HDR_DUPLICATE_DETECTION_ID, someDuplicateInfo.getBytes());
                }
                producer.send((org.apache.activemq.artemis.api.core.Message)clientFile);
            }
            ClientConsumer consumer = session.createConsumer(this.ADDRESS);
            session.start();
            ClientMessage msg = consumer.receive(10000L);
            for (int i = 0; i < 307200; ++i) {
                Assertions.assertEquals((byte)LargeMessageTest.getSamplebyte(i), (byte)msg.getBodyBuffer().readByte());
            }
            Assertions.assertNotNull((Object)msg);
            msg.acknowledge();
            Assertions.assertNull((Object)consumer.receiveImmediate());
            session.commit();
            this.validateNoFilesOnLargeDir();
        }
        finally {
            try {
                session.close();
            }
            catch (Throwable throwable) {}
        }
    }

    @TestTemplate
    public void testResendSmallStreamMessage() throws Exception {
        this.internalTestResendMessage(50000L);
    }

    @TestTemplate
    public void testResendLargeStreamMessage() throws Exception {
        this.internalTestResendMessage(153600L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalTestResendMessage(long messageSize) throws Exception {
        this.clearDataRecreateServerDirs();
        ClientSession session = null;
        try {
            ActiveMQServer server = this.createServer(true, this.isNetty(), this.storeType);
            server.start();
            ClientSessionFactory sf = this.addSessionFactory(this.createSessionFactory(this.locator));
            session = sf.createSession(false, false, false);
            session.createQueue(QueueConfiguration.of((SimpleString)this.ADDRESS));
            SimpleString ADDRESS2 = this.ADDRESS.concat("-2");
            session.createQueue(QueueConfiguration.of((SimpleString)ADDRESS2));
            ClientProducer producer = session.createProducer(this.ADDRESS);
            ClientProducer producer2 = session.createProducer(ADDRESS2);
            ClientMessage clientFile = this.createLargeClientMessageStreaming(session, messageSize, false);
            producer.send((org.apache.activemq.artemis.api.core.Message)clientFile);
            session.commit();
            session.start();
            ClientConsumer consumer = session.createConsumer(this.ADDRESS);
            ClientConsumer consumer2 = session.createConsumer(ADDRESS2);
            ClientMessage msg1 = consumer.receive(10000L);
            msg1.acknowledge();
            producer2.send((org.apache.activemq.artemis.api.core.Message)msg1);
            session.commit();
            ClientMessage msg2 = consumer2.receive(10000L);
            Assertions.assertNotNull((Object)msg2);
            msg2.acknowledge();
            session.commit();
            Assertions.assertEquals((long)messageSize, (long)msg2.getBodySize());
            this.compareString(messageSize, msg2);
            session.close();
            this.validateNoFilesOnLargeDir();
        }
        finally {
            try {
                session.close();
            }
            catch (Throwable throwable) {}
        }
    }

    @TestTemplate
    public void testResendCachedSmallStreamMessage() throws Exception {
        this.internalTestResendMessage(50000L);
    }

    @TestTemplate
    public void testResendCachedLargeStreamMessage() throws Exception {
        this.internalTestCachedResendMessage(153600L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalTestCachedResendMessage(long messageSize) throws Exception {
        ClientSession session = null;
        try {
            ActiveMQServer server = this.createServer(true, this.isNetty(), this.storeType);
            server.start();
            this.locator.setMinLargeMessageSize(200).setCacheLargeMessagesClient(true);
            ClientSessionFactory sf = this.addSessionFactory(this.createSessionFactory(this.locator));
            session = sf.createSession(false, false, false);
            session.createQueue(QueueConfiguration.of((SimpleString)this.ADDRESS));
            ClientProducer producer = session.createProducer(this.ADDRESS);
            ClientMessage originalMsg = this.createLargeClientMessageStreaming(session, messageSize, false);
            producer.send((org.apache.activemq.artemis.api.core.Message)originalMsg);
            session.commit();
            ClientConsumer consumer = session.createConsumer(this.ADDRESS);
            session.start();
            ClientMessage msgReceived = consumer.receive(10000L);
            msgReceived.acknowledge();
            session.commit();
            this.compareString(messageSize, msgReceived);
            msgReceived.getBodyBuffer().readerIndex(0);
            producer.send((org.apache.activemq.artemis.api.core.Message)msgReceived);
            session.commit();
            ClientMessage msgReceived2 = consumer.receive(10000L);
            msgReceived2.acknowledge();
            this.compareString(messageSize, msgReceived2);
            session.commit();
            session.close();
            this.validateNoFilesOnLargeDir();
        }
        finally {
            try {
                session.close();
            }
            catch (Throwable throwable) {}
        }
    }

    private void compareString(long messageSize, ClientMessage msg) {
        Assertions.assertNotNull((Object)msg);
        for (long i = 0L; i < messageSize; ++i) {
            Assertions.assertEquals((byte)ActiveMQTestBase.getSamplebyte(i), (byte)msg.getBodyBuffer().readByte(), (String)("position " + i));
        }
    }

    @TestTemplate
    public void testFilePersistenceOneHugeMessage() throws Exception {
        this.testChunks(false, false, false, true, true, false, false, false, false, 1, this.largeMessageSize, 10000, 0L, 0xA00000, 0x100000);
    }

    @TestTemplate
    public void testFilePersistenceOneMessageStreaming() throws Exception {
        this.testChunks(false, false, false, true, true, false, false, false, false, 1, this.largeMessageSize, 10000, 0L);
    }

    @TestTemplate
    public void testFilePersistenceSmallMessageStreaming() throws Exception {
        this.testChunks(false, false, false, true, true, false, false, false, false, 100, 1024L, 10000, 0L);
    }

    @TestTemplate
    public void testFilePersistenceOneHugeMessageConsumer() throws Exception {
        this.testChunks(false, false, false, true, true, false, false, false, true, 1, this.largeMessageSize, 120000, 0L, 0xA00000, 0x100000);
    }

    @TestTemplate
    public void testFilePersistence() throws Exception {
        this.testChunks(false, false, true, false, true, false, false, true, false, 100, this.largeMessageSize, 10000, 0L);
    }

    @TestTemplate
    public void testFilePersistenceConsumer() throws Exception {
        this.testChunks(false, false, true, false, true, false, false, true, true, 2, this.largeMessageSize, 10000, 0L);
    }

    @TestTemplate
    public void testFilePersistenceXA() throws Exception {
        this.testChunks(true, false, true, false, true, false, false, true, false, 100, this.largeMessageSize, 10000, 0L);
    }

    @TestTemplate
    public void testFilePersistenceXAStream() throws Exception {
        this.testChunks(true, false, false, true, true, false, false, false, false, 1, 0x100000L, 10000, 0L);
    }

    @TestTemplate
    public void testFilePersistenceXAStreamRestart() throws Exception {
        this.testChunks(true, true, false, true, true, false, false, false, false, 1, 0x100000L, 10000, 0L);
    }

    @TestTemplate
    public void testFilePersistenceXAConsumer() throws Exception {
        this.testChunks(true, false, true, false, true, false, false, true, true, 100, this.largeMessageSize, 10000, 0L);
    }

    @TestTemplate
    public void testFilePersistenceXAConsumerRestart() throws Exception {
        this.testChunks(true, true, true, false, true, false, false, true, true, 100, this.largeMessageSize, 10000, 0L);
    }

    @TestTemplate
    public void testFilePersistenceBlocked() throws Exception {
        this.testChunks(false, false, true, false, true, false, true, true, false, 100, this.largeMessageSize, 10000, 0L);
    }

    @TestTemplate
    public void testFilePersistenceBlockedConsumer() throws Exception {
        this.testChunks(false, false, true, false, true, false, true, true, true, 100, this.largeMessageSize, 10000, 0L);
    }

    @TestTemplate
    public void testFilePersistenceBlockedXA() throws Exception {
        this.testChunks(true, false, true, false, true, false, true, true, false, 100, this.largeMessageSize, 10000, 0L);
    }

    @TestTemplate
    public void testFilePersistenceBlockedXAConsumer() throws Exception {
        this.testChunks(true, false, true, false, true, false, true, true, true, 100, this.largeMessageSize, 10000, 0L);
    }

    @TestTemplate
    public void testFilePersistenceBlockedPreACK() throws Exception {
        this.testChunks(false, false, true, false, true, true, true, true, false, 1, this.largeMessageSize, 10000, 0L);
    }

    @TestTemplate
    public void testFilePersistenceBlockedPreACKConsumer() throws Exception {
        this.testChunks(false, false, true, false, true, true, true, true, true, 1, this.largeMessageSize, 10000, 0L);
    }

    @TestTemplate
    public void testFilePersistenceBlockedPreACKXA() throws Exception {
        this.testChunks(true, false, true, false, true, true, true, true, false, 100, this.largeMessageSize, 10000, 0L);
    }

    @TestTemplate
    public void testFilePersistenceBlockedPreACKXARestart() throws Exception {
        this.testChunks(true, true, true, false, true, true, true, true, false, 100, this.largeMessageSize, 10000, 0L);
    }

    @TestTemplate
    public void testFilePersistenceBlockedPreACKXAConsumer() throws Exception {
        this.testChunks(true, false, true, false, true, true, true, true, true, 100, this.largeMessageSize, 10000, 0L);
    }

    @TestTemplate
    public void testFilePersistenceBlockedPreACKXAConsumerRestart() throws Exception {
        this.testChunks(true, true, true, false, true, true, true, true, true, 100, this.largeMessageSize, 10000, 0L);
    }

    @TestTemplate
    public void testFilePersistenceDelayed() throws Exception {
        this.testChunks(false, false, true, false, true, false, false, false, false, 1, this.largeMessageSize, 10000, 200L);
    }

    @TestTemplate
    public void testFilePersistenceDelayedConsumer() throws Exception {
        this.testChunks(false, false, true, false, true, false, false, false, true, 1, this.largeMessageSize, 10000, 200L);
    }

    @TestTemplate
    public void testFilePersistenceDelayedXA() throws Exception {
        this.testChunks(true, false, true, false, true, false, false, false, false, 1, this.largeMessageSize, 10000, 200L);
    }

    @TestTemplate
    public void testFilePersistenceDelayedXAConsumer() throws Exception {
        this.testChunks(true, false, true, false, true, false, false, false, true, 1, this.largeMessageSize, 10000, 200L);
    }

    @TestTemplate
    public void testNullPersistence() throws Exception {
        this.testChunks(false, false, true, false, false, false, false, true, true, 1, this.largeMessageSize, 10000, 0L);
    }

    @TestTemplate
    public void testNullPersistenceConsumer() throws Exception {
        this.testChunks(false, false, true, false, false, false, false, true, true, 1, this.largeMessageSize, 10000, 0L);
    }

    @TestTemplate
    public void testNullPersistenceXA() throws Exception {
        this.testChunks(true, false, true, false, false, false, false, true, false, 1, this.largeMessageSize, 10000, 0L);
    }

    @TestTemplate
    public void testNullPersistenceXAConsumer() throws Exception {
        this.testChunks(true, false, true, false, false, false, false, true, true, 1, this.largeMessageSize, 10000, 0L);
    }

    @TestTemplate
    public void testNullPersistenceDelayed() throws Exception {
        this.testChunks(false, false, true, false, false, false, false, false, false, 100, this.largeMessageSize, 10000, 100L);
    }

    @TestTemplate
    public void testNullPersistenceDelayedConsumer() throws Exception {
        this.testChunks(false, false, true, false, false, false, false, false, true, 100, this.largeMessageSize, 10000, 100L);
    }

    @TestTemplate
    public void testNullPersistenceDelayedXA() throws Exception {
        this.testChunks(true, false, true, false, false, false, false, false, false, 100, this.largeMessageSize, 10000, 100L);
    }

    @TestTemplate
    public void testNullPersistenceDelayedXAConsumer() throws Exception {
        this.testChunks(true, false, true, false, false, false, false, false, true, 100, this.largeMessageSize, 10000, 100L);
    }

    @TestTemplate
    public void testPageOnLargeMessage() throws Exception {
        this.testPageOnLargeMessage(true, false);
    }

    @TestTemplate
    public void testSendSmallMessageXA() throws Exception {
        this.testChunks(true, false, true, false, true, false, false, true, false, 100, 4L, 10000, 0L);
    }

    @TestTemplate
    public void testSendSmallMessageXAConsumer() throws Exception {
        this.testChunks(true, false, true, false, true, false, false, true, true, 100, 4L, 10000, 0L);
    }

    @TestTemplate
    public void testSendSmallMessageNullPersistenceXA() throws Exception {
        this.testChunks(true, false, true, false, false, false, false, true, false, 100, 100L, 10000, 0L);
    }

    @TestTemplate
    public void testSendSmallMessageNullPersistenceXAConsumer() throws Exception {
        this.testChunks(true, false, true, false, false, false, false, true, true, 100, 100L, 10000, 0L);
    }

    @TestTemplate
    public void testSendRegularMessageNullPersistenceDelayed() throws Exception {
        this.testChunks(false, false, true, false, false, false, false, false, false, 100, 100L, 10000, 100L);
    }

    @TestTemplate
    public void testSendRegularMessageNullPersistenceDelayedConsumer() throws Exception {
        this.testChunks(false, false, true, false, false, false, false, false, true, 100, 100L, 10000, 100L);
    }

    @TestTemplate
    public void testSendRegularMessageNullPersistenceDelayedXA() throws Exception {
        this.testChunks(true, false, true, false, false, false, false, false, false, 100, 100L, 10000, 100L);
    }

    @TestTemplate
    public void testSendRegularMessageNullPersistenceDelayedXAConsumer() throws Exception {
        this.testChunks(true, false, true, false, false, false, false, false, true, 100, 100L, 10000, 100L);
    }

    @TestTemplate
    public void testSendRegularMessagePersistence() throws Exception {
        this.testChunks(false, false, true, false, true, false, false, true, false, 100, 100L, 10000, 0L);
    }

    @TestTemplate
    public void testSendRegularMessagePersistenceConsumer() throws Exception {
        this.testChunks(false, false, true, false, true, false, false, true, true, 100, 100L, 10000, 0L);
    }

    @TestTemplate
    public void testSendRegularMessagePersistenceXA() throws Exception {
        this.testChunks(true, false, true, false, true, false, false, true, false, 100, 100L, 10000, 0L);
    }

    @TestTemplate
    public void testSendRegularMessagePersistenceXAConsumer() throws Exception {
        this.testChunks(true, false, true, false, true, false, false, true, true, 100, 100L, 10000, 0L);
    }

    @TestTemplate
    public void testSendRegularMessagePersistenceDelayed() throws Exception {
        this.testChunks(false, false, true, false, true, false, false, false, false, 100, 100L, 10000, 100L);
    }

    @TestTemplate
    public void testSendRegularMessagePersistenceDelayedConsumer() throws Exception {
        this.testChunks(false, false, true, false, true, false, false, false, true, 100, 100L, 10000, 100L);
    }

    @TestTemplate
    public void testSendRegularMessagePersistenceDelayedXA() throws Exception {
        this.testChunks(false, false, true, false, true, false, false, false, false, 100, 100L, 10000, 100L);
    }

    @TestTemplate
    public void testSendRegularMessagePersistenceDelayedXAConsumer() throws Exception {
        this.testChunks(false, false, true, false, true, false, false, false, true, 100, 100L, 10000, 100L);
    }

    @TestTemplate
    public void testTwoBindingsTwoStartedConsumers() throws Exception {
        ActiveMQServer server = this.createServer(true, this.isNetty(), this.storeType);
        server.start();
        SimpleString[] queue = new SimpleString[]{SimpleString.of((String)"queue1"), SimpleString.of((String)"queue2")};
        ClientSessionFactory sf = this.addSessionFactory(this.createSessionFactory(this.locator));
        ClientSession session = sf.createSession(null, null, false, true, true, false, 0);
        session.createQueue(QueueConfiguration.of((SimpleString)queue[0]).setAddress(this.ADDRESS));
        session.createQueue(QueueConfiguration.of((SimpleString)queue[1]).setAddress(this.ADDRESS));
        int numberOfBytes = 400000;
        ClientMessage clientFile = this.createLargeClientMessageStreaming(session, numberOfBytes);
        ClientProducer producer = session.createProducer(this.ADDRESS);
        session.start();
        producer.send((org.apache.activemq.artemis.api.core.Message)clientFile);
        producer.close();
        ClientConsumer consumer = session.createConsumer(queue[1]);
        ClientMessage msg = consumer.receive(10000L);
        msg.getBodyBuffer().readByte();
        Assertions.assertNull((Object)consumer.receiveImmediate());
        Assertions.assertNotNull((Object)msg);
        msg.acknowledge();
        consumer.close();
        logger.debug("Stopping");
        session.stop();
        ClientConsumer consumer1 = session.createConsumer(queue[0]);
        session.start();
        msg = consumer1.receive(10000L);
        Assertions.assertNotNull((Object)msg);
        msg.acknowledge();
        consumer1.close();
        session.commit();
        session.close();
        this.validateNoFilesOnLargeDir();
    }

    @TestTemplate
    public void testTwoBindingsAndRestart() throws Exception {
        this.testTwoBindings(true);
    }

    @TestTemplate
    public void testTwoBindingsNoRestart() throws Exception {
        this.testTwoBindings(false);
    }

    public void testTwoBindings(boolean restart) throws Exception {
        ActiveMQServer server = this.createServer(true, this.isNetty(), this.storeType);
        server.start();
        SimpleString[] queue = new SimpleString[]{SimpleString.of((String)"queue1"), SimpleString.of((String)"queue2")};
        ClientSessionFactory sf = this.addSessionFactory(this.createSessionFactory(this.locator));
        ClientSession session = sf.createSession(null, null, false, true, true, false, 0);
        session.createQueue(QueueConfiguration.of((SimpleString)queue[0]).setAddress(this.ADDRESS));
        session.createQueue(QueueConfiguration.of((SimpleString)queue[1]).setAddress(this.ADDRESS));
        int numberOfBytes = 400000;
        ClientMessage clientFile = this.createLargeClientMessageStreaming(session, numberOfBytes);
        ClientProducer producer = session.createProducer(this.ADDRESS);
        producer.send((org.apache.activemq.artemis.api.core.Message)clientFile);
        producer.close();
        this.readMessage(session, queue[1], numberOfBytes);
        if (restart) {
            session.close();
            server.stop();
            server = this.createServer(true, this.isNetty(), this.storeType);
            server.start();
            sf = this.createSessionFactory(this.locator);
            session = sf.createSession(null, null, false, true, true, false, 0);
        }
        this.readMessage(session, queue[0], numberOfBytes);
        session.close();
        this.validateNoFilesOnLargeDir();
    }

    @TestTemplate
    public void testSendRollbackXADurable() throws Exception {
        this.internalTestSendRollback(true, true);
    }

    @TestTemplate
    public void testSendRollbackXANonDurable() throws Exception {
        this.internalTestSendRollback(true, false);
    }

    @TestTemplate
    public void testSendRollbackDurable() throws Exception {
        this.internalTestSendRollback(false, true);
    }

    @TestTemplate
    public void testSendRollbackNonDurable() throws Exception {
        this.internalTestSendRollback(false, false);
    }

    private void internalTestSendRollback(boolean isXA, boolean durable) throws Exception {
        ClientSession session = null;
        ActiveMQServer server = this.createServer(true, this.isNetty(), this.storeType);
        server.start();
        ClientSessionFactory sf = this.addSessionFactory(this.createSessionFactory(this.locator));
        session = sf.createSession(isXA, false, false);
        session.createQueue(QueueConfiguration.of((SimpleString)this.ADDRESS));
        Xid xid = null;
        if (isXA) {
            xid = RandomUtil.randomXid();
            session.start(xid, 0);
        }
        ClientProducer producer = session.createProducer(this.ADDRESS);
        ClientMessage clientFile = this.createLargeClientMessageStreaming(session, 50000L, durable);
        for (int i = 0; i < 1; ++i) {
            producer.send((org.apache.activemq.artemis.api.core.Message)clientFile);
        }
        if (isXA) {
            session.end(xid, 0x4000000);
            session.prepare(xid);
            session.close();
            server.stop();
            server.start();
            sf = this.createSessionFactory(this.locator);
            session = sf.createSession(isXA, false, false);
            session.rollback(xid);
        } else {
            session.rollback();
        }
        session.close();
        this.validateNoFilesOnLargeDir();
    }

    @TestTemplate
    public void testSimpleRollback() throws Exception {
        this.simpleRollbackInternalTest(false);
    }

    @TestTemplate
    public void testSimpleRollbackXA() throws Exception {
        this.simpleRollbackInternalTest(true);
    }

    public void simpleRollbackInternalTest(boolean isXA) throws Exception {
        ActiveMQServer server = this.createServer(true, this.isNetty(), this.storeType);
        server.start();
        ClientSessionFactory sf = this.addSessionFactory(this.createSessionFactory(this.locator));
        ClientSession session = sf.createSession(isXA, false, false);
        XidImpl xid = null;
        if (isXA) {
            xid = this.newXID();
            session.start((Xid)xid, 0);
        }
        session.createQueue(QueueConfiguration.of((SimpleString)this.ADDRESS));
        int numberOfBytes = 200000;
        session.start();
        ClientProducer producer = session.createProducer(this.ADDRESS);
        ClientConsumer consumer = session.createConsumer(this.ADDRESS);
        for (int n = 0; n < 10; ++n) {
            ClientMessage clientFile = this.createLargeClientMessageStreaming(session, numberOfBytes, n % 2 == 0);
            producer.send((org.apache.activemq.artemis.api.core.Message)clientFile);
            Assertions.assertNull((Object)consumer.receiveImmediate());
            if (isXA) {
                session.end((Xid)xid, 0x4000000);
                session.rollback((Xid)xid);
                xid = this.newXID();
                session.start((Xid)xid, 0);
            } else {
                session.rollback();
            }
            clientFile = this.createLargeClientMessageStreaming(session, numberOfBytes, n % 2 == 0);
            producer.send((org.apache.activemq.artemis.api.core.Message)clientFile);
            Assertions.assertNull((Object)consumer.receiveImmediate());
            if (isXA) {
                session.end((Xid)xid, 0x4000000);
                session.commit((Xid)xid, true);
                xid = this.newXID();
                session.start((Xid)xid, 0);
            } else {
                session.commit();
            }
            for (int i = 0; i < 2; ++i) {
                ClientMessage clientMessage = consumer.receive(5000L);
                Assertions.assertNotNull((Object)clientMessage);
                Assertions.assertEquals((int)numberOfBytes, (int)clientMessage.getBodySize());
                clientMessage.acknowledge();
                if (isXA) {
                    if (i == 0) {
                        session.end((Xid)xid, 0x4000000);
                        session.prepare((Xid)xid);
                        session.rollback((Xid)xid);
                        xid = this.newXID();
                        session.start((Xid)xid, 0);
                        continue;
                    }
                    session.end((Xid)xid, 0x4000000);
                    session.commit((Xid)xid, true);
                    xid = this.newXID();
                    session.start((Xid)xid, 0);
                    continue;
                }
                if (i == 0) {
                    session.rollback();
                    continue;
                }
                session.commit();
            }
        }
        session.close();
        this.validateNoFilesOnLargeDir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    public void testBufferMultipleLargeMessages() throws Exception {
        ClientSession session = null;
        ActiveMQServer server = null;
        int SIZE = 10240;
        int NUMBER_OF_MESSAGES = 30;
        try {
            server = this.createServer(true, this.isNetty(), this.storeType);
            server.start();
            this.locator.setMinLargeMessageSize(1024).setConsumerWindowSize(0x100000);
            ClientSessionFactory sf = this.addSessionFactory(this.createSessionFactory(this.locator));
            session = sf.createSession(null, null, false, false, false, false, 0);
            session.createQueue(QueueConfiguration.of((SimpleString)this.ADDRESS));
            ClientProducer producer = session.createProducer(this.ADDRESS);
            for (int i = 0; i < 30; ++i) {
                ClientMessage clientFile = session.createMessage(true);
                clientFile.setBodyInputStream(ActiveMQTestBase.createFakeLargeStream(10240L));
                producer.send((org.apache.activemq.artemis.api.core.Message)clientFile);
            }
            session.commit();
            producer.close();
            session.start();
            ClientConsumerInternal consumer = (ClientConsumerInternal)session.createConsumer(this.ADDRESS);
            Wait.waitFor(() -> consumer.getBufferSize() >= 30, (long)30000L, (long)100L);
            Assertions.assertEquals((int)30, (int)consumer.getBufferSize());
            for (int trans = 0; trans < 2; ++trans) {
                for (int i = 0; i < 30; ++i) {
                    ClientMessage msg = consumer.receive(10000L);
                    Assertions.assertNotNull((Object)msg);
                    if (trans == 0) {
                        for (int byteRead = 0; byteRead < 10240; ++byteRead) {
                            Assertions.assertEquals((byte)ActiveMQTestBase.getSamplebyte(byteRead), (byte)msg.getBodyBuffer().readByte());
                        }
                    }
                    msg.acknowledge();
                }
                if (trans == 0) {
                    session.rollback();
                    continue;
                }
                session.commit();
            }
            Assertions.assertEquals((int)0, (int)((Queue)server.getPostOffice().getBinding(this.ADDRESS).getBindable()).getDeliveringCount());
            Assertions.assertEquals((int)0, (int)this.getMessageCount((Queue)server.getPostOffice().getBinding(this.ADDRESS).getBindable()));
        }
        finally {
            try {
                session.close();
            }
            catch (Throwable throwable) {}
            try {
                server.stop();
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    public void testReceiveMultipleMessages() throws Exception {
        ClientSession session = null;
        ActiveMQServer server = null;
        int SIZE = 10240;
        int NUMBER_OF_MESSAGES = 100;
        try {
            server = this.createServer(true, this.isNetty(), this.storeType);
            server.start();
            this.locator.setMinLargeMessageSize(1024).setConsumerWindowSize(0x100000).setBlockOnDurableSend(false).setBlockOnNonDurableSend(false).setBlockOnAcknowledge(false);
            ClientSessionFactory sf = this.addSessionFactory(this.createSessionFactory(this.locator));
            session = sf.createSession(null, null, false, false, false, false, 0);
            session.createQueue(QueueConfiguration.of((SimpleString)this.ADDRESS));
            ClientProducer producer = session.createProducer(this.ADDRESS);
            for (int i = 0; i < 100; ++i) {
                ClientMessage clientFile = session.createMessage(true);
                clientFile.setBodyInputStream(ActiveMQTestBase.createFakeLargeStream(10240L));
                producer.send((org.apache.activemq.artemis.api.core.Message)clientFile);
            }
            session.commit();
            producer.close();
            session.start();
            for (int trans = 0; trans < 2; ++trans) {
                ClientConsumerInternal consumer = (ClientConsumerInternal)session.createConsumer(this.ADDRESS);
                Assertions.assertTrue((boolean)Wait.waitFor(() -> consumer.getBufferSize() >= 5, (long)30000L, (long)100L));
                for (int i = 0; i < 100; ++i) {
                    ClientMessage msg = consumer.receive(10000L);
                    Assertions.assertNotNull((Object)msg);
                    if (trans == 0) {
                        for (int byteRead = 0; byteRead < 10240; ++byteRead) {
                            Assertions.assertEquals((byte)ActiveMQTestBase.getSamplebyte(byteRead), (byte)msg.getBodyBuffer().readByte());
                        }
                    }
                    msg.acknowledge();
                }
                if (trans == 0) {
                    session.rollback();
                } else {
                    session.commit();
                }
                consumer.close();
            }
            Assertions.assertEquals((int)0, (int)((Queue)server.getPostOffice().getBinding(this.ADDRESS).getBindable()).getDeliveringCount());
            Assertions.assertEquals((int)0, (int)this.getMessageCount((Queue)server.getPostOffice().getBinding(this.ADDRESS).getBindable()));
        }
        finally {
            try {
                session.close();
            }
            catch (Throwable throwable) {}
            try {
                server.stop();
            }
            catch (Throwable throwable) {}
        }
    }

    @TestTemplate
    public void testPageOnLargeMessageMultipleQueues() throws Exception {
        AssertionLoggerHandler loggerHandler = new AssertionLoggerHandler();
        this.runAfter(() -> loggerHandler.close());
        Configuration config = this.createDefaultConfig(this.isNetty());
        int PAGE_MAX = 20480;
        int PAGE_SIZE = 10240;
        HashMap<String, AddressSettings> map = new HashMap<String, AddressSettings>();
        AddressSettings value = new AddressSettings();
        map.put(this.ADDRESS.toString(), value);
        ActiveMQServer server = this.createServer(true, config, 10240, 20480L, map, this.storeType);
        server.start();
        int numberOfBytes = 1024;
        int numberOfBytesBigMessage = 400000;
        this.locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true);
        ClientSessionFactory sf = this.addSessionFactory(this.createSessionFactory(this.locator));
        ClientSession session = sf.createSession(null, null, false, true, true, false, 0);
        session.createQueue(QueueConfiguration.of((SimpleString)this.ADDRESS.concat("-0")).setAddress(this.ADDRESS));
        session.createQueue(QueueConfiguration.of((SimpleString)this.ADDRESS.concat("-1")).setAddress(this.ADDRESS));
        ClientProducer producer = session.createProducer(this.ADDRESS);
        ClientMessage message = null;
        for (int i = 0; i < 100; ++i) {
            message = session.createMessage(true);
            message.getBodyBuffer().writerIndex(0);
            message.getBodyBuffer().writeBytes(new byte[1024]);
            for (int j = 1; j <= 1024; ++j) {
                message.getBodyBuffer().writeInt(j);
            }
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        ClientMessage clientFile = this.createLargeClientMessageStreaming(session, 400000);
        clientFile.putBooleanProperty("TestLarge", true);
        producer.send((org.apache.activemq.artemis.api.core.Message)clientFile);
        for (int i = 0; i < 100; ++i) {
            message = session.createMessage(true);
            message.getBodyBuffer().writeBytes(new byte[1024]);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        session.close();
        server.stop();
        server = this.createServer(true, config, 10240, 20480L, map, this.storeType);
        server.start();
        sf = this.createSessionFactory(this.locator);
        for (int ad = 0; ad < 2; ++ad) {
            ClientMessage message2;
            int i;
            session = sf.createSession(false, false, false);
            ClientConsumer consumer = session.createConsumer(this.ADDRESS.concat("-" + ad));
            session.start();
            for (i = 0; i < 100; ++i) {
                message2 = consumer.receive(10000L);
                Assertions.assertNotNull((Object)message2);
                message2.acknowledge();
                Assertions.assertNotNull((Object)message2);
            }
            session.commit();
            for (i = 0; i < 5; ++i) {
                ClientMessage messageLarge = consumer.receive(10000L);
                Assertions.assertTrue((boolean)messageLarge.getBooleanProperty("TestLarge"));
                Assertions.assertNotNull((Object)messageLarge);
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                messageLarge.acknowledge();
                messageLarge.saveToOutputStream((OutputStream)bout);
                byte[] body = bout.toByteArray();
                Assertions.assertEquals((int)400000, (int)body.length);
                for (int bi = 0; bi < body.length; ++bi) {
                    Assertions.assertEquals((byte)LargeMessageTest.getSamplebyte(bi), (byte)body[bi]);
                }
                if (i < 4) {
                    session.rollback();
                    continue;
                }
                session.commit();
            }
            for (i = 0; i < 100; ++i) {
                message2 = consumer.receive(10000L);
                Assertions.assertNotNull((Object)message2);
                message2.acknowledge();
                Assertions.assertNotNull((Object)message2);
            }
            session.commit();
            consumer.close();
            session.close();
        }
        Assertions.assertFalse((boolean)loggerHandler.findText(new String[]{"AMQ214034"}));
    }

    @TestTemplate
    public void testPageOnLargeMessageMultipleQueues2() throws Exception {
        int i;
        Configuration config = this.createDefaultConfig(this.isNetty());
        int PAGE_MAX = 20480;
        int PAGE_SIZE = 10240;
        HashMap<String, AddressSettings> map = new HashMap<String, AddressSettings>();
        AddressSettings value = new AddressSettings();
        map.put(this.ADDRESS.toString(), value);
        ActiveMQServer server = this.createServer(true, config, 10240, 20480L, map, this.storeType);
        server.start();
        int numberOfBytes = 1024;
        int numberOfBytesBigMessage = 400000;
        this.locator.setBlockOnNonDurableSend(false).setBlockOnDurableSend(false).setBlockOnAcknowledge(false).setCompressLargeMessage(true);
        ClientSessionFactory sf = this.addSessionFactory(this.createSessionFactory(this.locator));
        ClientSession session = sf.createSession(false, true, true);
        session.createQueue(QueueConfiguration.of((SimpleString)this.ADDRESS.concat("-0")).setAddress(this.ADDRESS));
        session.createQueue(QueueConfiguration.of((SimpleString)this.ADDRESS.concat("-1")).setAddress(this.ADDRESS));
        ClientProducer producer = session.createProducer(this.ADDRESS);
        int msgId = 0;
        for (i = 0; i < 100; ++i) {
            ClientMessage message = session.createMessage(true);
            message.putIntProperty("msgID", msgId++);
            message.putBooleanProperty("TestLarge", false);
            message.getBodyBuffer().writerIndex(0);
            message.getBodyBuffer().writeBytes(new byte[1024]);
            for (int j = 1; j <= 1024; ++j) {
                message.getBodyBuffer().writeInt(j);
            }
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        for (i = 0; i < 10; ++i) {
            ClientMessage clientFile = this.createLargeClientMessageStreaming(session, 400000);
            clientFile.putBooleanProperty("TestLarge", true);
            producer.send((org.apache.activemq.artemis.api.core.Message)clientFile);
        }
        session.close();
        for (int ad = 0; ad < 2; ++ad) {
            session = sf.createSession(false, false, false);
            ClientConsumer consumer = session.createConsumer(this.ADDRESS.concat("-" + ad));
            session.start();
            for (int received = 0; received < 5; ++received) {
                int i2;
                for (i2 = 0; i2 < 100; ++i2) {
                    ClientMessage message2 = consumer.receive(10000L);
                    Assertions.assertNotNull((Object)message2);
                    Assertions.assertFalse((boolean)message2.getBooleanProperty("TestLarge"));
                    message2.acknowledge();
                    Assertions.assertNotNull((Object)message2);
                }
                for (i2 = 0; i2 < 10; ++i2) {
                    ClientMessage messageLarge = consumer.receive(10000L);
                    Assertions.assertNotNull((Object)messageLarge);
                    Assertions.assertTrue((boolean)messageLarge.getBooleanProperty("TestLarge"));
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    messageLarge.acknowledge();
                    messageLarge.saveToOutputStream((OutputStream)bout);
                    byte[] body = bout.toByteArray();
                    Assertions.assertEquals((int)400000, (int)body.length);
                }
                session.rollback();
            }
            session.commit();
            consumer.close();
            session.close();
        }
    }

    @TestTemplate
    public void testSendStreamingSingleMessage() throws Exception {
        ClientSession session = null;
        ActiveMQServer server = null;
        int SIZE = 0xA00000;
        try {
            server = this.createServer(true, this.isNetty(), this.storeType);
            server.start();
            this.locator.setMinLargeMessageSize(this.largeMessageSize * 1024);
            ClientSessionFactory sf = this.addSessionFactory(this.createSessionFactory(this.locator));
            session = sf.createSession(null, null, false, true, true, false, 0);
            session.createQueue(QueueConfiguration.of((SimpleString)this.ADDRESS));
            ClientMessage clientFile = session.createMessage(true);
            clientFile.setBodyInputStream(ActiveMQTestBase.createFakeLargeStream(0xA00000L));
            ClientProducer producer = session.createProducer(this.ADDRESS);
            session.start();
            logger.debug("Sending");
            producer.send((org.apache.activemq.artemis.api.core.Message)clientFile);
            producer.close();
            logger.debug("Waiting");
            ClientConsumer consumer = session.createConsumer(this.ADDRESS);
            ClientMessage msg2 = consumer.receive(10000L);
            msg2.acknowledge();
            msg2.setOutputStream(this.createFakeOutputStream());
            Assertions.assertTrue((boolean)msg2.waitOutputStreamCompletion(0L));
            session.commit();
            Assertions.assertEquals((int)0, (int)((Queue)server.getPostOffice().getBinding(this.ADDRESS).getBindable()).getDeliveringCount());
            Assertions.assertEquals((int)0, (int)this.getMessageCount((Queue)server.getPostOffice().getBinding(this.ADDRESS).getBindable()));
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw t;
        }
        finally {
            try {
                session.close();
            }
            catch (Throwable sf) {}
            try {
                server.stop();
            }
            catch (Throwable sf) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    public void testSendStreamingSingleEmptyMessage() throws Exception {
        String propertyName = "myStringPropertyName";
        String propertyValue = "myStringPropertyValue";
        ClientSession session = null;
        ActiveMQServer server = null;
        boolean SIZE = false;
        try {
            server = this.createServer(true, this.isNetty(), this.storeType);
            server.start();
            this.locator.setMinLargeMessageSize(this.largeMessageSize * 1024);
            ClientSessionFactory sf = this.addSessionFactory(this.createSessionFactory(this.locator));
            session = sf.createSession(null, null, false, true, true, false, 0);
            session.createQueue(QueueConfiguration.of((SimpleString)this.ADDRESS));
            ClientMessage clientFile = session.createMessage(true);
            clientFile.setBodyInputStream(ActiveMQTestBase.createFakeLargeStream(0L));
            clientFile.putStringProperty("myStringPropertyName", "myStringPropertyValue");
            ClientProducer producer = session.createProducer(this.ADDRESS);
            session.start();
            logger.debug("Sending");
            producer.send((org.apache.activemq.artemis.api.core.Message)clientFile);
            producer.close();
            logger.debug("Waiting");
            ClientConsumer consumer = session.createConsumer(this.ADDRESS);
            ClientMessage msg2 = consumer.receive(10000L);
            msg2.acknowledge();
            msg2.setOutputStream(this.createFakeOutputStream());
            Assertions.assertTrue((boolean)msg2.waitOutputStreamCompletion(60000L));
            Assertions.assertEquals((Object)"myStringPropertyValue", (Object)msg2.getStringProperty("myStringPropertyName"));
            session.commit();
            Assertions.assertEquals((int)0, (int)((Queue)server.getPostOffice().getBinding(this.ADDRESS).getBindable()).getDeliveringCount());
            Assertions.assertEquals((int)0, (int)this.getMessageCount((Queue)server.getPostOffice().getBinding(this.ADDRESS).getBindable()));
        }
        finally {
            try {
                session.close();
            }
            catch (Throwable throwable) {}
            try {
                server.stop();
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    public void testSendStreamingEmptyMessagesWithRestart() throws Exception {
        String propertyName = "myStringPropertyName";
        String propertyValue = "myStringPropertyValue";
        ClientSession session = null;
        ActiveMQServer server = null;
        boolean SIZE = false;
        try {
            server = this.createServer(true, this.isNetty(), this.storeType);
            server.start();
            this.locator.setMinLargeMessageSize(this.largeMessageSize * 1024);
            ClientSessionFactory sf = this.addSessionFactory(this.createSessionFactory(this.locator));
            session = sf.createSession(null, null, false, true, true, false, 0);
            session.createQueue(QueueConfiguration.of((SimpleString)this.ADDRESS));
            ClientProducer producer = session.createProducer(this.ADDRESS);
            for (int i = 0; i < 10; ++i) {
                ClientMessage clientFile = session.createMessage(true);
                clientFile.setBodyInputStream(ActiveMQTestBase.createFakeLargeStream(0L));
                clientFile.putStringProperty("myStringPropertyName", "myStringPropertyValue" + i);
                producer.send((org.apache.activemq.artemis.api.core.Message)clientFile);
            }
            producer.close();
            session.close();
            sf.close();
            server.stop();
            server.start();
            sf = this.addSessionFactory(this.createSessionFactory(this.locator));
            session = sf.createSession(null, null, false, true, true, false, 0);
            ClientConsumer consumer = session.createConsumer(this.ADDRESS);
            session.start();
            for (int i = 0; i < 10; ++i) {
                ClientMessage msg2 = consumer.receive(10000L);
                msg2.acknowledge();
                msg2.setOutputStream(this.createFakeOutputStream());
                Assertions.assertTrue((boolean)msg2.waitOutputStreamCompletion(60000L));
                Assertions.assertEquals((Object)("myStringPropertyValue" + i), (Object)msg2.getStringProperty("myStringPropertyName"));
                session.commit();
            }
            Assertions.assertEquals((int)0, (int)((Queue)server.getPostOffice().getBinding(this.ADDRESS).getBindable()).getDeliveringCount());
            Assertions.assertEquals((int)0, (int)this.getMessageCount((Queue)server.getPostOffice().getBinding(this.ADDRESS).getBindable()));
        }
        finally {
            try {
                session.close();
            }
            catch (Throwable throwable) {}
            try {
                server.stop();
            }
            catch (Throwable throwable) {}
        }
    }

    @TestTemplate
    public void testIgnoreStreaming() throws Exception {
        ClientSession session = null;
        ActiveMQServer server = null;
        int SIZE = 10240;
        boolean NUMBER_OF_MESSAGES = true;
        server = this.createServer(true, this.isNetty(), this.storeType);
        server.start();
        this.locator.setMinLargeMessageSize(1024);
        ClientSessionFactory sf = this.addSessionFactory(this.createSessionFactory(this.locator));
        session = sf.createSession(null, null, false, true, true, false, 0);
        session.createQueue(QueueConfiguration.of((SimpleString)this.ADDRESS));
        ClientProducer producer = session.createProducer(this.ADDRESS);
        for (int i = 0; i < 1; ++i) {
            ClientMessage msg = session.createMessage(true);
            msg.setBodyInputStream(ActiveMQTestBase.createFakeLargeStream(10240L));
            msg.putIntProperty(SimpleString.of((String)"key"), i);
            producer.send((org.apache.activemq.artemis.api.core.Message)msg);
            logger.debug("Sent msg {}", (Object)i);
        }
        session.start();
        logger.debug("Sending");
        producer.close();
        logger.debug("Waiting");
        ClientConsumer consumer = session.createConsumer(this.ADDRESS);
        for (int i = 0; i < 1; ++i) {
            ClientMessage msg = consumer.receive(50000L);
            Assertions.assertNotNull((Object)msg);
            Assertions.assertEquals((Object)i, (Object)msg.getObjectProperty(SimpleString.of((String)"key")));
            msg.acknowledge();
        }
        consumer.close();
        session.commit();
        Assertions.assertEquals((int)0, (int)((Queue)server.getPostOffice().getBinding(this.ADDRESS).getBindable()).getDeliveringCount());
        Assertions.assertEquals((int)0, (int)this.getMessageCount((Queue)server.getPostOffice().getBinding(this.ADDRESS).getBindable()));
        logger.debug("Thread done");
    }

    @TestTemplate
    public void testLargeMessageBodySize() throws Exception {
        ActiveMQServer server = this.createServer(true, this.isNetty(), this.storeType);
        server.start();
        LargeServerMessageImpl fileMessage = new LargeServerMessageImpl(server.getStorageManager());
        fileMessage.setMessageID(1005L);
        Assertions.assertEquals((int)0, (int)fileMessage.getBodyBufferSize());
        for (int i = 0; i < this.largeMessageSize; ++i) {
            fileMessage.addBytes(new byte[]{ActiveMQTestBase.getSamplebyte(i)});
        }
        fileMessage.releaseResources(true, false);
        Assertions.assertEquals((int)this.largeMessageSize, (int)fileMessage.getBodyBufferSize());
        fileMessage.putLongProperty(org.apache.activemq.artemis.api.core.Message.HDR_LARGE_BODY_SIZE, (long)this.largeMessageSize);
        fileMessage.releaseResources(true, false);
        Assertions.assertEquals((int)this.largeMessageSize, (int)fileMessage.getBodyBufferSize());
    }

    @TestTemplate
    public void testSendServerMessage() throws Exception {
        ActiveMQServer server = this.createServer(true, this.isNetty(), this.storeType);
        server.start();
        ClientSessionFactory sf = this.addSessionFactory(this.createSessionFactory(this.locator));
        ClientSession session = sf.createSession(false, false);
        LargeServerMessageImpl fileMessage = new LargeServerMessageImpl(server.getStorageManager());
        fileMessage.setMessageID(1005L);
        for (int i = 0; i < this.largeMessageSize; ++i) {
            fileMessage.addBytes(new byte[]{ActiveMQTestBase.getSamplebyte(i)});
        }
        fileMessage.putLongProperty(org.apache.activemq.artemis.api.core.Message.HDR_LARGE_BODY_SIZE, (long)this.largeMessageSize);
        fileMessage.releaseResources(true, false);
        session.createQueue(QueueConfiguration.of((SimpleString)this.ADDRESS));
        ClientProducer prod = session.createProducer(this.ADDRESS);
        prod.send((org.apache.activemq.artemis.api.core.Message)fileMessage);
        fileMessage.deleteFile();
        session.commit();
        session.start();
        ClientConsumer cons = session.createConsumer(this.ADDRESS);
        ClientMessage msg = cons.receive(5000L);
        Assertions.assertNotNull((Object)msg);
        Assertions.assertEquals((int)msg.getBodySize(), (int)this.largeMessageSize);
        for (int i = 0; i < this.largeMessageSize; ++i) {
            Assertions.assertEquals((byte)ActiveMQTestBase.getSamplebyte(i), (byte)msg.getBodyBuffer().readByte());
        }
        msg.acknowledge();
        session.commit();
    }

    @TestTemplate
    public void testSendServerMessageMetrics() throws Exception {
        ActiveMQServer server = this.createServer(true, this.isNetty(), this.storeType);
        server.start();
        ClientSessionFactory sf = this.addSessionFactory(this.createSessionFactory(this.locator));
        ClientSession session = sf.createSession(false, false);
        LargeServerMessageImpl fileMessage = new LargeServerMessageImpl(server.getStorageManager());
        fileMessage.setMessageID(1005L);
        for (int i = 0; i < this.largeMessageSize; ++i) {
            fileMessage.addBytes(new byte[]{ActiveMQTestBase.getSamplebyte(i)});
        }
        fileMessage.putLongProperty(org.apache.activemq.artemis.api.core.Message.HDR_LARGE_BODY_SIZE, (long)this.largeMessageSize);
        fileMessage.releaseResources(true, false);
        session.createQueue(QueueConfiguration.of((SimpleString)this.ADDRESS));
        ClientProducer prod = session.createProducer(this.ADDRESS);
        prod.send((org.apache.activemq.artemis.api.core.Message)fileMessage);
        fileMessage.deleteFile();
        session.commit();
        Collection serverProducers = ((ServerSession)server.getSessions().iterator().next()).getServerProducers();
        Assertions.assertEquals((int)1, (int)serverProducers.size());
        ServerProducer producer = (ServerProducer)serverProducers.iterator().next();
        Assertions.assertEquals((long)1L, (long)producer.getMessagesSent());
        Assertions.assertEquals((long)this.largeMessageSize, (long)producer.getMessagesSentSize());
        fileMessage = new LargeServerMessageImpl(server.getStorageManager());
        fileMessage.setMessageID(1006L);
        for (int i = 0; i < this.largeMessageSize; ++i) {
            fileMessage.addBytes(new byte[]{ActiveMQTestBase.getSamplebyte(i)});
        }
        fileMessage.putLongProperty(org.apache.activemq.artemis.api.core.Message.HDR_LARGE_BODY_SIZE, (long)this.largeMessageSize);
        fileMessage.releaseResources(true, false);
        prod.send((org.apache.activemq.artemis.api.core.Message)fileMessage);
        fileMessage.deleteFile();
        session.commit();
        serverProducers = ((ServerSession)server.getSessions().iterator().next()).getServerProducers();
        Assertions.assertEquals((int)1, (int)serverProducers.size());
        producer = (ServerProducer)serverProducers.iterator().next();
        Assertions.assertEquals((long)2L, (long)producer.getMessagesSent());
        Assertions.assertEquals((long)(this.largeMessageSize * 2), (long)producer.getMessagesSentSize());
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.locator = this.createFactory(this.isNetty());
        this.locator.setCallTimeout(100000000L);
    }

    protected void testPageOnLargeMessage(boolean realFiles, boolean sendBlocking) throws Exception {
        Configuration config = this.createDefaultConfig(this.isNetty());
        int PAGE_MAX = 20480;
        int PAGE_SIZE = 10240;
        HashMap<String, AddressSettings> map = new HashMap<String, AddressSettings>();
        AddressSettings value = new AddressSettings();
        map.put(this.ADDRESS.toString(), value);
        ActiveMQServer server = this.createServer(realFiles, config, 10240, 20480L, map, this.storeType);
        server.start();
        int numberOfBytes = 1024;
        int numberOfBytesBigMessage = 400000;
        ClientSessionFactory sf = this.addSessionFactory(this.createSessionFactory(this.locator));
        if (sendBlocking) {
            sf.getServerLocator().setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true);
        }
        ClientSession session = sf.createSession(null, null, false, true, true, false, 0);
        session.createQueue(QueueConfiguration.of((SimpleString)this.ADDRESS));
        ClientProducer producer = session.createProducer(this.ADDRESS);
        ClientMessage message = null;
        for (int i = 0; i < 100; ++i) {
            message = session.createMessage(true);
            message.getBodyBuffer().writerIndex(0);
            for (int j = 1; j <= 1024; ++j) {
                message.getBodyBuffer().writeInt(j);
            }
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        ClientMessage clientFile = this.createLargeClientMessageStreaming(session, 400000);
        producer.send((org.apache.activemq.artemis.api.core.Message)clientFile);
        session.close();
        if (realFiles) {
            server.stop();
            server = this.createServer(true, config, 10240, 20480L, map, this.storeType);
            server.start();
            sf = this.createSessionFactory(this.locator);
        }
        session = sf.createSession(null, null, false, true, true, false, 0);
        ClientConsumer consumer = session.createConsumer(this.ADDRESS);
        session.start();
        for (int i = 0; i < 100; ++i) {
            ClientMessage message2 = consumer.receive(10000L);
            Assertions.assertNotNull((Object)message2);
            message2.acknowledge();
            Assertions.assertNotNull((Object)message2);
            message.getBodyBuffer().readerIndex(0);
            for (int j = 1; j <= 1024; ++j) {
                Assertions.assertEquals((int)j, (int)message.getBodyBuffer().readInt());
            }
        }
        consumer.close();
        session.close();
        session = sf.createSession(null, null, false, true, true, false, 0);
        this.readMessage(session, this.ADDRESS, 400000);
        session.close();
    }

    @TestTemplate
    public void testGlobalSizeBytesAndAddressSizeOnPage() throws Exception {
        this.testGlobalSizeBytesAndAddressSize(true);
    }

    @TestTemplate
    public void testGlobalSizeBytesAndAddressSize() throws Exception {
        this.testGlobalSizeBytesAndAddressSize(false);
    }

    public void testGlobalSizeBytesAndAddressSize(boolean isPage) throws Exception {
        ActiveMQServer server = this.createServer(true, this.isNetty(), this.storeType);
        server.start();
        ClientSessionFactory sf = this.addSessionFactory(this.createSessionFactory(this.locator));
        ClientSession session = sf.createSession(false, false);
        LargeServerMessageImpl fileMessage = new LargeServerMessageImpl(server.getStorageManager());
        fileMessage.setMessageID(1005L);
        for (int i = 0; i < this.largeMessageSize; ++i) {
            fileMessage.addBytes(new byte[]{ActiveMQTestBase.getSamplebyte(i)});
        }
        fileMessage.releaseResources(true, false);
        session.createQueue(QueueConfiguration.of((SimpleString)this.ADDRESS));
        PagingStore store = server.getPagingManager().getPageStore(this.ADDRESS);
        if (isPage) {
            store.startPaging();
        }
        ClientProducer prod = session.createProducer(this.ADDRESS);
        prod.send((org.apache.activemq.artemis.api.core.Message)fileMessage);
        fileMessage.deleteFile();
        session.commit();
        if (isPage) {
            Assertions.assertEquals((long)0L, (long)server.getPagingManager().getPageStore(this.ADDRESS).getAddressSize());
            Assertions.assertEquals((long)0L, (long)server.getPagingManager().getGlobalSize());
        } else {
            Assertions.assertNotEquals((long)0L, (long)server.getPagingManager().getPageStore(this.ADDRESS).getAddressSize());
            Assertions.assertNotEquals((long)0L, (long)server.getPagingManager().getGlobalSize());
        }
        session.start();
        ClientConsumer cons = session.createConsumer(this.ADDRESS);
        ClientMessage msg = cons.receive(5000L);
        Assertions.assertNotNull((Object)msg);
        msg.acknowledge();
        session.commit();
        Wait.assertEquals((long)0L, () -> ((PagingStore)server.getPagingManager().getPageStore(this.ADDRESS)).getAddressSize());
        Wait.assertEquals((long)0L, () -> ((PagingManager)server.getPagingManager()).getGlobalSize());
        session.close();
        cons.close();
    }

    @TestTemplate
    public void testAMQPLargeMessageFDs() throws Exception {
        OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
        Assumptions.assumeTrue((boolean)(os instanceof UnixOperatingSystemMXBean));
        SimpleString MY_QUEUE = SimpleString.of((String)"MY-QUEUE");
        int numberOfMessages = 30;
        ActiveMQServer server = this.createServer(true, true);
        server.start();
        long fdBefore = ((UnixOperatingSystemMXBean)os).getOpenFileDescriptorCount();
        server.createQueue(QueueConfiguration.of((SimpleString)MY_QUEUE).setRoutingType(RoutingType.ANYCAST));
        ConnectionFactory connectionFactory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:61616");
        Connection connection = connectionFactory.createConnection();
        Session session = connection.createSession(false, 1);
        byte[] bufferSample = new byte[307200];
        for (int i = 0; i < bufferSample.length; ++i) {
            bufferSample[i] = LargeMessageTest.getSamplebyte(i);
        }
        jakarta.jms.Queue jmsQueue = session.createQueue(MY_QUEUE.toString());
        MessageProducer producer = session.createProducer((Destination)jmsQueue);
        producer.setTimeToLive(300L);
        for (int i = 0; i < 30; ++i) {
            BytesMessage message = session.createBytesMessage();
            message.writeBytes(bufferSample);
            message.setIntProperty("count", i);
            producer.send((Message)message);
        }
        session.close();
        connection.close();
        Wait.assertTrue(() -> ((UnixOperatingSystemMXBean)os).getOpenFileDescriptorCount() - fdBefore < 3L);
    }

    @TestTemplate
    public void testStreamedMessage() throws Exception {
        this.testStream(false);
    }

    @TestTemplate
    public void testStreamedMessageCompressed() throws Exception {
        this.testStream(true);
    }

    private void testStream(boolean compressed) throws Exception {
        ActiveMQServer server = this.createServer(true, this.isNetty(), this.storeType);
        server.start();
        this.locator.setCompressLargeMessage(compressed);
        ClientSessionFactory sf = this.addSessionFactory(this.createSessionFactory(this.locator));
        ClientSession session = sf.createSession(false, false);
        session.createQueue(QueueConfiguration.of((SimpleString)this.ADDRESS));
        ClientProducer producer = session.createProducer(this.ADDRESS);
        final AtomicBoolean closed = new AtomicBoolean(false);
        int BYTES = 1000;
        InputStream inputStream = new InputStream(){
            int bytes = 1000;

            @Override
            public int read() throws IOException {
                if (this.bytes-- > 0) {
                    return 10;
                }
                return -1;
            }

            @Override
            public void close() {
                closed.set(true);
            }

            @Override
            public int available() {
                return this.bytes;
            }
        };
        ClientMessage message = session.createMessage(true);
        message.setBodyInputStream(inputStream);
        producer.send((org.apache.activemq.artemis.api.core.Message)message);
        Wait.assertTrue(closed::get);
        session.commit();
        session.start();
        ClientConsumer consumer = session.createConsumer(this.ADDRESS);
        ClientMessage receivedMessage = consumer.receive(5000L);
        Assertions.assertNotNull((Object)receivedMessage);
        ActiveMQBuffer buffer = receivedMessage.getBodyBuffer();
        Assertions.assertEquals((int)1000, (int)buffer.readableBytes());
        for (int i = 0; i < 1000; ++i) {
            Assertions.assertEquals((byte)10, (byte)buffer.readByte());
        }
        Assertions.assertEquals((int)0, (int)buffer.readableBytes());
        session.close();
    }
}

