/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.MessageHandler;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.transaction.impl.XidImpl;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageGroupingTest
extends ActiveMQTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private ActiveMQServer server;
    private ClientSession clientSession;
    private ClientSessionFactory clientSessionFactory;
    private final SimpleString qName = SimpleString.of((String)"MessageGroupingTestQueue");
    private ServerLocator locator;

    @Test
    public void testBasicGrouping() throws Exception {
        this.doTestBasicGrouping();
    }

    @Test
    public void testMultipleGrouping() throws Exception {
        this.doTestMultipleGrouping();
    }

    @Test
    public void testMultipleGroupingSingleConsumerWithDirectDelivery() throws Exception {
        this.doTestMultipleGroupingSingleConsumer(true);
    }

    @Test
    public void testMultipleGroupingSingleConsumerWithoutDirectDelivery() throws Exception {
        this.doTestMultipleGroupingSingleConsumer(false);
    }

    @Test
    public void testMultipleGroupingTXCommit() throws Exception {
        this.doTestMultipleGroupingTXCommit();
    }

    @Test
    public void testMultipleGroupingTXRollback() throws Exception {
        this.doTestMultipleGroupingTXRollback();
    }

    @Test
    public void testMultipleGroupingXACommit() throws Exception {
        this.dotestMultipleGroupingXACommit();
    }

    @Test
    public void testMultipleGroupingXARollback() throws Exception {
        this.doTestMultipleGroupingXARollback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoadBalanceGroups() throws Exception {
        Assumptions.assumeFalse((boolean)this.clientSessionFactory.getServerLocator().isAutoGroup(), (String)"only makes sense withOUT auto-group");
        ClientProducer clientProducer = this.clientSession.createProducer(this.qName);
        ClientConsumer consumer1 = this.clientSession.createConsumer(this.qName);
        ClientConsumer consumer2 = this.clientSession.createConsumer(this.qName);
        ClientConsumer consumer3 = this.clientSession.createConsumer(this.qName);
        ClientConsumer[] consumers = new ClientConsumer[]{consumer1, consumer2, consumer3};
        int[] counts = new int[consumers.length];
        this.clientSession.start();
        try {
            for (int group = 0; group < 10; ++group) {
                for (int messageId = 0; messageId < 3; ++messageId) {
                    ClientMessage message = this.clientSession.createMessage(false);
                    message.putStringProperty("_AMQ_GROUP_ID", "" + group);
                    clientProducer.send((Message)message);
                }
            }
            for (int c = 0; c < consumers.length; ++c) {
                ClientMessage msg;
                while ((msg = consumers[c].receiveImmediate()) != null) {
                    int n = c;
                    counts[n] = counts[n] + 1;
                }
            }
            for (int count : counts) {
                Assertions.assertNotEquals((int)30, (int)count, (String)"You shouldn't have all messages bound to a single consumer");
                Assertions.assertNotEquals((int)0, (int)count, (String)"But you shouldn't have also a single consumer bound to none");
            }
        }
        finally {
            consumer1.close();
            consumer2.close();
            consumer3.close();
        }
    }

    private void doTestBasicGrouping() throws Exception {
        ClientProducer clientProducer = this.clientSession.createProducer(this.qName);
        ClientConsumer consumer = this.clientSession.createConsumer(this.qName);
        ClientConsumer consumer2 = this.clientSession.createConsumer(this.qName);
        this.clientSession.start();
        SimpleString groupId = SimpleString.of((String)"grp1");
        int numMessages = 100;
        for (int i = 0; i < numMessages; ++i) {
            ClientMessage message = this.createTextMessage(this.clientSession, "m" + i);
            message.putStringProperty(Message.HDR_GROUP_ID, groupId);
            clientProducer.send((Message)message);
        }
        CountDownLatch latch = new CountDownLatch(numMessages);
        DummyMessageHandler dummyMessageHandler = new DummyMessageHandler(latch, true);
        consumer.setMessageHandler((MessageHandler)dummyMessageHandler);
        DummyMessageHandler dummyMessageHandler2 = new DummyMessageHandler(latch, true);
        consumer2.setMessageHandler((MessageHandler)dummyMessageHandler2);
        Assertions.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
        Assertions.assertEquals((int)100, (int)dummyMessageHandler.list.size());
        Assertions.assertEquals((int)0, (int)dummyMessageHandler2.list.size());
        consumer.close();
        consumer2.close();
    }

    @Test
    public void testMultipleGroupingConsumeHalf() throws Exception {
        int i;
        ClientProducer clientProducer = this.clientSession.createProducer(this.qName);
        ClientConsumer consumer = this.clientSession.createConsumer(this.qName);
        ClientConsumer consumer2 = this.clientSession.createConsumer(this.qName);
        this.clientSession.start();
        Thread.sleep(200L);
        SimpleString groupId = SimpleString.of((String)"grp1");
        SimpleString groupId2 = SimpleString.of((String)"grp2");
        int numMessages = 100;
        for (i = 0; i < numMessages; ++i) {
            ClientMessage message = this.createTextMessage(this.clientSession, "m" + i);
            if (i % 2 == 0 || i == 0) {
                message.putStringProperty(Message.HDR_GROUP_ID, groupId);
            } else {
                message.putStringProperty(Message.HDR_GROUP_ID, groupId2);
            }
            clientProducer.send((Message)message);
        }
        for (i = 0; i < numMessages / 2; ++i) {
            ClientMessage cm = consumer.receive(500L);
            Assertions.assertNotNull((Object)cm);
            Assertions.assertEquals((Object)cm.getBodyBuffer().readString(), (Object)("m" + i));
            cm = consumer2.receive(500L);
            Assertions.assertNotNull((Object)cm);
            Assertions.assertEquals((Object)cm.getBodyBuffer().readString(), (Object)("m" + ++i));
        }
        logger.debug("closing consumer2");
        consumer2.close();
        consumer.close();
    }

    private void doTestMultipleGroupingSingleConsumer(boolean directDelivery) throws Exception {
        ClientProducer clientProducer = this.clientSession.createProducer(this.qName);
        ClientConsumer consumer = this.clientSession.createConsumer(this.qName);
        if (directDelivery) {
            this.clientSession.start();
        }
        SimpleString groupId = SimpleString.of((String)"grp1");
        SimpleString groupId2 = SimpleString.of((String)"grp2");
        int numMessages = 100;
        for (int i = 0; i < numMessages; ++i) {
            ClientMessage message = this.createTextMessage(this.clientSession, "m" + i);
            if (i % 2 == 0 || i == 0) {
                message.putStringProperty(Message.HDR_GROUP_ID, groupId);
            } else {
                message.putStringProperty(Message.HDR_GROUP_ID, groupId2);
            }
            clientProducer.send((Message)message);
        }
        if (!directDelivery) {
            this.clientSession.start();
        }
        CountDownLatch latch = new CountDownLatch(numMessages);
        DummyMessageHandler dummyMessageHandler = new DummyMessageHandler(latch, true);
        consumer.setMessageHandler((MessageHandler)dummyMessageHandler);
        Assertions.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
        Assertions.assertEquals((int)dummyMessageHandler.list.size(), (int)100);
        int i = 0;
        for (ClientMessage message : dummyMessageHandler.list) {
            Assertions.assertEquals((Object)message.getBodyBuffer().readString(), (Object)("m" + i));
            ++i;
        }
        consumer.close();
    }

    private void doTestMultipleGroupingTXCommit() throws Exception {
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory sessionFactory = this.createSessionFactory(locator);
        ClientSession clientSession = sessionFactory.createSession(false, false, false);
        ClientProducer clientProducer = this.clientSession.createProducer(this.qName);
        clientSession.start();
        ClientConsumer consumer = clientSession.createConsumer(this.qName);
        ClientConsumer consumer2 = clientSession.createConsumer(this.qName);
        Thread.sleep(200L);
        SimpleString groupId = SimpleString.of((String)"grp1");
        SimpleString groupId2 = SimpleString.of((String)"grp2");
        int numMessages = 100;
        for (int i = 0; i < numMessages; ++i) {
            ClientMessage message = this.createTextMessage(clientSession, "m" + i);
            if (i % 2 == 0 || i == 0) {
                message.putStringProperty(Message.HDR_GROUP_ID, groupId);
            } else {
                message.putStringProperty(Message.HDR_GROUP_ID, groupId2);
            }
            clientProducer.send((Message)message);
        }
        CountDownLatch latch = new CountDownLatch(numMessages);
        DummyMessageHandler dummyMessageHandler = new DummyMessageHandler(latch, true);
        consumer.setMessageHandler((MessageHandler)dummyMessageHandler);
        DummyMessageHandler dummyMessageHandler2 = new DummyMessageHandler(latch, true);
        consumer2.setMessageHandler((MessageHandler)dummyMessageHandler2);
        Assertions.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
        clientSession.commit();
        Assertions.assertEquals((int)dummyMessageHandler.list.size(), (int)50);
        int i = 0;
        for (ClientMessage message : dummyMessageHandler.list) {
            Assertions.assertEquals((Object)message.getBodyBuffer().readString(), (Object)("m" + i));
            i += 2;
        }
        Assertions.assertEquals((int)dummyMessageHandler2.list.size(), (int)50);
        i = 1;
        for (ClientMessage message : dummyMessageHandler2.list) {
            Assertions.assertEquals((Object)message.getBodyBuffer().readString(), (Object)("m" + i));
            i += 2;
        }
        consumer.close();
        consumer2.close();
        consumer = this.clientSession.createConsumer(this.qName);
        Assertions.assertNull((Object)consumer.receiveImmediate());
        clientSession.close();
        locator.close();
    }

    private void doTestMultipleGroupingTXRollback() throws Exception {
        ServerLocator locator = this.createInVMNonHALocator();
        locator.setBlockOnAcknowledge(true);
        ClientSessionFactory sessionFactory = this.createSessionFactory(locator);
        ClientSession clientSession = sessionFactory.createSession(false, false, false);
        ClientProducer clientProducer = this.clientSession.createProducer(this.qName);
        ClientConsumer consumer = clientSession.createConsumer(this.qName);
        ClientConsumer consumer2 = clientSession.createConsumer(this.qName);
        clientSession.start();
        Thread.sleep(200L);
        SimpleString groupId = SimpleString.of((String)"grp1");
        SimpleString groupId2 = SimpleString.of((String)"grp2");
        int numMessages = 100;
        for (int i = 0; i < numMessages; ++i) {
            ClientMessage message = this.createTextMessage(clientSession, "m" + i);
            if (i % 2 == 0 || i == 0) {
                message.putStringProperty(Message.HDR_GROUP_ID, groupId);
            } else {
                message.putStringProperty(Message.HDR_GROUP_ID, groupId2);
            }
            clientProducer.send((Message)message);
        }
        CountDownLatch latch = new CountDownLatch(numMessages);
        DummyMessageHandler dummyMessageHandler = new DummyMessageHandler(latch, true);
        consumer.setMessageHandler((MessageHandler)dummyMessageHandler);
        DummyMessageHandler dummyMessageHandler2 = new DummyMessageHandler(latch, true);
        consumer2.setMessageHandler((MessageHandler)dummyMessageHandler2);
        Assertions.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
        Assertions.assertEquals((float)50.0f, (float)dummyMessageHandler.list.size(), (float)dummyMessageHandler.list.size());
        int i = 0;
        for (ClientMessage message : dummyMessageHandler.list) {
            Assertions.assertEquals((Object)message.getBodyBuffer().readString(), (Object)("m" + i));
            i += 2;
        }
        Assertions.assertEquals((int)dummyMessageHandler2.list.size(), (int)50);
        i = 1;
        for (ClientMessage message : dummyMessageHandler2.list) {
            Assertions.assertEquals((Object)message.getBodyBuffer().readString(), (Object)("m" + i));
            i += 2;
        }
        latch = new CountDownLatch(numMessages);
        dummyMessageHandler.reset(latch);
        dummyMessageHandler2.reset(latch);
        clientSession.rollback();
        Assertions.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
        Assertions.assertEquals((int)dummyMessageHandler.list.size(), (int)50);
        i = 0;
        for (ClientMessage message : dummyMessageHandler.list) {
            Assertions.assertEquals((Object)message.getBodyBuffer().readString(), (Object)("m" + i));
            i += 2;
        }
        Assertions.assertEquals((int)dummyMessageHandler2.list.size(), (int)50);
        i = 1;
        for (ClientMessage message : dummyMessageHandler2.list) {
            Assertions.assertEquals((Object)message.getBodyBuffer().readString(), (Object)("m" + i));
            i += 2;
        }
        consumer = this.clientSession.createConsumer(this.qName);
        Assertions.assertNull((Object)consumer.receiveImmediate());
        clientSession.close();
        locator.close();
    }

    private void dotestMultipleGroupingXACommit() throws Exception {
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory sessionFactory = this.createSessionFactory(locator);
        ClientSession clientSession = sessionFactory.createSession(true, false, false);
        ClientProducer clientProducer = this.clientSession.createProducer(this.qName);
        ClientConsumer consumer = clientSession.createConsumer(this.qName);
        ClientConsumer consumer2 = clientSession.createConsumer(this.qName);
        clientSession.start();
        XidImpl xid = new XidImpl("bq".getBytes(), 4, "gtid".getBytes());
        clientSession.start((Xid)xid, 0);
        SimpleString groupId = SimpleString.of((String)"grp1");
        SimpleString groupId2 = SimpleString.of((String)"grp2");
        int numMessages = 100;
        for (int i = 0; i < numMessages; ++i) {
            ClientMessage message = this.createTextMessage(clientSession, "m" + i);
            if (i % 2 == 0 || i == 0) {
                message.putStringProperty(Message.HDR_GROUP_ID, groupId);
            } else {
                message.putStringProperty(Message.HDR_GROUP_ID, groupId2);
            }
            clientProducer.send((Message)message);
        }
        CountDownLatch latch = new CountDownLatch(numMessages);
        DummyMessageHandler dummyMessageHandler = new DummyMessageHandler(latch, true);
        consumer.setMessageHandler((MessageHandler)dummyMessageHandler);
        DummyMessageHandler dummyMessageHandler2 = new DummyMessageHandler(latch, true);
        consumer2.setMessageHandler((MessageHandler)dummyMessageHandler2);
        Assertions.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
        clientSession.end((Xid)xid, 0x4000000);
        clientSession.prepare((Xid)xid);
        clientSession.commit((Xid)xid, false);
        Assertions.assertEquals((int)dummyMessageHandler.list.size(), (int)50);
        int i = 0;
        for (ClientMessage message : dummyMessageHandler.list) {
            Assertions.assertEquals((Object)message.getBodyBuffer().readString(), (Object)("m" + i));
            i += 2;
        }
        Assertions.assertEquals((int)dummyMessageHandler2.list.size(), (int)50);
        i = 1;
        for (ClientMessage message : dummyMessageHandler2.list) {
            Assertions.assertEquals((Object)message.getBodyBuffer().readString(), (Object)("m" + i));
            i += 2;
        }
        consumer.close();
        consumer2.close();
        consumer = this.clientSession.createConsumer(this.qName);
        Assertions.assertNull((Object)consumer.receiveImmediate());
        clientSession.close();
        locator.close();
    }

    private void doTestMultipleGroupingXARollback() throws Exception {
        ServerLocator locator = this.createInVMNonHALocator();
        locator.setBlockOnAcknowledge(true);
        ClientSessionFactory sessionFactory = this.createSessionFactory(locator);
        ClientSession clientSession = sessionFactory.createSession(true, false, false);
        ClientProducer clientProducer = this.clientSession.createProducer(this.qName);
        clientSession.start();
        ClientConsumer consumer = clientSession.createConsumer(this.qName);
        ClientConsumer consumer2 = clientSession.createConsumer(this.qName);
        XidImpl xid = new XidImpl("bq".getBytes(), 4, "gtid".getBytes());
        clientSession.start((Xid)xid, 0);
        SimpleString groupId = SimpleString.of((String)"grp1");
        SimpleString groupId2 = SimpleString.of((String)"grp2");
        int numMessages = 100;
        for (int i = 0; i < numMessages; ++i) {
            ClientMessage message = this.createTextMessage(clientSession, "m" + i);
            if (i % 2 == 0 || i == 0) {
                message.putStringProperty(Message.HDR_GROUP_ID, groupId);
            } else {
                message.putStringProperty(Message.HDR_GROUP_ID, groupId2);
            }
            clientProducer.send((Message)message);
        }
        CountDownLatch latch = new CountDownLatch(numMessages);
        DummyMessageHandler dummyMessageHandler = new DummyMessageHandler(latch, true);
        consumer.setMessageHandler((MessageHandler)dummyMessageHandler);
        DummyMessageHandler dummyMessageHandler2 = new DummyMessageHandler(latch, true);
        consumer2.setMessageHandler((MessageHandler)dummyMessageHandler2);
        Assertions.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
        clientSession.end((Xid)xid, 0x4000000);
        Assertions.assertEquals((int)dummyMessageHandler.list.size(), (int)50);
        int i = 0;
        for (ClientMessage message : dummyMessageHandler.list) {
            Assertions.assertEquals((Object)message.getBodyBuffer().readString(), (Object)("m" + i));
            i += 2;
        }
        Assertions.assertEquals((int)dummyMessageHandler2.list.size(), (int)50);
        i = 1;
        for (ClientMessage message : dummyMessageHandler2.list) {
            Assertions.assertEquals((Object)message.getBodyBuffer().readString(), (Object)("m" + i));
            i += 2;
        }
        latch = new CountDownLatch(numMessages);
        dummyMessageHandler.reset(latch);
        dummyMessageHandler2.reset(latch);
        clientSession.rollback((Xid)xid);
        clientSession.start((Xid)xid, 0);
        Assertions.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
        clientSession.end((Xid)xid, 0x4000000);
        clientSession.prepare((Xid)xid);
        clientSession.commit((Xid)xid, false);
        Assertions.assertEquals((int)dummyMessageHandler.list.size(), (int)50);
        i = 0;
        for (ClientMessage message : dummyMessageHandler.list) {
            Assertions.assertEquals((Object)message.getBodyBuffer().readString(), (Object)("m" + i));
            i += 2;
        }
        Assertions.assertEquals((int)dummyMessageHandler2.list.size(), (int)50);
        i = 1;
        for (ClientMessage message : dummyMessageHandler2.list) {
            Assertions.assertEquals((Object)message.getBodyBuffer().readString(), (Object)("m" + i));
            i += 2;
        }
        consumer = this.clientSession.createConsumer(this.qName);
        Assertions.assertNull((Object)consumer.receiveImmediate());
        clientSession.close();
        locator.close();
    }

    private void doTestMultipleGrouping() throws Exception {
        ClientProducer clientProducer = this.clientSession.createProducer(this.qName);
        ClientConsumer consumer = this.clientSession.createConsumer(this.qName);
        ClientConsumer consumer2 = this.clientSession.createConsumer(this.qName);
        this.clientSession.start();
        SimpleString groupId = SimpleString.of((String)"grp1");
        SimpleString groupId2 = SimpleString.of((String)"grp2");
        int numMessages = 4;
        for (int i = 0; i < numMessages; ++i) {
            ClientMessage message = this.createTextMessage(this.clientSession, "m" + i);
            if (i % 2 == 0 || i == 0) {
                message.putStringProperty(Message.HDR_GROUP_ID, groupId);
            } else {
                message.putStringProperty(Message.HDR_GROUP_ID, groupId2);
            }
            clientProducer.send((Message)message);
        }
        CountDownLatch latch = new CountDownLatch(numMessages);
        DummyMessageHandler dummyMessageHandler = new DummyMessageHandler(latch, true);
        consumer.setMessageHandler((MessageHandler)dummyMessageHandler);
        DummyMessageHandler dummyMessageHandler2 = new DummyMessageHandler(latch, true);
        consumer2.setMessageHandler((MessageHandler)dummyMessageHandler2);
        Assertions.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
        Assertions.assertEquals((int)(numMessages / 2), (int)dummyMessageHandler.list.size());
        int i = 0;
        for (ClientMessage message : dummyMessageHandler.list) {
            Assertions.assertEquals((Object)message.getBodyBuffer().readString(), (Object)("m" + i));
            i += 2;
        }
        Assertions.assertEquals((int)(numMessages / 2), (int)dummyMessageHandler2.list.size());
        i = 1;
        for (ClientMessage message : dummyMessageHandler2.list) {
            Assertions.assertEquals((Object)message.getBodyBuffer().readString(), (Object)("m" + i));
            i += 2;
        }
        consumer.close();
        consumer2.close();
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        Configuration configuration = this.createDefaultInVMConfig();
        this.server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)configuration, (boolean)false));
        this.server.start();
        this.locator = this.createInVMNonHALocator();
        this.clientSessionFactory = this.createSessionFactory(this.locator);
        this.clientSession = this.addClientSession(this.clientSessionFactory.createSession(false, true, true));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)this.qName).setDurable(Boolean.valueOf(false)));
    }

    private static class DummyMessageHandler
    implements MessageHandler {
        ArrayList<ClientMessage> list = new ArrayList();
        private CountDownLatch latch;
        private final boolean acknowledge;

        private DummyMessageHandler(CountDownLatch latch, boolean acknowledge) {
            this.latch = latch;
            this.acknowledge = acknowledge;
        }

        public void onMessage(ClientMessage message) {
            this.list.add(message);
            if (this.acknowledge) {
                try {
                    message.acknowledge();
                }
                catch (ActiveMQException activeMQException) {
                    // empty catch block
                }
            }
            this.latch.countDown();
        }

        public void reset(CountDownLatch latch) {
            this.list.clear();
            this.latch = latch;
        }
    }
}

