/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.tests.util.SingleServerTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MixRoutingTest
extends SingleServerTestBase {
    @Override
    protected ActiveMQServer createServer() throws Exception {
        return this.createServer(false, this.createDefaultNettyConfig());
    }

    @Test
    public void testMix() throws Exception {
        SimpleString queueName = SimpleString.of((String)this.getName());
        this.server.createQueue(QueueConfiguration.of((SimpleString)queueName).setRoutingType(RoutingType.ANYCAST));
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory();
        Connection connection = factory.createConnection();
        Session session = connection.createSession(false, 1);
        TemporaryQueue temporaryQueue = session.createTemporaryQueue();
        Queue queue = session.createQueue(queueName.toString());
        MessageProducer prodTemp = session.createProducer((Destination)temporaryQueue);
        MessageProducer prodQueue = session.createProducer((Destination)queue);
        int NMESSAGES = 100;
        for (int i = 0; i < 100; ++i) {
            TextMessage tmpMessage = session.createTextMessage("tmp");
            tmpMessage.setIntProperty("i", i);
            TextMessage permanent = session.createTextMessage("permanent");
            permanent.setIntProperty("i", i);
            prodQueue.send((Message)permanent);
            prodTemp.send((Message)tmpMessage);
        }
        MessageConsumer consumerTemp = session.createConsumer((Destination)temporaryQueue);
        MessageConsumer consumerQueue = session.createConsumer((Destination)queue);
        connection.start();
        for (int i = 0; i < 100; ++i) {
            TextMessage tmpMessage = (TextMessage)consumerTemp.receive(5000L);
            TextMessage permanent = (TextMessage)consumerQueue.receive(5000L);
            Assertions.assertNotNull((Object)tmpMessage);
            Assertions.assertNotNull((Object)permanent);
            Assertions.assertEquals((Object)"tmp", (Object)tmpMessage.getText());
            Assertions.assertEquals((Object)"permanent", (Object)permanent.getText());
            Assertions.assertEquals((int)i, (int)tmpMessage.getIntProperty("i"));
            Assertions.assertEquals((int)i, (int)permanent.getIntProperty("i"));
        }
        Assertions.assertNull((Object)consumerQueue.receiveNoWait());
        Assertions.assertNull((Object)consumerTemp.receiveNoWait());
        connection.close();
        factory.close();
    }

    @Test
    public void testMix2() throws Exception {
        this.server.createQueue(QueueConfiguration.of((String)this.getName()).setRoutingType(RoutingType.ANYCAST));
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory();
        Connection connection = factory.createConnection();
        Session session = connection.createSession(false, 1);
        Queue queue = session.createQueue(this.getName());
        MessageProducer prodQueue = session.createProducer((Destination)queue);
        int NMESSAGES = 100;
        for (int i = 0; i < 100; ++i) {
            TextMessage permanent = session.createTextMessage("permanent");
            permanent.setIntProperty("i", i);
            prodQueue.send((Message)permanent);
        }
        TemporaryQueue temporaryQueue = session.createTemporaryQueue();
        MessageProducer prodTemp = session.createProducer((Destination)temporaryQueue);
        for (int i = 0; i < 100; ++i) {
            TextMessage tmpMessage = session.createTextMessage("tmp");
            tmpMessage.setIntProperty("i", i);
            prodTemp.send((Message)tmpMessage);
        }
        MessageConsumer consumerTemp = session.createConsumer((Destination)temporaryQueue);
        MessageConsumer consumerQueue = session.createConsumer((Destination)queue);
        connection.start();
        for (int i = 0; i < 100; ++i) {
            TextMessage tmpMessage = (TextMessage)consumerTemp.receive(5000L);
            TextMessage permanent = (TextMessage)consumerQueue.receive(5000L);
            Assertions.assertNotNull((Object)tmpMessage);
            Assertions.assertNotNull((Object)permanent);
            Assertions.assertEquals((Object)"tmp", (Object)tmpMessage.getText());
            Assertions.assertEquals((Object)"permanent", (Object)permanent.getText());
            Assertions.assertEquals((int)i, (int)tmpMessage.getIntProperty("i"));
            Assertions.assertEquals((int)i, (int)permanent.getIntProperty("i"));
        }
        Assertions.assertNull((Object)consumerQueue.receiveNoWait());
        Assertions.assertNull((Object)consumerTemp.receiveNoWait());
        connection.close();
        factory.close();
    }

    @Test
    public void testMixWithTopics() throws Exception {
        TextMessage permanent;
        SimpleString queueName = SimpleString.of((String)this.getName());
        SimpleString topicName = SimpleString.of((String)("topic" + this.getName()));
        AddressInfo info = new AddressInfo(topicName, RoutingType.MULTICAST);
        this.server.addAddressInfo(info);
        this.server.createQueue(QueueConfiguration.of((SimpleString)queueName).setRoutingType(RoutingType.ANYCAST));
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory();
        Connection connection = factory.createConnection();
        Session session = connection.createSession(false, 1);
        Queue queue = session.createQueue(queueName.toString());
        Topic topic = session.createTopic(topicName.toString());
        MessageProducer prodQueue = session.createProducer((Destination)queue);
        MessageProducer prodTopic = session.createProducer((Destination)topic);
        int NMESSAGES = 10;
        for (int i = 0; i < 10; ++i) {
            TextMessage topicMessage = session.createTextMessage("topic");
            topicMessage.setIntProperty("i", i);
            permanent = session.createTextMessage("permanent");
            permanent.setIntProperty("i", i);
            prodQueue.send((Message)permanent);
            prodTopic.send((Message)topicMessage);
        }
        MessageConsumer consumerQueue = session.createConsumer((Destination)queue);
        connection.start();
        for (int i = 0; i < 10; ++i) {
            permanent = (TextMessage)consumerQueue.receive(5000L);
            Assertions.assertNotNull((Object)permanent);
            Assertions.assertEquals((Object)"permanent", (Object)permanent.getText());
            Assertions.assertEquals((int)i, (int)permanent.getIntProperty("i"));
        }
        Assertions.assertNull((Object)consumerQueue.receiveNoWait());
        connection.close();
        factory.close();
    }
}

