/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.BaseInterceptor;
import org.apache.activemq.artemis.api.core.Interceptor;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerTest
extends ActiveMQTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private ActiveMQServer server;
    private final SimpleString QUEUE = SimpleString.of((String)"ConsumerTestQueue");

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(false);
        this.server.start();
    }

    @Test
    public void testProducerWithSmallWindowSizeAndLargeMessage() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        this.server.getRemotingService().addIncomingInterceptor((BaseInterceptor)((Interceptor)(packet, connection) -> {
            if (packet.getType() == 71) {
                latch.countDown();
            }
            return true;
        }));
        ServerLocator locator = this.createInVMNonHALocator().setConfirmationWindowSize(100);
        ClientSessionFactory cf = locator.createSessionFactory();
        ClientSession session = cf.createSession(false, true, true);
        ClientProducer producer = session.createProducer(this.QUEUE);
        ClientMessage message = session.createMessage(true);
        byte[] body = new byte[1000];
        message.getBodyBuffer().writeBytes(body);
        producer.send((Message)message);
        Assertions.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
        session.close();
        locator.close();
    }

    @Test
    public void testProducerMultiThread() throws Exception {
        ServerLocator locator = this.createInVMNonHALocator();
        AddressSettings setting = new AddressSettings().setAddressFullMessagePolicy(AddressFullMessagePolicy.BLOCK).setMaxSizeBytes(10240L);
        this.server.stop();
        this.server.getConfiguration().getAddressSettings().clear();
        this.server.getConfiguration().getAddressSettings().put(this.QUEUE.toString(), setting);
        this.server.start();
        this.server.createQueue(QueueConfiguration.of((SimpleString)this.QUEUE));
        for (int i = 0; i < 100; ++i) {
            ClientMessage msg;
            CountDownLatch latch = new CountDownLatch(1);
            logger.debug("Try {}", (Object)i);
            ClientSessionFactory cf = locator.createSessionFactory();
            ClientSession session = cf.createSession(false, true, true);
            Thread t = new Thread(() -> {
                try {
                    ClientProducer producer = session.createProducer();
                    for (int i1 = 0; i1 < 62; ++i1) {
                        if (i1 == 30) {
                            latch.countDown();
                        }
                        ClientMessage msg = session.createMessage(false);
                        msg.getBodyBuffer().writeBytes(new byte[2048]);
                        producer.send(this.QUEUE, (Message)msg);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
            t.start();
            Assertions.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
            session.close();
            t.join(5000L);
            if (!t.isAlive()) {
                t.interrupt();
            }
            Assertions.assertFalse((boolean)t.isAlive());
            ClientSession sessionConsumer = cf.createSession();
            sessionConsumer.start();
            ClientConsumer cons = sessionConsumer.createConsumer(this.QUEUE);
            while ((msg = cons.receiveImmediate()) != null) {
                msg.acknowledge();
                sessionConsumer.commit();
            }
            cf.close();
        }
    }
}

