/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorInternal;
import org.apache.activemq.artemis.core.config.ha.ReplicaPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicationBackupPolicyConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.integration.cluster.failover.ReplicatedMultipleServerFailoverTest;
import org.apache.activemq.artemis.tests.integration.cluster.util.TestableServer;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class ReplicatedMultipleServerFailoverExtraBackupsTest
extends ReplicatedMultipleServerFailoverTest {
    private void waitForSync(ActiveMQServer server) throws Exception {
        Wait.waitFor(() -> ((ActiveMQServer)server).isReplicaSync());
    }

    @Override
    @TestTemplate
    public void testStartPrimaryFirst() throws Exception {
        switch (this.haType()) {
            case SharedNothingReplication: {
                ((ReplicaPolicyConfiguration)((TestableServer)this.backupServers.get(2)).getServer().getConfiguration().getHAPolicyConfiguration()).setGroupName(this.getNodeGroupName() + "-0");
                ((ReplicaPolicyConfiguration)((TestableServer)this.backupServers.get(3)).getServer().getConfiguration().getHAPolicyConfiguration()).setGroupName(this.getNodeGroupName() + "-1");
                break;
            }
            case PluggableQuorumReplication: {
                ((ReplicationBackupPolicyConfiguration)((TestableServer)this.backupServers.get(2)).getServer().getConfiguration().getHAPolicyConfiguration()).setGroupName(this.getNodeGroupName() + "-0");
                ((ReplicationBackupPolicyConfiguration)((TestableServer)this.backupServers.get(3)).getServer().getConfiguration().getHAPolicyConfiguration()).setGroupName(this.getNodeGroupName() + "-1");
            }
        }
        this.startServers(this.primaryServers);
        ((TestableServer)this.backupServers.get(0)).start();
        ((TestableServer)this.backupServers.get(1)).start();
        this.waitForSync(((TestableServer)this.backupServers.get(0)).getServer());
        this.waitForSync(((TestableServer)this.backupServers.get(1)).getServer());
        ((TestableServer)this.backupServers.get(2)).start();
        ((TestableServer)this.backupServers.get(3)).start();
        this.sendCrashReceive();
        Wait.assertTrue(((TestableServer)this.backupServers.get(0))::isActive, (long)5000L, (long)10L);
        Wait.assertTrue(((TestableServer)this.backupServers.get(1))::isActive, (long)5000L, (long)10L);
        ReplicatedMultipleServerFailoverExtraBackupsTest.waitForTopology(((TestableServer)this.backupServers.get(0)).getServer(), this.primaryServers.size(), 2);
        ReplicatedMultipleServerFailoverExtraBackupsTest.waitForTopology(((TestableServer)this.backupServers.get(1)).getServer(), this.primaryServers.size(), 2);
        this.sendCrashBackupReceive();
    }

    private void waitForBackups() throws InterruptedException {
        for (TestableServer backupServer : this.backupServers) {
            ReplicatedMultipleServerFailoverExtraBackupsTest.waitForComponent((ActiveMQComponent)backupServer.getServer(), 5L);
        }
    }

    private void startServers(List<TestableServer> servers) throws Exception {
        for (TestableServer testableServer : servers) {
            testableServer.start();
        }
    }

    @Override
    @TestTemplate
    public void testStartBackupFirst() throws Exception {
        switch (this.haType()) {
            case SharedNothingReplication: {
                ((ReplicaPolicyConfiguration)((TestableServer)this.backupServers.get(2)).getServer().getConfiguration().getHAPolicyConfiguration()).setGroupName(this.getNodeGroupName() + "-0");
                ((ReplicaPolicyConfiguration)((TestableServer)this.backupServers.get(3)).getServer().getConfiguration().getHAPolicyConfiguration()).setGroupName(this.getNodeGroupName() + "-1");
                break;
            }
            case PluggableQuorumReplication: {
                ((ReplicationBackupPolicyConfiguration)((TestableServer)this.backupServers.get(2)).getServer().getConfiguration().getHAPolicyConfiguration()).setGroupName(this.getNodeGroupName() + "-0");
                ((ReplicationBackupPolicyConfiguration)((TestableServer)this.backupServers.get(3)).getServer().getConfiguration().getHAPolicyConfiguration()).setGroupName(this.getNodeGroupName() + "-1");
            }
        }
        this.startServers(this.backupServers);
        this.startServers(this.primaryServers);
        this.waitForBackups();
        ReplicatedMultipleServerFailoverExtraBackupsTest.waitForTopology(((TestableServer)this.primaryServers.get(0)).getServer(), this.primaryServers.size(), 2);
        this.sendCrashReceive();
    }

    protected void sendCrashBackupReceive() throws Exception {
        this.waitForBindings(((TestableServer)this.backupServers.get(0)).getServer(), ADDRESS.toString(), false, 1, 0, 2000L);
        this.waitForBindings(((TestableServer)this.backupServers.get(0)).getServer(), ADDRESS.toString(), false, 1, 0, 2000L);
        this.waitForBindings(((TestableServer)this.backupServers.get(1)).getServer(), ADDRESS.toString(), false, 1, 0, 2000L);
        this.waitForBindings(((TestableServer)this.backupServers.get(1)).getServer(), ADDRESS.toString(), false, 1, 0, 2000L);
        ServerLocatorInternal locator0 = this.getBackupServerLocator(0);
        ServerLocatorInternal locator1 = this.getBackupServerLocator(1);
        ClientSessionFactory factory0 = this.createSessionFactory((ServerLocator)locator0);
        ClientSessionFactory factory1 = this.createSessionFactory((ServerLocator)locator1);
        ClientSession session0 = factory0.createSession(false, true, true);
        ClientSession session1 = factory1.createSession(false, true, true);
        ClientProducer producer = session0.createProducer(ADDRESS);
        for (int i = 0; i < 200; ++i) {
            ClientMessage message = session0.createMessage(true);
            this.setBody(i, message);
            message.putIntProperty("counter", i);
            producer.send((Message)message);
        }
        producer.close();
        Assertions.assertTrue((boolean)this.waitForDistribution(ADDRESS, ((TestableServer)this.backupServers.get(0)).getServer(), 100));
        Assertions.assertTrue((boolean)this.waitForDistribution(ADDRESS, ((TestableServer)this.backupServers.get(1)).getServer(), 100));
        ArrayList<TestableServer> toCrash = new ArrayList<TestableServer>();
        for (Object backupServer : this.backupServers) {
            if (backupServer.getServer().getHAPolicy().isBackup()) continue;
            toCrash.add((TestableServer)backupServer);
        }
        CountDownLatch failoverHappened = new CountDownLatch(1);
        session0.addFailoverListener(type -> failoverHappened.countDown());
        for (TestableServer testableServer : toCrash) {
            testableServer.crash(new ClientSession[0]).await(10L, TimeUnit.SECONDS);
            testableServer.stop();
        }
        Assertions.assertTrue((boolean)failoverHappened.await(10L, TimeUnit.SECONDS));
        ClientConsumer consumer0 = session0.createConsumer(ADDRESS);
        ClientConsumer consumer1 = session1.createConsumer(ADDRESS);
        session0.start();
        session1.start();
        for (int i = 0; i < 100; ++i) {
            ClientMessage message = consumer0.receive(1000L);
            Assertions.assertNotNull((Object)message, (String)("expecting durable msg " + i));
            message.acknowledge();
            message = consumer1.receive(1000L);
            Assertions.assertNotNull((Object)message, (String)("expecting durable msg " + i));
            message.acknowledge();
        }
    }

    @Override
    public int getBackupServerCount() {
        return 4;
    }
}

