/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.discovery;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.activemq.artemis.api.core.BroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.UDPBroadcastEndpointFactory;
import org.apache.activemq.artemis.core.cluster.DiscoveryEntry;
import org.apache.activemq.artemis.core.cluster.DiscoveryGroup;
import org.apache.activemq.artemis.core.cluster.DiscoveryListener;
import org.apache.activemq.artemis.core.server.ActivateCallback;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.cluster.BroadcastGroup;
import org.apache.activemq.artemis.core.server.cluster.impl.BroadcastGroupImpl;
import org.apache.activemq.artemis.core.server.impl.CleaningActivateCallback;
import org.apache.activemq.artemis.core.server.management.NotificationService;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.junit.jupiter.api.Assertions;

public class DiscoveryBaseTest
extends ActiveMQTestBase {
    protected final String address1 = DiscoveryBaseTest.getUDPDiscoveryAddress();
    protected final String address2 = DiscoveryBaseTest.getUDPDiscoveryAddress(1);
    protected final String address3 = DiscoveryBaseTest.getUDPDiscoveryAddress(2);

    protected static void verifyBroadcast(BroadcastGroup broadcastGroup, DiscoveryGroup discoveryGroup) throws Exception {
        broadcastGroup.broadcastConnectors();
        Assertions.assertTrue((boolean)discoveryGroup.waitForBroadcast(2000L), (String)"broadcast not received");
    }

    protected static void verifyNonBroadcast(BroadcastGroup broadcastGroup, DiscoveryGroup discoveryGroup) throws Exception {
        broadcastGroup.broadcastConnectors();
        Assertions.assertFalse((boolean)discoveryGroup.waitForBroadcast(2000L), (String)"NO broadcast received");
    }

    protected TransportConfiguration generateTC() {
        return this.generateTC("");
    }

    protected TransportConfiguration generateTC(String debug) {
        String className = "org.foo.bar." + debug + "|" + UUIDGenerator.getInstance().generateStringUUID();
        String name = UUIDGenerator.getInstance().generateStringUUID();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(UUIDGenerator.getInstance().generateStringUUID(), 123);
        params.put(UUIDGenerator.getInstance().generateStringUUID(), UUIDGenerator.getInstance().generateStringUUID());
        params.put(UUIDGenerator.getInstance().generateStringUUID(), true);
        TransportConfiguration tc = new TransportConfiguration(className, params, name);
        return tc;
    }

    protected static void assertEqualsDiscoveryEntries(List<TransportConfiguration> expected, List<DiscoveryEntry> actual) {
        Assertions.assertNotNull(actual);
        ArrayList<TransportConfiguration> sortedExpected = new ArrayList<TransportConfiguration>(expected);
        Collections.sort(sortedExpected, (o1, o2) -> o2.toString().compareTo(o1.toString()));
        ArrayList<DiscoveryEntry> sortedActual = new ArrayList<DiscoveryEntry>(actual);
        Collections.sort(sortedActual, (o1, o2) -> o2.getConnector().toString().compareTo(o1.getConnector().toString()));
        if (sortedExpected.size() != sortedActual.size()) {
            DiscoveryBaseTest.dump(sortedExpected, sortedActual);
        }
        Assertions.assertEquals((int)sortedExpected.size(), (int)sortedActual.size());
        for (int i = 0; i < sortedExpected.size(); ++i) {
            if (!((TransportConfiguration)sortedExpected.get(i)).equals((Object)((DiscoveryEntry)sortedActual.get(i)).getConnector())) {
                DiscoveryBaseTest.dump(sortedExpected, sortedActual);
            }
            Assertions.assertEquals(sortedExpected.get(i), (Object)((DiscoveryEntry)sortedActual.get(i)).getConnector());
        }
    }

    protected static void dump(List<TransportConfiguration> sortedExpected, List<DiscoveryEntry> sortedActual) {
        System.out.println("wrong broadcasts received");
        System.out.println("expected");
        System.out.println("----------------------------");
        for (TransportConfiguration transportConfiguration : sortedExpected) {
            System.out.println("transportConfiguration = " + transportConfiguration);
        }
        System.out.println("----------------------------");
        System.out.println("actual");
        System.out.println("----------------------------");
        for (DiscoveryEntry discoveryEntry : sortedActual) {
            System.out.println("transportConfiguration = " + discoveryEntry.getConnector());
        }
        System.out.println("----------------------------");
    }

    protected BroadcastGroupImpl newBroadcast(String nodeID, String name, InetAddress localAddress, int localPort, InetAddress groupAddress, int groupPort) throws Exception {
        return new BroadcastGroupImpl((NodeManager)new FakeNodeManager(nodeID), name, 0L, null, (BroadcastEndpointFactory)new UDPBroadcastEndpointFactory().setGroupAddress(groupAddress.getHostAddress()).setGroupPort(groupPort).setLocalBindAddress(localAddress != null ? localAddress.getHostAddress() : "localhost").setLocalBindPort(localPort));
    }

    protected DiscoveryGroup newDiscoveryGroup(String nodeID, String name, InetAddress localBindAddress, InetAddress groupAddress, int groupPort, long timeout) throws Exception {
        return this.newDiscoveryGroup(nodeID, name, localBindAddress, groupAddress, groupPort, timeout, null);
    }

    protected DiscoveryGroup newDiscoveryGroup(String nodeID, String name, InetAddress localBindAddress, InetAddress groupAddress, int groupPort, long timeout, NotificationService notif) throws Exception {
        return new DiscoveryGroup(nodeID, name, timeout, (BroadcastEndpointFactory)new UDPBroadcastEndpointFactory().setGroupAddress(groupAddress.getHostAddress()).setGroupPort(groupPort).setLocalBindAddress(localBindAddress != null ? localBindAddress.getHostAddress() : "localhost"), notif);
    }

    protected final class FakeNodeManager
    extends NodeManager {
        public FakeNodeManager(String nodeID) {
            super(false);
            this.setNodeID(nodeID);
        }

        public void awaitPrimaryNode() {
        }

        public void awaitActiveStatus() {
        }

        public void startBackup() {
        }

        public ActivateCallback startPrimaryNode() {
            return new CleaningActivateCallback(){};
        }

        public void pausePrimaryServer() {
        }

        public void crashPrimaryServer() {
        }

        public void releaseBackup() {
        }

        public SimpleString readNodeId() {
            return null;
        }

        public boolean isAwaitingFailback() {
            return false;
        }

        public boolean isBackupActive() {
            return false;
        }

        public void interrupt() {
        }
    }

    protected static class MyListener
    implements DiscoveryListener {
        volatile boolean called;

        protected MyListener() {
        }

        public void connectorsChanged(List<DiscoveryEntry> newConnectors) {
            this.called = true;
        }
    }
}

