/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.federation;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.core.server.embedded.EmbeddedActiveMQ;
import org.apache.activemq.artemis.tests.integration.jms.RedeployTest;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FederationQueueMatchXMLConfigParsingTest
extends ActiveMQTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Test
    @Timeout(value=20L)
    public void testOpenWireOverCoreFederationDownstream() throws Exception {
        this.doTestSimpleQueueFederationOverCoreFederationDoownstream("OPENWIRE");
    }

    @Test
    @Timeout(value=20L)
    public void testCoreOverCoreFederationDownstream() throws Exception {
        this.doTestSimpleQueueFederationOverCoreFederationDoownstream("CORE");
    }

    @Test
    @Timeout(value=20L)
    public void testAMQPOverCoreFederationDownstream() throws Exception {
        this.doTestSimpleQueueFederationOverCoreFederationDoownstream("AMQP");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTestSimpleQueueFederationOverCoreFederationDoownstream(String clientProtocol) throws Exception {
        URL urlServer1 = RedeployTest.class.getClassLoader().getResource("core-federated-queue-match-server1.xml");
        URL urlServer2 = RedeployTest.class.getClassLoader().getResource("core-federated-queue-match-server2.xml");
        int MESSAGE_COUNT = 5;
        CountDownLatch receivedAllLatch = new CountDownLatch(5);
        EmbeddedActiveMQ embeddedActiveMQ1 = new EmbeddedActiveMQ();
        embeddedActiveMQ1.setConfigResourcePath(urlServer1.toURI().toString());
        embeddedActiveMQ1.start();
        EmbeddedActiveMQ embeddedActiveMQ2 = new EmbeddedActiveMQ();
        embeddedActiveMQ2.setConfigResourcePath(urlServer2.toURI().toString());
        embeddedActiveMQ2.start();
        ConnectionFactory consumerConnectionFactory = CFUtil.createConnectionFactory(clientProtocol, "tcp://localhost:61618");
        ConnectionFactory producerConnectionFactory = CFUtil.createConnectionFactory(clientProtocol, "tcp://localhost:61616");
        try (Connection consumerConnection = consumerConnectionFactory.createConnection();){
            Session consumerSession = consumerConnection.createSession(false, 1);
            Queue consumerDestination = consumerSession.createQueue("exampleQueueTwo");
            MessageConsumer consumer = consumerSession.createConsumer((Destination)consumerDestination);
            consumerConnection.start();
            consumer.setMessageListener(message -> {
                logger.info("Received message: {} ", (Object)message);
                receivedAllLatch.countDown();
            });
            try (Connection producerConnection = producerConnectionFactory.createConnection();){
                producerConnection.start();
                Session producerSession = producerConnection.createSession(false, 1);
                Queue producerQueue = producerSession.createQueue("exampleQueueTwo");
                MessageProducer producer = producerSession.createProducer((Destination)producerQueue);
                UUID uuid = UUID.randomUUID();
                for (int i = 0; i < 5; ++i) {
                    producer.send((Message)producerSession.createTextMessage("Test message:" + uuid));
                    logger.trace("Sent message: {}", (Object)uuid);
                }
                logger.info("Sent {} messages to queue for federation dispatch.", (Object)5);
            }
            Assertions.assertTrue((boolean)receivedAllLatch.await(10L, TimeUnit.SECONDS));
        }
        finally {
            try {
                embeddedActiveMQ1.stop();
            }
            catch (Exception exception) {}
            try {
                embeddedActiveMQ2.stop();
            }
            catch (Exception exception) {}
        }
    }

    @Test
    @Timeout(value=20L)
    public void testQueuePolicyMatchesOnlyIndicatedQueueOpenwire() throws Exception {
        this.doTestQueueMatchPolicyOnlyMatchesIndicatedQueue("OPENWIRE");
    }

    @Test
    @Timeout(value=20L)
    public void testQueuePolicyMatchesOnlyIndicatedQueueCore() throws Exception {
        this.doTestQueueMatchPolicyOnlyMatchesIndicatedQueue("CORE");
    }

    @Test
    @Timeout(value=20L)
    public void testQueuePolicyMatchesOnlyIndicatedQueueAMQP() throws Exception {
        this.doTestQueueMatchPolicyOnlyMatchesIndicatedQueue("AMQP");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTestQueueMatchPolicyOnlyMatchesIndicatedQueue(String clientProtocol) throws Exception {
        URL urlServer1 = RedeployTest.class.getClassLoader().getResource("core-federated-queue-match-server1.xml");
        URL urlServer2 = RedeployTest.class.getClassLoader().getResource("core-federated-queue-match-server2.xml");
        int MESSAGE_COUNT = 5;
        AtomicInteger receivedOnQ1Count = new AtomicInteger();
        CountDownLatch receivedAllOnQ2Latch = new CountDownLatch(5);
        EmbeddedActiveMQ embeddedActiveMQ1 = new EmbeddedActiveMQ();
        embeddedActiveMQ1.setConfigResourcePath(urlServer1.toURI().toString());
        embeddedActiveMQ1.start();
        EmbeddedActiveMQ embeddedActiveMQ2 = new EmbeddedActiveMQ();
        embeddedActiveMQ2.setConfigResourcePath(urlServer2.toURI().toString());
        embeddedActiveMQ2.start();
        ConnectionFactory consumerConnectionFactory = CFUtil.createConnectionFactory(clientProtocol, "tcp://localhost:61616");
        ConnectionFactory producerConnectionFactory = CFUtil.createConnectionFactory(clientProtocol, "tcp://localhost:61618");
        try (Connection consumerConnection = consumerConnectionFactory.createConnection();){
            Session consumerSession = consumerConnection.createSession(false, 1);
            Queue consumerDestination1 = consumerSession.createQueue("exampleQueueOne");
            Queue consumerDestination2 = consumerSession.createQueue("exampleQueueTwo");
            MessageConsumer consumer1 = consumerSession.createConsumer((Destination)consumerDestination1);
            MessageConsumer consumer2 = consumerSession.createConsumer((Destination)consumerDestination2);
            consumerConnection.start();
            consumer1.setMessageListener(message -> {
                logger.info("Consumer #1 Received message: {} ", (Object)message);
                receivedOnQ1Count.incrementAndGet();
            });
            consumer2.setMessageListener(message -> {
                logger.info("Consumer #2 Received message: {} ", (Object)message);
                receivedAllOnQ2Latch.countDown();
            });
            try (Connection producerConnection = producerConnectionFactory.createConnection();){
                producerConnection.start();
                Session producerSession = producerConnection.createSession(false, 1);
                Queue producerQueue1 = producerSession.createQueue("exampleQueueOne");
                Queue producerQueue2 = producerSession.createQueue("exampleQueueTwo");
                MessageProducer producer1 = producerSession.createProducer((Destination)producerQueue1);
                MessageProducer producer2 = producerSession.createProducer((Destination)producerQueue2);
                UUID uuid = UUID.randomUUID();
                for (int i = 0; i < 5; ++i) {
                    producer1.send((Message)producerSession.createTextMessage("Test message:" + uuid));
                    producer2.send((Message)producerSession.createTextMessage("Test message:" + uuid));
                    logger.trace("Sent message: {}", (Object)uuid);
                }
                logger.info("Sent {} messages to queues for federation dispatch.", (Object)5);
            }
            Assertions.assertTrue((boolean)receivedAllOnQ2Latch.await(10L, TimeUnit.SECONDS));
            Assertions.assertEquals((int)0, (int)receivedOnQ1Count.get());
        }
        finally {
            try {
                embeddedActiveMQ1.stop();
            }
            catch (Exception exception) {}
            try {
                embeddedActiveMQ2.stop();
            }
            catch (Exception exception) {}
        }
    }
}

