/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.core.postoffice.impl.DivertBinding;
import org.apache.activemq.artemis.core.postoffice.impl.LocalQueueBinding;
import org.apache.activemq.artemis.core.security.CheckType;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.server.cluster.impl.RemoteQueueBindingImpl;
import org.apache.activemq.artemis.core.server.embedded.EmbeddedActiveMQ;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.reload.ReloadManager;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQDestination;
import org.apache.activemq.artemis.tests.unit.core.postoffice.impl.fakes.FakeQueue;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.ReusableLatch;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RedeployTest
extends ActiveMQTestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRedeployAutoCreateAddress() throws Exception {
        Path brokerXML = this.getTestDirfile().toPath().resolve("broker.xml");
        URL url1 = RedeployTest.class.getClassLoader().getResource("reload-test-autocreateaddress.xml");
        URL url2 = RedeployTest.class.getClassLoader().getResource("reload-test-autocreateaddress-reload.xml");
        Files.copy(url1.openStream(), brokerXML, new CopyOption[0]);
        EmbeddedActiveMQ embeddedActiveMQ = new EmbeddedActiveMQ();
        embeddedActiveMQ.setConfigResourcePath(brokerXML.toUri().toString());
        embeddedActiveMQ.start();
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory();
        try (Connection connection = factory.createConnection();){
            Session session = connection.createSession();
            jakarta.jms.Queue queue = session.createQueue("autoQueue");
            MessageProducer producer = session.createProducer((Destination)queue);
            producer.send((Message)session.createTextMessage("text"));
            connection.start();
            MessageConsumer consumer = session.createConsumer((Destination)session.createQueue("autoQueue"));
            Assertions.assertNotNull((Object)consumer.receive(5000L), (String)"Address wasn't autocreated accordingly");
        }
        Assertions.assertNotNull((Object)this.getQueue(embeddedActiveMQ, "autoQueue"));
        embeddedActiveMQ.getActiveMQServer().getPostOffice().addBinding((Binding)new RemoteQueueBindingImpl(5L, SimpleString.of((String)"autoQueue"), SimpleString.of((String)"uniqueName"), SimpleString.of((String)"routingName"), Long.valueOf(6L), null, (Queue)new FakeQueue(SimpleString.of((String)"foo"), 6L), SimpleString.of((String)"bridge"), 1, MessageLoadBalancingType.OFF));
        ReusableLatch latch = new ReusableLatch(1);
        Runnable tick = () -> ((ReusableLatch)latch).countDown();
        embeddedActiveMQ.getActiveMQServer().getReloadManager().setTick(tick);
        try {
            latch.await(10L, TimeUnit.SECONDS);
            Files.copy(url2.openStream(), brokerXML, StandardCopyOption.REPLACE_EXISTING);
            brokerXML.toFile().setLastModified(System.currentTimeMillis() + 1000L);
            latch.setCount(1);
            embeddedActiveMQ.getActiveMQServer().getReloadManager().setTick(tick);
            latch.await(10L, TimeUnit.SECONDS);
            Assertions.assertTrue((boolean)this.tryConsume());
            Assertions.assertNotNull((Object)this.getQueue(embeddedActiveMQ, "autoQueue"));
            factory = new ActiveMQConnectionFactory();
            try (Connection connection = factory.createConnection();){
                Session session = connection.createSession();
                jakarta.jms.Queue queue = session.createQueue("autoQueue");
                MessageProducer producer = session.createProducer((Destination)queue);
                producer.send((Message)session.createTextMessage("text"));
                connection.start();
                MessageConsumer consumer = session.createConsumer((Destination)session.createQueue("autoQueue"));
                Assertions.assertNotNull((Object)consumer.receive(5000L), (String)"autoQueue redeployed accordingly");
            }
        }
        finally {
            embeddedActiveMQ.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRedeploy() throws Exception {
        Path brokerXML = this.getTestDirfile().toPath().resolve("broker.xml");
        URL url1 = RedeployTest.class.getClassLoader().getResource("reload-test-jms.xml");
        URL url2 = RedeployTest.class.getClassLoader().getResource("reload-test-updated-jms.xml");
        Files.copy(url1.openStream(), brokerXML, new CopyOption[0]);
        EmbeddedActiveMQ embeddedActiveMQ = new EmbeddedActiveMQ();
        embeddedActiveMQ.setConfigResourcePath(brokerXML.toUri().toString());
        embeddedActiveMQ.start();
        ReusableLatch latch = new ReusableLatch(1);
        Runnable tick = () -> ((ReusableLatch)latch).countDown();
        embeddedActiveMQ.getActiveMQServer().getReloadManager().setTick(tick);
        try {
            latch.await(10L, TimeUnit.SECONDS);
            Assertions.assertEquals((Object)"DLQ", (Object)((AddressSettings)embeddedActiveMQ.getActiveMQServer().getAddressSettingsRepository().getMatch("jms")).getDeadLetterAddress().toString());
            Assertions.assertEquals((Object)"ExpiryQueue", (Object)((AddressSettings)embeddedActiveMQ.getActiveMQServer().getAddressSettingsRepository().getMatch("jms")).getExpiryAddress().toString());
            Assertions.assertFalse((boolean)this.tryConsume());
            Files.copy(url2.openStream(), brokerXML, StandardCopyOption.REPLACE_EXISTING);
            brokerXML.toFile().setLastModified(System.currentTimeMillis() + 1000L);
            latch.setCount(1);
            embeddedActiveMQ.getActiveMQServer().getReloadManager().setTick(tick);
            latch.await(10L, TimeUnit.SECONDS);
            Assertions.assertTrue((boolean)this.tryConsume());
            Assertions.assertEquals((Object)"NewQueue", (Object)((AddressSettings)embeddedActiveMQ.getActiveMQServer().getAddressSettingsRepository().getMatch("jms")).getDeadLetterAddress().toString());
            Assertions.assertEquals((Object)"NewQueue", (Object)((AddressSettings)embeddedActiveMQ.getActiveMQServer().getAddressSettingsRepository().getMatch("jms")).getExpiryAddress().toString());
            ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory();
            try (Connection connection = factory.createConnection();){
                Session session = connection.createSession();
                jakarta.jms.Queue queue = session.createQueue("DivertQueue");
                MessageProducer producer = session.createProducer((Destination)queue);
                producer.send((Message)session.createTextMessage("text"));
                connection.start();
                MessageConsumer consumer = session.createConsumer((Destination)session.createQueue("NewQueue"));
                Assertions.assertNotNull((Object)consumer.receive(5000L), (String)"Divert wasn't redeployed accordingly");
            }
        }
        finally {
            embeddedActiveMQ.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRedeployConnector() throws Exception {
        Path brokerXML = this.getTestDirfile().toPath().resolve("broker.xml");
        URL url1 = RedeployTest.class.getClassLoader().getResource("reload-connector.xml");
        URL url2 = RedeployTest.class.getClassLoader().getResource("reload-connector-updated.xml");
        Files.copy(url1.openStream(), brokerXML, new CopyOption[0]);
        EmbeddedActiveMQ embeddedActiveMQ = new EmbeddedActiveMQ();
        embeddedActiveMQ.setConfigResourcePath(brokerXML.toUri().toString());
        embeddedActiveMQ.start();
        ReusableLatch latch = new ReusableLatch(1);
        Runnable tick = () -> ((ReusableLatch)latch).countDown();
        embeddedActiveMQ.getActiveMQServer().getReloadManager().setTick(tick);
        try {
            latch.await(10L, TimeUnit.SECONDS);
            Assertions.assertEquals((Object)"127.0.0.1", ((TransportConfiguration)embeddedActiveMQ.getActiveMQServer().getConfiguration().getConnectorConfigurations().get("artemis")).getParams().get("host"));
            Assertions.assertEquals((Object)"61616", ((TransportConfiguration)embeddedActiveMQ.getActiveMQServer().getConfiguration().getConnectorConfigurations().get("artemis")).getParams().get("port"));
            Files.copy(url2.openStream(), brokerXML, StandardCopyOption.REPLACE_EXISTING);
            brokerXML.toFile().setLastModified(System.currentTimeMillis() + 1000L);
            latch.setCount(1);
            embeddedActiveMQ.getActiveMQServer().getReloadManager().setTick(tick);
            latch.await(10L, TimeUnit.SECONDS);
            Assertions.assertEquals((Object)"127.0.0.2", ((TransportConfiguration)embeddedActiveMQ.getActiveMQServer().getConfiguration().getConnectorConfigurations().get("artemis")).getParams().get("host"));
            Assertions.assertEquals((Object)"61617", ((TransportConfiguration)embeddedActiveMQ.getActiveMQServer().getConfiguration().getConnectorConfigurations().get("artemis")).getParams().get("port"));
            Assertions.assertEquals((Object)"127.0.0.3", ((TransportConfiguration)embeddedActiveMQ.getActiveMQServer().getConfiguration().getConnectorConfigurations().get("artemis2")).getParams().get("host"));
            Assertions.assertEquals((Object)"61618", ((TransportConfiguration)embeddedActiveMQ.getActiveMQServer().getConfiguration().getConnectorConfigurations().get("artemis2")).getParams().get("port"));
        }
        finally {
            embeddedActiveMQ.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRedeploySecuritySettings() throws Exception {
        Path brokerXML = this.getTestDirfile().toPath().resolve("broker.xml");
        URL url1 = RedeployTest.class.getClassLoader().getResource("reload-security-settings.xml");
        URL url2 = RedeployTest.class.getClassLoader().getResource("reload-security-settings-updated.xml");
        Files.copy(url1.openStream(), brokerXML, new CopyOption[0]);
        EmbeddedActiveMQ embeddedActiveMQ = new EmbeddedActiveMQ();
        embeddedActiveMQ.setConfigResourcePath(brokerXML.toUri().toString());
        embeddedActiveMQ.start();
        ReusableLatch latch = new ReusableLatch(1);
        Runnable tick = () -> ((ReusableLatch)latch).countDown();
        embeddedActiveMQ.getActiveMQServer().getReloadManager().setTick(tick);
        try {
            latch.await(10L, TimeUnit.SECONDS);
            Set roles = (Set)embeddedActiveMQ.getActiveMQServer().getSecurityRepository().getMatch("foo");
            boolean found = false;
            for (Role role : roles) {
                if (!role.getName().equals("a")) continue;
                found = true;
            }
            Assertions.assertTrue((boolean)found);
            Files.copy(url2.openStream(), brokerXML, StandardCopyOption.REPLACE_EXISTING);
            brokerXML.toFile().setLastModified(System.currentTimeMillis() + 1000L);
            latch.setCount(1);
            embeddedActiveMQ.getActiveMQServer().getReloadManager().setTick(tick);
            latch.await(10L, TimeUnit.SECONDS);
            roles = (Set)embeddedActiveMQ.getActiveMQServer().getSecurityRepository().getMatch("foo");
            found = false;
            for (Role role : roles) {
                if (!role.getName().equals("b") || !CheckType.VIEW.hasRole(role)) continue;
                found = true;
            }
            Assertions.assertTrue((boolean)found);
        }
        finally {
            embeddedActiveMQ.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRedeploySecuritySettingsWithManagementChange() throws Exception {
        Path brokerXML = this.getTestDirfile().toPath().resolve("broker.xml");
        URL url1 = RedeployTest.class.getClassLoader().getResource("reload-security-settings.xml");
        URL url2 = RedeployTest.class.getClassLoader().getResource("reload-security-settings-updated.xml");
        Files.copy(url1.openStream(), brokerXML, new CopyOption[0]);
        EmbeddedActiveMQ embeddedActiveMQ = new EmbeddedActiveMQ();
        embeddedActiveMQ.setConfigResourcePath(brokerXML.toUri().toString());
        embeddedActiveMQ.start();
        ReusableLatch latch = new ReusableLatch(1);
        Runnable tick = () -> ((ReusableLatch)latch).countDown();
        embeddedActiveMQ.getActiveMQServer().getReloadManager().setTick(tick);
        try {
            latch.await(10L, TimeUnit.SECONDS);
            Set roles = (Set)embeddedActiveMQ.getActiveMQServer().getSecurityRepository().getMatch("foo");
            boolean found = false;
            for (Role role : roles) {
                if (!role.getName().equals("a")) continue;
                found = true;
            }
            Assertions.assertTrue((boolean)found);
            embeddedActiveMQ.getActiveMQServer().getActiveMQServerControl().addSecuritySettings("bar", "c", "c", "c", "c", "c", "c", "c", "c", "c", "c", "", "");
            roles = (Set)embeddedActiveMQ.getActiveMQServer().getSecurityRepository().getMatch("bar");
            for (Role role : roles) {
                if (!role.getName().equals("c")) continue;
                found = true;
            }
            Assertions.assertTrue((boolean)found);
            Files.copy(url2.openStream(), brokerXML, StandardCopyOption.REPLACE_EXISTING);
            brokerXML.toFile().setLastModified(System.currentTimeMillis() + 1000L);
            latch.setCount(1);
            embeddedActiveMQ.getActiveMQServer().getReloadManager().setTick(tick);
            latch.await(10L, TimeUnit.SECONDS);
            roles = (Set)embeddedActiveMQ.getActiveMQServer().getSecurityRepository().getMatch("foo");
            found = false;
            for (Role role : roles) {
                if (!role.getName().equals("b")) continue;
                found = true;
            }
            Assertions.assertTrue((boolean)found);
            roles = (Set)embeddedActiveMQ.getActiveMQServer().getSecurityRepository().getMatch("bar");
            found = false;
            for (Role role : roles) {
                if (!role.getName().equals("c")) continue;
                found = true;
            }
            Assertions.assertTrue((boolean)found);
        }
        finally {
            embeddedActiveMQ.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRedeployAddressSettingsWithManagementChange() throws Exception {
        Path brokerXML = this.getTestDirfile().toPath().resolve("broker.xml");
        URL url1 = RedeployTest.class.getClassLoader().getResource("reload-address-settings.xml");
        URL url2 = RedeployTest.class.getClassLoader().getResource("reload-address-settings-updated.xml");
        Files.copy(url1.openStream(), brokerXML, new CopyOption[0]);
        EmbeddedActiveMQ embeddedActiveMQ = new EmbeddedActiveMQ();
        embeddedActiveMQ.setConfigResourcePath(brokerXML.toUri().toString());
        embeddedActiveMQ.start();
        ReusableLatch latch = new ReusableLatch(1);
        Runnable tick = () -> ((ReusableLatch)latch).countDown();
        embeddedActiveMQ.getActiveMQServer().getReloadManager().setTick(tick);
        try {
            latch.await(10L, TimeUnit.SECONDS);
            AddressSettings addressSettings = (AddressSettings)embeddedActiveMQ.getActiveMQServer().getAddressSettingsRepository().getMatch("foo");
            Assertions.assertEquals((Object)"a", (Object)addressSettings.getDeadLetterAddress().toString());
            AddressSettings settings = new AddressSettings();
            settings.setDeadLetterAddress(SimpleString.of((String)"c")).setExpiryDelay(Long.valueOf(0L));
            embeddedActiveMQ.getActiveMQServer().getActiveMQServerControl().addAddressSettings("bar", settings.toJSON());
            addressSettings = (AddressSettings)embeddedActiveMQ.getActiveMQServer().getAddressSettingsRepository().getMatch("bar");
            Assertions.assertEquals((Object)"c", (Object)addressSettings.getDeadLetterAddress().toString());
            Files.copy(url2.openStream(), brokerXML, StandardCopyOption.REPLACE_EXISTING);
            brokerXML.toFile().setLastModified(System.currentTimeMillis() + 1000L);
            latch.setCount(1);
            embeddedActiveMQ.getActiveMQServer().getReloadManager().setTick(tick);
            latch.await(10L, TimeUnit.SECONDS);
            addressSettings = (AddressSettings)embeddedActiveMQ.getActiveMQServer().getAddressSettingsRepository().getMatch("foo");
            Assertions.assertEquals((Object)"b", (Object)addressSettings.getDeadLetterAddress().toString());
            addressSettings = (AddressSettings)embeddedActiveMQ.getActiveMQServer().getAddressSettingsRepository().getMatch("bar");
            Assertions.assertEquals((Object)"c", (Object)addressSettings.getDeadLetterAddress().toString());
        }
        finally {
            embeddedActiveMQ.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRedeployDivertsWithManagementChange() throws Exception {
        Path brokerXML = this.getTestDirfile().toPath().resolve("broker.xml");
        URL url1 = RedeployTest.class.getClassLoader().getResource("reload-diverts.xml");
        URL url2 = RedeployTest.class.getClassLoader().getResource("reload-diverts-updated.xml");
        Files.copy(url1.openStream(), brokerXML, new CopyOption[0]);
        EmbeddedActiveMQ embeddedActiveMQ = new EmbeddedActiveMQ();
        embeddedActiveMQ.setConfigResourcePath(brokerXML.toUri().toString());
        embeddedActiveMQ.start();
        ReusableLatch latch = new ReusableLatch(1);
        Runnable tick = () -> ((ReusableLatch)latch).countDown();
        embeddedActiveMQ.getActiveMQServer().getReloadManager().setTick(tick);
        try {
            latch.await(10L, TimeUnit.SECONDS);
            DivertBinding divertBinding = (DivertBinding)embeddedActiveMQ.getActiveMQServer().getPostOffice().getBinding(SimpleString.of((String)"a"));
            Assertions.assertNotNull((Object)divertBinding);
            Assertions.assertEquals((Object)"a", (Object)divertBinding.getDivert().getAddress().toString());
            embeddedActiveMQ.getActiveMQServer().getActiveMQServerControl().createDivert("c", "c", "c", "target", false, null, null);
            Files.copy(url2.openStream(), brokerXML, StandardCopyOption.REPLACE_EXISTING);
            brokerXML.toFile().setLastModified(System.currentTimeMillis() + 1000L);
            latch.setCount(1);
            embeddedActiveMQ.getActiveMQServer().getReloadManager().setTick(tick);
            latch.await(10L, TimeUnit.SECONDS);
            divertBinding = (DivertBinding)embeddedActiveMQ.getActiveMQServer().getPostOffice().getBinding(SimpleString.of((String)"b"));
            Assertions.assertNotNull((Object)divertBinding);
            Assertions.assertEquals((Object)"b", (Object)divertBinding.getDivert().getAddress().toString());
            divertBinding = (DivertBinding)embeddedActiveMQ.getActiveMQServer().getPostOffice().getBinding(SimpleString.of((String)"c"));
            Assertions.assertNotNull((Object)divertBinding);
            Assertions.assertEquals((Object)"c", (Object)divertBinding.getDivert().getAddress().toString());
        }
        finally {
            embeddedActiveMQ.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRedeployFilter() throws Exception {
        Path brokerXML = this.getTestDirfile().toPath().resolve("broker.xml");
        URL url1 = RedeployTest.class.getClassLoader().getResource("reload-queue-filter.xml");
        URL url2 = RedeployTest.class.getClassLoader().getResource("reload-queue-filter-updated.xml");
        Files.copy(url1.openStream(), brokerXML, new CopyOption[0]);
        EmbeddedActiveMQ embeddedActiveMQ = new EmbeddedActiveMQ();
        embeddedActiveMQ.setConfigResourcePath(brokerXML.toUri().toString());
        embeddedActiveMQ.start();
        ReusableLatch latch = new ReusableLatch(1);
        Runnable tick = () -> ((ReusableLatch)latch).countDown();
        embeddedActiveMQ.getActiveMQServer().getReloadManager().setTick(tick);
        try {
            Message message;
            jakarta.jms.Queue queue;
            Session session;
            Connection connection;
            MessageConsumer consumer;
            Message message2;
            MessageProducer producer;
            jakarta.jms.Queue queue2;
            Session session2;
            Connection connection2;
            latch.await(10L, TimeUnit.SECONDS);
            try (ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory();){
                connection2 = factory.createConnection();
                try {
                    session2 = connection2.createSession(1);
                    try {
                        connection2.start();
                        queue2 = session2.createQueue("myFilterQueue");
                        producer = session2.createProducer((Destination)queue2);
                        message2 = session2.createMessage();
                        message2.setStringProperty("x", "x");
                        producer.send(message2);
                        consumer = session2.createConsumer((Destination)queue2);
                        Assertions.assertNotNull((Object)consumer.receive(5000L));
                        consumer.close();
                    }
                    finally {
                        if (session2 != null) {
                            session2.close();
                        }
                    }
                }
                finally {
                    if (connection2 != null) {
                        connection2.close();
                    }
                }
            }
            factory = new ActiveMQConnectionFactory();
            try {
                connection2 = factory.createConnection();
                try {
                    session2 = connection2.createSession(1);
                    try {
                        connection2.start();
                        queue2 = session2.createQueue("myFilterQueue");
                        producer = session2.createProducer((Destination)queue2);
                        message2 = session2.createTextMessage("hello");
                        message2.setStringProperty("x", "x");
                        producer.send(message2);
                    }
                    finally {
                        if (session2 != null) {
                            session2.close();
                        }
                    }
                }
                finally {
                    if (connection2 != null) {
                        connection2.close();
                    }
                }
            }
            finally {
                factory.close();
            }
            Binding binding = embeddedActiveMQ.getActiveMQServer().getPostOffice().getBinding(SimpleString.of((String)"myFilterQueue"));
            Files.copy(url2.openStream(), brokerXML, StandardCopyOption.REPLACE_EXISTING);
            brokerXML.toFile().setLastModified(System.currentTimeMillis() + 1000L);
            latch.setCount(1);
            embeddedActiveMQ.getActiveMQServer().getReloadManager().setTick(tick);
            latch.await(10L, TimeUnit.SECONDS);
            Binding bindingAfterChange = embeddedActiveMQ.getActiveMQServer().getPostOffice().getBinding(SimpleString.of((String)"myFilterQueue"));
            Assertions.assertTrue((binding == bindingAfterChange ? (byte)1 : 0) != 0, (String)"Instance should be the same (as should be non destructive)");
            Assertions.assertEquals((Long)binding.getID(), (Long)bindingAfterChange.getID());
            try (ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory();){
                connection = factory.createConnection();
                try {
                    session = connection.createSession(1);
                    try {
                        connection.start();
                        queue = session.createQueue("myFilterQueue");
                        consumer = session.createConsumer((Destination)queue);
                        message = consumer.receive(5000L);
                        Assertions.assertNotNull((Object)message);
                        Assertions.assertEquals((Object)"hello", (Object)((TextMessage)message).getText());
                        consumer.close();
                    }
                    finally {
                        if (session != null) {
                            session.close();
                        }
                    }
                }
                finally {
                    if (connection != null) {
                        connection.close();
                    }
                }
            }
            factory = new ActiveMQConnectionFactory();
            try {
                connection = factory.createConnection();
                try {
                    session = connection.createSession(1);
                    try {
                        connection.start();
                        queue = session.createQueue("myFilterQueue");
                        MessageProducer producer2 = session.createProducer((Destination)queue);
                        message = session.createMessage();
                        message.setStringProperty("x", "y");
                        producer2.send(message);
                        MessageConsumer consumer2 = session.createConsumer((Destination)queue);
                        Assertions.assertNotNull((Object)consumer2.receive(2000L));
                        consumer2.close();
                    }
                    finally {
                        if (session != null) {
                            session.close();
                        }
                    }
                }
                finally {
                    if (connection != null) {
                        connection.close();
                    }
                }
            }
            finally {
                factory.close();
            }
        }
        finally {
            embeddedActiveMQ.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRedeployBridge() throws Exception {
        Path brokerXML = this.getTestDirfile().toPath().resolve("broker.xml");
        URL url1 = RedeployTest.class.getClassLoader().getResource("reload-bridge.xml");
        URL url2 = RedeployTest.class.getClassLoader().getResource("reload-bridge-updated.xml");
        Files.copy(url1.openStream(), brokerXML, new CopyOption[0]);
        EmbeddedActiveMQ embeddedActiveMQ = new EmbeddedActiveMQ();
        embeddedActiveMQ.setConfigResourcePath(brokerXML.toUri().toString());
        embeddedActiveMQ.start();
        ReusableLatch latch = new ReusableLatch(1);
        Runnable tick = () -> ((ReusableLatch)latch).countDown();
        embeddedActiveMQ.getActiveMQServer().getReloadManager().setTick(tick);
        try {
            MessageProducer producer;
            jakarta.jms.Queue queue;
            Session session;
            Connection connection;
            latch.await(10L, TimeUnit.SECONDS);
            try (ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory();){
                connection = factory.createConnection();
                try {
                    session = connection.createSession(1);
                    try {
                        queue = session.createQueue("a-from");
                        producer = session.createProducer((Destination)queue);
                        producer.send(session.createMessage());
                        Wait.assertEquals((long)1L, () -> embeddedActiveMQ.getActiveMQServer().locateQueue("a-to").getMessageCount());
                        Wait.assertEquals((int)3, () -> embeddedActiveMQ.getActiveMQServer().locateQueue("a-from").getConsumerCount());
                    }
                    finally {
                        if (session != null) {
                            session.close();
                        }
                    }
                }
                finally {
                    if (connection != null) {
                        connection.close();
                    }
                }
            }
            factory = new ActiveMQConnectionFactory();
            try {
                connection = factory.createConnection();
                try {
                    session = connection.createSession(1);
                    try {
                        queue = session.createQueue("b-from");
                        producer = session.createProducer((Destination)queue);
                        producer.send(session.createMessage());
                        Wait.assertEquals((long)1L, () -> embeddedActiveMQ.getActiveMQServer().locateQueue("b-to").getMessageCount());
                    }
                    finally {
                        if (session != null) {
                            session.close();
                        }
                    }
                }
                finally {
                    if (connection != null) {
                        connection.close();
                    }
                }
            }
            finally {
                factory.close();
            }
            Files.copy(url2.openStream(), brokerXML, StandardCopyOption.REPLACE_EXISTING);
            brokerXML.toFile().setLastModified(System.currentTimeMillis() + 1000L);
            latch.setCount(1);
            embeddedActiveMQ.getActiveMQServer().getReloadManager().setTick(tick);
            latch.await(10L, TimeUnit.SECONDS);
            factory = new ActiveMQConnectionFactory();
            try {
                connection = factory.createConnection();
                try {
                    session = connection.createSession(1);
                    try {
                        queue = session.createQueue("a-from");
                        producer = session.createProducer((Destination)queue);
                        producer.send(session.createMessage());
                        Wait.assertEquals((long)1L, () -> embeddedActiveMQ.getActiveMQServer().locateQueue("a-new").getMessageCount());
                        Wait.assertEquals((long)1L, () -> embeddedActiveMQ.getActiveMQServer().locateQueue("a-to").getMessageCount());
                        Wait.assertEquals((int)2, () -> embeddedActiveMQ.getActiveMQServer().locateQueue("a-from").getConsumerCount());
                    }
                    finally {
                        if (session != null) {
                            session.close();
                        }
                    }
                }
                finally {
                    if (connection != null) {
                        connection.close();
                    }
                }
            }
            finally {
                factory.close();
            }
            factory = new ActiveMQConnectionFactory();
            try {
                connection = factory.createConnection();
                try {
                    session = connection.createSession(1);
                    try {
                        queue = session.createQueue("b-from");
                        producer = session.createProducer((Destination)queue);
                        producer.send(session.createMessage());
                        Assertions.assertFalse((boolean)Wait.waitFor(() -> embeddedActiveMQ.getActiveMQServer().locateQueue("b-to").getMessageCount() == 2L, (long)2000L, (long)100L));
                    }
                    finally {
                        if (session != null) {
                            session.close();
                        }
                    }
                }
                finally {
                    if (connection != null) {
                        connection.close();
                    }
                }
            }
            finally {
                factory.close();
            }
            factory = new ActiveMQConnectionFactory();
            try {
                connection = factory.createConnection();
                try {
                    session = connection.createSession(1);
                    try {
                        queue = session.createQueue("c-from");
                        producer = session.createProducer((Destination)queue);
                        producer.send(session.createMessage());
                        Wait.assertEquals((long)1L, () -> embeddedActiveMQ.getActiveMQServer().locateQueue("c-to").getMessageCount());
                    }
                    finally {
                        if (session != null) {
                            session.close();
                        }
                    }
                }
                finally {
                    if (connection != null) {
                        connection.close();
                    }
                }
            }
            finally {
                factory.close();
            }
        }
        finally {
            embeddedActiveMQ.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deployBrokerConfig(EmbeddedActiveMQ server, String configFileName) throws Exception {
        Path brokerXML = this.getTestDirfile().toPath().resolve("broker.xml");
        ReloadManager reloadManager = server.getActiveMQServer().getReloadManager();
        boolean reloadManagerOriginallyStarted = reloadManager.isStarted();
        try {
            reloadManager.stop();
            URL configFile = RedeployTest.class.getClassLoader().getResource(configFileName);
            Assertions.assertNotNull((Object)configFile);
            try (InputStream configStream = configFile.openStream();){
                Files.copy(configStream, brokerXML, StandardCopyOption.REPLACE_EXISTING);
            }
            server.getActiveMQServer().reloadConfigurationFile();
        }
        finally {
            if (reloadManagerOriginallyStarted) {
                reloadManager.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTestQueueRemoveFilter(String testConfigurationFileName) throws Exception {
        EmbeddedActiveMQ embeddedActiveMQ = this.createEmbeddedActiveMQServer("reload-queue-filter.xml");
        try {
            MessageConsumer consumer;
            MessageProducer producer;
            LocalQueueBinding queueBinding;
            jakarta.jms.Queue queue;
            Session session;
            Connection connection;
            try (ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory();){
                connection = factory.createConnection();
                try {
                    session = connection.createSession(1);
                    try {
                        connection.start();
                        queue = session.createQueue("myFilterQueue");
                        queueBinding = (LocalQueueBinding)embeddedActiveMQ.getActiveMQServer().getPostOffice().getBinding(SimpleString.of((String)"myFilterQueue"));
                        Assertions.assertEquals((Object)"x = 'x'", (Object)queueBinding.getFilter().getFilterString().toString());
                        producer = session.createProducer((Destination)queue);
                        Message passingMessage = session.createMessage();
                        passingMessage.setStringProperty("x", "x");
                        producer.send(passingMessage);
                        Message filteredMessage = session.createMessage();
                        filteredMessage.setStringProperty("x", "y");
                        producer.send(filteredMessage);
                        consumer = session.createConsumer((Destination)queue);
                        Message receivedMessage = consumer.receive(2000L);
                        Assertions.assertNotNull((Object)receivedMessage);
                        Assertions.assertEquals((Object)"x", (Object)receivedMessage.getStringProperty("x"));
                        Assertions.assertNull((Object)consumer.receive(2000L));
                        consumer.close();
                    }
                    finally {
                        if (session != null) {
                            session.close();
                        }
                    }
                }
                finally {
                    if (connection != null) {
                        connection.close();
                    }
                }
            }
            this.deployBrokerConfig(embeddedActiveMQ, testConfigurationFileName);
            factory = new ActiveMQConnectionFactory();
            try {
                connection = factory.createConnection();
                try {
                    session = connection.createSession(1);
                    try {
                        connection.start();
                        queue = session.createQueue("myFilterQueue");
                        queueBinding = (LocalQueueBinding)embeddedActiveMQ.getActiveMQServer().getPostOffice().getBinding(SimpleString.of((String)"myFilterQueue"));
                        Assertions.assertNull((Object)queueBinding.getFilter());
                        producer = session.createProducer((Destination)queue);
                        Message message1 = session.createMessage();
                        message1.setStringProperty("x", "x");
                        producer.send(message1);
                        Message message2 = session.createMessage();
                        message2.setStringProperty("x", "y");
                        producer.send(message2);
                        consumer = session.createConsumer((Destination)queue);
                        Assertions.assertNotNull((Object)consumer.receive(2000L));
                        Assertions.assertNotNull((Object)consumer.receive(2000L));
                        consumer.close();
                    }
                    finally {
                        if (session != null) {
                            session.close();
                        }
                    }
                }
                finally {
                    if (connection != null) {
                        connection.close();
                    }
                }
            }
            finally {
                factory.close();
            }
        }
        finally {
            embeddedActiveMQ.stop();
        }
    }

    @Test
    public void testRedeployRemoveQueueFilter() throws Exception {
        this.doTestQueueRemoveFilter("reload-queue-filter-updated-empty.xml");
        this.doTestQueueRemoveFilter("reload-queue-filter-removed.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQueuePartialReconfiguration() throws Exception {
        EmbeddedActiveMQ embeddedActiveMQ = this.createEmbeddedActiveMQServer("reload-empty.xml");
        try {
            embeddedActiveMQ.getActiveMQServer().createQueue(QueueConfiguration.of((String)"virtualQueue").setUser("bob"));
            embeddedActiveMQ.getActiveMQServer().updateQueue(QueueConfiguration.of((String)"virtualQueue").setFilterString("foo"));
            LocalQueueBinding queueBinding = (LocalQueueBinding)embeddedActiveMQ.getActiveMQServer().getPostOffice().getBinding(SimpleString.of((String)"virtualQueue"));
            Queue queue = queueBinding.getQueue();
            Assertions.assertEquals((Object)SimpleString.of((String)"bob"), (Object)queue.getUser());
            Assertions.assertEquals((Object)SimpleString.of((String)"foo"), (Object)queue.getFilter().getFilterString());
        }
        finally {
            embeddedActiveMQ.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRedeployQueueDefaults() throws Exception {
        EmbeddedActiveMQ embeddedActiveMQ = this.createEmbeddedActiveMQServer("reload-queue-defaults-before.xml");
        try {
            LocalQueueBinding queueBinding = (LocalQueueBinding)embeddedActiveMQ.getActiveMQServer().getPostOffice().getBinding(SimpleString.of((String)"myQueue"));
            Queue queue = queueBinding.getQueue();
            Assertions.assertNotEquals((int)ActiveMQDefaultConfiguration.getDefaultMaxQueueConsumers(), (int)queue.getMaxConsumers());
            Assertions.assertNotEquals((Object)RoutingType.MULTICAST, (Object)queue.getRoutingType());
            Assertions.assertNotEquals((Object)ActiveMQDefaultConfiguration.getDefaultPurgeOnNoConsumers(), (Object)queue.isPurgeOnNoConsumers());
            Assertions.assertNotEquals((Object)ActiveMQDefaultConfiguration.getDefaultEnabled(), (Object)queue.isEnabled());
            Assertions.assertNotEquals((Object)ActiveMQDefaultConfiguration.getDefaultExclusive(), (Object)queue.isExclusive());
            Assertions.assertNotEquals((Object)ActiveMQDefaultConfiguration.getDefaultGroupRebalance(), (Object)queue.isGroupRebalance());
            Assertions.assertNotEquals((int)ActiveMQDefaultConfiguration.getDefaultGroupBuckets(), (int)queue.getGroupBuckets());
            Assertions.assertNotEquals((Object)ActiveMQDefaultConfiguration.getDefaultGroupFirstKey(), (Object)queue.getGroupFirstKey());
            Assertions.assertNotEquals((Object)ActiveMQDefaultConfiguration.getDefaultNonDestructive(), (Object)queue.isNonDestructive());
            Assertions.assertNotEquals((int)ActiveMQDefaultConfiguration.getDefaultConsumersBeforeDispatch(), (int)queue.getConsumersBeforeDispatch());
            Assertions.assertNotEquals((long)ActiveMQDefaultConfiguration.getDefaultDelayBeforeDispatch(), (long)queue.getDelayBeforeDispatch());
            Assertions.assertNotNull((Object)queue.getFilter());
            Assertions.assertEquals((Object)SimpleString.of((String)"jdoe"), (Object)queue.getUser());
            Assertions.assertNotEquals((long)ActiveMQDefaultConfiguration.getDefaultRingSize(), (long)queue.getRingSize());
            this.deployBrokerConfig(embeddedActiveMQ, "reload-queue-defaults-after.xml");
            Assertions.assertEquals((int)ActiveMQDefaultConfiguration.getDefaultMaxQueueConsumers(), (int)queue.getMaxConsumers());
            Assertions.assertEquals((Object)RoutingType.MULTICAST, (Object)queue.getRoutingType());
            Assertions.assertEquals((Object)ActiveMQDefaultConfiguration.getDefaultPurgeOnNoConsumers(), (Object)queue.isPurgeOnNoConsumers());
            Assertions.assertEquals((Object)ActiveMQDefaultConfiguration.getDefaultEnabled(), (Object)queue.isEnabled());
            Assertions.assertEquals((Object)ActiveMQDefaultConfiguration.getDefaultExclusive(), (Object)queue.isExclusive());
            Assertions.assertEquals((Object)ActiveMQDefaultConfiguration.getDefaultGroupRebalance(), (Object)queue.isGroupRebalance());
            Assertions.assertEquals((int)ActiveMQDefaultConfiguration.getDefaultGroupBuckets(), (int)queue.getGroupBuckets());
            Assertions.assertEquals((Object)ActiveMQDefaultConfiguration.getDefaultGroupFirstKey(), (Object)queue.getGroupFirstKey());
            Assertions.assertEquals((Object)ActiveMQDefaultConfiguration.getDefaultNonDestructive(), (Object)queue.isNonDestructive());
            Assertions.assertEquals((int)ActiveMQDefaultConfiguration.getDefaultConsumersBeforeDispatch(), (int)queue.getConsumersBeforeDispatch());
            Assertions.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultDelayBeforeDispatch(), (long)queue.getDelayBeforeDispatch());
            Assertions.assertNull((Object)queue.getFilter());
            Assertions.assertNull((Object)queue.getUser());
            Assertions.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultRingSize(), (long)queue.getRingSize());
        }
        finally {
            embeddedActiveMQ.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUndeployDivert() throws Exception {
        EmbeddedActiveMQ embeddedActiveMQ = this.createEmbeddedActiveMQServer("reload-divert-undeploy-before.xml");
        try {
            TextMessage message;
            MessageConsumer targetConsumer;
            MessageConsumer sourceConsumer;
            MessageProducer sourceProducer;
            Session session;
            Connection connection;
            DivertBinding divertBinding = (DivertBinding)embeddedActiveMQ.getActiveMQServer().getPostOffice().getBinding(SimpleString.of((String)"divert"));
            Assertions.assertNotNull((Object)divertBinding);
            jakarta.jms.Queue sourceQueue = (jakarta.jms.Queue)ActiveMQDestination.createDestination((String)"queue://source", (ActiveMQDestination.TYPE)ActiveMQDestination.TYPE.QUEUE);
            jakarta.jms.Queue targetQueue = (jakarta.jms.Queue)ActiveMQDestination.createDestination((String)"queue://target", (ActiveMQDestination.TYPE)ActiveMQDestination.TYPE.QUEUE);
            try (ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory();){
                connection = factory.createConnection();
                try {
                    session = connection.createSession(1);
                    try {
                        sourceProducer = session.createProducer((Destination)sourceQueue);
                        try {
                            sourceConsumer = session.createConsumer((Destination)sourceQueue);
                            try {
                                targetConsumer = session.createConsumer((Destination)targetQueue);
                                try {
                                    connection.start();
                                    message = session.createTextMessage("Hello world");
                                    sourceProducer.send((Message)message);
                                    Assertions.assertNotNull((Object)sourceConsumer.receive(2000L));
                                    Assertions.assertNotNull((Object)targetConsumer.receive(2000L));
                                }
                                finally {
                                    if (targetConsumer != null) {
                                        targetConsumer.close();
                                    }
                                }
                            }
                            finally {
                                if (sourceConsumer != null) {
                                    sourceConsumer.close();
                                }
                            }
                        }
                        finally {
                            if (sourceProducer != null) {
                                sourceProducer.close();
                            }
                        }
                    }
                    finally {
                        if (session != null) {
                            session.close();
                        }
                    }
                }
                finally {
                    if (connection != null) {
                        connection.close();
                    }
                }
            }
            this.deployBrokerConfig(embeddedActiveMQ, "reload-divert-undeploy-after.xml");
            Wait.waitFor(() -> embeddedActiveMQ.getActiveMQServer().getPostOffice().getBinding(SimpleString.of((String)"divert")) == null);
            divertBinding = (DivertBinding)embeddedActiveMQ.getActiveMQServer().getPostOffice().getBinding(SimpleString.of((String)"divert"));
            Assertions.assertNull((Object)divertBinding);
            factory = new ActiveMQConnectionFactory();
            try {
                connection = factory.createConnection();
                try {
                    session = connection.createSession(1);
                    try {
                        sourceProducer = session.createProducer((Destination)sourceQueue);
                        try {
                            sourceConsumer = session.createConsumer((Destination)sourceQueue);
                            try {
                                targetConsumer = session.createConsumer((Destination)targetQueue);
                                try {
                                    connection.start();
                                    message = session.createTextMessage("Hello world");
                                    sourceProducer.send((Message)message);
                                    Assertions.assertNotNull((Object)sourceConsumer.receive(2000L));
                                    Assertions.assertNull((Object)targetConsumer.receiveNoWait());
                                }
                                finally {
                                    if (targetConsumer != null) {
                                        targetConsumer.close();
                                    }
                                }
                            }
                            finally {
                                if (sourceConsumer != null) {
                                    sourceConsumer.close();
                                }
                            }
                        }
                        finally {
                            if (sourceProducer != null) {
                                sourceProducer.close();
                            }
                        }
                    }
                    finally {
                        if (session != null) {
                            session.close();
                        }
                    }
                }
                finally {
                    if (connection != null) {
                        connection.close();
                    }
                }
            }
            finally {
                factory.close();
            }
        }
        finally {
            embeddedActiveMQ.stop();
        }
    }

    private void sendDivertedTestMessage(jakarta.jms.Queue queue, jakarta.jms.Queue forwardingQueue, boolean shouldReceiveFromQueue, boolean shouldReceiveFromForwardingQueue, Map<String, String> properties) throws JMSException {
        try (ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory();
             Connection connection = factory.createConnection();
             Session session = connection.createSession(1);
             MessageProducer queueProducer = session.createProducer((Destination)queue);
             MessageConsumer queueConsumer = session.createConsumer((Destination)queue);
             MessageConsumer forwardingQueueConsumer = session.createConsumer((Destination)forwardingQueue);){
            connection.start();
            TextMessage message = session.createTextMessage("Hello world");
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                message.setStringProperty(entry.getKey(), entry.getValue());
            }
            queueProducer.send((Message)message);
            Message queueMessage = queueConsumer.receive(2000L);
            Message forwardingQueueMessage = forwardingQueueConsumer.receive(2000L);
            if (shouldReceiveFromQueue) {
                Assertions.assertNotNull((Object)queueMessage, (String)("A message should have been received from the '" + queue.getQueueName() + "' queue."));
            } else {
                Assertions.assertNull((Object)queueMessage, (String)("No message should have been received from the '" + queue.getQueueName() + "' queue."));
            }
            if (shouldReceiveFromForwardingQueue) {
                Assertions.assertNotNull((Object)forwardingQueueMessage, (String)("A message should have been received from the '" + forwardingQueue.getQueueName() + "' forwarding queue."));
            } else {
                Assertions.assertNull((Object)forwardingQueueMessage, (String)("No message should have been received from the '" + forwardingQueue.getQueueName() + "' forwarding queue."));
            }
        }
    }

    private EmbeddedActiveMQ createEmbeddedActiveMQServer(String initialConfigFileName) throws Exception {
        Path brokerXML = this.getTestDirfile().toPath().resolve("broker.xml");
        URL baseConfig = RedeployTest.class.getClassLoader().getResource(initialConfigFileName);
        Assertions.assertNotNull((Object)baseConfig);
        try (InputStream configStream = baseConfig.openStream();){
            Files.copy(configStream, brokerXML, StandardCopyOption.REPLACE_EXISTING);
        }
        EmbeddedActiveMQ embeddedActiveMQ = new EmbeddedActiveMQ();
        embeddedActiveMQ.setConfigResourcePath(brokerXML.toUri().toString());
        embeddedActiveMQ.start();
        this.waitForServerToStart(embeddedActiveMQ.getActiveMQServer());
        return embeddedActiveMQ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddDivertFilter() throws Exception {
        EmbeddedActiveMQ embeddedActiveMQ = this.createEmbeddedActiveMQServer("reload-divert-filter-none.xml");
        SimpleString divertName = SimpleString.of((String)"source-to-target");
        jakarta.jms.Queue sourceQueue = (jakarta.jms.Queue)ActiveMQDestination.createDestination((String)"queue://source", (ActiveMQDestination.TYPE)ActiveMQDestination.TYPE.QUEUE);
        jakarta.jms.Queue targetQueue = (jakarta.jms.Queue)ActiveMQDestination.createDestination((String)"queue://target", (ActiveMQDestination.TYPE)ActiveMQDestination.TYPE.QUEUE);
        Map<String, String> emptyTestMessageProperties = Map.of();
        Map<String, String> testMessagePropertiesXX = Map.of("x", "x");
        try {
            DivertBinding divertBinding = (DivertBinding)embeddedActiveMQ.getActiveMQServer().getPostOffice().getBinding(divertName);
            Assertions.assertNotNull((Object)divertBinding, (String)("Divert '" + divertName + "' binding should exist."));
            Assertions.assertNull((Object)divertBinding.getFilter(), (String)("The divert '" + divertName + "' should have no filter applied at first."));
            Assertions.assertNull((Object)embeddedActiveMQ.getActiveMQServer().getPostOffice().getBinding(SimpleString.of((String)"foo")));
            this.sendDivertedTestMessage(sourceQueue, targetQueue, false, true, emptyTestMessageProperties);
            this.sendDivertedTestMessage(sourceQueue, targetQueue, false, true, testMessagePropertiesXX);
            this.deployBrokerConfig(embeddedActiveMQ, "reload-divert-filter-x-eq-x.xml");
            divertBinding = (DivertBinding)embeddedActiveMQ.getActiveMQServer().getPostOffice().getBinding(divertName);
            Assertions.assertNotNull((Object)divertBinding, (String)("Divert '" + divertName + "' binding should exist."));
            Assertions.assertNotNull((Object)divertBinding.getFilter(), (String)("The divert '" + divertName + "' should have a filter applied after the new configuration is loaded."));
            this.sendDivertedTestMessage(sourceQueue, targetQueue, true, false, emptyTestMessageProperties);
            this.sendDivertedTestMessage(sourceQueue, targetQueue, false, true, testMessagePropertiesXX);
        }
        finally {
            embeddedActiveMQ.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRemoveDivertFilter() throws Exception {
        EmbeddedActiveMQ embeddedActiveMQ = this.createEmbeddedActiveMQServer("reload-divert-filter-x-eq-x.xml");
        SimpleString divertName = SimpleString.of((String)"source-to-target");
        jakarta.jms.Queue sourceQueue = (jakarta.jms.Queue)ActiveMQDestination.createDestination((String)"queue://source", (ActiveMQDestination.TYPE)ActiveMQDestination.TYPE.QUEUE);
        jakarta.jms.Queue targetQueue = (jakarta.jms.Queue)ActiveMQDestination.createDestination((String)"queue://target", (ActiveMQDestination.TYPE)ActiveMQDestination.TYPE.QUEUE);
        Map<String, String> emptyTestMessageProperties = Map.of();
        Map<String, String> testMessagePropertiesXX = Map.of("x", "x");
        try {
            DivertBinding divertBinding = (DivertBinding)embeddedActiveMQ.getActiveMQServer().getPostOffice().getBinding(divertName);
            Assertions.assertNotNull((Object)divertBinding, (String)("Divert '" + divertName + "' binding should exist."));
            Assertions.assertNotNull((Object)divertBinding.getFilter(), (String)("The divert '" + divertName + "' should have a filter applied at first."));
            this.sendDivertedTestMessage(sourceQueue, targetQueue, true, false, emptyTestMessageProperties);
            this.sendDivertedTestMessage(sourceQueue, targetQueue, false, true, testMessagePropertiesXX);
            this.deployBrokerConfig(embeddedActiveMQ, "reload-divert-filter-none.xml");
            divertBinding = (DivertBinding)embeddedActiveMQ.getActiveMQServer().getPostOffice().getBinding(divertName);
            Assertions.assertNotNull((Object)divertBinding, (String)("Divert '" + divertName + "' binding should exist."));
            Assertions.assertNull((Object)divertBinding.getFilter(), (String)("The divert '" + divertName + "' should not have a filter applied after the new configuration is loaded."));
            this.sendDivertedTestMessage(sourceQueue, targetQueue, false, true, emptyTestMessageProperties);
            this.sendDivertedTestMessage(sourceQueue, targetQueue, false, true, testMessagePropertiesXX);
        }
        finally {
            embeddedActiveMQ.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChangeDivertFilter() throws Exception {
        EmbeddedActiveMQ embeddedActiveMQ = this.createEmbeddedActiveMQServer("reload-divert-filter-x-eq-x.xml");
        SimpleString divertName = SimpleString.of((String)"source-to-target");
        jakarta.jms.Queue sourceQueue = (jakarta.jms.Queue)ActiveMQDestination.createDestination((String)"queue://source", (ActiveMQDestination.TYPE)ActiveMQDestination.TYPE.QUEUE);
        jakarta.jms.Queue targetQueue = (jakarta.jms.Queue)ActiveMQDestination.createDestination((String)"queue://target", (ActiveMQDestination.TYPE)ActiveMQDestination.TYPE.QUEUE);
        Map<String, String> testMessagePropertiesXX = Map.of("x", "x");
        Map<String, String> testMessagePropertiesXY = Map.of("x", "y");
        try {
            DivertBinding divertBinding = (DivertBinding)embeddedActiveMQ.getActiveMQServer().getPostOffice().getBinding(divertName);
            Assertions.assertNotNull((Object)divertBinding, (String)("Divert '" + divertName + "' binding should exist."));
            Assertions.assertNotNull((Object)divertBinding.getFilter(), (String)("The divert '" + divertName + "' should have a filter applied after the first configuration file is loaded."));
            this.sendDivertedTestMessage(sourceQueue, targetQueue, false, true, testMessagePropertiesXX);
            this.sendDivertedTestMessage(sourceQueue, targetQueue, true, false, testMessagePropertiesXY);
            this.deployBrokerConfig(embeddedActiveMQ, "reload-divert-filter-x-eq-y.xml");
            divertBinding = (DivertBinding)embeddedActiveMQ.getActiveMQServer().getPostOffice().getBinding(divertName);
            Assertions.assertNotNull((Object)divertBinding, (String)("Divert '" + divertName + "' binding should exist."));
            Assertions.assertNotNull((Object)divertBinding.getFilter(), (String)("The divert '" + divertName + "' should have a filter applied after the second configuration file is loaded."));
            this.sendDivertedTestMessage(sourceQueue, targetQueue, true, false, testMessagePropertiesXX);
            this.sendDivertedTestMessage(sourceQueue, targetQueue, false, true, testMessagePropertiesXY);
        }
        finally {
            embeddedActiveMQ.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChangeDivertExclusivity() throws Exception {
        EmbeddedActiveMQ embeddedActiveMQ = this.createEmbeddedActiveMQServer("reload-divert-exclusive.xml");
        SimpleString divertName = SimpleString.of((String)"source-to-target");
        jakarta.jms.Queue sourceQueue = (jakarta.jms.Queue)ActiveMQDestination.createDestination((String)"queue://source", (ActiveMQDestination.TYPE)ActiveMQDestination.TYPE.QUEUE);
        jakarta.jms.Queue targetQueue = (jakarta.jms.Queue)ActiveMQDestination.createDestination((String)"queue://target", (ActiveMQDestination.TYPE)ActiveMQDestination.TYPE.QUEUE);
        try {
            DivertBinding divertBinding = (DivertBinding)embeddedActiveMQ.getActiveMQServer().getPostOffice().getBinding(divertName);
            Assertions.assertNotNull((Object)divertBinding, (String)("Divert '" + divertName + "' binding should exist."));
            this.sendDivertedTestMessage(sourceQueue, targetQueue, false, true, Map.of());
            this.deployBrokerConfig(embeddedActiveMQ, "reload-divert-non-exclusive.xml");
            this.sendDivertedTestMessage(sourceQueue, targetQueue, true, true, Map.of());
            this.deployBrokerConfig(embeddedActiveMQ, "reload-divert-exclusive.xml");
            this.sendDivertedTestMessage(sourceQueue, targetQueue, false, true, Map.of());
        }
        finally {
            embeddedActiveMQ.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChangeDivertAddress() throws Exception {
        EmbeddedActiveMQ embeddedActiveMQ = this.createEmbeddedActiveMQServer("reload-divert-address-source1.xml");
        SimpleString divertName = SimpleString.of((String)"source-to-target");
        jakarta.jms.Queue sourceQueue1 = (jakarta.jms.Queue)ActiveMQDestination.createDestination((String)"queue://source1", (ActiveMQDestination.TYPE)ActiveMQDestination.TYPE.QUEUE);
        jakarta.jms.Queue sourceQueue2 = (jakarta.jms.Queue)ActiveMQDestination.createDestination((String)"queue://source2", (ActiveMQDestination.TYPE)ActiveMQDestination.TYPE.QUEUE);
        jakarta.jms.Queue targetQueue = (jakarta.jms.Queue)ActiveMQDestination.createDestination((String)"queue://target", (ActiveMQDestination.TYPE)ActiveMQDestination.TYPE.QUEUE);
        try {
            DivertBinding divertBinding = (DivertBinding)embeddedActiveMQ.getActiveMQServer().getPostOffice().getBinding(divertName);
            Assertions.assertNotNull((Object)divertBinding, (String)("Divert '" + divertName + "' binding should exist."));
            Assertions.assertEquals((Object)sourceQueue1.getQueueName(), (Object)divertBinding.getAddress().toString(), (String)("Divert '" + divertName + "' address should be '" + sourceQueue1.getQueueName() + "'."));
            this.sendDivertedTestMessage(sourceQueue1, targetQueue, false, true, Map.of());
            this.sendDivertedTestMessage(sourceQueue2, targetQueue, true, false, Map.of());
            this.deployBrokerConfig(embeddedActiveMQ, "reload-divert-address-source2.xml");
            divertBinding = (DivertBinding)embeddedActiveMQ.getActiveMQServer().getPostOffice().getBinding(divertName);
            Assertions.assertNotNull((Object)divertBinding, (String)("Divert '" + divertName + "' binding should exist."));
            Assertions.assertEquals((Object)sourceQueue2.getQueueName(), (Object)divertBinding.getAddress().toString(), (String)("Divert '" + divertName + "' address should have been updated to '" + sourceQueue2.getQueueName() + "'."));
            this.sendDivertedTestMessage(sourceQueue1, targetQueue, true, false, Map.of());
            this.sendDivertedTestMessage(sourceQueue2, targetQueue, false, true, Map.of());
        }
        finally {
            embeddedActiveMQ.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRedeployWithFailover() throws Exception {
        HashSet<Role> original = new HashSet<Role>();
        original.add(new Role("a", false, true, false, false, false, false, false, false, false, false, false, false));
        HashSet<Role> changed = new HashSet<Role>();
        changed.add(new Role("b", false, true, false, false, false, false, false, false, false, false, false, false));
        EmbeddedActiveMQ primary = new EmbeddedActiveMQ();
        EmbeddedActiveMQ backup = new EmbeddedActiveMQ();
        try {
            MessageProducer producer;
            jakarta.jms.Queue queue;
            Session session;
            System.setProperty("primary-data-dir", this.getTestDirfile().toPath() + "/redeploy-primary-data");
            System.setProperty("backup-data-dir", this.getTestDirfile().toPath() + "/redeploy-backup-data");
            Path primaryBrokerXML = this.getTestDirfile().toPath().resolve("primary.xml");
            Path backupBrokerXML = this.getTestDirfile().toPath().resolve("backup.xml");
            URL url1 = RedeployTest.class.getClassLoader().getResource("reload-primary-original.xml");
            URL url2 = RedeployTest.class.getClassLoader().getResource("reload-primary-changed.xml");
            URL url3 = RedeployTest.class.getClassLoader().getResource("reload-backup-original.xml");
            URL url4 = RedeployTest.class.getClassLoader().getResource("reload-backup-changed.xml");
            Files.copy(url1.openStream(), primaryBrokerXML, new CopyOption[0]);
            Files.copy(url3.openStream(), backupBrokerXML, new CopyOption[0]);
            primary.setConfigResourcePath(primaryBrokerXML.toUri().toString());
            primary.start();
            this.waitForServerToStart(primary.getActiveMQServer());
            backup.setConfigResourcePath(backupBrokerXML.toUri().toString());
            backup.start();
            Assertions.assertTrue((boolean)Wait.waitFor(() -> backup.getActiveMQServer().isReplicaSync(), (long)15000L, (long)200L));
            Assertions.assertEquals((Object)AddressFullMessagePolicy.BLOCK, (Object)((AddressSettings)primary.getActiveMQServer().getAddressSettingsRepository().getMatch("myQueue")).getAddressFullMessagePolicy(), (String)"Test address settings original - primary");
            Assertions.assertEquals((Object)AddressFullMessagePolicy.BLOCK, (Object)((AddressSettings)backup.getActiveMQServer().getAddressSettingsRepository().getMatch("myQueue")).getAddressFullMessagePolicy(), (String)"Test address settings original - backup");
            Assertions.assertEquals(original, (Object)primary.getActiveMQServer().getSecurityRepository().getMatch("myQueue"), (String)"Test security settings original - primary");
            Assertions.assertEquals(original, (Object)backup.getActiveMQServer().getSecurityRepository().getMatch("myQueue"), (String)"Test security settings original - backup");
            ReusableLatch primaryReloadLatch = new ReusableLatch(1);
            Runnable liveTick = () -> primaryReloadLatch.countDown();
            primary.getActiveMQServer().getReloadManager().setTick(liveTick);
            ReusableLatch backupReloadTickLatch = new ReusableLatch(1);
            Runnable backupTick = () -> backupReloadTickLatch.countDown();
            backup.getActiveMQServer().getReloadManager().setTick(backupTick);
            primaryReloadLatch.await(10L, TimeUnit.SECONDS);
            Files.copy(url2.openStream(), primaryBrokerXML, StandardCopyOption.REPLACE_EXISTING);
            primaryBrokerXML.toFile().setLastModified(System.currentTimeMillis() + 1000L);
            primaryReloadLatch.countUp();
            primary.getActiveMQServer().getReloadManager().setTick(liveTick);
            primaryReloadLatch.await(10L, TimeUnit.SECONDS);
            backupReloadTickLatch.await(10L, TimeUnit.SECONDS);
            Files.copy(url4.openStream(), backupBrokerXML, StandardCopyOption.REPLACE_EXISTING);
            backupBrokerXML.toFile().setLastModified(System.currentTimeMillis() + 1000L);
            backupReloadTickLatch.countUp();
            backup.getActiveMQServer().getReloadManager().setTick(backupTick);
            backupReloadTickLatch.await(10L, TimeUnit.SECONDS);
            ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("tcp://127.0.0.1:61616");
            try (Connection connection = factory.createConnection();){
                session = connection.createSession();
                queue = session.createQueue("myQueue2");
                producer = session.createProducer((Destination)queue);
                producer.send((Message)session.createTextMessage("text1"));
            }
            Assertions.assertFalse((boolean)backup.getActiveMQServer().isActive());
            Assertions.assertEquals((Object)AddressFullMessagePolicy.PAGE, (Object)((AddressSettings)primary.getActiveMQServer().getAddressSettingsRepository().getMatch("myQueue")).getAddressFullMessagePolicy(), (String)"Test address settings redeploy - primary");
            Assertions.assertEquals(changed, (Object)primary.getActiveMQServer().getSecurityRepository().getMatch("myQueue"), (String)"Test security settings redeploy - primary");
            primary.stop();
            Assertions.assertTrue((boolean)Wait.waitFor(() -> backup.getActiveMQServer().isActive(), (long)5000L, (long)100L));
            factory = new ActiveMQConnectionFactory("tcp://127.0.0.1:61617");
            connection = factory.createConnection();
            try {
                session = connection.createSession();
                queue = session.createQueue("myQueue2");
                producer = session.createProducer((Destination)queue);
                producer.send((Message)session.createTextMessage("text"));
                connection.start();
                MessageConsumer consumer = session.createConsumer((Destination)session.createQueue("myQueue2"));
                Assertions.assertNotNull((Object)consumer.receive(5000L), (String)"Queue wasn't deployed accordingly");
                Assertions.assertNotNull((Object)consumer.receive(5000L));
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
            Assertions.assertEquals(changed, (Object)backup.getActiveMQServer().getSecurityRepository().getMatch("myQueue"), (String)"Test security settings redeploy - backup");
            Assertions.assertEquals((Object)AddressFullMessagePolicy.PAGE, (Object)((AddressSettings)backup.getActiveMQServer().getAddressSettingsRepository().getMatch("myQueue")).getAddressFullMessagePolicy(), (String)"Test address settings redeploy - backup");
        }
        finally {
            primary.stop();
            backup.stop();
            System.clearProperty("primary-data-dir");
            System.clearProperty("backup-data-dir");
        }
    }

    /*
     * Exception decompiling
     */
    private boolean tryConsume() throws JMSException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRedeployAddressQueue() throws Exception {
        Path brokerXML = this.getTestDirfile().toPath().resolve("broker.xml");
        URL url1 = RedeployTest.class.getClassLoader().getResource("reload-address-queues.xml");
        URL url2 = RedeployTest.class.getClassLoader().getResource("reload-address-queues-updated.xml");
        Files.copy(url1.openStream(), brokerXML, new CopyOption[0]);
        EmbeddedActiveMQ embeddedActiveMQ = new EmbeddedActiveMQ();
        embeddedActiveMQ.setConfigResourcePath(brokerXML.toUri().toString());
        embeddedActiveMQ.start();
        ReusableLatch latch = new ReusableLatch(1);
        Runnable tick = () -> ((ReusableLatch)latch).countDown();
        embeddedActiveMQ.getActiveMQServer().getReloadManager().setTick(tick);
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory();
        try (JMSContext jmsContext = connectionFactory.createContext();){
            jmsContext.createSharedDurableConsumer(jmsContext.createTopic("config_test_consumer_created_queues"), "mySub").receive(100L);
        }
        try {
            latch.await(10L, TimeUnit.SECONDS);
            Assertions.assertTrue((boolean)this.listQueuesNamesForAddress(embeddedActiveMQ, "config_test_consumer_created_queues").contains("mySub"));
            Assertions.assertNotNull((Object)this.getAddressInfo(embeddedActiveMQ, "config_test_address_removal_no_queue"));
            Assertions.assertNotNull((Object)this.getAddressInfo(embeddedActiveMQ, "config_test_address_removal"));
            Assertions.assertNotNull((Object)this.getAddressInfo(embeddedActiveMQ, "config_test_queue_removal"));
            Assertions.assertTrue((boolean)this.listQueuesNamesForAddress(embeddedActiveMQ, "config_test_queue_removal").contains("config_test_queue_removal_queue_1"));
            Assertions.assertTrue((boolean)this.listQueuesNamesForAddress(embeddedActiveMQ, "config_test_queue_removal").contains("config_test_queue_removal_queue_2"));
            Assertions.assertNotNull((Object)this.getAddressInfo(embeddedActiveMQ, "permanent_test_address_removal"));
            Assertions.assertNotNull((Object)this.getAddressInfo(embeddedActiveMQ, "permanent_test_queue_removal"));
            Assertions.assertTrue((boolean)this.listQueuesNamesForAddress(embeddedActiveMQ, "permanent_test_queue_removal").contains("permanent_test_queue_removal_queue_1"));
            Assertions.assertTrue((boolean)this.listQueuesNamesForAddress(embeddedActiveMQ, "permanent_test_queue_removal").contains("permanent_test_queue_removal_queue_2"));
            Assertions.assertNotNull((Object)this.getAddressInfo(embeddedActiveMQ, "config_test_queue_change"));
            Assertions.assertTrue((boolean)this.listQueuesNamesForAddress(embeddedActiveMQ, "config_test_queue_change").contains("config_test_queue_change_queue"));
            Assertions.assertEquals((int)10, (int)this.getQueue(embeddedActiveMQ, "config_test_queue_change_queue").getMaxConsumers());
            Assertions.assertFalse((boolean)this.getQueue(embeddedActiveMQ, "config_test_queue_change_queue").isPurgeOnNoConsumers());
            Files.copy(url2.openStream(), brokerXML, StandardCopyOption.REPLACE_EXISTING);
            brokerXML.toFile().setLastModified(System.currentTimeMillis() + 1000L);
            latch.setCount(1);
            embeddedActiveMQ.getActiveMQServer().getReloadManager().setTick(tick);
            latch.await(10L, TimeUnit.SECONDS);
            Assertions.assertTrue((boolean)this.listQueuesNamesForAddress(embeddedActiveMQ, "config_test_consumer_created_queues").contains("mySub"));
            Assertions.assertNull((Object)this.getAddressInfo(embeddedActiveMQ, "config_test_address_removal_no_queue"));
            Assertions.assertNull((Object)this.getAddressInfo(embeddedActiveMQ, "config_test_address_removal"));
            Assertions.assertNotNull((Object)this.getAddressInfo(embeddedActiveMQ, "config_test_queue_removal"));
            Assertions.assertTrue((boolean)this.listQueuesNamesForAddress(embeddedActiveMQ, "config_test_queue_removal").contains("config_test_queue_removal_queue_1"));
            Assertions.assertFalse((boolean)this.listQueuesNamesForAddress(embeddedActiveMQ, "config_test_queue_removal").contains("config_test_queue_removal_queue_2"));
            Assertions.assertNotNull((Object)this.getAddressInfo(embeddedActiveMQ, "permanent_test_address_removal"));
            Assertions.assertNotNull((Object)this.getAddressInfo(embeddedActiveMQ, "permanent_test_queue_removal"));
            Assertions.assertTrue((boolean)this.listQueuesNamesForAddress(embeddedActiveMQ, "permanent_test_queue_removal").contains("permanent_test_queue_removal_queue_1"));
            Assertions.assertTrue((boolean)this.listQueuesNamesForAddress(embeddedActiveMQ, "permanent_test_queue_removal").contains("permanent_test_queue_removal_queue_2"));
            Assertions.assertNotNull((Object)this.getAddressInfo(embeddedActiveMQ, "config_test_queue_change"));
            Assertions.assertTrue((boolean)this.listQueuesNamesForAddress(embeddedActiveMQ, "config_test_queue_change").contains("config_test_queue_change_queue"));
            Assertions.assertEquals((int)1, (int)this.getQueue(embeddedActiveMQ, "config_test_queue_change_queue").getMaxConsumers());
            Assertions.assertTrue((boolean)this.getQueue(embeddedActiveMQ, "config_test_queue_change_queue").isPurgeOnNoConsumers());
            Assertions.assertNull((Object)this.getAddressInfo(embeddedActiveMQ, "config_test_queue_change_queue"));
            Assertions.assertNull((Object)this.getAddressInfo(embeddedActiveMQ, "config_test_queue_removal_queue_1"));
        }
        finally {
            embeddedActiveMQ.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRedeployChangeQueueRoutingType() throws Exception {
        Path brokerXML = this.getTestDirfile().toPath().resolve("broker.xml");
        URL url1 = RedeployTest.class.getClassLoader().getResource("reload-queue-routingtype.xml");
        URL url2 = RedeployTest.class.getClassLoader().getResource("reload-queue-routingtype-updated.xml");
        Files.copy(url1.openStream(), brokerXML, new CopyOption[0]);
        EmbeddedActiveMQ embeddedActiveMQ = new EmbeddedActiveMQ();
        embeddedActiveMQ.setConfigResourcePath(brokerXML.toUri().toString());
        embeddedActiveMQ.start();
        ReusableLatch latch = new ReusableLatch(1);
        embeddedActiveMQ.getActiveMQServer().getReloadManager().setTick(() -> ((ReusableLatch)latch).countDown());
        try {
            ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("tcp://0.0.0.0:61616");
            try (JMSContext context = connectionFactory.createContext();){
                context.createProducer().send((Destination)context.createQueue("myAddress"), "hello");
            }
            latch.await(10L, TimeUnit.SECONDS);
            Assertions.assertNotNull((Object)this.getAddressInfo(embeddedActiveMQ, "myAddress"));
            Assertions.assertEquals((Object)RoutingType.ANYCAST, (Object)this.getQueue(embeddedActiveMQ, "myQueue").getRoutingType());
            Files.copy(url2.openStream(), brokerXML, StandardCopyOption.REPLACE_EXISTING);
            brokerXML.toFile().setLastModified(System.currentTimeMillis() + 1000L);
            latch.setCount(1);
            embeddedActiveMQ.getActiveMQServer().getReloadManager().setTick(() -> ((ReusableLatch)latch).countDown());
            Assertions.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
            Assertions.assertNotNull((Object)this.getAddressInfo(embeddedActiveMQ, "myAddress"));
            Assertions.assertEquals((Object)RoutingType.MULTICAST, (Object)this.getQueue(embeddedActiveMQ, "myQueue").getRoutingType());
            context = connectionFactory.createContext();
            try {
                Message message = context.createSharedDurableConsumer(context.createTopic("myAddress"), "myQueue").receive();
                Assertions.assertEquals((Object)"hello", (Object)((TextMessage)message).getText());
            }
            finally {
                if (context != null) {
                    context.close();
                }
            }
        }
        finally {
            embeddedActiveMQ.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRedeployChangeAddressQueueRoutingType() throws Exception {
        Path brokerXML = this.getTestDirfile().toPath().resolve("broker.xml");
        URL url1 = RedeployTest.class.getClassLoader().getResource("reload-address-queue-routingtype.xml");
        URL url2 = RedeployTest.class.getClassLoader().getResource("reload-address-queue-routingtype-updated.xml");
        Files.copy(url1.openStream(), brokerXML, new CopyOption[0]);
        EmbeddedActiveMQ embeddedActiveMQ = new EmbeddedActiveMQ();
        embeddedActiveMQ.setConfigResourcePath(brokerXML.toUri().toString());
        embeddedActiveMQ.start();
        ReusableLatch latch = new ReusableLatch(1);
        embeddedActiveMQ.getActiveMQServer().getReloadManager().setTick(() -> ((ReusableLatch)latch).countDown());
        try {
            latch.await(10L, TimeUnit.SECONDS);
            Assertions.assertNotNull((Object)this.getAddressInfo(embeddedActiveMQ, "TEST.QUEUE.0"));
            Assertions.assertTrue((boolean)this.getAddressInfo(embeddedActiveMQ, "TEST.QUEUE.0").getRoutingTypes().contains(RoutingType.ANYCAST));
            Assertions.assertEquals((Object)RoutingType.ANYCAST, (Object)this.getQueue(embeddedActiveMQ, "TEST.QUEUE.0.1").getRoutingType());
            Assertions.assertEquals((Object)RoutingType.ANYCAST, (Object)this.getQueue(embeddedActiveMQ, "TEST.QUEUE.0.2").getRoutingType());
            Assertions.assertEquals((Object)RoutingType.ANYCAST, (Object)this.getQueue(embeddedActiveMQ, "TEST.QUEUE.0.3").getRoutingType());
            Assertions.assertEquals((Object)RoutingType.ANYCAST, (Object)this.getQueue(embeddedActiveMQ, "TEST.QUEUE.0.4").getRoutingType());
            Files.copy(url2.openStream(), brokerXML, StandardCopyOption.REPLACE_EXISTING);
            brokerXML.toFile().setLastModified(System.currentTimeMillis() + 1000L);
            latch.setCount(1);
            embeddedActiveMQ.getActiveMQServer().getReloadManager().setTick(() -> ((ReusableLatch)latch).countDown());
            Assertions.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
            AddressInfo testQueue0AddressInfo = this.getAddressInfo(embeddedActiveMQ, "TEST.QUEUE.0");
            Assertions.assertNotNull((Object)testQueue0AddressInfo);
            Assertions.assertTrue((boolean)testQueue0AddressInfo.getRoutingTypes().contains(RoutingType.ANYCAST));
            Assertions.assertTrue((boolean)testQueue0AddressInfo.getRoutingTypes().contains(RoutingType.MULTICAST));
            Assertions.assertEquals((Object)RoutingType.ANYCAST, (Object)this.getQueue(embeddedActiveMQ, "TEST.QUEUE.0.1").getRoutingType());
            Assertions.assertEquals((Object)RoutingType.MULTICAST, (Object)this.getQueue(embeddedActiveMQ, "TEST.QUEUE.0.2").getRoutingType());
            Assertions.assertNotNull((Object)this.getAddressInfo(embeddedActiveMQ, "TEST.QUEUE.0.3"));
            Assertions.assertTrue((boolean)this.getAddressInfo(embeddedActiveMQ, "TEST.QUEUE.0.3").getRoutingTypes().contains(RoutingType.ANYCAST));
            Assertions.assertEquals((Object)RoutingType.ANYCAST, (Object)this.getQueue(embeddedActiveMQ, "TEST.QUEUE.0.3").getRoutingType());
            Assertions.assertNotNull((Object)this.getAddressInfo(embeddedActiveMQ, "TEST.QUEUE.0.4"));
            Assertions.assertTrue((boolean)this.getAddressInfo(embeddedActiveMQ, "TEST.QUEUE.0.4").getRoutingTypes().contains(RoutingType.MULTICAST));
            Assertions.assertEquals((Object)RoutingType.MULTICAST, (Object)this.getQueue(embeddedActiveMQ, "TEST.QUEUE.0.4").getRoutingType());
        }
        finally {
            embeddedActiveMQ.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRedeployStopAndRestart() throws Exception {
        Path brokerXML = this.getTestDirfile().toPath().resolve("broker.xml");
        URL url1 = RedeployTest.class.getClassLoader().getResource("reload-original.xml");
        URL url2 = RedeployTest.class.getClassLoader().getResource("reload-changed.xml");
        Files.copy(url1.openStream(), brokerXML, new CopyOption[0]);
        EmbeddedActiveMQ embeddedActiveMQ = new EmbeddedActiveMQ();
        embeddedActiveMQ.setConfigResourcePath(brokerXML.toUri().toString());
        embeddedActiveMQ.start();
        ReusableLatch latch = new ReusableLatch(1);
        Runnable tick = () -> ((ReusableLatch)latch).countDown();
        embeddedActiveMQ.getActiveMQServer().getReloadManager().setTick(tick);
        try {
            latch.await(10L, TimeUnit.SECONDS);
            Assertions.assertEquals((int)this.getSecurityRoles(embeddedActiveMQ, "security_address").size(), (int)1);
            Assertions.assertEquals((Object)this.getSecurityRoles(embeddedActiveMQ, "security_address").iterator().next().getName(), (Object)"b");
            Assertions.assertEquals((Object)this.getAddressSettings(embeddedActiveMQ, "address_settings_address").getDeadLetterAddress(), (Object)SimpleString.of((String)"OriginalDLQ"));
            Assertions.assertEquals((Object)this.getAddressSettings(embeddedActiveMQ, "address_settings_address").getExpiryAddress(), (Object)SimpleString.of((String)"OriginalExpiryQueue"));
            Assertions.assertNotNull((Object)this.getAddressInfo(embeddedActiveMQ, "config_test_address_removal_no_queue"));
            Assertions.assertNotNull((Object)this.getAddressInfo(embeddedActiveMQ, "config_test_address_removal"));
            Assertions.assertNotNull((Object)this.getAddressInfo(embeddedActiveMQ, "config_test_queue_removal"));
            Assertions.assertTrue((boolean)this.listQueuesNamesForAddress(embeddedActiveMQ, "config_test_queue_removal").contains("config_test_queue_removal_queue_1"));
            Assertions.assertTrue((boolean)this.listQueuesNamesForAddress(embeddedActiveMQ, "config_test_queue_removal").contains("config_test_queue_removal_queue_2"));
            Assertions.assertNotNull((Object)this.getAddressInfo(embeddedActiveMQ, "config_test_queue_change"));
            Assertions.assertTrue((boolean)this.listQueuesNamesForAddress(embeddedActiveMQ, "config_test_queue_change").contains("config_test_queue_change_queue"));
            Assertions.assertEquals((int)10, (int)this.getQueue(embeddedActiveMQ, "config_test_queue_change_queue").getMaxConsumers());
            Assertions.assertFalse((boolean)this.getQueue(embeddedActiveMQ, "config_test_queue_change_queue").isPurgeOnNoConsumers());
            Assertions.assertTrue((boolean)this.getQueue(embeddedActiveMQ, "config_test_queue_change_queue").isEnabled());
            Assertions.assertTrue((boolean)this.getQueue(embeddedActiveMQ, "config_test_queue_change_queue_defaults").isPurgeOnNoConsumers());
            Assertions.assertFalse((boolean)this.getQueue(embeddedActiveMQ, "config_test_queue_change_queue_defaults").isEnabled());
            Files.copy(url2.openStream(), brokerXML, StandardCopyOption.REPLACE_EXISTING);
            brokerXML.toFile().setLastModified(System.currentTimeMillis() + 1000L);
            latch.setCount(1);
            embeddedActiveMQ.getActiveMQServer().getReloadManager().setTick(tick);
            latch.await(10L, TimeUnit.SECONDS);
            Assertions.assertEquals((int)this.getSecurityRoles(embeddedActiveMQ, "security_address").size(), (int)1);
            Assertions.assertEquals((Object)this.getSecurityRoles(embeddedActiveMQ, "security_address").iterator().next().getName(), (Object)"c");
            Assertions.assertEquals((Object)this.getAddressSettings(embeddedActiveMQ, "address_settings_address").getDeadLetterAddress(), (Object)SimpleString.of((String)"NewDLQ"));
            Assertions.assertEquals((Object)this.getAddressSettings(embeddedActiveMQ, "address_settings_address").getExpiryAddress(), (Object)SimpleString.of((String)"NewExpiryQueue"));
            Assertions.assertNull((Object)this.getAddressInfo(embeddedActiveMQ, "config_test_address_removal_no_queue"));
            Assertions.assertNull((Object)this.getAddressInfo(embeddedActiveMQ, "config_test_address_removal"));
            Assertions.assertNotNull((Object)this.getAddressInfo(embeddedActiveMQ, "config_test_queue_removal"));
            Assertions.assertTrue((boolean)this.listQueuesNamesForAddress(embeddedActiveMQ, "config_test_queue_removal").contains("config_test_queue_removal_queue_1"));
            Assertions.assertFalse((boolean)this.listQueuesNamesForAddress(embeddedActiveMQ, "config_test_queue_removal").contains("config_test_queue_removal_queue_2"));
            Assertions.assertNotNull((Object)this.getAddressInfo(embeddedActiveMQ, "config_test_queue_change"));
            Assertions.assertTrue((boolean)this.listQueuesNamesForAddress(embeddedActiveMQ, "config_test_queue_change").contains("config_test_queue_change_queue"));
            Assertions.assertEquals((int)1, (int)this.getQueue(embeddedActiveMQ, "config_test_queue_change_queue").getMaxConsumers());
            Assertions.assertTrue((boolean)this.getQueue(embeddedActiveMQ, "config_test_queue_change_queue").isPurgeOnNoConsumers());
            Assertions.assertFalse((boolean)this.getQueue(embeddedActiveMQ, "config_test_queue_change_queue").isEnabled());
            Assertions.assertFalse((boolean)this.getQueue(embeddedActiveMQ, "config_test_queue_change_queue_defaults").isPurgeOnNoConsumers());
            Assertions.assertTrue((boolean)this.getQueue(embeddedActiveMQ, "config_test_queue_change_queue_defaults").isEnabled());
        }
        finally {
            embeddedActiveMQ.stop();
        }
        try {
            embeddedActiveMQ.start();
            Assertions.assertEquals((int)this.getSecurityRoles(embeddedActiveMQ, "security_address").size(), (int)1);
            Assertions.assertEquals((Object)this.getSecurityRoles(embeddedActiveMQ, "security_address").iterator().next().getName(), (Object)"c");
            Assertions.assertEquals((Object)this.getAddressSettings(embeddedActiveMQ, "address_settings_address").getDeadLetterAddress(), (Object)SimpleString.of((String)"NewDLQ"));
            Assertions.assertEquals((Object)this.getAddressSettings(embeddedActiveMQ, "address_settings_address").getExpiryAddress(), (Object)SimpleString.of((String)"NewExpiryQueue"));
            Assertions.assertNull((Object)this.getAddressInfo(embeddedActiveMQ, "config_test_address_removal_no_queue"));
            Assertions.assertNull((Object)this.getAddressInfo(embeddedActiveMQ, "config_test_address_removal"));
            Assertions.assertNotNull((Object)this.getAddressInfo(embeddedActiveMQ, "config_test_queue_removal"));
            Assertions.assertTrue((boolean)this.listQueuesNamesForAddress(embeddedActiveMQ, "config_test_queue_removal").contains("config_test_queue_removal_queue_1"));
            Assertions.assertFalse((boolean)this.listQueuesNamesForAddress(embeddedActiveMQ, "config_test_queue_removal").contains("config_test_queue_removal_queue_2"));
            Assertions.assertNotNull((Object)this.getAddressInfo(embeddedActiveMQ, "config_test_queue_change"));
            Assertions.assertTrue((boolean)this.listQueuesNamesForAddress(embeddedActiveMQ, "config_test_queue_change").contains("config_test_queue_change_queue"));
            Assertions.assertEquals((int)1, (int)this.getQueue(embeddedActiveMQ, "config_test_queue_change_queue").getMaxConsumers());
            Assertions.assertTrue((boolean)this.getQueue(embeddedActiveMQ, "config_test_queue_change_queue").isPurgeOnNoConsumers());
            Assertions.assertFalse((boolean)this.getQueue(embeddedActiveMQ, "config_test_queue_change_queue").isEnabled());
            Assertions.assertFalse((boolean)this.getQueue(embeddedActiveMQ, "config_test_queue_change_queue_defaults").isPurgeOnNoConsumers());
            Assertions.assertTrue((boolean)this.getQueue(embeddedActiveMQ, "config_test_queue_change_queue_defaults").isEnabled());
        }
        finally {
            embeddedActiveMQ.stop();
        }
    }

    private AddressSettings getAddressSettings(EmbeddedActiveMQ embeddedActiveMQ, String address) {
        return (AddressSettings)embeddedActiveMQ.getActiveMQServer().getAddressSettingsRepository().getMatch(address);
    }

    private Set<Role> getSecurityRoles(EmbeddedActiveMQ embeddedActiveMQ, String address) {
        return (Set)embeddedActiveMQ.getActiveMQServer().getSecurityRepository().getMatch(address);
    }

    private AddressInfo getAddressInfo(EmbeddedActiveMQ embeddedActiveMQ, String address) {
        return embeddedActiveMQ.getActiveMQServer().getPostOffice().getAddressInfo(SimpleString.of((String)address));
    }

    private Queue getQueue(EmbeddedActiveMQ embeddedActiveMQ, String queueName) throws Exception {
        QueueBinding queueBinding = (QueueBinding)embeddedActiveMQ.getActiveMQServer().getPostOffice().getBinding(SimpleString.of((String)queueName));
        return queueBinding == null ? null : queueBinding.getQueue();
    }

    private List<String> listQueuesNamesForAddress(EmbeddedActiveMQ embeddedActiveMQ, String address) throws Exception {
        return embeddedActiveMQ.getActiveMQServer().getPostOffice().listQueuesForAddress(SimpleString.of((String)address)).stream().map(Queue::getName).map(SimpleString::toString).collect(Collectors.toList());
    }
}

