/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.cluster;

import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.ExceptionListener;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQNotConnectedException;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.api.jms.JMSFactoryType;
import org.apache.activemq.artemis.core.client.impl.ClientSessionInternal;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQSession;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class JMSReconnectTest
extends ActiveMQTestBase {
    private ActiveMQServer server;

    @Test
    public void testReattachSameNode() throws Exception {
        this.testReconnectOrReattachSameNode(true);
    }

    @Test
    public void testReconnectSameNode() throws Exception {
        this.testReconnectOrReattachSameNode(false);
    }

    private void testReconnectOrReattachSameNode(boolean reattach) throws Exception {
        ActiveMQConnectionFactory jbcf = ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(INVM_CONNECTOR_FACTORY)});
        jbcf.setBlockOnDurableSend(true);
        jbcf.setBlockOnNonDurableSend(true);
        jbcf.setReconnectAttempts(-1);
        if (reattach) {
            jbcf.setConfirmationWindowSize(0x100000);
        }
        int numMessages = 10;
        int bodySize = 1000;
        jbcf.setConsumerWindowSize(1000);
        Connection conn = jbcf.createConnection();
        MyExceptionListener listener = new MyExceptionListener();
        conn.setExceptionListener((ExceptionListener)listener);
        Session sess = conn.createSession(false, 1);
        ClientSession coreSession = ((ActiveMQSession)sess).getCoreSession();
        RemotingConnection coreConn = ((ClientSessionInternal)coreSession).getConnection();
        SimpleString jmsQueueName = SimpleString.of((String)"myqueue");
        coreSession.createQueue(QueueConfiguration.of((SimpleString)jmsQueueName).setRoutingType(RoutingType.ANYCAST));
        Queue queue = sess.createQueue("myqueue");
        MessageProducer producer = sess.createProducer((Destination)queue);
        producer.setDeliveryMode(2);
        MessageConsumer consumer = sess.createConsumer((Destination)queue);
        byte[] body = RandomUtil.randomBytes((int)1000);
        for (int i = 0; i < 10; ++i) {
            BytesMessage bm = sess.createBytesMessage();
            bm.writeBytes(body);
            producer.send((Message)bm);
        }
        conn.start();
        Thread.sleep(2000L);
        ActiveMQNotConnectedException me = new ActiveMQNotConnectedException();
        coreConn.fail((ActiveMQException)((Object)me));
        for (int i = 0; i < 10; ++i) {
            BytesMessage bm = (BytesMessage)consumer.receive(1000L);
            Assertions.assertNotNull((Object)bm);
            Assertions.assertEquals((long)body.length, (long)bm.getBodyLength());
        }
        TextMessage tm = (TextMessage)consumer.receiveNoWait();
        Assertions.assertNull((Object)tm);
        conn.close();
        Assertions.assertNotNull((Object)((Object)listener.e));
        Assertions.assertTrue((me == listener.e.getCause() ? 1 : 0) != 0);
    }

    @Test
    public void testReconnectSameNodeServerRestartedWithNonDurableSub() throws Exception {
        this.testReconnectSameNodeServerRestartedWithNonDurableSubOrTempQueue(true);
    }

    @Test
    public void testReconnectSameNodeServerRestartedWithTempQueue() throws Exception {
        this.testReconnectSameNodeServerRestartedWithNonDurableSubOrTempQueue(false);
    }

    private void testReconnectSameNodeServerRestartedWithNonDurableSubOrTempQueue(boolean nonDurableSub) throws Exception {
        BytesMessage bm;
        int i;
        TemporaryQueue dest;
        ActiveMQConnectionFactory jbcf = ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(INVM_CONNECTOR_FACTORY)});
        jbcf.setReconnectAttempts(-1);
        Connection conn = jbcf.createConnection();
        MyExceptionListener listener = new MyExceptionListener();
        conn.setExceptionListener((ExceptionListener)listener);
        Session sess = conn.createSession(false, 1);
        ClientSession coreSession = ((ActiveMQSession)sess).getCoreSession();
        if (nonDurableSub) {
            coreSession.createQueue(QueueConfiguration.of((String)"blahblah").setAddress("mytopic").setDurable(Boolean.valueOf(false)));
            dest = ActiveMQJMSClient.createTopic((String)"mytopic");
        } else {
            dest = sess.createTemporaryQueue();
        }
        MessageProducer producer = sess.createProducer((Destination)dest);
        MessageConsumer consumer = sess.createConsumer((Destination)dest);
        this.server.stop();
        this.server.start();
        Thread.sleep(3000L);
        int numMessages = 100;
        byte[] body = RandomUtil.randomBytes((int)1000);
        for (i = 0; i < 100; ++i) {
            bm = sess.createBytesMessage();
            bm.writeBytes(body);
            producer.send((Message)bm);
        }
        conn.start();
        for (i = 0; i < 100; ++i) {
            bm = (BytesMessage)consumer.receive(1000L);
            Assertions.assertNotNull((Object)bm);
            Assertions.assertEquals((long)body.length, (long)bm.getBodyLength());
        }
        TextMessage tm = (TextMessage)consumer.receiveNoWait();
        Assertions.assertNull((Object)tm);
        conn.close();
        Assertions.assertNotNull((Object)((Object)listener.e));
    }

    @Test
    public void testNoReconnectCloseAfterFailToReconnectWithTopicConsumer() throws Exception {
        ActiveMQConnectionFactory jbcf = ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(INVM_CONNECTOR_FACTORY)});
        jbcf.setReconnectAttempts(0);
        Connection conn = jbcf.createConnection();
        Session sess = conn.createSession(false, 1);
        ClientSession coreSession = ((ActiveMQSession)sess).getCoreSession();
        coreSession.createQueue(QueueConfiguration.of((String)"blahblah").setAddress("mytopic").setDurable(Boolean.valueOf(false)));
        Topic topic = ActiveMQJMSClient.createTopic((String)"mytopic");
        sess.createConsumer((Destination)topic);
        Thread.sleep(2000L);
        this.server.stop();
        this.server.start();
        sess.close();
        conn.close();
    }

    @Test
    public void testNoReconnectCloseAfterFailToReconnectWithTempQueue() throws Exception {
        ActiveMQConnectionFactory jbcf = ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(INVM_CONNECTOR_FACTORY)});
        jbcf.setReconnectAttempts(0);
        Connection conn = jbcf.createConnection();
        Session sess = conn.createSession(false, 1);
        sess.createTemporaryQueue();
        Thread.sleep(2000L);
        this.server.stop();
        this.server.start();
        sess.close();
        conn.close();
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.createDefaultInVMConfig(), (boolean)true));
        this.server.start();
    }

    private static class MyExceptionListener
    implements ExceptionListener {
        volatile JMSException e;

        private MyExceptionListener() {
        }

        public void onException(JMSException e) {
            this.e = e;
        }
    }
}

