/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.multiprotocol;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.jms.multiprotocol.MultiprotocolJMSClientTestSupport;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.utils.CompositeAddress;
import org.apache.activemq.artemis.utils.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMSFQQNConsumerTest
extends MultiprotocolJMSClientTestSupport {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Test
    public void testFQQNTopicConsumerWithSelectorAMQP() throws Exception {
        this.testFQQNTopicConsumerWithSelector("AMQP", true);
    }

    @Test
    public void testFQQNTopicConsumerWithSelectorOpenWire() throws Exception {
        this.testFQQNTopicConsumerWithSelector("OPENWIRE", false);
    }

    @Test
    public void testFQQNTopicConsumerWithSelectorCore() throws Exception {
        this.testFQQNTopicConsumerWithSelector("CORE", true);
    }

    private void testFQQNTopicConsumerWithSelector(String protocol, boolean validateFilterChange) throws Exception {
        Queue serverQueue;
        ConnectionFactory factory = CFUtil.createConnectionFactory(protocol, "tcp://localhost:5672");
        String queue = "queue";
        String address = "address";
        String filter = "prop='match'";
        try (Connection c = factory.createConnection();){
            c.start();
            Session s = c.createSession(false, 1);
            Topic t = s.createTopic(CompositeAddress.toFullyQualified((String)"address", (String)"queue"));
            MessageConsumer mc = s.createConsumer((Destination)t, "prop='match'");
            Wait.assertTrue(() -> this.server.locateQueue("queue") != null, (long)2000L, (long)100L);
            serverQueue = this.server.locateQueue(SimpleString.of((String)"queue"));
            Assertions.assertEquals((Object)RoutingType.MULTICAST, (Object)serverQueue.getRoutingType());
            Assertions.assertNotNull((Object)serverQueue.getFilter());
            Assertions.assertEquals((Object)"prop='match'", (Object)serverQueue.getFilter().getFilterString().toString());
            Assertions.assertEquals((Object)"prop='match'", (Object)this.server.locateQueue("queue").getFilter().getFilterString().toString());
            MessageProducer producer = s.createProducer((Destination)s.createTopic("address"));
            TextMessage message = s.createTextMessage("hello");
            message.setStringProperty("prop", "match");
            producer.send((Message)message);
            Assertions.assertNotNull((Object)mc.receive(5000L));
            message = s.createTextMessage("hello");
            message.setStringProperty("prop", "nomatch");
            producer.send((Message)message);
            if (protocol.equals("OPENWIRE")) {
                Assertions.assertNull((Object)mc.receive(500L));
            } else {
                Assertions.assertNull((Object)mc.receiveNoWait());
            }
        }
        if (validateFilterChange) {
            Topic t;
            Session s;
            Connection c;
            boolean thrownException = false;
            try {
                c = factory.createConnection();
                try {
                    s = c.createSession(false, 1);
                    t = s.createTopic(CompositeAddress.toFullyQualified((String)"address", (String)"queue"));
                    serverQueue = s.createConsumer((Destination)t, "shouldThrowException=true");
                }
                finally {
                    if (c != null) {
                        c.close();
                    }
                }
            }
            catch (Exception e) {
                logger.debug(e.getMessage(), (Throwable)e);
                thrownException = true;
            }
            Assertions.assertTrue((boolean)thrownException);
            c = factory.createConnection();
            try {
                c.start();
                s = c.createSession(false, 1);
                t = s.createTopic(CompositeAddress.toFullyQualified((String)"address", (String)"queue"));
                MessageConsumer mc = s.createConsumer((Destination)t);
                Wait.assertTrue(() -> this.server.locateQueue("queue") != null, (long)2000L, (long)100L);
                Queue serverQueue2 = this.server.locateQueue(SimpleString.of((String)"queue"));
                Wait.assertEquals((int)1, () -> serverQueue2.getConsumers().size());
                serverQueue2.getConsumers().forEach(serverConsumer -> Assertions.assertNull((Object)serverConsumer.getFilter()));
                MessageProducer producer = s.createProducer((Destination)s.createTopic("address"));
                TextMessage message = s.createTextMessage("hello");
                message.setStringProperty("prop", "match");
                producer.send((Message)message);
                Assertions.assertNotNull((Object)mc.receive(5000L));
                message = s.createTextMessage("hello");
                message.setStringProperty("prop", "nomatch");
                producer.send((Message)message);
                if (protocol.equals("OPENWIRE")) {
                    Assertions.assertNull((Object)mc.receive(500L));
                } else {
                    Assertions.assertNull((Object)mc.receiveNoWait());
                }
            }
            finally {
                if (c != null) {
                    c.close();
                }
            }
        }
    }

    @Test
    public void testFQQNTopicFilterConsumerOnlyAMQP() throws Exception {
        this.testFQQNTopicFilterConsumerOnly("AMQP");
    }

    @Test
    public void testFQQNTopicFilterConsumerOnlyOPENWIRE() throws Exception {
        this.testFQQNTopicFilterConsumerOnly("OPENWIRE");
    }

    @Test
    public void testFQQNTopicFilterConsumerOnlyCORE() throws Exception {
        this.testFQQNTopicFilterConsumerOnly("CORE");
    }

    private void testFQQNTopicFilterConsumerOnly(String protocol) throws Exception {
        ConnectionFactory factory = CFUtil.createConnectionFactory(protocol, "tcp://localhost:5672");
        String queue = "queue";
        String address = "address";
        String filter = "prop='match'";
        this.server.addAddressInfo(new AddressInfo("address").addRoutingType(RoutingType.MULTICAST));
        this.server.createQueue(QueueConfiguration.of((String)"queue").setAddress("address").setRoutingType(RoutingType.MULTICAST));
        try (Connection c = factory.createConnection();){
            c.start();
            Session s = c.createSession(false, 1);
            Topic t = s.createTopic(CompositeAddress.toFullyQualified((String)"address", (String)"queue"));
            MessageConsumer mc = s.createConsumer((Destination)t, "prop='match'");
            Wait.assertTrue(() -> this.server.locateQueue("queue") != null, (long)2000L, (long)100L);
            Queue serverQueue = this.server.locateQueue(SimpleString.of((String)"queue"));
            Assertions.assertEquals((Object)RoutingType.MULTICAST, (Object)serverQueue.getRoutingType());
            Assertions.assertNull((Object)serverQueue.getFilter());
            Wait.assertEquals((int)1, () -> serverQueue.getConsumers().size());
            serverQueue.getConsumers().forEach(consumer -> {
                Assertions.assertNotNull((Object)consumer.getFilter());
                Assertions.assertEquals((Object)"prop='match'", (Object)consumer.getFilter().getFilterString().toString());
            });
            MessageProducer producer = s.createProducer((Destination)s.createTopic("address"));
            TextMessage message = s.createTextMessage("hello");
            message.setStringProperty("prop", "match");
            producer.send((Message)message);
            Assertions.assertNotNull((Object)mc.receive(5000L));
            message = s.createTextMessage("hello");
            message.setStringProperty("prop", "nomatch");
            producer.send((Message)message);
            if (protocol.equals("OPENWIRE")) {
                Assertions.assertNull((Object)mc.receive(100L));
            } else {
                Assertions.assertNull((Object)mc.receiveNoWait());
            }
        }
    }

    @Test
    public void testFQQNTopicConsumerDontExistAMQP() throws Exception {
        this.testFQQNTopicConsumerDontExist("AMQP");
    }

    @Test
    public void testFQQNTopicConsumerDontExistCORE() throws Exception {
        this.testFQQNTopicConsumerDontExist("CORE");
    }

    private void testFQQNTopicConsumerDontExist(String protocol) throws Exception {
        AddressSettings settings = new AddressSettings().setAutoCreateAddresses(Boolean.valueOf(false)).setAutoCreateQueues(Boolean.valueOf(false));
        this.server.getAddressSettingsRepository().clear();
        this.server.getAddressSettingsRepository().addMatch("#", (Object)settings);
        ConnectionFactory factory = CFUtil.createConnectionFactory(protocol, "tcp://localhost:5672");
        String queue = "queue";
        String address = "address";
        boolean thrownException = false;
        try (Connection c = factory.createConnection();){
            Session s = c.createSession(false, 1);
            Topic t = s.createTopic(CompositeAddress.toFullyQualified((String)"address", (String)"queue"));
            MessageConsumer messageConsumer = s.createConsumer((Destination)t);
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            thrownException = true;
        }
        Assertions.assertTrue((boolean)thrownException);
    }

    @Test
    public void testFQQNQueueConsumerWithSelectorAMQP() throws Exception {
        this.testFQQNQueueConsumerWithSelector("AMQP");
    }

    @Test
    public void testFQQNQueueConsumerWithSelectorOpenWire() throws Exception {
        this.testFQQNQueueConsumerWithSelector("OPENWIRE");
    }

    @Test
    public void testFQQNQueueConsumerWithSelectorCore() throws Exception {
        this.testFQQNQueueConsumerWithSelector("CORE");
    }

    private void testFQQNQueueConsumerWithSelector(String protocol) throws Exception {
        AddressSettings settings = new AddressSettings().setDefaultQueueRoutingType(RoutingType.ANYCAST).setDefaultAddressRoutingType(RoutingType.ANYCAST);
        this.server.getAddressSettingsRepository().addMatch("#", (Object)settings);
        String queue = "myQueue";
        String address = "address";
        String filter = "prop='match'";
        ConnectionFactory factory = CFUtil.createConnectionFactory(protocol, "tcp://localhost:5672");
        try (Connection c = factory.createConnection();){
            c.start();
            Session s = c.createSession(false, 1);
            String queueQuery = CompositeAddress.toFullyQualified((String)"address", (String)"myQueue") + (protocol.equals("OPENWIRE") ? "?selectorAware=true" : "");
            jakarta.jms.Queue q = s.createQueue(queueQuery);
            MessageConsumer mc = s.createConsumer((Destination)q, "prop='match'");
            Wait.assertTrue(() -> this.server.locateQueue("myQueue") != null, (long)2000L, (long)100L);
            Queue serverQueue = this.server.locateQueue(SimpleString.of((String)"myQueue"));
            Assertions.assertEquals((Object)RoutingType.ANYCAST, (Object)serverQueue.getRoutingType());
            Assertions.assertNull((Object)serverQueue.getFilter());
            MessageProducer p = s.createProducer((Destination)q);
            Message m = s.createMessage();
            m.setStringProperty("prop", "match");
            p.send(m);
            Assertions.assertNotNull((Object)mc.receive(1000L));
            m = s.createMessage();
            m.setStringProperty("prop", "no-match");
            p.send(m);
            if (protocol.equals("OPENWIRE")) {
                Assertions.assertNull((Object)mc.receive(100L));
            } else {
                Assertions.assertNull((Object)mc.receiveNoWait());
            }
            Wait.assertEquals((int)1, () -> serverQueue.getConsumers().size());
            serverQueue.getConsumers().forEach(queueConsumer -> {
                Assertions.assertNotNull((Object)queueConsumer.getFilter());
                Assertions.assertEquals((Object)"prop='match'", (Object)queueConsumer.getFilter().getFilterString().toString());
            });
            mc.close();
            Wait.assertEquals((int)0, () -> serverQueue.getConsumers().size());
            String invalidFilter = "notHappening=true";
            mc = s.createConsumer((Destination)q, invalidFilter);
            Wait.assertEquals((int)1, () -> serverQueue.getConsumers().size());
            serverQueue.getConsumers().forEach(queueConsumer -> {
                Assertions.assertNotNull((Object)queueConsumer.getFilter());
                Assertions.assertEquals((Object)invalidFilter, (Object)queueConsumer.getFilter().getFilterString().toString());
            });
        }
    }

    @Test
    public void testFQQNTopicMultiConsumerWithSelectorAMQP() throws Exception {
        this.testFQQNTopicMultiConsumerWithSelector("AMQP", true);
    }

    @Test
    public void testFQQNTopicMultiConsumerWithSelectorOpenWire() throws Exception {
        this.testFQQNTopicMultiConsumerWithSelector("OPENWIRE", false);
    }

    @Test
    public void testFQQNTopicMultiConsumerWithSelectorCORE() throws Exception {
        this.testFQQNTopicMultiConsumerWithSelector("CORE", true);
    }

    private void testFQQNTopicMultiConsumerWithSelector(final String protocol, boolean validateFilterChange) throws Exception {
        ConnectionFactory factory = CFUtil.createConnectionFactory(protocol, "tcp://localhost:5672");
        String address = "address";
        int threads = 10;
        ExecutorService executor = Executors.newFixedThreadPool(threads);
        this.runAfter(executor::shutdownNow);
        try (Connection c = factory.createConnection();){
            c.start();
            CountDownLatch doneLatch = new CountDownLatch(threads);
            class RunnableConsumer
            implements Runnable {
                int errors = 0;
                final int expected;
                final Connection c;
                final Session session;
                final Topic topic;
                final MessageConsumer consumer;
                final String queueName;
                final String filter;
                final CountDownLatch done;

                RunnableConsumer(Connection c, String queueName, int expected, String filter, CountDownLatch done) throws Exception {
                    this.c = c;
                    this.session = c.createSession(false, 1);
                    this.queueName = queueName;
                    this.expected = expected;
                    this.topic = this.session.createTopic(queueName);
                    this.consumer = this.session.createConsumer((Destination)this.topic, filter);
                    this.done = done;
                    this.filter = filter;
                }

                @Override
                public void run() {
                    try {
                        for (int i = 0; i < this.expected; ++i) {
                            TextMessage message = (TextMessage)this.consumer.receive(5000L);
                            logger.debug("Queue {} received message {}", (Object)this.queueName, (Object)message.getText());
                            Assertions.assertEquals((int)i, (int)message.getIntProperty("i"));
                            Assertions.assertNotNull((Object)message);
                        }
                        if (protocol.equals("OPENWIRE")) {
                            Assertions.assertNull((Object)this.consumer.receive(500L));
                        } else {
                            Assertions.assertNull((Object)this.consumer.receiveNoWait());
                        }
                    }
                    catch (Throwable e) {
                        ++this.errors;
                        logger.warn(e.getMessage(), e);
                    }
                    finally {
                        this.done.countDown();
                    }
                }
            }
            RunnableConsumer[] consumers = new RunnableConsumer[threads];
            for (int i = 0; i < threads; ++i) {
                consumers[i] = new RunnableConsumer(c, "address::queue" + i, i * 10, "i < " + i * 10, doneLatch);
            }
            Session s = c.createSession(false, 1);
            MessageProducer p = s.createProducer((Destination)s.createTopic("address"));
            for (int i = 0; i < threads * 10; ++i) {
                TextMessage message = s.createTextMessage("i=" + i);
                message.setIntProperty("i", i);
                p.send((Message)message);
            }
            for (RunnableConsumer consumer : consumers) {
                executor.execute(consumer);
            }
            Assertions.assertTrue((boolean)doneLatch.await(10L, TimeUnit.SECONDS));
            for (RunnableConsumer consumer : consumers) {
                Assertions.assertEquals((int)0, (int)consumer.errors, (String)("Error on consumer for queue " + consumer.queueName));
            }
        }
    }
}

