/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.management;

import java.util.Map;
import javax.management.MBeanServer;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.apache.activemq.artemis.api.core.JsonUtil;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.management.ConnectionRouterControl;
import org.apache.activemq.artemis.core.server.routing.KeyType;
import org.apache.activemq.artemis.json.JsonObject;
import org.apache.activemq.artemis.json.JsonValue;
import org.apache.activemq.artemis.tests.integration.management.ManagementControlHelper;
import org.apache.activemq.artemis.tests.integration.routing.RoutingTestBase;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ConnectionRouterControlTest
extends RoutingTestBase {
    private MBeanServer mbeanServer;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.mbeanServer = this.createMBeanServer();
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testGetTarget() throws Exception {
        ConnectionRouterControl connectionRouterControl = this.getConnectionRouterControlForTarget();
        CompositeData targetData = connectionRouterControl.getTarget("admin");
        Assertions.assertNotNull((Object)targetData);
        String nodeID = (String)targetData.get("nodeID");
        Assertions.assertEquals((Object)this.getServer(1).getNodeID().toString(), (Object)nodeID);
        Boolean local = (Boolean)targetData.get("local");
        Assertions.assertNotNull((Object)local);
        Assertions.assertFalse((boolean)local);
        CompositeData connectorData = (CompositeData)targetData.get("connector");
        Assertions.assertNotNull((Object)connectorData);
        TransportConfiguration connector = this.getDefaultServerConnector(1);
        String connectorName = (String)connectorData.get("name");
        Assertions.assertEquals((Object)connector.getName(), (Object)connectorName);
        String connectorFactoryClassName = (String)connectorData.get("factoryClassName");
        Assertions.assertEquals((Object)connector.getFactoryClassName(), (Object)connectorFactoryClassName);
        TabularData connectorParams = (TabularData)connectorData.get("params");
        Assertions.assertNotNull((Object)connectorParams);
        for (Map.Entry param : connector.getParams().entrySet()) {
            CompositeData paramData = connectorParams.get(new Object[]{param.getKey()});
            Assertions.assertEquals((Object)String.valueOf(param.getValue()), (Object)paramData.get("value"));
        }
    }

    @Test
    public void testGetTargetAsJSON() throws Exception {
        ConnectionRouterControl connectionRouterControl = this.getConnectionRouterControlForTarget();
        String targetJSON = connectionRouterControl.getTargetAsJSON("admin");
        Assertions.assertNotNull((Object)targetJSON);
        JsonObject targetData = JsonUtil.readJsonObject((String)targetJSON);
        Assertions.assertNotNull((Object)targetData);
        String nodeID = targetData.getString("nodeID");
        Assertions.assertEquals((Object)this.getServer(1).getNodeID().toString(), (Object)nodeID);
        Boolean local = targetData.getBoolean("local");
        Assertions.assertNotNull((Object)local);
        Assertions.assertFalse((boolean)local);
        JsonObject connectorData = targetData.getJsonObject("connector");
        Assertions.assertNotNull((Object)connectorData);
        TransportConfiguration connector = this.getDefaultServerConnector(1);
        String connectorName = connectorData.getString("name");
        Assertions.assertEquals((Object)connector.getName(), (Object)connectorName);
        String connectorFactoryClassName = connectorData.getString("factoryClassName");
        Assertions.assertEquals((Object)connector.getFactoryClassName(), (Object)connectorFactoryClassName);
        JsonObject connectorParams = connectorData.getJsonObject("params");
        Assertions.assertNotNull((Object)connectorParams);
        for (Map.Entry param : connector.getParams().entrySet()) {
            JsonValue paramData = (JsonValue)connectorParams.get(param.getKey());
            Assertions.assertEquals((Object)String.valueOf(param.getValue()), (Object)paramData.toString());
        }
    }

    @Test
    public void testGetLocalTarget() throws Exception {
        ConnectionRouterControl connectionRouterControl = this.getConnectionRouterControlForLocalTarget();
        CompositeData targetData = connectionRouterControl.getTarget("admin");
        Assertions.assertNotNull((Object)targetData);
        String nodeID = (String)targetData.get("nodeID");
        Assertions.assertEquals((Object)this.getServer(0).getNodeID().toString(), (Object)nodeID);
        Boolean local = (Boolean)targetData.get("local");
        Assertions.assertNotNull((Object)local);
        Assertions.assertTrue((boolean)local);
        CompositeData connectorData = (CompositeData)targetData.get("connector");
        Assertions.assertNull((Object)connectorData);
    }

    @Test
    public void testLocalTargetAccessors() throws Exception {
        ConnectionRouterControl connectionRouterControl = this.getConnectionRouterControlForLocalTarget();
        Assertions.assertNull((Object)connectionRouterControl.getLocalTargetFilter());
        String v = "EQ";
        connectionRouterControl.setLocalTargetFilter("EQ");
        Assertions.assertEquals((Object)"EQ", (Object)connectionRouterControl.getLocalTargetFilter());
        connectionRouterControl.setLocalTargetFilter("");
        Assertions.assertNull((Object)connectionRouterControl.getLocalTargetFilter());
        connectionRouterControl.setLocalTargetFilter(null);
        Assertions.assertNull((Object)connectionRouterControl.getLocalTargetFilter());
        Assertions.assertNull((Object)connectionRouterControl.getTargetKeyFilter());
        connectionRouterControl.setTargetKeyFilter("EQ");
        Assertions.assertEquals((Object)"EQ", (Object)connectionRouterControl.getTargetKeyFilter());
        connectionRouterControl.setTargetKeyFilter("");
        Assertions.assertNull((Object)connectionRouterControl.getTargetKeyFilter());
        connectionRouterControl.setTargetKeyFilter(null);
        Assertions.assertNull((Object)connectionRouterControl.getTargetKeyFilter());
    }

    @Test
    public void testGetLocalTargetAsJSON() throws Exception {
        ConnectionRouterControl connectionRouterControl = this.getConnectionRouterControlForLocalTarget();
        String targetJSON = connectionRouterControl.getTargetAsJSON("admin");
        Assertions.assertNotNull((Object)targetJSON);
        JsonObject targetData = JsonUtil.readJsonObject((String)targetJSON);
        Assertions.assertNotNull((Object)targetData);
        String nodeID = targetData.getString("nodeID");
        Assertions.assertEquals((Object)this.getServer(0).getNodeID().toString(), (Object)nodeID);
        Boolean local = targetData.getBoolean("local");
        Assertions.assertNotNull((Object)local);
        Assertions.assertTrue((boolean)local);
        Assertions.assertTrue((boolean)targetData.isNull("connector"));
    }

    private ConnectionRouterControl getConnectionRouterControlForTarget() throws Exception {
        this.setupPrimaryServerWithDiscovery(0, GROUP_ADDRESS, GROUP_PORT, true, true, false);
        this.setupRouterServerWithDiscovery(0, KeyType.USER_NAME, "FIRST_ELEMENT", null, false, null, 1);
        this.getServer(0).setMBeanServer(this.mbeanServer);
        this.setupPrimaryServerWithDiscovery(1, GROUP_ADDRESS, GROUP_PORT, true, true, false);
        this.startServers(0, 1);
        return ManagementControlHelper.createConnectionRouterControl("bb1", this.mbeanServer);
    }

    private ConnectionRouterControl getConnectionRouterControlForLocalTarget() throws Exception {
        this.setupPrimaryServerWithDiscovery(0, GROUP_ADDRESS, GROUP_PORT, true, true, false);
        this.setupRouterServerWithDiscovery(0, KeyType.USER_NAME, "FIRST_ELEMENT", null, true, null, 1);
        this.getServer(0).setMBeanServer(this.mbeanServer);
        this.startServers(0);
        return ManagementControlHelper.createConnectionRouterControl("bb1", this.mbeanServer);
    }
}

