/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.mqtt;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.Bindings;
import org.apache.activemq.artemis.core.server.QueueQueryResult;
import org.apache.activemq.artemis.tests.integration.mqtt.MQTTClientProvider;
import org.apache.activemq.artemis.tests.integration.mqtt.MQTTTestSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class MQTTFQQNTest
extends MQTTTestSupport {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMQTTSubNames() throws Exception {
        MQTTClientProvider subscriptionProvider = this.getMQTTClientProvider();
        this.initializeConnection(subscriptionProvider);
        try {
            subscriptionProvider.subscribe("foo/bah", 0);
            Bindings bindings = this.server.getPostOffice().getBindingsForAddress(SimpleString.of((String)"foo.bah"));
            Assertions.assertEquals((int)1, (int)bindings.size());
            Binding b = (Binding)bindings.getBindings().iterator().next();
            QueueQueryResult result = this.server.queueQuery(b.getUniqueName());
            Assertions.assertTrue((boolean)result.isExists());
            Assertions.assertEquals((Object)result.getAddress(), (Object)SimpleString.of((String)"foo.bah"));
            Assertions.assertEquals((Object)b.getUniqueName(), (Object)result.getName());
            result = this.server.queueQuery(SimpleString.of((String)("foo.bah::" + b.getUniqueName())));
            Assertions.assertTrue((boolean)result.isExists());
            Assertions.assertEquals((Object)SimpleString.of((String)"foo.bah"), (Object)result.getAddress());
            Assertions.assertEquals((Object)b.getUniqueName(), (Object)result.getName());
        }
        finally {
            subscriptionProvider.disconnect();
        }
    }

    @Test
    @Timeout(value=60L)
    public void testSendAndReceiveMQTTSpecial1() throws Exception {
        MQTTClientProvider subscriptionProvider = this.getMQTTClientProvider();
        this.initializeConnection(subscriptionProvider);
        subscriptionProvider.subscribe("foo/bah::", 0);
        CountDownLatch latch = new CountDownLatch(250);
        Thread thread = new Thread(() -> {
            for (int i = 0; i < 250; ++i) {
                try {
                    byte[] payload = subscriptionProvider.receive(10000);
                    Assertions.assertNotNull((Object)payload, (String)"Should get a message");
                    latch.countDown();
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break;
                }
            }
        });
        thread.start();
        MQTTClientProvider publishProvider = this.getMQTTClientProvider();
        this.initializeConnection(publishProvider);
        for (int i = 0; i < 250; ++i) {
            String payload = "Message " + i;
            publishProvider.publish("foo/bah", payload.getBytes(), 1);
        }
        latch.await(10L, TimeUnit.SECONDS);
        Assertions.assertEquals((long)0L, (long)latch.getCount());
        subscriptionProvider.disconnect();
        publishProvider.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60L)
    public void testSendAndReceiveMQTTSpecial2() throws Exception {
        MQTTClientProvider subscriptionProvider = this.getMQTTClientProvider();
        this.initializeConnection(subscriptionProvider);
        try {
            subscriptionProvider.subscribe("::foo/bah", 0);
            Assertions.fail((String)"should get exception!");
        }
        catch (Exception exception) {
        }
        finally {
            subscriptionProvider.disconnect();
        }
        this.initializeConnection(subscriptionProvider);
        try {
            subscriptionProvider.subscribe("::", 0);
            Assertions.fail((String)"should get exception!");
        }
        catch (Exception exception) {
        }
        finally {
            subscriptionProvider.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMQTTSubNamesSpecial() throws Exception {
        MQTTClientProvider subscriptionProvider = this.getMQTTClientProvider();
        this.initializeConnection(subscriptionProvider);
        try {
            subscriptionProvider.subscribe("foo/bah", 0);
            Bindings bindings = this.server.getPostOffice().getBindingsForAddress(SimpleString.of((String)"foo.bah"));
            Assertions.assertEquals((int)1, (int)bindings.size());
            Binding b = (Binding)bindings.getBindings().iterator().next();
            QueueQueryResult result = this.server.queueQuery(SimpleString.of((String)("::" + b.getUniqueName())));
            Assertions.assertTrue((boolean)result.isExists());
            Assertions.assertEquals((Object)SimpleString.of((String)"foo.bah"), (Object)result.getAddress());
            Assertions.assertEquals((Object)b.getUniqueName(), (Object)result.getName());
            result = this.server.queueQuery(SimpleString.of((String)(b.getUniqueName() + "::")));
            Assertions.assertFalse((boolean)result.isExists());
            result = this.server.queueQuery(SimpleString.of((String)"::"));
            Assertions.assertFalse((boolean)result.isExists());
        }
        finally {
            subscriptionProvider.disconnect();
        }
    }
}

