/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.mqtt5.spec;

import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttPubAckMessage;
import io.netty.handler.codec.mqtt.MqttPubReplyMessageVariableHeader;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.BaseInterceptor;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.core.config.WildcardConfiguration;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTInterceptor;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTUtil;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.tests.integration.mqtt5.MQTT5TestSupport;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.apache.activemq.artemis.tests.util.Wait;
import org.eclipse.paho.mqttv5.client.MqttCallback;
import org.eclipse.paho.mqttv5.client.MqttClient;
import org.eclipse.paho.mqttv5.client.MqttConnectionOptions;
import org.eclipse.paho.mqttv5.common.MqttMessage;
import org.eclipse.paho.mqttv5.common.packet.MqttProperties;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class QoSTests
extends MQTT5TestSupport {
    @Test
    @Timeout(value=60L)
    public void testQoS1andDupFlag() throws Exception {
        String TOPIC = RandomUtil.randomString();
        final CountDownLatch latch = new CountDownLatch(1);
        MqttClient consumer = this.createPahoClient("consumer");
        consumer.connect();
        consumer.setCallback((MqttCallback)new MQTT5TestSupport.DefaultMqttCallback(){

            @Override
            public void messageArrived(String incomingTopic, MqttMessage message) throws Exception {
                Assertions.assertEquals((int)1, (int)message.getQos());
                Assertions.assertFalse((boolean)message.isDuplicate());
                latch.countDown();
            }
        });
        consumer.subscribe(TOPIC, 1);
        MqttClient producer = this.createPahoClient("producer");
        producer.connect();
        producer.publish(TOPIC, RandomUtil.randomString().getBytes(), 1, false);
        producer.disconnect();
        producer.close();
        Assertions.assertTrue((boolean)latch.await(2L, TimeUnit.SECONDS));
        consumer.disconnect();
        consumer.close();
    }

    @Test
    @Timeout(value=60L)
    public void testQoS1PubAck() throws Exception {
        String TOPIC = RandomUtil.randomString();
        String CONSUMER_ID = "consumer";
        CountDownLatch ackLatch = new CountDownLatch(1);
        AtomicInteger packetId = new AtomicInteger();
        MQTTInterceptor incomingInterceptor = (packet, connection) -> {
            if (packet.fixedHeader().messageType() == MqttMessageType.PUBACK) {
                Assertions.assertEquals((long)1L, (long)this.getSubscriptionQueue(TOPIC, "consumer").getMessageCount());
                Assertions.assertEquals((int)1, (int)this.getSubscriptionQueue(TOPIC, "consumer").getDeliveringCount());
                Assertions.assertEquals((int)packetId.get(), (int)((MqttPubReplyMessageVariableHeader)packet.variableHeader()).messageId());
                ackLatch.countDown();
            }
            return true;
        };
        MQTTInterceptor outgoingInterceptor = (packet, connection) -> {
            if (packet.fixedHeader().messageType() == MqttMessageType.PUBLISH) {
                packetId.set(((MqttPublishMessage)packet).variableHeader().packetId());
            }
            return true;
        };
        this.server.getRemotingService().addIncomingInterceptor((BaseInterceptor)incomingInterceptor);
        this.server.getRemotingService().addOutgoingInterceptor((BaseInterceptor)outgoingInterceptor);
        CountDownLatch latch = new CountDownLatch(1);
        MqttClient consumer = this.createPahoClient("consumer");
        consumer.connect();
        consumer.setCallback((MqttCallback)new MQTT5TestSupport.LatchedMqttCallback(this, latch));
        consumer.subscribe(TOPIC, 1);
        MqttClient producer = this.createPahoClient("producer");
        producer.connect();
        producer.publish(TOPIC, RandomUtil.randomString().getBytes(), 1, false);
        producer.disconnect();
        producer.close();
        Assertions.assertTrue((boolean)ackLatch.await(2L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)latch.await(2L, TimeUnit.SECONDS));
        Assertions.assertEquals((long)0L, (long)this.getSubscriptionQueue(TOPIC, "consumer").getMessageCount());
        Assertions.assertEquals((int)0, (int)this.getSubscriptionQueue(TOPIC, "consumer").getDeliveringCount());
        consumer.disconnect();
        consumer.close();
    }

    @Test
    @Timeout(value=60L)
    public void testQoS1PubAckId() throws Exception {
        String TOPIC = RandomUtil.randomString();
        CountDownLatch ackLatch = new CountDownLatch(1);
        AtomicInteger packetId = new AtomicInteger();
        MQTTInterceptor incomingInterceptor = (packet, connection) -> {
            if (packet.fixedHeader().messageType() == MqttMessageType.PUBLISH) {
                packetId.set(((MqttPublishMessage)packet).variableHeader().packetId());
            }
            return true;
        };
        MQTTInterceptor outgoingInterceptor = (packet, connection) -> {
            if (packet.fixedHeader().messageType() == MqttMessageType.PUBACK) {
                Assertions.assertEquals((int)packetId.get(), (int)((MqttPubAckMessage)packet).variableHeader().messageId());
                ackLatch.countDown();
            }
            return true;
        };
        this.server.getRemotingService().addIncomingInterceptor((BaseInterceptor)incomingInterceptor);
        this.server.getRemotingService().addOutgoingInterceptor((BaseInterceptor)outgoingInterceptor);
        CountDownLatch latch = new CountDownLatch(1);
        MqttClient consumer = this.createPahoClient("consumer");
        consumer.connect();
        consumer.setCallback((MqttCallback)new MQTT5TestSupport.LatchedMqttCallback(this, latch));
        consumer.subscribe(TOPIC, 1);
        MqttClient producer = this.createPahoClient("producer");
        producer.connect();
        producer.publish(TOPIC, RandomUtil.randomString().getBytes(), 1, false);
        producer.disconnect();
        producer.close();
        Assertions.assertTrue((boolean)ackLatch.await(2L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)latch.await(2L, TimeUnit.SECONDS));
        consumer.disconnect();
        consumer.close();
    }

    @Test
    @Timeout(value=60L)
    public void testQoS2PubRec() throws Exception {
        String TOPIC = RandomUtil.randomString();
        String CONSUMER_ID = "consumer";
        CountDownLatch ackLatch = new CountDownLatch(1);
        AtomicInteger packetId = new AtomicInteger();
        MQTTInterceptor incomingInterceptor = (packet, connection) -> {
            if (packet.fixedHeader().messageType() == MqttMessageType.PUBREC) {
                Assertions.assertEquals((long)1L, (long)this.getSubscriptionQueue(TOPIC, "consumer").getMessageCount());
                Assertions.assertEquals((int)1, (int)this.getSubscriptionQueue(TOPIC, "consumer").getDeliveringCount());
                Assertions.assertEquals((int)packetId.get(), (int)((MqttPubReplyMessageVariableHeader)packet.variableHeader()).messageId());
                ackLatch.countDown();
            }
            return true;
        };
        MQTTInterceptor outgoingInterceptor = (packet, connection) -> {
            if (packet.fixedHeader().messageType() == MqttMessageType.PUBLISH) {
                packetId.set(((MqttPublishMessage)packet).variableHeader().packetId());
            }
            return true;
        };
        this.server.getRemotingService().addIncomingInterceptor((BaseInterceptor)incomingInterceptor);
        this.server.getRemotingService().addOutgoingInterceptor((BaseInterceptor)outgoingInterceptor);
        CountDownLatch latch = new CountDownLatch(1);
        MqttClient consumer = this.createPahoClient("consumer");
        consumer.connect();
        consumer.setCallback((MqttCallback)new MQTT5TestSupport.LatchedMqttCallback(this, latch));
        consumer.subscribe(TOPIC, 2);
        MqttClient producer = this.createPahoClient("producer");
        producer.connect();
        producer.publish(TOPIC, RandomUtil.randomString().getBytes(), 2, false);
        producer.disconnect();
        producer.close();
        Assertions.assertTrue((boolean)ackLatch.await(2L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)latch.await(2L, TimeUnit.SECONDS));
        Assertions.assertEquals((long)0L, (long)this.getSubscriptionQueue(TOPIC, "consumer").getMessageCount());
        Assertions.assertEquals((int)0, (int)this.getSubscriptionQueue(TOPIC, "consumer").getDeliveringCount());
        consumer.disconnect();
        consumer.close();
    }

    @Test
    @Timeout(value=60L)
    public void testQoS2PubRelId() throws Exception {
        String TOPIC = RandomUtil.randomString();
        CountDownLatch ackLatch = new CountDownLatch(1);
        AtomicInteger packetId = new AtomicInteger();
        AtomicBoolean pubRecReceived = new AtomicBoolean(false);
        MQTTInterceptor incomingInterceptor = (packet, connection) -> {
            if (packet.fixedHeader().messageType() == MqttMessageType.PUBLISH) {
                packetId.set(((MqttPublishMessage)packet).variableHeader().packetId());
            }
            if (packet.fixedHeader().messageType() == MqttMessageType.PUBREC) {
                Assertions.assertEquals((int)packetId.get(), (int)((MqttPubReplyMessageVariableHeader)packet.variableHeader()).messageId());
                Assertions.assertEquals((byte)0, (byte)((MqttPubReplyMessageVariableHeader)packet.variableHeader()).reasonCode());
                pubRecReceived.set(true);
            }
            return true;
        };
        MQTTInterceptor outgoingInterceptor = (packet, connection) -> {
            if (packet.fixedHeader().messageType() == MqttMessageType.PUBREL) {
                Assertions.assertTrue((boolean)pubRecReceived.get());
                Assertions.assertEquals((int)packetId.get(), (int)((MqttPubAckMessage)packet).variableHeader().messageId());
                ackLatch.countDown();
            }
            return true;
        };
        this.server.getRemotingService().addIncomingInterceptor((BaseInterceptor)incomingInterceptor);
        this.server.getRemotingService().addOutgoingInterceptor((BaseInterceptor)outgoingInterceptor);
        CountDownLatch latch = new CountDownLatch(1);
        MqttClient consumer = this.createPahoClient("consumer");
        consumer.connect();
        consumer.setCallback((MqttCallback)new MQTT5TestSupport.LatchedMqttCallback(this, latch));
        consumer.subscribe(TOPIC, 2);
        MqttClient producer = this.createPahoClient("producer");
        producer.connect();
        producer.publish(TOPIC, RandomUtil.randomString().getBytes(), 2, false);
        producer.disconnect();
        producer.close();
        Assertions.assertTrue((boolean)ackLatch.await(2L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)latch.await(2L, TimeUnit.SECONDS));
        consumer.disconnect();
        consumer.close();
    }

    @Test
    @Timeout(value=60L)
    public void testQoS2PubRel() throws Exception {
        String TOPIC = RandomUtil.randomString();
        String CONSUMER_ID = "consumer";
        CountDownLatch ackLatch = new CountDownLatch(1);
        AtomicInteger packetId = new AtomicInteger();
        MQTTInterceptor incomingInterceptor = (packet, connection) -> {
            if (packet.fixedHeader().messageType() == MqttMessageType.PUBCOMP) {
                try {
                    Wait.assertEquals((Long)1L, () -> this.server.locateQueue("$sys.mqtt.queue.qos2.consumer").getMessageCount(), (long)2000L, (long)100L);
                    Wait.assertEquals((Long)1L, () -> this.server.locateQueue("$sys.mqtt.queue.qos2.consumer").getDeliveringCount(), (long)2000L, (long)100L);
                }
                catch (Exception e) {
                    return false;
                }
                Assertions.assertEquals((int)packetId.get(), (int)((MqttPubReplyMessageVariableHeader)packet.variableHeader()).messageId());
                ackLatch.countDown();
            }
            return true;
        };
        MQTTInterceptor outgoingInterceptor = (packet, connection) -> {
            if (packet.fixedHeader().messageType() == MqttMessageType.PUBLISH) {
                packetId.set(((MqttPublishMessage)packet).variableHeader().packetId());
            }
            return true;
        };
        this.server.getRemotingService().addIncomingInterceptor((BaseInterceptor)incomingInterceptor);
        this.server.getRemotingService().addOutgoingInterceptor((BaseInterceptor)outgoingInterceptor);
        CountDownLatch latch = new CountDownLatch(1);
        MqttClient consumer = this.createPahoClient("consumer");
        consumer.connect();
        consumer.setCallback((MqttCallback)new MQTT5TestSupport.LatchedMqttCallback(this, latch));
        consumer.subscribe(TOPIC, 2);
        MqttClient producer = this.createPahoClient("producer");
        producer.connect();
        producer.publish(TOPIC, RandomUtil.randomString().getBytes(), 2, false);
        producer.disconnect();
        producer.close();
        Assertions.assertTrue((boolean)ackLatch.await(2L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)latch.await(2L, TimeUnit.SECONDS));
        Assertions.assertEquals((long)0L, (long)this.getSubscriptionQueue(TOPIC, "consumer").getMessageCount());
        Assertions.assertEquals((int)0, (int)this.getSubscriptionQueue(TOPIC, "consumer").getDeliveringCount());
        consumer.disconnect();
        consumer.close();
    }

    @Test
    @Timeout(value=60L)
    public void testQoS2WithExpiration() throws Exception {
        String TOPIC = "myTopic";
        String CONSUMER_ID = "consumer";
        CountDownLatch ackLatch = new CountDownLatch(1);
        CountDownLatch expireRefsLatch = new CountDownLatch(1);
        long messageExpiryInterval = 2L;
        MQTTInterceptor incomingInterceptor = (packet, connection) -> {
            if (packet.fixedHeader().messageType() == MqttMessageType.PUBREC) {
                Assertions.assertEquals((long)1L, (long)this.getSubscriptionQueue("myTopic", "consumer").getMessageCount());
                Assertions.assertEquals((int)1, (int)this.getSubscriptionQueue("myTopic", "consumer").getDeliveringCount());
                try {
                    Thread.sleep(3000L);
                    this.getSubscriptionQueue("myTopic", "consumer").expireReferences(expireRefsLatch::countDown);
                    Assertions.assertTrue((boolean)expireRefsLatch.await(2L, TimeUnit.SECONDS));
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    Assertions.fail();
                }
                ackLatch.countDown();
            }
            return true;
        };
        this.server.getRemotingService().addIncomingInterceptor((BaseInterceptor)incomingInterceptor);
        final CountDownLatch latch = new CountDownLatch(1);
        MqttClient consumer = this.createPahoClient("consumer");
        consumer.connect();
        consumer.setCallback((MqttCallback)new MQTT5TestSupport.DefaultMqttCallback(){

            @Override
            public void messageArrived(String topic, MqttMessage message) throws Exception {
                latch.countDown();
            }
        });
        consumer.subscribe("myTopic", 2);
        MqttClient producer = this.createPahoClient("producer");
        producer.connect();
        MqttMessage m = new MqttMessage();
        MqttProperties props = new MqttProperties();
        props.setMessageExpiryInterval(Long.valueOf(2L));
        m.setProperties(props);
        m.setQos(2);
        m.setPayload("foo".getBytes(StandardCharsets.UTF_8));
        producer.publish("myTopic", m);
        producer.disconnect();
        producer.close();
        Assertions.assertTrue((boolean)ackLatch.await(4L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)latch.await(4L, TimeUnit.SECONDS));
        Wait.assertEquals((long)0L, () -> this.getSubscriptionQueue("myTopic", "consumer").getMessageCount());
        Wait.assertEquals((int)0, () -> this.getSubscriptionQueue("myTopic", "consumer").getDeliveringCount());
        Wait.assertEquals((long)0L, () -> this.getSubscriptionQueue("myTopic", "consumer").getMessagesExpired());
        consumer.disconnect();
        consumer.close();
    }

    @Test
    @Timeout(value=60L)
    public void testQoS2PubRecId() throws Exception {
        String TOPIC = RandomUtil.randomString();
        CountDownLatch ackLatch = new CountDownLatch(1);
        AtomicInteger packetId = new AtomicInteger();
        MQTTInterceptor incomingInterceptor = (packet, connection) -> {
            if (packet.fixedHeader().messageType() == MqttMessageType.PUBLISH) {
                packetId.set(((MqttPublishMessage)packet).variableHeader().packetId());
            }
            return true;
        };
        MQTTInterceptor outgoingInterceptor = (packet, connection) -> {
            if (packet.fixedHeader().messageType() == MqttMessageType.PUBREC) {
                Assertions.assertEquals((int)packetId.get(), (int)((MqttPubAckMessage)packet).variableHeader().messageId());
                ackLatch.countDown();
            }
            return true;
        };
        this.server.getRemotingService().addIncomingInterceptor((BaseInterceptor)incomingInterceptor);
        this.server.getRemotingService().addOutgoingInterceptor((BaseInterceptor)outgoingInterceptor);
        CountDownLatch latch = new CountDownLatch(1);
        MqttClient consumer = this.createPahoClient("consumer");
        consumer.connect();
        consumer.setCallback((MqttCallback)new MQTT5TestSupport.LatchedMqttCallback(this, latch));
        consumer.subscribe(TOPIC, 2);
        MqttClient producer = this.createPahoClient("producer");
        producer.connect();
        producer.publish(TOPIC, RandomUtil.randomString().getBytes(), 2, false);
        producer.disconnect();
        producer.close();
        Assertions.assertTrue((boolean)ackLatch.await(2L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)latch.await(2L, TimeUnit.SECONDS));
        consumer.disconnect();
        consumer.close();
    }

    @Test
    @Timeout(value=60L)
    public void testQoS2DuplicatePub() throws Exception {
        String TOPIC = RandomUtil.randomString();
        CountDownLatch ackLatch = new CountDownLatch(1);
        AtomicInteger packetId = new AtomicInteger();
        AtomicInteger count = new AtomicInteger(0);
        byte[] PAYLOAD = RandomUtil.randomString().getBytes();
        MQTTInterceptor incomingInterceptor = (packet, connection) -> {
            if (packet.fixedHeader().messageType() == MqttMessageType.PUBLISH) {
                packetId.set(((MqttPublishMessage)packet).variableHeader().packetId());
            }
            return true;
        };
        MQTTInterceptor outgoingInterceptor = (packet, connection) -> {
            if (count.get() == 0 && packet.fixedHeader().messageType() == MqttMessageType.PUBREC) {
                ackLatch.countDown();
                count.incrementAndGet();
                connection.disconnect(true);
                return false;
            }
            return true;
        };
        this.server.getRemotingService().addIncomingInterceptor((BaseInterceptor)incomingInterceptor);
        this.server.getRemotingService().addOutgoingInterceptor((BaseInterceptor)outgoingInterceptor);
        Queue queue = this.server.createQueue(QueueConfiguration.of((String)TOPIC));
        MqttClient producer = this.createPahoClient("producer");
        MqttConnectionOptions connectionOptions = new MqttConnectionOptions();
        connectionOptions.setCleanStart(false);
        connectionOptions.setSessionExpiryInterval(Long.valueOf(999L));
        producer.connect(connectionOptions);
        try {
            producer.publish(TOPIC, PAYLOAD, 2, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertTrue((boolean)ackLatch.await(2L, TimeUnit.SECONDS));
        producer.disconnectForcibly(1L, 1L, false);
        producer.close();
        producer = this.createPahoClient("producer");
        producer.connect(connectionOptions);
        producer.publish(TOPIC, PAYLOAD, 2, false);
        producer.disconnect();
        producer.close();
        Assertions.assertEquals((long)1L, (long)queue.getMessageCount());
    }

    @Test
    @Timeout(value=60L)
    public void testQoS2PubCompId() throws Exception {
        String TOPIC = RandomUtil.randomString();
        CountDownLatch ackLatch = new CountDownLatch(1);
        AtomicInteger packetId = new AtomicInteger();
        MQTTInterceptor incomingInterceptor = (packet, connection) -> {
            if (packet.fixedHeader().messageType() == MqttMessageType.PUBREL) {
                packetId.set(((MqttPubReplyMessageVariableHeader)packet.variableHeader()).messageId());
            }
            return true;
        };
        MQTTInterceptor outgoingInterceptor = (packet, connection) -> {
            if (packet.fixedHeader().messageType() == MqttMessageType.PUBCOMP) {
                Assertions.assertEquals((int)packetId.get(), (int)((MqttPubAckMessage)packet).variableHeader().messageId());
                ackLatch.countDown();
            }
            return true;
        };
        this.server.getRemotingService().addIncomingInterceptor((BaseInterceptor)incomingInterceptor);
        this.server.getRemotingService().addOutgoingInterceptor((BaseInterceptor)outgoingInterceptor);
        CountDownLatch latch = new CountDownLatch(1);
        MqttClient consumer = this.createPahoClient("consumer");
        consumer.connect();
        consumer.setCallback((MqttCallback)new MQTT5TestSupport.LatchedMqttCallback(this, latch));
        consumer.subscribe(TOPIC, 2);
        MqttClient producer = this.createPahoClient("producer");
        producer.connect();
        producer.publish(TOPIC, RandomUtil.randomString().getBytes(), 2, false);
        producer.disconnect();
        producer.close();
        Assertions.assertTrue((boolean)ackLatch.await(2L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)latch.await(2L, TimeUnit.SECONDS));
        consumer.disconnect();
        consumer.close();
    }

    @Test
    @Timeout(value=60L)
    public void testQoS2WithExpiration2() throws Exception {
        String TOPIC = "myTopic";
        String CONSUMER_ID = "consumer";
        this.server.createQueue(QueueConfiguration.of((String)MQTTUtil.getCoreQueueFromMqttTopic((String)"myTopic", (String)"consumer", (WildcardConfiguration)this.server.getConfiguration().getWildcardConfiguration())).setAddress(MQTTUtil.getCoreAddressFromMqttTopic((String)"myTopic", (WildcardConfiguration)this.server.getConfiguration().getWildcardConfiguration())).setRoutingType(RoutingType.MULTICAST));
        CountDownLatch ackLatch = new CountDownLatch(1);
        CountDownLatch expireRefsLatch = new CountDownLatch(1);
        long messageExpiryInterval = 1L;
        MQTTInterceptor outgoingInterceptor = (packet, connection) -> {
            if (packet.fixedHeader().messageType() == MqttMessageType.PUBREC) {
                Wait.assertTrue(() -> this.getSubscriptionQueue("myTopic", "consumer").getMessageCount() == 1L, (long)2000L, (long)100L);
                try {
                    Thread.sleep(1500L);
                    this.getSubscriptionQueue("myTopic", "consumer").expireReferences(expireRefsLatch::countDown);
                    Assertions.assertTrue((boolean)expireRefsLatch.await(2L, TimeUnit.SECONDS));
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    Assertions.fail();
                }
                ackLatch.countDown();
            }
            return true;
        };
        this.server.getRemotingService().addOutgoingInterceptor((BaseInterceptor)outgoingInterceptor);
        MqttClient producer = this.createPahoClient("producer");
        producer.connect();
        MqttMessage m = new MqttMessage();
        MqttProperties props = new MqttProperties();
        props.setMessageExpiryInterval(Long.valueOf(1L));
        m.setProperties(props);
        m.setQos(2);
        m.setPayload("foo".getBytes(StandardCharsets.UTF_8));
        producer.publish("myTopic", m);
        producer.disconnect();
        producer.close();
        Assertions.assertTrue((boolean)ackLatch.await(2L, TimeUnit.SECONDS));
        Wait.assertEquals((long)1L, () -> this.getSubscriptionQueue("myTopic", "consumer").getMessagesExpired());
    }
}

