/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.mqtt5.spec.controlpackets;

import io.netty.handler.codec.mqtt.MqttMessageType;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.activemq.artemis.api.core.BaseInterceptor;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTInterceptor;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTSessionState;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTUtil;
import org.apache.activemq.artemis.tests.integration.mqtt5.MQTT5TestSupport;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.apache.activemq.artemis.utils.Wait;
import org.eclipse.paho.mqttv5.client.IMqttToken;
import org.eclipse.paho.mqttv5.client.MqttCallback;
import org.eclipse.paho.mqttv5.client.MqttClient;
import org.eclipse.paho.mqttv5.client.MqttConnectionOptions;
import org.eclipse.paho.mqttv5.client.MqttConnectionOptionsBuilder;
import org.eclipse.paho.mqttv5.client.MqttDisconnectResponse;
import org.eclipse.paho.mqttv5.common.MqttException;
import org.eclipse.paho.mqttv5.common.MqttMessage;
import org.eclipse.paho.mqttv5.common.packet.MqttProperties;
import org.eclipse.paho.mqttv5.common.packet.UserProperty;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectTests
extends MQTT5TestSupport {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Test
    @Timeout(value=60L)
    public void testWillFlag() throws Exception {
        String CLIENT_ID = RandomUtil.randomString();
        byte[] WILL = RandomUtil.randomBytes();
        MqttClient client = this.createPahoClient(CLIENT_ID);
        MqttConnectionOptions options = new MqttConnectionOptionsBuilder().will("/topic/foo", new MqttMessage(WILL)).build();
        client.connect(options);
        Assertions.assertEquals((int)1, (int)this.getSessionStates().size());
        Assertions.assertNotNull((Object)this.getSessionStates().get(CLIENT_ID));
        Assertions.assertTrue((boolean)this.getSessionStates().get(CLIENT_ID).isWill());
        byte[] willMessage = new byte[this.getSessionStates().get(CLIENT_ID).getWillMessage().capacity()];
        this.getSessionStates().get(CLIENT_ID).getWillMessage().getBytes(0, willMessage);
        ConnectTests.assertEqualsByteArrays(WILL, willMessage);
        client.disconnect();
    }

    @Test
    @Timeout(value=60L)
    public void testWillMessageWithNoSessionExpiryDelayAndNoWillDelay() throws Exception {
        String CLIENT_ID_1 = RandomUtil.randomString();
        String CLIENT_ID_2 = RandomUtil.randomString();
        byte[] WILL = RandomUtil.randomBytes();
        MqttClient client1 = this.createPahoClient(CLIENT_ID_1);
        CountDownLatch latch = new CountDownLatch(1);
        client1.setCallback((MqttCallback)new MQTT5TestSupport.LatchedMqttCallback(this, latch));
        client1.connect();
        client1.subscribe("/topic/foo", 1);
        MqttClient client2 = this.createPahoClient(CLIENT_ID_2);
        MqttConnectionOptions options = new MqttConnectionOptionsBuilder().will("/topic/foo", new MqttMessage(WILL)).build();
        client2.connect(options);
        client2.disconnectForcibly(0L, 0L, false);
        Assertions.assertTrue((boolean)latch.await(2L, TimeUnit.SECONDS));
    }

    @Test
    @Timeout(value=60L)
    public void testWillFlagWithSessionExpiryDelayAndWillDelay() throws Exception {
        byte[] WILL = RandomUtil.randomBytes();
        MqttClient client1 = this.createPahoClient("willConsumer");
        CountDownLatch latch = new CountDownLatch(1);
        client1.setCallback((MqttCallback)new MQTT5TestSupport.LatchedMqttCallback(this, latch));
        client1.connect();
        client1.subscribe("/topic/foo", 1);
        MqttClient client2 = this.createPahoClient("willGenerator");
        MqttProperties willMessageProperties = new MqttProperties();
        willMessageProperties.setWillDelayInterval(Long.valueOf(1L));
        MqttConnectionOptions options = new MqttConnectionOptionsBuilder().sessionExpiryInterval(Long.valueOf(4L)).will("/topic/foo", new MqttMessage(WILL)).build();
        options.setWillMessageProperties(willMessageProperties);
        client2.connect(options);
        client2.disconnectForcibly(0L, 0L, false);
        long start = System.currentTimeMillis();
        Assertions.assertTrue((boolean)latch.await(3L, TimeUnit.SECONDS));
        Assertions.assertTrue((System.currentTimeMillis() - start >= 1000L ? (byte)1 : 0) != 0);
    }

    @Test
    @Timeout(value=60L)
    public void testWillFlagWithNoSessionExpiryDelayAndWillDelay() throws Exception {
        byte[] WILL = RandomUtil.randomBytes();
        MqttClient client1 = this.createPahoClient("willConsumer");
        CountDownLatch latch = new CountDownLatch(1);
        client1.setCallback((MqttCallback)new MQTT5TestSupport.LatchedMqttCallback(this, latch));
        client1.connect();
        client1.subscribe("/topic/foo", 1);
        MqttClient client2 = this.createPahoClient("willGenerator");
        MqttProperties willMessageProperties = new MqttProperties();
        willMessageProperties.setWillDelayInterval(Long.valueOf(1L));
        MqttConnectionOptions options = new MqttConnectionOptionsBuilder().will("/topic/foo", new MqttMessage(WILL)).build();
        options.setWillMessageProperties(willMessageProperties);
        client2.connect(options);
        client2.disconnectForcibly(0L, 0L, false);
        Assertions.assertTrue((boolean)latch.await(500L, TimeUnit.MILLISECONDS));
    }

    @Test
    @Timeout(value=60L)
    public void testWillFlagWithShorterSessionExpiryDelayThanWillDelay() throws Exception {
        byte[] WILL = RandomUtil.randomBytes();
        MqttClient client1 = this.createPahoClient("willConsumer");
        CountDownLatch latch = new CountDownLatch(1);
        client1.setCallback((MqttCallback)new MQTT5TestSupport.LatchedMqttCallback(this, latch));
        client1.connect();
        client1.subscribe("/topic/foo", 1);
        MqttClient client2 = this.createPahoClient("willGenerator");
        MqttProperties willMessageProperties = new MqttProperties();
        willMessageProperties.setWillDelayInterval(Long.valueOf(2L));
        MqttConnectionOptions options = new MqttConnectionOptionsBuilder().sessionExpiryInterval(Long.valueOf(1L)).will("/topic/foo", new MqttMessage(WILL)).build();
        options.setWillMessageProperties(willMessageProperties);
        client2.connect(options);
        client2.disconnectForcibly(0L, 0L, false);
        Assertions.assertTrue((boolean)latch.await(1500L, TimeUnit.MILLISECONDS));
    }

    @Test
    @Timeout(value=60L)
    public void testWillFlagWithSessionExpiryDelayAndWillDelayWithReconnect() throws Exception {
        byte[] WILL = RandomUtil.randomBytes();
        MqttClient client1 = this.createPahoClient("willConsumer");
        CountDownLatch latch = new CountDownLatch(1);
        client1.setCallback((MqttCallback)new MQTT5TestSupport.LatchedMqttCallback(this, latch));
        client1.connect();
        client1.subscribe("/topic/foo", 1);
        MqttClient client2 = this.createPahoClient("willGenerator");
        MqttProperties willMessageProperties = new MqttProperties();
        willMessageProperties.setWillDelayInterval(Long.valueOf(2L));
        MqttConnectionOptions options = new MqttConnectionOptionsBuilder().sessionExpiryInterval(Long.valueOf(2L)).will("/topic/foo", new MqttMessage(WILL)).build();
        options.setWillMessageProperties(willMessageProperties);
        client2.connect(options);
        client2.disconnectForcibly(0L, 0L, false);
        options = new MqttConnectionOptionsBuilder().cleanStart(false).will("/topic/foo", new MqttMessage(WILL)).build();
        client2.connect(options);
        Assertions.assertFalse((boolean)latch.await(2L, TimeUnit.SECONDS));
        client2.disconnect();
    }

    @Test
    @Timeout(value=60L)
    public void testWillFlagWithDisconnect() throws Exception {
        byte[] WILL = RandomUtil.randomBytes();
        MqttClient client1 = this.createPahoClient("willConsumer");
        CountDownLatch latch = new CountDownLatch(1);
        client1.setCallback((MqttCallback)new MQTT5TestSupport.LatchedMqttCallback(this, latch));
        client1.connect();
        client1.subscribe("/topic/foo", 1);
        MqttClient client2 = this.createPahoClient("willGenerator");
        MqttConnectionOptions options = new MqttConnectionOptionsBuilder().will("/topic/foo", new MqttMessage(WILL)).build();
        client2.connect(options);
        client2.disconnect();
        Assertions.assertFalse((boolean)latch.await(2L, TimeUnit.SECONDS));
    }

    @Test
    @Timeout(value=60L)
    public void testWillMessageRemovedOnceSent() throws Exception {
        String WILL_CONSUMER = RandomUtil.randomString();
        String WILL_SENDER = RandomUtil.randomString();
        byte[] WILL = RandomUtil.randomBytes();
        MqttClient willConsumer = this.createPahoClient(WILL_CONSUMER);
        CountDownLatch latch = new CountDownLatch(1);
        willConsumer.setCallback((MqttCallback)new MQTT5TestSupport.LatchedMqttCallback(this, latch));
        willConsumer.connect();
        willConsumer.subscribe("/topic/foo", 1);
        MqttClient willSender = this.createPahoClient(WILL_SENDER);
        MqttProperties willMessageProperties = new MqttProperties();
        willMessageProperties.setWillDelayInterval(Long.valueOf(1L));
        MqttConnectionOptions options = new MqttConnectionOptionsBuilder().sessionExpiryInterval(Long.valueOf(5L)).will("/topic/foo", new MqttMessage(WILL)).build();
        options.setWillMessageProperties(willMessageProperties);
        willSender.connect(options);
        MQTTSessionState state = this.getSessionStates().get(WILL_SENDER);
        Assertions.assertNotNull((Object)state);
        Assertions.assertNotNull((Object)state.getWillMessage());
        willSender.disconnectForcibly(0L, 0L, false);
        Assertions.assertTrue((boolean)latch.await(2L, TimeUnit.SECONDS));
        Assertions.assertNull((Object)state.getWillMessage());
    }

    @Test
    @Timeout(value=60L)
    public void testWillMessageRemovedOnDisconnect() throws Exception {
        String CLIENT_ID = RandomUtil.randomString();
        byte[] WILL = RandomUtil.randomBytes();
        MqttClient client = this.createPahoClient(CLIENT_ID);
        MqttConnectionOptions options = new MqttConnectionOptionsBuilder().will("/topic/foo", new MqttMessage(WILL)).build();
        client.connect(options);
        Assertions.assertNotNull((Object)this.getSessionStates().get(CLIENT_ID).getWillMessage());
        client.disconnect();
        Assertions.assertNull((Object)this.getSessionStates().get(CLIENT_ID));
    }

    @Test
    @Timeout(value=60L)
    public void testWillFlagWithRetain() throws Exception {
        String CLIENT_ID = RandomUtil.randomString();
        byte[] WILL = RandomUtil.randomBytes();
        MqttClient client = this.createPahoClient(CLIENT_ID);
        MqttConnectionOptions options = new MqttConnectionOptions();
        options.setWill("/topic/foo", new MqttMessage(WILL));
        MqttProperties willProperties = new MqttProperties();
        options.setWillMessageProperties(willProperties);
        client.connect(options);
        Assertions.assertEquals((int)1, (int)this.getSessionStates().size());
        Assertions.assertNotNull((Object)this.getSessionStates().get(CLIENT_ID));
        Assertions.assertTrue((boolean)this.getSessionStates().get(CLIENT_ID).isWill());
        Assertions.assertFalse((boolean)this.getSessionStates().get(CLIENT_ID).isWillRetain());
        client.disconnect();
    }

    @Test
    @Timeout(value=60L)
    public void testKeepAlive() throws Exception {
        MQTTInterceptor incomingInterceptor = (packet, connection) -> {
            if (packet.fixedHeader().messageType() == MqttMessageType.PINGREQ) {
                try {
                    logger.info("Caught PING so sleeping...");
                    Thread.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return true;
        };
        this.server.getRemotingService().addIncomingInterceptor((BaseInterceptor)incomingInterceptor);
        MqttClient client = this.createPahoClient(RandomUtil.randomString());
        MqttConnectionOptions options = new MqttConnectionOptions();
        options.setKeepAliveInterval(1);
        client.connect(options);
        Wait.assertEquals((int)0, () -> this.server.getConnectionCount(), (long)2000L, (long)100L);
    }

    @Test
    @Timeout(value=60L)
    public void testMaxPacketSize() throws Exception {
        String CONSUMER_ID = RandomUtil.randomString();
        String TOPIC = this.getTopicName();
        long SIZE = 1500L;
        byte[] bytes = new byte[1500];
        int i = 0;
        while ((long)i < 3000L) {
            bytes[0] = 0;
            ++i;
        }
        CountDownLatch latch = new CountDownLatch(1);
        MqttClient consumer = this.createPahoClient(CONSUMER_ID);
        MqttConnectionOptions options = new MqttConnectionOptionsBuilder().maximumPacketSize(Long.valueOf(1500L)).build();
        consumer.setCallback((MqttCallback)new MQTT5TestSupport.LatchedMqttCallback(this, latch));
        consumer.connect(options);
        consumer.subscribe(TOPIC, 2);
        MqttClient producer = this.createPahoClient(RandomUtil.randomString());
        producer.connect();
        producer.publish(TOPIC, bytes, 2, false);
        producer.disconnect();
        producer.close();
        Wait.assertEquals((Long)1L, () -> this.getSubscriptionQueue(TOPIC, CONSUMER_ID).getMessagesAdded(), (long)2000L, (long)100L);
        Assertions.assertFalse((boolean)latch.await(2L, TimeUnit.SECONDS));
        Wait.assertEquals((Long)1L, () -> this.getSubscriptionQueue(TOPIC, CONSUMER_ID).getMessagesAcknowledged(), (long)2000L, (long)100L);
        consumer.disconnect();
        consumer.close();
    }

    @Test
    @Timeout(value=60L)
    public void testTopicAliasDisabledOnClient() throws Exception {
        this.testTopicAliasOnClient(true);
    }

    @Test
    @Timeout(value=60L)
    public void testTopicAliasAbsentOnClient() throws Exception {
        this.testTopicAliasOnClient(true);
    }

    private void testTopicAliasOnClient(boolean disabled) throws Exception {
        String CONSUMER_ID = RandomUtil.randomString();
        String TOPIC = this.getTopicName();
        int MESSAGE_COUNT = 25;
        MqttClient consumer = this.createPahoClient(CONSUMER_ID);
        MqttConnectionOptions options = null;
        if (disabled) {
            options = new MqttConnectionOptionsBuilder().topicAliasMaximum(Integer.valueOf(0)).build();
        }
        consumer.connect(options);
        final CountDownLatch latch = new CountDownLatch(25);
        consumer.setCallback((MqttCallback)new MQTT5TestSupport.DefaultMqttCallback(){

            @Override
            public void messageArrived(String topic, MqttMessage message) throws Exception {
                Assertions.assertNull((Object)message.getProperties().getTopicAlias());
                latch.countDown();
            }
        });
        consumer.subscribe(TOPIC + "/#", 2);
        MqttClient producer = this.createPahoClient("producer");
        producer.connect();
        for (int i = 0; i < 25; ++i) {
            producer.publish(TOPIC + "/" + i, ("foo" + i).getBytes(StandardCharsets.UTF_8), 2, false);
        }
        producer.disconnect();
        producer.close();
        Assertions.assertTrue((boolean)latch.await(2L, TimeUnit.SECONDS));
        consumer.disconnect();
    }

    @Test
    @Timeout(value=60L)
    public void testUserPropertiesOrder() throws Exception {
        String CONSUMER_ID = RandomUtil.randomString();
        String TOPIC = this.getTopicName();
        int USER_PROPERTY_COUNT = 10;
        final ArrayList<UserProperty> userProperties = new ArrayList<UserProperty>();
        for (int i = 0; i < 10; ++i) {
            userProperties.add(new UserProperty(RandomUtil.randomString(), RandomUtil.randomString()));
        }
        final CountDownLatch latch = new CountDownLatch(1);
        MqttClient consumer = this.createPahoClient(CONSUMER_ID);
        consumer.connect();
        consumer.setCallback((MqttCallback)new MQTT5TestSupport.DefaultMqttCallback(){

            @Override
            public void messageArrived(String topic, MqttMessage message) throws Exception {
                List receivedUserProperties = message.getProperties().getUserProperties();
                for (int i = 0; i < 10; ++i) {
                    Assertions.assertEquals((Object)((UserProperty)userProperties.get(i)).getKey(), (Object)((UserProperty)receivedUserProperties.get(i)).getKey());
                    Assertions.assertEquals((Object)((UserProperty)userProperties.get(i)).getValue(), (Object)((UserProperty)receivedUserProperties.get(i)).getValue());
                }
                latch.countDown();
            }
        });
        consumer.subscribe(TOPIC, 2);
        MqttClient producer = this.createPahoClient("producer");
        producer.connect();
        MqttMessage m = new MqttMessage();
        m.setQos(2);
        MqttProperties properties = new MqttProperties();
        properties.setUserProperties(userProperties);
        m.setProperties(properties);
        producer.publish(TOPIC, m);
        producer.disconnect();
        producer.close();
        Assertions.assertTrue((boolean)latch.await(2L, TimeUnit.SECONDS));
        consumer.disconnect();
        consumer.close();
    }

    @Test
    @Timeout(value=60L)
    public void testClientID() throws Exception {
        String CLIENT_ID = RandomUtil.randomString();
        Assertions.assertEquals((int)0, (int)this.getSessionStates().size());
        MqttClient client = this.createPahoClient(CLIENT_ID);
        client.connect();
        Assertions.assertEquals((int)1, (int)this.getSessionStates().size());
        Assertions.assertNotNull((Object)this.getSessionStates().get(CLIENT_ID));
        client.disconnect();
    }

    @Test
    @Timeout(value=60L)
    public void testEmptyClientID() throws Exception {
        Assertions.assertEquals((int)0, (int)this.getSessionStates().size());
        MqttClient client = this.createPahoClient("");
        IMqttToken result = client.connectWithResult(null);
        Assertions.assertFalse((boolean)result.getSessionPresent());
        String assignedClientID = result.getResponseProperties().getAssignedClientIdentifier();
        Assertions.assertNotNull((Object)assignedClientID);
        Assertions.assertEquals((int)1, (int)this.getSessionStates().size());
        Assertions.assertNotNull((Object)this.getSessionStates().get(assignedClientID));
        client.disconnect();
    }

    @Test
    @Timeout(value=60L)
    public void testEmptyClientIDWithoutCleanStart() throws Exception {
        Assertions.assertEquals((int)0, (int)this.getSessionStates().size());
        MqttClient client = this.createPahoClient("");
        MqttConnectionOptions options = new MqttConnectionOptionsBuilder().cleanStart(false).build();
        try {
            client.connect(options);
            Assertions.fail((String)"Should throw exception about invalid client identifier");
        }
        catch (MqttException e) {
            Assertions.assertEquals((byte)-123, (byte)((byte)e.getReasonCode()));
        }
        Assertions.assertFalse((boolean)client.isConnected());
        Assertions.assertEquals((int)0, (int)this.getSessionStates().size());
    }

    @Test
    @Timeout(value=60L)
    public void testAuthenticationFailure() throws Exception {
        String CLIENT_ID = RandomUtil.randomString();
        MqttClient client = this.createPahoClient(CLIENT_ID);
        MqttConnectionOptions options = new MqttConnectionOptionsBuilder().username("bad").password("bad".getBytes(StandardCharsets.UTF_8)).build();
        client.connect(options);
        client.disconnect();
    }

    @Test
    @Timeout(value=60L)
    public void testConnectionStealing() throws Exception {
        String CLIENT_ID = RandomUtil.randomString();
        MqttClient client = this.createPahoClient(CLIENT_ID);
        client.connect();
        final int[] reasonCode = new int[1];
        final CountDownLatch disconnectedLatch = new CountDownLatch(1);
        client.setCallback((MqttCallback)new MQTT5TestSupport.LatchedMqttCallback(disconnectedLatch){

            @Override
            public void disconnected(MqttDisconnectResponse disconnectResponse) {
                reasonCode[0] = disconnectResponse.getReturnCode();
                disconnectedLatch.countDown();
            }

            @Override
            public void mqttErrorOccurred(MqttException exception) {
                exception.printStackTrace();
            }
        });
        MqttClient client2 = this.createPahoClient(CLIENT_ID);
        client2.connect();
        Assertions.assertTrue((boolean)disconnectedLatch.await(500L, TimeUnit.MILLISECONDS));
        Assertions.assertEquals((byte)-114, (byte)((byte)reasonCode[0]));
        Assertions.assertEquals((int)1, (int)this.getSessionStates().size());
        Assertions.assertNotNull((Object)this.getSessionStates().get(CLIENT_ID));
        Assertions.assertFalse((boolean)client.isConnected());
        client2.disconnect();
    }

    @Test
    @Timeout(value=60L)
    public void testConnectionStealingBy3_1_1() throws Exception {
        String CLIENT_ID = RandomUtil.randomString();
        MqttClient client = this.createPahoClient(CLIENT_ID);
        client.connect();
        final int[] reasonCode = new int[1];
        final CountDownLatch disconnectedLatch = new CountDownLatch(1);
        client.setCallback((MqttCallback)new MQTT5TestSupport.LatchedMqttCallback(disconnectedLatch){

            @Override
            public void disconnected(MqttDisconnectResponse disconnectResponse) {
                reasonCode[0] = disconnectResponse.getReturnCode();
                disconnectedLatch.countDown();
            }

            @Override
            public void mqttErrorOccurred(MqttException exception) {
                exception.printStackTrace();
            }
        });
        org.eclipse.paho.client.mqttv3.MqttClient client2 = this.createPaho3_1_1Client(CLIENT_ID);
        client2.connect();
        Assertions.assertTrue((boolean)disconnectedLatch.await(500L, TimeUnit.MILLISECONDS));
        Assertions.assertEquals((byte)-114, (byte)((byte)reasonCode[0]));
        Assertions.assertEquals((int)1, (int)this.getSessionStates().size());
        Assertions.assertNotNull((Object)this.getSessionStates().get(CLIENT_ID));
        Assertions.assertFalse((boolean)client.isConnected());
        client2.disconnect();
    }

    @Test
    @Timeout(value=60L)
    public void testConnackWhenCleanStartFalse() throws Exception {
        String CONSUMER_ID = RandomUtil.randomString();
        Assertions.assertEquals((int)0, (int)this.getSessionStates().size());
        MqttClient consumer = this.createPahoClient(CONSUMER_ID);
        MqttConnectionOptions options = new MqttConnectionOptionsBuilder().cleanStart(false).sessionExpiryInterval(Long.valueOf(MQTTUtil.FOUR_BYTE_INT_MAX)).build();
        IMqttToken result = consumer.connectWithResult(options);
        Assertions.assertFalse((boolean)result.getSessionPresent());
        Assertions.assertTrue((boolean)this.getListOfCodes(result.getResponse().getReasonCodes()).contains(0));
        consumer.disconnect();
        Assertions.assertEquals((int)1, (int)this.getSessionStates().size());
        Assertions.assertNotNull((Object)this.getSessionStates().get(CONSUMER_ID));
        result = consumer.connectWithResult(options);
        Assertions.assertTrue((boolean)result.getSessionPresent());
        Assertions.assertTrue((boolean)this.getListOfCodes(result.getResponse().getReasonCodes()).contains(0));
    }

    @Test
    @Timeout(value=60L)
    public void testConnackWhenCleanStartTrue() throws Exception {
        String CONSUMER_ID = RandomUtil.randomString();
        Assertions.assertEquals((int)0, (int)this.getSessionStates().size());
        MqttClient consumer = this.createPahoClient(CONSUMER_ID);
        MqttConnectionOptions options = new MqttConnectionOptionsBuilder().cleanStart(true).build();
        IMqttToken result = consumer.connectWithResult(options);
        Assertions.assertFalse((boolean)result.getSessionPresent());
        Assertions.assertTrue((boolean)this.getListOfCodes(result.getResponse().getReasonCodes()).contains(0));
        consumer.disconnect();
    }

    private List<Integer> getListOfCodes(int[] codes) {
        return IntStream.of(codes).boxed().collect(Collectors.toList());
    }

    @Test
    @Timeout(value=60L)
    public void testCleanStartFalse() throws Exception {
        String CONSUMER_ID = RandomUtil.randomString();
        Assertions.assertEquals((int)0, (int)this.getSessionStates().size());
        MqttClient consumer = this.createPahoClient(CONSUMER_ID);
        MqttConnectionOptions options = new MqttConnectionOptionsBuilder().cleanStart(false).build();
        consumer.connect(options);
        Assertions.assertEquals((int)1, (int)this.getSessionStates().size());
        Assertions.assertNotNull((Object)this.getSessionStates().get(CONSUMER_ID));
        consumer.disconnect();
    }

    @Test
    @Timeout(value=60L)
    public void testCleanStartFalseWithReconnect() throws Exception {
        String CONSUMER_ID = RandomUtil.randomString();
        String TOPIC = this.getTopicName();
        CountDownLatch latch = new CountDownLatch(1);
        MqttClient producer = this.createPahoClient(RandomUtil.randomString());
        MqttClient consumer = this.createPahoClient(CONSUMER_ID);
        MqttConnectionOptions options = new MqttConnectionOptionsBuilder().cleanStart(false).sessionExpiryInterval(Long.valueOf(300L)).build();
        consumer.connect(options);
        consumer.subscribe(TOPIC, 2);
        consumer.disconnect();
        Assertions.assertEquals((int)1, (int)this.getSessionStates().size());
        Assertions.assertNotNull((Object)this.getSessionStates().get(CONSUMER_ID));
        producer.connect();
        producer.publish(TOPIC, "hello".getBytes(), 2, false);
        producer.disconnect();
        producer.close();
        Assertions.assertEquals((int)1, (int)this.getSessionStates().size());
        Assertions.assertNotNull((Object)this.getSessionStates().get(CONSUMER_ID));
        consumer.setCallback((MqttCallback)new MQTT5TestSupport.LatchedMqttCallback(this, latch));
        consumer.connect(options);
        ConnectTests.waitForLatch(latch);
        consumer.disconnect();
        consumer.close();
        Assertions.assertEquals((int)1, (int)this.getSessionStates().size());
        Assertions.assertNotNull((Object)this.getSessionStates().get(CONSUMER_ID));
    }

    @Test
    @Timeout(value=60L)
    public void testCleanStartFalseWith0SessionExpiryInterval() throws Exception {
        String CONSUMER_ID = RandomUtil.randomString();
        String TOPIC = this.getTopicName();
        MqttClient consumer = this.createPahoClient(CONSUMER_ID);
        MqttConnectionOptions options = new MqttConnectionOptionsBuilder().cleanStart(false).sessionExpiryInterval(Long.valueOf(0L)).build();
        consumer.connect(options);
        consumer.subscribe(TOPIC, 2);
        consumer.disconnect();
        Assertions.assertEquals((int)0, (int)this.getSessionStates().size());
        Assertions.assertNull((Object)this.getSessionStates().get(CONSUMER_ID));
    }

    @Test
    @Timeout(value=60L)
    public void testCleanStartFalseWithNon0SessionExpiryInterval() throws Exception {
        String CONSUMER_ID = RandomUtil.randomString();
        String TOPIC = this.getTopicName();
        long EXPIRY_INTERVAL = 2L;
        MqttClient consumer = this.createPahoClient(CONSUMER_ID);
        MqttConnectionOptions options = new MqttConnectionOptionsBuilder().cleanStart(false).sessionExpiryInterval(Long.valueOf(2L)).build();
        consumer.connect(options);
        consumer.subscribe(TOPIC, 2);
        long start = System.currentTimeMillis();
        consumer.disconnect();
        Assertions.assertNotNull((Object)this.getSubscriptionQueue(TOPIC, CONSUMER_ID));
        Wait.assertEquals((int)0, () -> this.getSessionStates().size(), (long)4000L, (long)100L);
        Assertions.assertTrue((System.currentTimeMillis() - start >= 2000L ? (byte)1 : 0) != 0);
        Assertions.assertNull((Object)this.getSessionStates().get(CONSUMER_ID));
        Wait.assertTrue(() -> this.getSubscriptionQueue(TOPIC, CONSUMER_ID) == null, (long)2000L, (long)100L);
    }

    @Test
    @Timeout(value=60L)
    public void testCleanStartFalseWithAbsentSessionExpiryInterval() throws Exception {
        String CONSUMER_ID = RandomUtil.randomString();
        String TOPIC = this.getTopicName();
        MqttClient consumer = this.createPahoClient(CONSUMER_ID);
        MqttConnectionOptions options = new MqttConnectionOptionsBuilder().cleanStart(false).build();
        consumer.connect(options);
        consumer.subscribe(TOPIC, 2);
        consumer.disconnect();
        Assertions.assertEquals((int)0, (int)this.getSessionStates().size());
        Assertions.assertNull((Object)this.getSessionStates().get(CONSUMER_ID));
    }

    @Test
    @Timeout(value=60L)
    public void testCleanStartFalseWithMaxSessionExpiryInterval() throws Exception {
        String CONSUMER_ID = RandomUtil.randomString();
        String TOPIC = this.getTopicName();
        long EXPIRY_INTERVAL = 2000L;
        MqttClient consumer = this.createPahoClient(CONSUMER_ID);
        MqttConnectionOptions options = new MqttConnectionOptionsBuilder().cleanStart(false).sessionExpiryInterval(Long.valueOf(MQTTUtil.FOUR_BYTE_INT_MAX)).build();
        consumer.connect(options);
        consumer.subscribe(TOPIC, 2);
        consumer.disconnect();
        long start = System.currentTimeMillis();
        Assertions.assertFalse((boolean)Wait.waitFor(() -> this.getSessionStates().size() == 0, (long)4000L, (long)100L));
        Assertions.assertNotNull((Object)this.getSessionStates().get(CONSUMER_ID));
    }

    @Test
    @Timeout(value=60L)
    public void testCleanStartTrue() throws Exception {
        String CONSUMER_ID = RandomUtil.randomString();
        String TOPIC = this.getTopicName();
        CountDownLatch latch = new CountDownLatch(1);
        MqttClient producer = this.createPahoClient(RandomUtil.randomString());
        MqttClient consumer = this.createPahoClient(CONSUMER_ID);
        MqttConnectionOptions options = new MqttConnectionOptionsBuilder().cleanStart(false).sessionExpiryInterval(Long.valueOf(MQTTUtil.FOUR_BYTE_INT_MAX)).build();
        consumer.connect(options);
        consumer.subscribe(TOPIC, 2);
        consumer.disconnect();
        Assertions.assertEquals((int)1, (int)this.getSessionStates().size());
        Assertions.assertNotNull((Object)this.getSessionStates().get(CONSUMER_ID));
        producer.connect();
        producer.publish(TOPIC, "hello".getBytes(), 2, false);
        producer.disconnect();
        producer.close();
        options.setCleanStart(true);
        consumer.setCallback((MqttCallback)new MQTT5TestSupport.LatchedMqttCallback(this, latch));
        consumer.connect(options);
        Assertions.assertFalse((boolean)latch.await(3L, TimeUnit.SECONDS));
        consumer.disconnect();
        consumer.close();
    }
}

