/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire.amq;

import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.Session;
import java.util.Arrays;
import java.util.Collection;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.integration.openwire.BasicOpenWireTest;
import org.apache.activemq.command.ActiveMQDestination;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class JMSConsumer10Test
extends BasicOpenWireTest {
    public int deliveryMode;
    public int ackMode;
    public byte destinationType;

    @Parameters(name="deliveryMode={0} ackMode={1} destinationType={2}")
    public static Collection<Object[]> getParams() {
        return Arrays.asList({1, 1, (byte)1}, {1, 3, (byte)1}, {1, 2, (byte)1}, {2, 1, (byte)1}, {2, 3, (byte)1}, {2, 2, (byte)1});
    }

    public JMSConsumer10Test(int deliveryMode, int ackMode, byte destinationType) {
        this.deliveryMode = deliveryMode;
        this.ackMode = ackMode;
        this.destinationType = destinationType;
    }

    @TestTemplate
    public void testUnackedWithPrefetch1StayInQueue() throws Exception {
        int i;
        this.connection.getPrefetchPolicy().setAll(1);
        this.connection.start();
        Session session = this.connection.createSession(false, this.ackMode);
        ActiveMQDestination destination = this.createDestination(session, this.destinationType);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        this.sendMessages(session, (Destination)destination, 4);
        Message message = null;
        for (i = 0; i < 2; ++i) {
            message = consumer.receive(1000L);
            Assertions.assertNotNull((Object)message);
        }
        message.acknowledge();
        this.connection.close();
        this.connection = (ActiveMQConnection)this.factory.createConnection();
        this.connection.getPrefetchPolicy().setAll(1);
        this.connection.start();
        session = this.connection.createSession(false, this.ackMode);
        consumer = session.createConsumer((Destination)destination);
        for (i = 0; i < 2; ++i) {
            message = consumer.receive(1000L);
            Assertions.assertNotNull((Object)message);
        }
        message.acknowledge();
        Assertions.assertNull((Object)consumer.receiveNoWait());
    }
}

