/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.paging;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.logs.AssertionLoggerHandler;
import org.apache.activemq.artemis.tests.integration.paging.PageCountSyncServer;
import org.apache.activemq.artemis.tests.integration.paging.SpawnedServerSupport;
import org.apache.activemq.artemis.tests.util.SpawnedTestBase;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.apache.activemq.artemis.utils.Wait;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageCountSyncOnNonTXTest
extends SpawnedTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String WORD_START = "&*STARTED&*";
    private long timeToRun;
    Process process;
    private AssertionLoggerHandler loggerHandler;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.timeToRun = 5000L + (long)(RandomUtil.randomPositiveInt() % 1000);
        this.loggerHandler = new AssertionLoggerHandler();
    }

    @AfterEach
    public void checkLoggerEnd() throws Exception {
        if (this.loggerHandler != null) {
            try {
                Assertions.assertFalse((boolean)this.loggerHandler.findText(new String[]{"222214"}));
                Assertions.assertFalse((boolean)this.loggerHandler.findText(new String[]{"222215"}));
            }
            finally {
                this.loggerHandler.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSendNoTx() throws Exception {
        String QUEUE_NAME = "myQueue";
        CountDownLatch latch = new CountDownLatch(1);
        Runnable runnable = latch::countDown;
        this.process = PageCountSyncServer.spawnVMWithLogMacher(WORD_START, runnable, this.getTestDir(), this.timeToRun);
        Assertions.assertTrue((boolean)latch.await(30L, TimeUnit.SECONDS), (String)"Server didn't start in 30 seconds");
        ServerLocator locator = this.createNettyNonHALocator();
        try {
            locator = this.createNettyNonHALocator().setReconnectAttempts(0).setInitialConnectAttempts(10).setRetryInterval(500L).setBlockOnDurableSend(false);
            ClientSessionFactory factory = locator.createSessionFactory();
            ClientSession session = factory.createSession(true, true);
            session.createQueue(QueueConfiguration.of((String)QUEUE_NAME));
            ClientProducer producer = session.createProducer(QUEUE_NAME);
            ClientConsumer consumer = session.createConsumer(QUEUE_NAME);
            session.start();
            ClientSession sessionTransacted = factory.createSession(false, false);
            ClientProducer producerTransacted = sessionTransacted.createProducer(QUEUE_NAME);
            ClientConsumer consumerTransacted = sessionTransacted.createConsumer(QUEUE_NAME);
            sessionTransacted.start();
            long start = System.currentTimeMillis();
            long nmsgs = 0L;
            try {
                while (true) {
                    int size;
                    if ((size = RandomUtil.randomPositiveInt() % 1024) == 0) {
                        size = 1024;
                    }
                    ClientMessage msg = session.createMessage(true);
                    msg.getBodyBuffer().writeBytes(new byte[size]);
                    producer.send((Message)msg);
                    if (++nmsgs % 100L == 0L) {
                        producerTransacted.send((Message)msg);
                        for (int i = 0; i < 50; ++i) {
                            msg = consumerTransacted.receive(100L);
                            if (msg == null) continue;
                            msg.acknowledge();
                        }
                        sessionTransacted.commit();
                        msg = consumer.receive(100L);
                        if (msg != null) {
                            msg.acknowledge();
                        }
                    }
                    if (System.currentTimeMillis() - start <= this.timeToRun) continue;
                    session.commit();
                }
            }
            catch (Exception expected) {
                logger.info("expected exception {}", (Object)expected.toString(), (Object)expected);
                locator.close();
            }
        }
        catch (Throwable throwable) {
            locator.close();
            throw throwable;
        }
        Assertions.assertEquals((int)1, (int)this.process.waitFor(), (String)"Process didn't end as expected");
        ActiveMQServer server = SpawnedServerSupport.createServer(this.getTestDir());
        try {
            server.start();
            Wait.assertTrue(() -> ((ActiveMQServer)server).isActive());
            locator = this.createNettyNonHALocator();
            try {
                Queue queue = server.locateQueue(SimpleString.of((String)QUEUE_NAME));
                Assertions.assertNotNull((Object)queue);
                long msgs = this.getMessageCount(queue);
                ClientSessionFactory factory = locator.createSessionFactory();
                ClientSession session = factory.createSession(false, false);
                ClientConsumer consumer = session.createConsumer(QUEUE_NAME, false);
                session.start();
                int i = 0;
                while ((long)i < msgs) {
                    ClientMessage msg = consumer.receive(5000L);
                    Assertions.assertNotNull((Object)msg);
                    ++i;
                }
                Assertions.assertNull((Object)consumer.receiveImmediate());
                session.close();
            }
            finally {
                locator.close();
            }
        }
        finally {
            server.stop();
        }
    }
}

