/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.persistence;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DeleteQueueRestartTest
extends ActiveMQTestBase {
    private static final String ADDRESS = "ADDRESS";

    @Test
    public void testDeleteQueueAndRestart() throws Exception {
        for (int i = 0; i < 5; ++i) {
            this.setUp();
            this.internalDeleteQueueAndRestart();
            this.tearDown();
        }
    }

    private void internalDeleteQueueAndRestart() throws Exception {
        ActiveMQServer server = this.createServer(true);
        server.start();
        ServerLocator locator = this.createInVMNonHALocator().setBlockOnDurableSend(true).setBlockOnNonDurableSend(true).setMinLargeMessageSize(0x100000);
        ClientSessionFactory factory = this.createSessionFactory(locator);
        ClientSession session = factory.createSession(false, true, true);
        session.createQueue(QueueConfiguration.of((String)ADDRESS));
        ClientProducer prod = session.createProducer(ADDRESS);
        for (int i = 0; i < 100; ++i) {
            ClientMessage msg = this.createBytesMessage(session, (byte)4, new byte[0], true);
            prod.send((Message)msg);
        }
        CountDownLatch count = new CountDownLatch(1);
        new Thread(() -> {
            try {
                session.deleteQueue(ADDRESS);
                session.close();
                count.countDown();
            }
            catch (ActiveMQException activeMQException) {
                // empty catch block
            }
        }).start();
        Assertions.assertTrue((boolean)count.await(5L, TimeUnit.SECONDS));
        server.stop();
        server.start();
        server.stop();
    }
}

