/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.persistence;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.StoreConfiguration;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.JDBCJournalStorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.JournalStorageManager;
import org.apache.activemq.artemis.core.postoffice.PostOffice;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.impl.JournalLoader;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.unit.core.server.impl.fakes.FakeJournalLoader;
import org.apache.activemq.artemis.tests.unit.core.server.impl.fakes.FakePostOffice;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.ExecutorFactory;
import org.apache.activemq.artemis.utils.critical.CriticalAnalyzer;
import org.apache.activemq.artemis.utils.critical.EmptyCriticalAnalyzer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public abstract class StorageManagerTestBase
extends ActiveMQTestBase {
    protected ExecutorService executor;
    protected ExecutorFactory execFactory;
    protected ScheduledExecutorService scheduledExecutorService;
    protected StorageManager journal;
    protected StoreConfiguration.StoreType storeType;

    public StorageManagerTestBase(StoreConfiguration.StoreType storeType) {
        this.storeType = storeType;
    }

    @Parameters(name="storeType={0}")
    public static Collection<Object[]> data() {
        Object[][] params = new Object[][]{{StoreConfiguration.StoreType.FILE}, {StoreConfiguration.StoreType.DATABASE}};
        return Arrays.asList(params);
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.execFactory = this.getOrderedExecutor();
        this.scheduledExecutorService = new ScheduledThreadPoolExecutor(5);
        this.createStorage();
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        Exception exception = null;
        if (this.journal != null) {
            try {
                this.journal.stop();
            }
            catch (Exception e) {
                exception = e;
            }
            this.journal = null;
        }
        this.scheduledExecutorService.shutdown();
        super.tearDown();
        if (exception != null) {
            throw exception;
        }
    }

    protected void createStorage() throws Exception {
        this.journal = this.storeType == StoreConfiguration.StoreType.DATABASE ? this.createJDBCJournalStorageManager(this.createDefaultJDBCConfig(true)) : this.createJournalStorageManager(this.createDefaultInVMConfig());
        this.journal.start();
        this.journal.loadBindingJournal(new ArrayList(), new ArrayList(), new ArrayList());
        this.journal.loadMessageJournal((PostOffice)new FakePostOffice(), null, null, null, null, null, null, null, (JournalLoader)new FakeJournalLoader());
    }

    protected void rebootStorage() throws Exception {
        this.journal.stop();
        this.createStorage();
    }

    protected JournalStorageManager createJournalStorageManager(Configuration configuration) {
        JournalStorageManager jsm = new JournalStorageManager(configuration, (CriticalAnalyzer)EmptyCriticalAnalyzer.getInstance(), this.execFactory, this.execFactory);
        this.addActiveMQComponent((ActiveMQComponent)jsm);
        return jsm;
    }

    protected JDBCJournalStorageManager createJDBCJournalStorageManager(Configuration configuration) {
        JDBCJournalStorageManager jsm = new JDBCJournalStorageManager(configuration, (CriticalAnalyzer)EmptyCriticalAnalyzer.getInstance(), this.execFactory, this.execFactory, this.scheduledExecutorService);
        this.addActiveMQComponent((ActiveMQComponent)jsm);
        return jsm;
    }
}

