/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.persistence;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.JournalType;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.nativo.jlibaio.LibaioContext;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.Wait;
import org.apache.qpid.jms.JmsConnectionFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class SyncSendTest
extends ActiveMQTestBase {
    private static long totalRecordTime = -1L;
    private static final int RECORDS = 300;
    private static final int MEASURE_RECORDS = 100;
    private static final int WRAMP_UP = 100;
    private final String storage;
    private final String protocol;
    ActiveMQServer server;

    @Parameters(name="storage={0}, protocol={1}")
    public static Collection getParameters() {
        Object[] storages = new Object[]{"libaio", "nio", "null"};
        Object[] protocols = new Object[]{"core", "openwire", "amqp"};
        ArrayList<Object[]> objects = new ArrayList<Object[]>();
        for (Object s : storages) {
            if (s.equals("libaio") && !LibaioContext.isLoaded()) continue;
            for (Object p : protocols) {
                objects.add(new Object[]{s, p});
            }
        }
        return objects;
    }

    public SyncSendTest(String storage, String protocol) {
        this.storage = storage;
        this.protocol = protocol;
    }

    @Override
    protected ConfigurationImpl createBasicConfig(int serverID) {
        ConfigurationImpl config = super.createBasicConfig(serverID);
        config.setJournalDatasync(true).setJournalSyncNonTransactional(true).setJournalSyncTransactional(true);
        return config;
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.storage.equals("null") ? this.createServer(false, true) : this.createServer(true, true);
        if (this.storage.equals("libaio")) {
            this.server.getConfiguration().setJournalType(JournalType.ASYNCIO);
        } else {
            this.server.getConfiguration().setJournalType(JournalType.NIO);
        }
        this.server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setAutoCreateAddresses(Boolean.valueOf(false)).setAutoCreateQueues(Boolean.valueOf(false)));
        this.server.getConfiguration().setJournalSyncTransactional(true).setJournalSyncNonTransactional(true).setJournalDatasync(true);
        this.server.start();
    }

    private long getTimePerSync() throws Exception {
        if (this.storage.equals("null")) {
            return 0L;
        }
        if (totalRecordTime < 0L) {
            File measureFile = File.createTempFile("junit", null, this.temporaryFolder);
            System.out.println("File::" + measureFile);
            RandomAccessFile rfile = new RandomAccessFile(measureFile, "rw");
            FileChannel channel = rfile.getChannel();
            channel.position(0L);
            ByteBuffer buffer = ByteBuffer.allocate(10);
            buffer.put(new byte[10]);
            buffer.position(0);
            Assertions.assertEquals((int)10, (int)channel.write(buffer));
            channel.force(true);
            long time = System.nanoTime();
            for (int i = 0; i < 200; ++i) {
                if (i == 100) {
                    time = System.nanoTime();
                }
                channel.position(0L);
                buffer.position(0);
                buffer.putInt(i);
                buffer.position(0);
                Assertions.assertEquals((int)10, (int)channel.write(buffer));
                channel.force(false);
            }
            long timeEnd = System.nanoTime();
            totalRecordTime = (timeEnd - time) / 100L * 300L;
            System.out.println("total time = " + totalRecordTime);
        }
        return totalRecordTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    public void testSendConsumeAudoACK() throws Exception {
        long recordTime = this.getTimePerSync();
        this.server.createQueue(QueueConfiguration.of((String)"queue").setRoutingType(RoutingType.ANYCAST).setAutoCreateAddress(Boolean.valueOf(true)));
        ConnectionFactory factory = this.newCF();
        try (Connection connection = factory.createConnection();){
            Session session = connection.createSession(false, 1);
            jakarta.jms.Queue queue = session.createQueue("queue");
            MessageProducer producer = session.createProducer((Destination)queue);
            long start = System.nanoTime();
            for (int i = 0; i < 400; ++i) {
                if (i == 100) {
                    start = System.nanoTime();
                }
                producer.send(session.createMessage());
            }
            long end = System.nanoTime();
            System.out.println("end - start = " + (end - start) + " milliseconds = " + TimeUnit.NANOSECONDS.toMillis(end - start));
            System.out.println("RECORD TIME = " + recordTime + " milliseconds = " + TimeUnit.NANOSECONDS.toMillis(recordTime));
            if ((double)(end - start) < (double)recordTime * 0.7) {
                Assertions.fail((String)"Messages are being sent too fast! Faster than the disk would be able to sync!");
            }
            connection.start();
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            for (int i = 0; i < 400; ++i) {
                if (i == 100) {
                    start = System.nanoTime();
                }
                Message msg = consumer.receive(5000L);
                Assertions.assertNotNull((Object)msg);
            }
            end = System.nanoTime();
            System.out.println("end - start = " + (end - start) + " milliseconds = " + TimeUnit.NANOSECONDS.toMillis(end - start));
            System.out.println("RECORD TIME = " + recordTime + " milliseconds = " + TimeUnit.NANOSECONDS.toMillis(recordTime));
            if (!this.protocol.equals("amqp") && (double)(end - start) < (double)recordTime * 0.7) {
                Assertions.fail((String)"Messages are being acked too fast! Faster than the disk would be able to sync!");
            }
            Queue serverQueue = this.server.locateQueue(SimpleString.of((String)"queue"));
            Wait.assertEquals((long)0L, () -> ((Queue)serverQueue).getMessageCount());
            Wait.assertEquals((int)0, () -> ((Queue)serverQueue).getDeliveringCount());
        }
    }

    private ConnectionFactory newCF() {
        if (this.protocol.equals("core")) {
            org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory factory = new org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory();
            factory.setBlockOnAcknowledge(true);
            return factory;
        }
        if (this.protocol.equals("amqp")) {
            JmsConnectionFactory factory = new JmsConnectionFactory("amqp://localhost:61616");
            factory.setForceAsyncAcks(true);
            return factory;
        }
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("tcp://localhost:61616?wireFormat.cacheEnabled=true");
        cf.setSendAcksAsync(false);
        return cf;
    }
}

