/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.plugin;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.activemq.artemis.core.config.MetricsConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.metrics.plugins.SimpleMetricsPlugin;
import org.apache.activemq.artemis.tests.integration.plugin.MetricsPluginTest;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class CacheMetricsTest
extends ActiveMQTestBase {
    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
    }

    @Test
    public void testCacheMetricsEnabled() throws Exception {
        this.testCacheMetrics(true);
    }

    @Test
    public void testCacheMetricsDisabled() throws Exception {
        this.testCacheMetrics(false);
    }

    private void testCacheMetrics(boolean enabled) throws Exception {
        ActiveMQServer server = this.createServer(false, this.createDefaultInVMConfig().setSecurityEnabled(true).setMetricsConfiguration(new MetricsConfiguration().setPlugin(new SimpleMetricsPlugin().init(null)).setSecurityCaches(enabled)));
        server.start();
        ArrayList<Meter.Id> metersToMatch = new ArrayList<Meter.Id>();
        for (String cacheTagValue : Arrays.asList("authentication", "authorization")) {
            Tags defaultTags = Tags.of((Tag[])new Tag[]{Tag.of((String)"broker", (String)"localhost"), Tag.of((String)"cache", (String)cacheTagValue)});
            metersToMatch.add(new Meter.Id("cache.size", defaultTags, null, null, null));
            metersToMatch.add(new Meter.Id("cache.puts", defaultTags, null, null, null));
            metersToMatch.add(new Meter.Id("cache.gets", defaultTags.and(new Tag[]{Tag.of((String)"result", (String)"miss")}), null, null, null));
            metersToMatch.add(new Meter.Id("cache.gets", defaultTags.and(new Tag[]{Tag.of((String)"result", (String)"hit")}), null, null, null));
            metersToMatch.add(new Meter.Id("cache.evictions", defaultTags, null, null, null));
            metersToMatch.add(new Meter.Id("cache.eviction.weight", defaultTags, null, null, null));
        }
        Assertions.assertEquals((Object)enabled, (Object)MetricsPluginTest.getMetrics(server).keySet().containsAll(metersToMatch));
    }
}

