/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.plugin;

import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerBasePlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerResourcePlugin;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.core.transaction.impl.XidImpl;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceBrokerPluginTest
extends ActiveMQTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Map<String, AddressSettings> addressSettings = new HashMap<String, AddressSettings>();
    private ActiveMQServer server;
    private ClientSession clientSession;
    private ClientSessionFactory sessionFactory;
    private Configuration configuration;
    private ServerLocator locator;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.addressSettings.clear();
        this.configuration = this.createDefaultNettyConfig();
        this.server = this.createServer(true, this.configuration, -1, -1L, this.addressSettings);
        this.server.start();
        this.locator = this.createNettyNonHALocator();
        this.sessionFactory = this.createSessionFactory(this.locator);
        this.clientSession = this.addClientSession(this.sessionFactory.createSession(true, false, false));
    }

    @Test
    public void testXATransaction() throws Exception {
        CountDownLatch latch = new CountDownLatch(4);
        XidImpl clientXid = new XidImpl("XA_TEST".getBytes(), 1, UUIDGenerator.getInstance().generateStringUUID().getBytes());
        this.server.registerBrokerPlugin((ActiveMQServerBasePlugin)new ActiveMQServerResourcePlugin(){
            final /* synthetic */ Xid val$clientXid;
            final /* synthetic */ CountDownLatch val$latch;
            {
                this.val$clientXid = xid;
                this.val$latch = countDownLatch;
            }

            public void beforePutTransaction(Xid xid, Transaction tx, RemotingConnection remotingConnection) throws ActiveMQException {
                Assertions.assertEquals((Object)this.val$clientXid, (Object)xid);
                this.val$latch.countDown();
            }

            public void afterPutTransaction(Xid xid, Transaction tx, RemotingConnection remotingConnection) throws ActiveMQException {
                Assertions.assertEquals((Object)this.val$clientXid, (Object)xid);
                this.val$latch.countDown();
            }

            public void beforeRemoveTransaction(Xid xid, RemotingConnection remotingConnection) throws ActiveMQException {
                Assertions.assertEquals((Object)this.val$clientXid, (Object)xid);
                this.val$latch.countDown();
            }

            public void afterRemoveTransaction(Xid xid, RemotingConnection remotingConnection) throws ActiveMQException {
                Assertions.assertEquals((Object)this.val$clientXid, (Object)xid);
                this.val$latch.countDown();
            }
        });
        this.clientSession.start((Xid)clientXid, 0);
        this.clientSession.end((Xid)clientXid, 0x4000000);
        this.clientSession.commit((Xid)clientXid, true);
        Assertions.assertTrue((boolean)latch.await(100L, TimeUnit.MILLISECONDS));
    }

    @Test
    public void testXAClientsMisconfiguration() throws Exception {
        int JTA_FORMAT_ID = 131077;
        final CountDownLatch latch = new CountDownLatch(1);
        ClientSessionFactory sessionFactoryEx = this.createSessionFactory(this.locator);
        ClientSession clientSessionEx = sessionFactoryEx.createSession(true, false, false);
        this.server.registerBrokerPlugin((ActiveMQServerBasePlugin)new ActiveMQServerResourcePlugin(){
            private final ConcurrentMap<String, String> clients = new ConcurrentHashMap<String, String>();

            public void afterPutTransaction(Xid xid, Transaction tx, RemotingConnection remotingConnection) throws ActiveMQException {
                String nodeName;
                String clientAddress;
                if (xid.getFormatId() == 131077 && (clientAddress = this.clients.putIfAbsent(nodeName = new String(Arrays.copyOfRange(xid.getGlobalTransactionId(), 28, xid.getGlobalTransactionId().length), StandardCharsets.UTF_8), remotingConnection.getRemoteAddress())) != null && !clientAddress.equals(remotingConnection.getRemoteAddress())) {
                    latch.countDown();
                    logger.warn("Possible XA client misconfiguration. Two addresses with the same node name {}: {}/{}", new Object[]{nodeName, clientAddress, remotingConnection.getRemoteAddress()});
                }
            }
        });
        XidImpl xid = new XidImpl("XA_TEST".getBytes(), 131077, UUIDGenerator.getInstance().generateStringUUID().getBytes());
        this.clientSession.start((Xid)xid, 0);
        byte[] getGlobalTransactionIdEx = (byte[])xid.getGlobalTransactionId().clone();
        getGlobalTransactionIdEx[0] = (byte)(getGlobalTransactionIdEx[0] + 1);
        XidImpl xidEx = new XidImpl(xid.getBranchQualifier(), 131077, getGlobalTransactionIdEx);
        clientSessionEx.start((Xid)xidEx, 0);
        Assertions.assertTrue((boolean)latch.await(100L, TimeUnit.MILLISECONDS));
    }
}

