/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.routing;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicSubscriber;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.routing.ConnectionRouterConfiguration;
import org.apache.activemq.artemis.core.config.routing.NamedPropertyConfiguration;
import org.apache.activemq.artemis.core.protocol.openwire.OpenWireProtocolManagerFactory;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.server.routing.KeyType;
import org.apache.activemq.artemis.protocol.amqp.broker.ProtonProtocolManagerFactory;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManagerFactory;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.ClusterTestBase;
import org.apache.activemq.artemis.tests.integration.routing.RoutingTestBase;
import org.apache.activemq.artemis.utils.Wait;
import org.apache.qpid.jms.JmsConnectionFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class AutoClientIDShardClusterTest
extends RoutingTestBase {
    private final String protocol;
    final int numMessages = 50;
    AtomicInteger toSend = new AtomicInteger(50);
    Runnable producer = new Runnable(){
        final AtomicInteger producerSeq = new AtomicInteger();

        @Override
        public void run() {
            while (AutoClientIDShardClusterTest.this.toSend.get() > 0) {
                try {
                    ConnectionFactory connectionFactory = AutoClientIDShardClusterTest.this.createFactory(AutoClientIDShardClusterTest.this.protocol, "producer", "admin", "admin");
                    Connection connection = connectionFactory.createConnection();
                    try {
                        connection.start();
                        Session session = connection.createSession(false, 1);
                        try {
                            Topic topic = session.createTopic(AutoClientIDShardClusterTest.this.name);
                            MessageProducer producer = session.createProducer((Destination)topic);
                            try {
                                for (int i = 0; i < 10 && AutoClientIDShardClusterTest.this.toSend.get() > 0; ++i) {
                                    TextMessage message = session.createTextMessage();
                                    message.setIntProperty("SEQ", this.producerSeq.get() + 1);
                                    producer.send((Message)message);
                                    this.producerSeq.incrementAndGet();
                                    AutoClientIDShardClusterTest.this.toSend.decrementAndGet();
                                }
                                TimeUnit.MILLISECONDS.sleep(100L);
                            }
                            finally {
                                if (producer == null) continue;
                                producer.close();
                            }
                        }
                        finally {
                            if (session == null) continue;
                            session.close();
                        }
                    }
                    finally {
                        if (connection == null) continue;
                        connection.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    };

    @Parameters(name="protocol: {0}")
    public static Collection<Object[]> data() {
        String[] protocols = new String[]{"AMQP", "CORE", "OPENWIRE"};
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        for (String protocol : protocols) {
            data.add(new Object[]{protocol});
        }
        return data;
    }

    public AutoClientIDShardClusterTest(String protocol) {
        this.protocol = protocol;
    }

    protected void setupServers() throws Exception {
        for (int i = 0; i < 2; ++i) {
            this.setupPrimaryServer(i, true, ClusterTestBase.HAType.SharedNothingReplication, true, false);
            this.servers[i].addProtocolManagerFactory((ProtocolManagerFactory)new ProtonProtocolManagerFactory());
            this.servers[i].addProtocolManagerFactory((ProtocolManagerFactory)new OpenWireProtocolManagerFactory());
        }
        this.setupClusterConnection("cluster0", this.name, MessageLoadBalancingType.ON_DEMAND, 1, true, 0, 1);
        this.setupClusterConnection("cluster1", this.name, MessageLoadBalancingType.ON_DEMAND, 1, true, 1, 0);
        this.toSend.set(50);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    @Disabled(value="not totally reliable, but does show the root cause of the problem being solved")
    public void testWithoutOutSharding() throws Exception {
        this.setupServers();
        this.startServers(0, 1);
        DurableSub sub0 = new DurableSub("0");
        DurableSub sub1 = new DurableSub("1");
        ExecutorService executorService = Executors.newFixedThreadPool(3);
        try {
            executorService.submit(sub0);
            executorService.submit(sub1);
            Assertions.assertTrue((boolean)sub0.registered.await(20L, TimeUnit.SECONDS));
            Assertions.assertTrue((boolean)sub1.registered.await(20L, TimeUnit.SECONDS));
            Assertions.assertTrue((boolean)this.waitForBindings(this.servers[0], this.name, true, 2, -1, 10000L));
            Assertions.assertTrue((boolean)this.waitForBindings(this.servers[1], this.name, true, 2, -1, 10000L));
            Assertions.assertTrue((boolean)this.waitForBindings(this.servers[0], this.name, false, 2, -1, 10000L));
            Assertions.assertTrue((boolean)this.waitForBindings(this.servers[1], this.name, false, 2, -1, 10000L));
            executorService.submit(this.producer);
            Assertions.assertTrue((boolean)Wait.waitFor(() -> this.toSend.get() == 0), (String)"All sent");
            Assertions.assertTrue((boolean)Wait.waitFor(() -> sub0.maxReceived == 50), (String)"All received sub0");
            Assertions.assertTrue((boolean)Wait.waitFor(() -> sub1.maxReceived == 50), (String)"All received sub1");
            Assertions.assertTrue((sub0.orderShot.get() || sub1.orderShot.get() ? (byte)1 : 0) != 0);
            sub0.consumerDone.set(true);
            sub1.consumerDone.set(true);
            executorService.shutdown();
        }
        catch (Throwable throwable) {
            sub0.consumerDone.set(true);
            sub1.consumerDone.set(true);
            executorService.shutdown();
            this.stopServers(0, 1);
            throw throwable;
        }
        this.stopServers(0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    public void testWithConsistentHashClientIDModTwo() throws Exception {
        this.setupServers();
        this.addRouterWithClientIdConsistentHashMod();
        this.startServers(0, 1);
        DurableSub sub0 = new DurableSub("0");
        DurableSub sub1 = new DurableSub("1");
        ExecutorService executorService = Executors.newFixedThreadPool(3);
        try {
            executorService.submit(sub0);
            executorService.submit(sub1);
            Assertions.assertTrue((boolean)sub0.registered.await(5L, TimeUnit.SECONDS));
            Assertions.assertTrue((boolean)sub1.registered.await(5L, TimeUnit.SECONDS));
            Assertions.assertTrue((boolean)this.waitForBindings(this.servers[0], this.name, true, 1, 1, 2000L));
            Assertions.assertTrue((boolean)this.waitForBindings(this.servers[1], this.name, true, 1, 1, 2000L));
            Assertions.assertTrue((boolean)this.waitForBindings(this.servers[0], this.name, false, 1, 1, 10000L));
            Assertions.assertTrue((boolean)this.waitForBindings(this.servers[1], this.name, false, 1, 1, 10000L));
            executorService.submit(this.producer);
            Assertions.assertTrue((boolean)Wait.waitFor(() -> this.toSend.get() == 0), (String)"All sent");
            Assertions.assertTrue((boolean)Wait.waitFor(() -> sub0.maxReceived == 50), (String)"All received sub0");
            Assertions.assertTrue((boolean)Wait.waitFor(() -> sub1.maxReceived == 50), (String)"All received sub1");
            Assertions.assertFalse((sub0.orderShot.get() && sub1.orderShot.get() ? (byte)1 : 0) != 0);
            sub0.consumerDone.set(true);
            sub1.consumerDone.set(true);
            executorService.shutdown();
        }
        catch (Throwable throwable) {
            sub0.consumerDone.set(true);
            sub1.consumerDone.set(true);
            executorService.shutdown();
            this.stopServers(0, 1);
            throw throwable;
        }
        this.stopServers(0, 1);
    }

    private void addRouterWithClientIdConsistentHashMod() {
        int numberOfNodes = 2;
        for (int node = 0; node < 2; ++node) {
            Configuration configuration = this.servers[node].getConfiguration();
            ConnectionRouterConfiguration connectionRouterConfiguration = new ConnectionRouterConfiguration().setName("bb1");
            connectionRouterConfiguration.setKeyType(KeyType.CLIENT_ID).setLocalTargetFilter("NULL|" + node);
            NamedPropertyConfiguration polocyConfig = new NamedPropertyConfiguration();
            polocyConfig.setName("CONSISTENT_HASH_MODULO");
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("MODULO", String.valueOf(2));
            polocyConfig.setProperties(properties);
            connectionRouterConfiguration.setPolicyConfiguration(polocyConfig);
            configuration.setConnectionRouters(Collections.singletonList(connectionRouterConfiguration));
            TransportConfiguration acceptor = this.getDefaultServerAcceptor(node);
            acceptor.getParams().put("router", "bb1");
        }
    }

    protected ConnectionFactory createFactory(String protocol, String clientID, String user, String password) throws Exception {
        StringBuilder urlBuilder = new StringBuilder();
        switch (protocol) {
            case "CORE": {
                urlBuilder.append("(tcp://localhost:61616,tcp://localhost:61617)?connectionLoadBalancingPolicyClassName=org.apache.activemq.artemis.api.core.client.loadbalance.RandomConnectionLoadBalancingPolicy");
                urlBuilder.append("&clientID=");
                urlBuilder.append(clientID);
                return new org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory(urlBuilder.toString(), user, password);
            }
            case "AMQP": {
                urlBuilder.append("failover:(amqp://localhost:61616,amqp://localhost:61617)?failover.randomize=true");
                urlBuilder.append("&jms.clientID=");
                urlBuilder.append(clientID);
                return new JmsConnectionFactory(user, password, urlBuilder.toString());
            }
            case "OPENWIRE": {
                urlBuilder.append("failover:(tcp://localhost:61616,tcp://localhost:61617)?randomize=true&maxReconnectAttempts=0&startupMaxReconnectAttempts=0");
                urlBuilder.append("&jms.clientID=");
                urlBuilder.append(clientID);
                return new ActiveMQConnectionFactory(user, password, urlBuilder.toString());
            }
        }
        throw new IllegalStateException("Unexpected value: " + protocol);
    }

    class DurableSub
    implements Runnable {
        final String id;
        int receivedInOrder = -1;
        int lastReceived;
        int maxReceived;
        AtomicBoolean consumerDone = new AtomicBoolean();
        AtomicBoolean orderShot = new AtomicBoolean();
        CountDownLatch registered = new CountDownLatch(1);

        DurableSub(String id) {
            this.id = id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.consumerDone.get()) {
                try {
                    ConnectionFactory connectionFactory = AutoClientIDShardClusterTest.this.createFactory(AutoClientIDShardClusterTest.this.protocol, "ClientId-" + this.id, "admin", "admin");
                    Connection connection = null;
                    try {
                        connection = connectionFactory.createConnection();
                        connection.start();
                        Session session = connection.createSession(false, 1);
                        try {
                            Topic topic = session.createTopic(AutoClientIDShardClusterTest.this.name);
                            TopicSubscriber durableSubscriber = session.createDurableSubscriber(topic, "Sub-" + this.id);
                            try {
                                Message message;
                                this.registered.countDown();
                                for (int i = 0; i < 5 && (message = durableSubscriber.receive(500L)) != null; ++i) {
                                    this.lastReceived = message.getIntProperty("SEQ");
                                    if (this.lastReceived > this.maxReceived) {
                                        this.maxReceived = this.lastReceived;
                                    }
                                    if (this.receivedInOrder < 0) {
                                        this.receivedInOrder = this.lastReceived;
                                        continue;
                                    }
                                    if (this.receivedInOrder == this.lastReceived - 1) {
                                        ++this.receivedInOrder;
                                        continue;
                                    }
                                    if (!this.orderShot.get()) {
                                        System.err.println("Sub: " + this.id + ", received: out of order " + this.lastReceived + ", last in order: " + this.receivedInOrder);
                                    }
                                    this.orderShot.set(true);
                                }
                                TimeUnit.MILLISECONDS.sleep(500L);
                            }
                            finally {
                                if (durableSubscriber == null) continue;
                                durableSubscriber.close();
                            }
                        }
                        finally {
                            if (session == null) continue;
                            session.close();
                        }
                    }
                    finally {
                        if (connection == null) continue;
                        connection.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }
}

