/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.server;

import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.management.QueueControl;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.util.SingleServerTestBase;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TempQueueNamespaceTest
extends SingleServerTestBase {
    @Test
    public void testTempQueueNamespace() throws Exception {
        String TEMP_QUEUE_NAMESPACE = "temp";
        SimpleString DLA = RandomUtil.randomSimpleString();
        SimpleString EA = RandomUtil.randomSimpleString();
        int RING_SIZE = 10;
        this.server.getConfiguration().setTemporaryQueueNamespace("temp");
        this.server.getAddressSettingsRepository().addMatch("temp.#", (Object)new AddressSettings().setDefaultRingSize(10L).setDeadLetterAddress(DLA).setExpiryAddress(EA));
        SimpleString queue = RandomUtil.randomSimpleString();
        SimpleString address = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(false)).setTemporary(Boolean.valueOf(true)));
        QueueControl queueControl = (QueueControl)this.server.getManagementService().getResource("queue." + queue);
        Assertions.assertEquals((long)10L, (long)queueControl.getRingSize());
        Assertions.assertEquals((Object)DLA.toString(), (Object)queueControl.getDeadLetterAddress());
        Assertions.assertEquals((Object)EA.toString(), (Object)queueControl.getExpiryAddress());
        this.session.close();
    }

    @Test
    public void testTempQueueNamespaceNegative() throws Exception {
        SimpleString queue = RandomUtil.randomSimpleString();
        SimpleString address = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(false)).setTemporary(Boolean.valueOf(true)));
        Assertions.assertNotEquals((long)10L, (long)this.server.locateQueue(queue).getQueueConfiguration().getRingSize());
        this.session.close();
    }
}

