/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.ssl;

import java.lang.management.ManagementFactory;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import javax.management.MBeanServer;
import org.apache.activemq.artemis.api.core.ActiveMQNotConnectedException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.tests.integration.security.SecurityTest;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SslPEMTest
extends ActiveMQTestBase {
    private TransportConfiguration tc;
    private SimpleString QUEUE;

    @Test
    public void testPemKeyAndTrustStore() throws Exception {
        ClientSessionFactory producerSessionFactory;
        ServerLocator producerLocator;
        this.tc.getParams().put("sslEnabled", true);
        this.tc.getParams().put("keyStoreType", "PEM");
        this.tc.getParams().put("keyStorePath", "client-key-cert.pem");
        this.tc.getParams().put("port", "61617");
        try {
            producerLocator = this.addServerLocator(ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{this.tc}));
            producerSessionFactory = this.createSessionFactory(producerLocator);
            producerSessionFactory.createSession(false, true, true);
        }
        catch (ActiveMQNotConnectedException activeMQNotConnectedException) {
            // empty catch block
        }
        this.tc.getParams().put("trustStoreType", "PEM");
        this.tc.getParams().put("trustStorePath", "server-ca-cert.pem");
        producerLocator = this.addServerLocator(ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{this.tc}));
        producerSessionFactory = this.createSessionFactory(producerLocator);
        ClientSession producerSession = producerSessionFactory.createSession(false, true, true);
        producerSession.createQueue(QueueConfiguration.of((SimpleString)this.QUEUE).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = producerSession.createProducer(this.QUEUE);
        ClientMessage message = this.createTextMessage(producerSession, RandomUtil.randomString());
        producer.send((Message)message);
        ServerLocator consumerLocator = this.addServerLocator(ActiveMQClient.createServerLocator((String)"tcp://localhost:61616"));
        ClientSessionFactory consumerSessionFactory = this.createSessionFactory(consumerLocator);
        ClientSession consumerSession = consumerSessionFactory.createSession("consumer", "consumerPassword", false, true, true, consumerLocator.isPreAcknowledge(), consumerLocator.getAckBatchSize());
        ClientConsumer consumer = consumerSession.createConsumer(this.QUEUE);
        consumerSession.start();
        ClientMessage m = consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.QUEUE = SimpleString.of((String)this.getName());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("sslEnabled", true);
        params.put("keyStoreType", "PEMCFG");
        params.put("keyStorePath", "server-keystore.pemcfg");
        params.put("trustStoreType", "PEM");
        params.put("trustStorePath", "client-ca-cert.pem");
        params.put("needClientAuth", true);
        params.put("port", "61617");
        ConfigurationImpl config = this.createBasicConfig();
        config.addAcceptorConfiguration(new TransportConfiguration(NETTY_ACCEPTOR_FACTORY, params));
        config.addAcceptorConfiguration(new TransportConfiguration(NETTY_ACCEPTOR_FACTORY));
        config.setSecurityEnabled(true);
        ActiveMQJAASSecurityManager securityManager = new ActiveMQJAASSecurityManager("DualAuthenticationPropertiesLogin", "DualAuthenticationCertLogin");
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)config, (MBeanServer)ManagementFactory.getPlatformMBeanServer(), (ActiveMQSecurityManager)securityManager, (boolean)false));
        HierarchicalRepository securityRepository = server.getSecurityRepository();
        Role sendRole = new Role("producers", true, false, true, false, true, false, false, false, true, false, false, false);
        Role receiveRole = new Role("consumers", false, true, false, false, false, false, false, false, false, false, false, false);
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(sendRole);
        roles.add(receiveRole);
        securityRepository.addMatch(this.QUEUE.toString(), roles);
        server.start();
        this.waitForServerToStart(server);
        this.tc = new TransportConfiguration(NETTY_CONNECTOR_FACTORY);
    }

    static {
        URL resource;
        String path = System.getProperty("java.security.auth.login.config");
        if (path == null && (resource = SecurityTest.class.getClassLoader().getResource("login.config")) != null) {
            path = resource.getFile();
            System.setProperty("java.security.auth.login.config", path);
        }
    }
}

