/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.xa;

import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServer;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.management.QueueControl;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.StoreConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.transaction.impl.XidImpl;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.integration.management.ManagementControlHelper;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExtendWith(value={ParameterizedTestExtension.class})
public class BasicXaRecoveryTest
extends ActiveMQTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Map<String, AddressSettings> addressSettings = new HashMap<String, AddressSettings>();
    private ActiveMQServer server;
    private ClientSession clientSession;
    private ClientProducer clientProducer;
    private ClientConsumer clientConsumer;
    private ClientSessionFactory sessionFactory;
    private Configuration configuration;
    private final SimpleString atestq = SimpleString.of((String)"atestq");
    private ServerLocator locator;
    private MBeanServer mbeanServer;
    protected StoreConfiguration.StoreType storeType;

    public BasicXaRecoveryTest(StoreConfiguration.StoreType storeType) {
        this.storeType = storeType;
    }

    @Parameters(name="storeType={0}")
    public static Collection<Object[]> data() {
        Object[][] params = new Object[][]{{StoreConfiguration.StoreType.FILE}, {StoreConfiguration.StoreType.DATABASE}};
        return Arrays.asList(params);
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        if (this.storeType == StoreConfiguration.StoreType.DATABASE) {
            Object obj = Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
        }
        this.addressSettings.clear();
        this.configuration = this.storeType == StoreConfiguration.StoreType.DATABASE ? this.createDefaultJDBCConfig(true).setJMXManagementEnabled(true) : this.createDefaultInVMConfig().setJMXManagementEnabled(true);
        this.mbeanServer = this.createMBeanServer();
        this.server = this.createServer(true, this.configuration, -1, -1L, this.addressSettings);
        this.server.setMBeanServer(this.mbeanServer);
        this.server.start();
        this.createClients(true, false);
    }

    @TestTemplate
    public void testBasicSendWithCommit() throws Exception {
        this.testBasicSendWithCommit(false);
    }

    @TestTemplate
    public void testBasicSendWithCommitWithServerStopped() throws Exception {
        this.testBasicSendWithCommit(true);
    }

    @TestTemplate
    public void testBasicSendWithRollback() throws Exception {
        this.testBasicSendWithRollback(false);
    }

    @TestTemplate
    public void testBasicSendWithRollbackWithServerStopped() throws Exception {
        this.testBasicSendWithRollback(true);
    }

    @TestTemplate
    public void testMultipleBeforeSendWithCommit() throws Exception {
        this.testMultipleBeforeSendWithCommit(false);
    }

    @TestTemplate
    public void testMultipleBeforeSendWithCommitWithServerStopped() throws Exception {
        this.testMultipleBeforeSendWithCommit(true);
    }

    @TestTemplate
    public void testMultipleTxSendWithCommit() throws Exception {
        this.testMultipleTxSendWithCommit(false);
    }

    @TestTemplate
    public void testMultipleTxSendWithCommitWithServerStopped() throws Exception {
        this.testMultipleTxSendWithCommit(true);
    }

    @TestTemplate
    public void testMultipleTxSendWithRollback() throws Exception {
        this.testMultipleTxSendWithRollback(false);
    }

    @TestTemplate
    public void testMultipleTxSendWithRollbackWithServerStopped() throws Exception {
        this.testMultipleTxSendWithRollback(true);
    }

    @TestTemplate
    public void testMultipleTxSendWithCommitAndRollback() throws Exception {
        this.testMultipleTxSendWithCommitAndRollback(false);
    }

    @TestTemplate
    public void testMultipleTxSendWithCommitAndRollbackWithServerStopped() throws Exception {
        this.testMultipleTxSendWithCommitAndRollback(true);
    }

    @TestTemplate
    public void testMultipleTxSameXidSendWithCommit() throws Exception {
        this.testMultipleTxSameXidSendWithCommit(false);
    }

    @TestTemplate
    public void testMultipleTxSameXidSendWithCommitWithServerStopped() throws Exception {
        this.testMultipleTxSameXidSendWithCommit(true);
    }

    @TestTemplate
    public void testBasicReceiveWithCommit() throws Exception {
        this.testBasicReceiveWithCommit(false);
    }

    @TestTemplate
    public void testBasicReceiveWithCommitWithServerStopped() throws Exception {
        this.testBasicReceiveWithCommit(true);
    }

    @TestTemplate
    public void testBasicReceiveWithRollback() throws Exception {
        this.testBasicReceiveWithRollback(false);
    }

    @TestTemplate
    public void testBasicReceiveWithRollbackWithServerStopped() throws Exception {
        this.testBasicReceiveWithRollback(true);
    }

    @TestTemplate
    public void testMultipleTxReceiveWithCommit() throws Exception {
        this.testMultipleTxReceiveWithCommit(false);
    }

    @TestTemplate
    public void testMultipleTxReceiveWithCommitWithServerStopped() throws Exception {
        this.testMultipleTxReceiveWithCommit(true);
    }

    @TestTemplate
    public void testMultipleTxReceiveWithRollback() throws Exception {
        this.testMultipleTxReceiveWithRollback(false);
    }

    @TestTemplate
    public void testMultipleTxReceiveWithRollbackWithServerStopped() throws Exception {
        this.testMultipleTxReceiveWithRollback(true);
    }

    @TestTemplate
    public void testPagingServerRestarted() throws Exception {
        if (this.storeType == StoreConfiguration.StoreType.DATABASE) {
            return;
        }
        this.verifyPaging(true);
    }

    @TestTemplate
    public void testPaging() throws Exception {
        if (this.storeType == StoreConfiguration.StoreType.DATABASE) {
            return;
        }
        this.verifyPaging(false);
    }

    public void verifyPaging(boolean restartServer) throws Exception {
        if (this.storeType == StoreConfiguration.StoreType.DATABASE) {
            return;
        }
        XidImpl xid = new XidImpl("xa1".getBytes(), 1, UUIDGenerator.getInstance().generateStringUUID().getBytes());
        SimpleString pageQueue = SimpleString.of((String)"pagequeue");
        AddressSettings pageAddressSettings = new AddressSettings().setMaxSizeBytes(102400L).setPageSizeBytes(10240);
        this.addressSettings.put(pageQueue.toString(), pageAddressSettings);
        this.addSettings();
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)pageQueue));
        this.clientSession.start((Xid)xid, 0);
        ClientProducer pageProducer = this.clientSession.createProducer(pageQueue);
        for (int i = 0; i < 1000; ++i) {
            ClientMessage m = this.createBytesMessage(new byte[512], true);
            pageProducer.send((Message)m);
        }
        pageProducer.close();
        this.clientSession.end((Xid)xid, 0x4000000);
        this.clientSession.prepare((Xid)xid);
        logger.debug("*** stopping and restarting");
        if (restartServer) {
            this.stopAndRestartServer();
        } else {
            this.recreateClients();
        }
        Xid[] xids = this.clientSession.recover(0x1000000);
        Assertions.assertEquals((int)xids.length, (int)1);
        Assertions.assertEquals((int)xids[0].getFormatId(), (int)xid.getFormatId());
        ActiveMQTestBase.assertEqualsByteArrays(xids[0].getBranchQualifier(), xid.getBranchQualifier());
        ActiveMQTestBase.assertEqualsByteArrays(xids[0].getGlobalTransactionId(), xid.getGlobalTransactionId());
        this.clientSession.commit((Xid)xid, false);
        this.clientSession.close();
        this.clientSession = this.sessionFactory.createSession(false, false, false);
        this.clientSession.start();
        ClientConsumer pageConsumer = this.clientSession.createConsumer(pageQueue);
        for (int i = 0; i < 1000; ++i) {
            ClientMessage m = pageConsumer.receive(10000L);
            Assertions.assertNotNull((Object)m);
            m.acknowledge();
            this.clientSession.commit();
        }
        Assertions.assertNull((Object)pageConsumer.receiveImmediate());
    }

    @TestTemplate
    public void testRollbackPaging() throws Exception {
        if (this.storeType == StoreConfiguration.StoreType.DATABASE) {
            return;
        }
        this.testRollbackPaging(false);
    }

    @TestTemplate
    public void testRollbackPagingServerRestarted() throws Exception {
        if (this.storeType == StoreConfiguration.StoreType.DATABASE) {
            return;
        }
        this.testRollbackPaging(true);
    }

    public void testRollbackPaging(boolean restartServer) throws Exception {
        XidImpl xid = new XidImpl("xa1".getBytes(), 1, UUIDGenerator.getInstance().generateStringUUID().getBytes());
        SimpleString pageQueue = SimpleString.of((String)"pagequeue");
        AddressSettings pageAddressSettings = new AddressSettings().setMaxSizeBytes(102400L).setPageSizeBytes(10240);
        this.addressSettings.put(pageQueue.toString(), pageAddressSettings);
        this.addSettings();
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)pageQueue));
        this.clientSession.start((Xid)xid, 0);
        ClientProducer pageProducer = this.clientSession.createProducer(pageQueue);
        for (int i = 0; i < 1000; ++i) {
            ClientMessage m = this.createBytesMessage(new byte[512], true);
            pageProducer.send((Message)m);
        }
        this.clientSession.end((Xid)xid, 0x4000000);
        this.clientSession.prepare((Xid)xid);
        if (restartServer) {
            this.stopAndRestartServer();
        } else {
            this.recreateClients();
        }
        Xid[] xids = this.clientSession.recover(0x1000000);
        Assertions.assertEquals((int)1, (int)xids.length);
        Assertions.assertEquals((int)xids[0].getFormatId(), (int)xid.getFormatId());
        ActiveMQTestBase.assertEqualsByteArrays(xids[0].getBranchQualifier(), xid.getBranchQualifier());
        ActiveMQTestBase.assertEqualsByteArrays(xids[0].getGlobalTransactionId(), xid.getGlobalTransactionId());
        this.clientSession.rollback((Xid)xid);
        this.clientSession.start();
        ClientConsumer pageConsumer = this.clientSession.createConsumer(pageQueue);
        Assertions.assertNull((Object)pageConsumer.receiveImmediate());
    }

    @TestTemplate
    public void testNonPersistent() throws Exception {
        this.testNonPersistent(true);
        this.testNonPersistent(false);
    }

    public void testNonPersistent(boolean commit) throws Exception {
        XidImpl xid = new XidImpl("xa1".getBytes(), 1, UUIDGenerator.getInstance().generateStringUUID().getBytes());
        ClientMessage m1 = this.createTextMessage("m1", false);
        ClientMessage m2 = this.createTextMessage("m2", false);
        ClientMessage m3 = this.createTextMessage("m3", false);
        ClientMessage m4 = this.createTextMessage("m4", false);
        this.clientSession.start((Xid)xid, 0);
        this.clientProducer.send((Message)m1);
        this.clientProducer.send((Message)m2);
        this.clientProducer.send((Message)m3);
        this.clientProducer.send((Message)m4);
        this.clientSession.end((Xid)xid, 0x4000000);
        this.clientSession.prepare((Xid)xid);
        this.stopAndRestartServer();
        Xid[] xids = this.clientSession.recover(0x1000000);
        Assertions.assertEquals((int)xids.length, (int)1);
        Assertions.assertEquals((int)xids[0].getFormatId(), (int)xid.getFormatId());
        ActiveMQTestBase.assertEqualsByteArrays(xids[0].getBranchQualifier(), xid.getBranchQualifier());
        ActiveMQTestBase.assertEqualsByteArrays(xids[0].getGlobalTransactionId(), xid.getGlobalTransactionId());
        xids = this.clientSession.recover(0x800000);
        Assertions.assertEquals((int)xids.length, (int)0);
        if (commit) {
            this.clientSession.commit((Xid)xid, false);
        } else {
            this.clientSession.rollback((Xid)xid);
        }
        xids = this.clientSession.recover(0x1000000);
        Assertions.assertEquals((int)xids.length, (int)0);
    }

    @TestTemplate
    public void testNonPersistentMultipleIDs() throws Exception {
        for (int i = 0; i < 10; ++i) {
            XidImpl xid = new XidImpl("xa1".getBytes(), 1, UUIDGenerator.getInstance().generateStringUUID().getBytes());
            ClientMessage m1 = this.createTextMessage("m1", false);
            ClientMessage m2 = this.createTextMessage("m2", false);
            ClientMessage m3 = this.createTextMessage("m3", false);
            ClientMessage m4 = this.createTextMessage("m4", false);
            this.clientSession.start((Xid)xid, 0);
            this.clientProducer.send((Message)m1);
            this.clientProducer.send((Message)m2);
            this.clientProducer.send((Message)m3);
            this.clientProducer.send((Message)m4);
            this.clientSession.end((Xid)xid, 0x4000000);
            this.clientSession.prepare((Xid)xid);
            if (i == 2) {
                this.clientSession.commit((Xid)xid, false);
            }
            this.recreateClients();
        }
        this.stopAndRestartServer();
        Xid[] xids = this.clientSession.recover(0x1000000);
        Assertions.assertEquals((int)9, (int)xids.length);
    }

    public void testBasicSendWithCommit(boolean stopServer) throws Exception {
        XidImpl xid = new XidImpl("xa1".getBytes(), 1, UUIDGenerator.getInstance().generateStringUUID().getBytes());
        ClientMessage m1 = this.createTextMessage("m1");
        ClientMessage m2 = this.createTextMessage("m2");
        ClientMessage m3 = this.createTextMessage("m3");
        ClientMessage m4 = this.createTextMessage("m4");
        this.clientSession.start((Xid)xid, 0);
        this.clientProducer.send((Message)m1);
        this.clientProducer.send((Message)m2);
        this.clientProducer.send((Message)m3);
        this.clientProducer.send((Message)m4);
        this.clientSession.end((Xid)xid, 0x4000000);
        this.clientSession.prepare((Xid)xid);
        if (stopServer) {
            this.stopAndRestartServer();
        } else {
            this.recreateClients();
        }
        Xid[] xids = this.clientSession.recover(0x1000000);
        Assertions.assertEquals((int)xids.length, (int)1);
        Assertions.assertEquals((int)xids[0].getFormatId(), (int)xid.getFormatId());
        ActiveMQTestBase.assertEqualsByteArrays(xids[0].getBranchQualifier(), xid.getBranchQualifier());
        ActiveMQTestBase.assertEqualsByteArrays(xids[0].getGlobalTransactionId(), xid.getGlobalTransactionId());
        xids = this.clientSession.recover(0x800000);
        Assertions.assertEquals((int)xids.length, (int)0);
        this.clientSession.commit((Xid)xid, false);
        this.clientSession.start();
        ClientMessage m = this.clientConsumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m1");
        m = this.clientConsumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m2");
        m = this.clientConsumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m3");
        m = this.clientConsumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m4");
    }

    public void testBasicSendWithRollback(boolean stopServer) throws Exception {
        XidImpl xid = new XidImpl("xa1".getBytes(), 1, UUIDGenerator.getInstance().generateStringUUID().getBytes());
        ClientMessage m1 = this.createTextMessage("m1");
        ClientMessage m2 = this.createTextMessage("m2");
        ClientMessage m3 = this.createTextMessage("m3");
        ClientMessage m4 = this.createTextMessage("m4");
        this.clientSession.start((Xid)xid, 0);
        this.clientProducer.send((Message)m1);
        this.clientProducer.send((Message)m2);
        this.clientProducer.send((Message)m3);
        this.clientProducer.send((Message)m4);
        this.clientSession.end((Xid)xid, 0x4000000);
        this.clientSession.prepare((Xid)xid);
        logger.debug("shutting down server");
        if (stopServer) {
            this.stopAndRestartServer();
        } else {
            this.recreateClients();
        }
        logger.debug("restarted");
        Xid[] xids = this.clientSession.recover(0x1000000);
        Assertions.assertEquals((int)xids.length, (int)1);
        Assertions.assertEquals((int)xids[0].getFormatId(), (int)xid.getFormatId());
        ActiveMQTestBase.assertEqualsByteArrays(xids[0].getBranchQualifier(), xid.getBranchQualifier());
        ActiveMQTestBase.assertEqualsByteArrays(xids[0].getGlobalTransactionId(), xid.getGlobalTransactionId());
        xids = this.clientSession.recover(0x800000);
        Assertions.assertEquals((int)xids.length, (int)0);
        this.clientSession.rollback((Xid)xid);
        this.clientSession.start();
        ClientMessage m = this.clientConsumer.receiveImmediate();
        Assertions.assertNull((Object)m);
    }

    public void testMultipleBeforeSendWithCommit(boolean stopServer) throws Exception {
        XidImpl xid = new XidImpl("xa1".getBytes(), 1, UUIDGenerator.getInstance().generateStringUUID().getBytes());
        ClientMessage m1 = this.createTextMessage("m1");
        ClientMessage m2 = this.createTextMessage("m2");
        ClientMessage m3 = this.createTextMessage("m3");
        ClientMessage m4 = this.createTextMessage("m4");
        ClientMessage m5 = this.createTextMessage("m5");
        ClientMessage m6 = this.createTextMessage("m6");
        ClientMessage m7 = this.createTextMessage("m7");
        ClientMessage m8 = this.createTextMessage("m8");
        ClientSession clientSession2 = this.sessionFactory.createSession(false, false, true);
        ClientProducer clientProducer2 = clientSession2.createProducer(this.atestq);
        clientProducer2.send((Message)m1);
        clientProducer2.send((Message)m2);
        clientProducer2.send((Message)m3);
        clientProducer2.send((Message)m4);
        clientSession2.close();
        this.clientSession.start((Xid)xid, 0);
        this.clientProducer.send((Message)m5);
        this.clientProducer.send((Message)m6);
        this.clientProducer.send((Message)m7);
        this.clientProducer.send((Message)m8);
        this.clientSession.end((Xid)xid, 0x4000000);
        this.clientSession.prepare((Xid)xid);
        if (stopServer) {
            this.stopAndRestartServer();
        } else {
            this.recreateClients();
        }
        Xid[] xids = this.clientSession.recover(0x1000000);
        Assertions.assertEquals((int)xids.length, (int)1);
        Assertions.assertEquals((int)xids[0].getFormatId(), (int)xid.getFormatId());
        ActiveMQTestBase.assertEqualsByteArrays(xids[0].getBranchQualifier(), xid.getBranchQualifier());
        ActiveMQTestBase.assertEqualsByteArrays(xids[0].getGlobalTransactionId(), xid.getGlobalTransactionId());
        xids = this.clientSession.recover(0x800000);
        Assertions.assertEquals((int)xids.length, (int)0);
        this.clientSession.commit((Xid)xid, false);
        this.clientSession.start();
        ClientMessage m = this.clientConsumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m5");
        m = this.clientConsumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m6");
        m = this.clientConsumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m7");
        m = this.clientConsumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m8");
    }

    public void testMultipleTxSendWithCommit(boolean stopServer) throws Exception {
        XidImpl xid = new XidImpl("xa1".getBytes(), 1, UUIDGenerator.getInstance().generateStringUUID().getBytes());
        XidImpl xid2 = new XidImpl("xa2".getBytes(), 1, UUIDGenerator.getInstance().generateStringUUID().getBytes());
        ClientMessage m1 = this.createTextMessage("m1");
        ClientMessage m2 = this.createTextMessage("m2");
        ClientMessage m3 = this.createTextMessage("m3");
        ClientMessage m4 = this.createTextMessage("m4");
        ClientMessage m5 = this.createTextMessage("m5");
        ClientMessage m6 = this.createTextMessage("m6");
        ClientMessage m7 = this.createTextMessage("m7");
        ClientMessage m8 = this.createTextMessage("m8");
        ClientSession clientSession2 = this.sessionFactory.createSession(true, false, true);
        ClientProducer clientProducer2 = clientSession2.createProducer(this.atestq);
        clientSession2.start((Xid)xid2, 0);
        clientProducer2.send((Message)m1);
        clientProducer2.send((Message)m2);
        clientProducer2.send((Message)m3);
        clientProducer2.send((Message)m4);
        clientSession2.end((Xid)xid2, 0x4000000);
        clientSession2.prepare((Xid)xid2);
        clientSession2.close();
        this.clientSession.start((Xid)xid, 0);
        this.clientProducer.send((Message)m5);
        this.clientProducer.send((Message)m6);
        this.clientProducer.send((Message)m7);
        this.clientProducer.send((Message)m8);
        this.clientSession.end((Xid)xid, 0x4000000);
        this.clientSession.prepare((Xid)xid);
        if (stopServer) {
            this.stopAndRestartServer();
        } else {
            this.recreateClients();
        }
        Xid[] xids = this.clientSession.recover(0x1000000);
        Assertions.assertEquals((int)xids.length, (int)2);
        this.assertEqualXids(xids, new Xid[]{xid, xid2});
        xids = this.clientSession.recover(0x800000);
        Assertions.assertEquals((int)xids.length, (int)0);
        this.clientSession.commit((Xid)xid, false);
        this.clientSession.commit((Xid)xid2, false);
        this.clientSession.start();
        ClientMessage m = this.clientConsumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m5");
        m = this.clientConsumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m6");
        m = this.clientConsumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m7");
        m = this.clientConsumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m8");
        m = this.clientConsumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m1");
        m = this.clientConsumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m2");
        m = this.clientConsumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m3");
        m = this.clientConsumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m4");
    }

    public void testMultipleTxSendWithRollback(boolean stopServer) throws Exception {
        XidImpl xid = new XidImpl("xa1".getBytes(), 1, UUIDGenerator.getInstance().generateStringUUID().getBytes());
        XidImpl xid2 = new XidImpl("xa2".getBytes(), 1, UUIDGenerator.getInstance().generateStringUUID().getBytes());
        ClientMessage m1 = this.createTextMessage("m1");
        ClientMessage m2 = this.createTextMessage("m2");
        ClientMessage m3 = this.createTextMessage("m3");
        ClientMessage m4 = this.createTextMessage("m4");
        ClientMessage m5 = this.createTextMessage("m5");
        ClientMessage m6 = this.createTextMessage("m6");
        ClientMessage m7 = this.createTextMessage("m7");
        ClientMessage m8 = this.createTextMessage("m8");
        ClientSession clientSession2 = this.sessionFactory.createSession(true, false, true);
        ClientProducer clientProducer2 = clientSession2.createProducer(this.atestq);
        clientSession2.start((Xid)xid2, 0);
        clientProducer2.send((Message)m1);
        clientProducer2.send((Message)m2);
        clientProducer2.send((Message)m3);
        clientProducer2.send((Message)m4);
        clientSession2.end((Xid)xid2, 0x4000000);
        clientSession2.prepare((Xid)xid2);
        clientSession2.close();
        this.clientSession.start((Xid)xid, 0);
        this.clientProducer.send((Message)m5);
        this.clientProducer.send((Message)m6);
        this.clientProducer.send((Message)m7);
        this.clientProducer.send((Message)m8);
        this.clientSession.end((Xid)xid, 0x4000000);
        this.clientSession.prepare((Xid)xid);
        if (stopServer) {
            this.stopAndRestartServer();
        } else {
            this.recreateClients();
        }
        Xid[] xids = this.clientSession.recover(0x1000000);
        Assertions.assertEquals((int)xids.length, (int)2);
        this.assertEqualXids(xids, new Xid[]{xid, xid2});
        xids = this.clientSession.recover(0x800000);
        Assertions.assertEquals((int)xids.length, (int)0);
        this.clientSession.rollback((Xid)xid);
        this.clientSession.rollback((Xid)xid2);
        this.clientSession.start();
        ClientMessage m = this.clientConsumer.receiveImmediate();
        Assertions.assertNull((Object)m);
    }

    public void testMultipleTxSendWithCommitAndRollback(boolean stopServer) throws Exception {
        XidImpl xid = new XidImpl("xa1".getBytes(), 1, UUIDGenerator.getInstance().generateStringUUID().getBytes());
        XidImpl xid2 = new XidImpl("xa2".getBytes(), 1, UUIDGenerator.getInstance().generateStringUUID().getBytes());
        ClientMessage m1 = this.createTextMessage("m1");
        ClientMessage m2 = this.createTextMessage("m2");
        ClientMessage m3 = this.createTextMessage("m3");
        ClientMessage m4 = this.createTextMessage("m4");
        ClientMessage m5 = this.createTextMessage("m5");
        ClientMessage m6 = this.createTextMessage("m6");
        ClientMessage m7 = this.createTextMessage("m7");
        ClientMessage m8 = this.createTextMessage("m8");
        ClientSession clientSession2 = this.sessionFactory.createSession(true, false, true);
        ClientProducer clientProducer2 = clientSession2.createProducer(this.atestq);
        clientSession2.start((Xid)xid2, 0);
        clientProducer2.send((Message)m1);
        clientProducer2.send((Message)m2);
        clientProducer2.send((Message)m3);
        clientProducer2.send((Message)m4);
        clientSession2.end((Xid)xid2, 0x4000000);
        clientSession2.prepare((Xid)xid2);
        clientSession2.close();
        this.clientSession.start((Xid)xid, 0);
        this.clientProducer.send((Message)m5);
        this.clientProducer.send((Message)m6);
        this.clientProducer.send((Message)m7);
        this.clientProducer.send((Message)m8);
        this.clientSession.end((Xid)xid, 0x4000000);
        this.clientSession.prepare((Xid)xid);
        if (stopServer) {
            this.stopAndRestartServer();
        } else {
            this.recreateClients();
        }
        Xid[] xids = this.clientSession.recover(0x1000000);
        Assertions.assertEquals((int)xids.length, (int)2);
        this.assertEqualXids(xids, new Xid[]{xid, xid2});
        xids = this.clientSession.recover(0x800000);
        Assertions.assertEquals((int)xids.length, (int)0);
        this.clientSession.rollback((Xid)xid);
        this.clientSession.commit((Xid)xid2, false);
        this.clientSession.start();
        ClientMessage m = this.clientConsumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m1");
        m = this.clientConsumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m2");
        m = this.clientConsumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m3");
        m = this.clientConsumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m4");
        m = this.clientConsumer.receiveImmediate();
        Assertions.assertNull((Object)m);
    }

    public void testMultipleTxSameXidSendWithCommit(boolean stopServer) throws Exception {
        XidImpl xid = new XidImpl("xa1".getBytes(), 1, UUIDGenerator.getInstance().generateStringUUID().getBytes());
        ClientMessage m1 = this.createTextMessage("m1");
        ClientMessage m2 = this.createTextMessage("m2");
        ClientMessage m3 = this.createTextMessage("m3");
        ClientMessage m4 = this.createTextMessage("m4");
        ClientMessage m5 = this.createTextMessage("m5");
        ClientMessage m6 = this.createTextMessage("m6");
        ClientMessage m7 = this.createTextMessage("m7");
        ClientMessage m8 = this.createTextMessage("m8");
        ClientSession clientSession2 = this.sessionFactory.createSession(true, false, true);
        ClientProducer clientProducer2 = clientSession2.createProducer(this.atestq);
        clientSession2.start((Xid)xid, 0);
        clientProducer2.send((Message)m1);
        clientProducer2.send((Message)m2);
        clientProducer2.send((Message)m3);
        clientProducer2.send((Message)m4);
        clientSession2.end((Xid)xid, 0x4000000);
        clientSession2.close();
        this.clientSession.start((Xid)xid, 0x200000);
        this.clientProducer.send((Message)m5);
        this.clientProducer.send((Message)m6);
        this.clientProducer.send((Message)m7);
        this.clientProducer.send((Message)m8);
        this.clientSession.end((Xid)xid, 0x4000000);
        this.clientSession.prepare((Xid)xid);
        if (stopServer) {
            this.stopAndRestartServer();
        } else {
            this.recreateClients();
        }
        Xid[] xids = this.clientSession.recover(0x1000000);
        Assertions.assertEquals((int)xids.length, (int)1);
        Assertions.assertEquals((int)xids[0].getFormatId(), (int)xid.getFormatId());
        ActiveMQTestBase.assertEqualsByteArrays(xids[0].getBranchQualifier(), xid.getBranchQualifier());
        ActiveMQTestBase.assertEqualsByteArrays(xids[0].getGlobalTransactionId(), xid.getGlobalTransactionId());
        xids = this.clientSession.recover(0x800000);
        Assertions.assertEquals((int)xids.length, (int)0);
        this.clientSession.commit((Xid)xid, false);
        this.clientSession.start();
        ClientMessage m = this.clientConsumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m1");
        m = this.clientConsumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m2");
        m = this.clientConsumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m3");
        m = this.clientConsumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m4");
        m = this.clientConsumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m5");
        m = this.clientConsumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m6");
        m = this.clientConsumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m7");
        m = this.clientConsumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m8");
    }

    public void testBasicReceiveWithCommit(boolean stopServer) throws Exception {
        XidImpl xid = new XidImpl("xa1".getBytes(), 1, UUIDGenerator.getInstance().generateStringUUID().getBytes());
        ClientMessage m1 = this.createTextMessage("m1");
        ClientMessage m2 = this.createTextMessage("m2");
        ClientMessage m3 = this.createTextMessage("m3");
        ClientMessage m4 = this.createTextMessage("m4");
        ClientSession clientSession2 = this.sessionFactory.createSession(false, true, true);
        ClientProducer clientProducer2 = clientSession2.createProducer(this.atestq);
        clientProducer2.send((Message)m1);
        clientProducer2.send((Message)m2);
        clientProducer2.send((Message)m3);
        clientProducer2.send((Message)m4);
        clientSession2.close();
        this.clientSession.start((Xid)xid, 0);
        this.clientSession.start();
        ClientMessage m = this.clientConsumer.receive(1000L);
        m.acknowledge();
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m1");
        m = this.clientConsumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m2");
        m = this.clientConsumer.receive(1000L);
        m.acknowledge();
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m3");
        m = this.clientConsumer.receive(1000L);
        m.acknowledge();
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m4");
        this.clientSession.end((Xid)xid, 0x4000000);
        Assertions.assertEquals((int)0, (int)this.clientSession.prepare((Xid)xid), (String)"Expected XA_OK");
        if (stopServer) {
            this.stopAndRestartServer();
        } else {
            this.recreateClients();
        }
        Xid[] xids = this.clientSession.recover(0x1000000);
        Assertions.assertEquals((int)xids.length, (int)1);
        Assertions.assertEquals((int)xids[0].getFormatId(), (int)xid.getFormatId());
        ActiveMQTestBase.assertEqualsByteArrays(xids[0].getBranchQualifier(), xid.getBranchQualifier());
        ActiveMQTestBase.assertEqualsByteArrays(xids[0].getGlobalTransactionId(), xid.getGlobalTransactionId());
        xids = this.clientSession.recover(0x800000);
        Assertions.assertEquals((int)xids.length, (int)0);
        this.clientSession.commit((Xid)xid, false);
        this.clientSession.start();
        m = this.clientConsumer.receiveImmediate();
        Assertions.assertNull((Object)m);
        this.checkQueueDeliveryCount(this.atestq, 0);
    }

    private void checkQueueDeliveryCount(SimpleString thequeue, int expectedCount) throws Exception {
        QueueControl queueControl = ManagementControlHelper.createQueueControl(thequeue, thequeue, this.mbeanServer);
        int actualCount = queueControl.getDeliveringCount();
        Assertions.assertEquals((int)expectedCount, (int)actualCount);
    }

    public void testBasicReceiveWithRollback(boolean stopServer) throws Exception {
        XidImpl xid = new XidImpl("xa1".getBytes(), 1, UUIDGenerator.getInstance().generateStringUUID().getBytes());
        ClientMessage m1 = this.createTextMessage("m1");
        ClientMessage m2 = this.createTextMessage("m2");
        ClientMessage m3 = this.createTextMessage("m3");
        ClientMessage m4 = this.createTextMessage("m4");
        ClientSession clientSession2 = this.sessionFactory.createSession(false, true, true);
        ClientProducer clientProducer2 = clientSession2.createProducer(this.atestq);
        clientProducer2.send((Message)m1);
        clientProducer2.send((Message)m2);
        clientProducer2.send((Message)m3);
        clientProducer2.send((Message)m4);
        clientSession2.close();
        this.clientSession.start((Xid)xid, 0);
        this.clientSession.start();
        ClientMessage m = this.clientConsumer.receive(1000L);
        m.acknowledge();
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m1");
        m = this.clientConsumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m2");
        m = this.clientConsumer.receive(1000L);
        m.acknowledge();
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m3");
        m = this.clientConsumer.receive(1000L);
        m.acknowledge();
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m4");
        this.clientSession.end((Xid)xid, 0x4000000);
        this.clientSession.prepare((Xid)xid);
        logger.debug("stopping and restarting");
        if (stopServer) {
            this.stopAndRestartServer();
        } else {
            this.recreateClients();
        }
        logger.debug("Restarted");
        Xid[] xids = this.clientSession.recover(0x1000000);
        Assertions.assertEquals((int)1, (int)xids.length);
        Assertions.assertEquals((int)xids[0].getFormatId(), (int)xid.getFormatId());
        ActiveMQTestBase.assertEqualsByteArrays(xids[0].getBranchQualifier(), xid.getBranchQualifier());
        ActiveMQTestBase.assertEqualsByteArrays(xids[0].getGlobalTransactionId(), xid.getGlobalTransactionId());
        xids = this.clientSession.recover(0x800000);
        Assertions.assertEquals((int)xids.length, (int)0);
        this.clientSession.rollback((Xid)xid);
        this.clientSession.start();
        m = this.clientConsumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m1");
        m = this.clientConsumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m2");
        m = this.clientConsumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m3");
        m = this.clientConsumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m4");
    }

    public void testMultipleTxReceiveWithCommit(boolean stopServer) throws Exception {
        XidImpl xid = new XidImpl("xa1".getBytes(), 1, UUIDGenerator.getInstance().generateStringUUID().getBytes());
        XidImpl xid2 = new XidImpl("xa2".getBytes(), 1, UUIDGenerator.getInstance().generateStringUUID().getBytes());
        ClientMessage m1 = this.createTextMessage("m1");
        ClientMessage m2 = this.createTextMessage("m2");
        ClientMessage m3 = this.createTextMessage("m3");
        ClientMessage m4 = this.createTextMessage("m4");
        ClientMessage m5 = this.createTextMessage("m5");
        ClientMessage m6 = this.createTextMessage("m6");
        ClientMessage m7 = this.createTextMessage("m7");
        ClientMessage m8 = this.createTextMessage("m8");
        ClientSession clientSession2 = this.sessionFactory.createSession(false, true, true);
        ClientProducer clientProducer2 = clientSession2.createProducer(this.atestq);
        SimpleString anewtestq = SimpleString.of((String)"anewtestq");
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)anewtestq));
        ClientProducer clientProducer3 = clientSession2.createProducer(anewtestq);
        clientProducer2.send((Message)m1);
        clientProducer2.send((Message)m2);
        clientProducer2.send((Message)m3);
        clientProducer2.send((Message)m4);
        clientProducer3.send((Message)m5);
        clientProducer3.send((Message)m6);
        clientProducer3.send((Message)m7);
        clientProducer3.send((Message)m8);
        clientSession2.close();
        clientSession2 = this.sessionFactory.createSession(true, false, false);
        ClientConsumer clientConsumer2 = clientSession2.createConsumer(anewtestq);
        clientSession2.start((Xid)xid2, 0);
        clientSession2.start();
        ClientMessage m = clientConsumer2.receive(1000L);
        m.acknowledge();
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m5");
        m = clientConsumer2.receive(1000L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m6");
        m = clientConsumer2.receive(1000L);
        m.acknowledge();
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m7");
        m = clientConsumer2.receive(1000L);
        m.acknowledge();
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m8");
        clientSession2.end((Xid)xid2, 0x4000000);
        clientSession2.prepare((Xid)xid2);
        clientSession2.close();
        clientSession2 = null;
        this.clientSession.start((Xid)xid, 0);
        this.clientSession.start();
        m = this.clientConsumer.receive(1000L);
        m.acknowledge();
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m1");
        m = this.clientConsumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m2");
        m = this.clientConsumer.receive(1000L);
        m.acknowledge();
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m3");
        m = this.clientConsumer.receive(1000L);
        m.acknowledge();
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m4");
        this.clientSession.end((Xid)xid, 0x4000000);
        this.clientSession.prepare((Xid)xid);
        if (stopServer) {
            this.stopAndRestartServer();
        } else {
            this.recreateClients();
        }
        Xid[] xids = this.clientSession.recover(0x1000000);
        this.assertEqualXids(xids, new Xid[]{xid, xid2});
        xids = this.clientSession.recover(0x800000);
        Assertions.assertEquals((int)xids.length, (int)0);
        this.clientSession.commit((Xid)xid, false);
        this.clientSession.start();
        m = this.clientConsumer.receiveImmediate();
        Assertions.assertNull((Object)m);
    }

    public void testMultipleTxReceiveWithRollback(boolean stopServer) throws Exception {
        XidImpl xid = new XidImpl("xa1".getBytes(), 1, UUIDGenerator.getInstance().generateStringUUID().getBytes());
        XidImpl xid2 = new XidImpl("xa2".getBytes(), 1, UUIDGenerator.getInstance().generateStringUUID().getBytes());
        ClientMessage m1 = this.createTextMessage("m1");
        ClientMessage m2 = this.createTextMessage("m2");
        ClientMessage m3 = this.createTextMessage("m3");
        ClientMessage m4 = this.createTextMessage("m4");
        ClientMessage m5 = this.createTextMessage("m5");
        ClientMessage m6 = this.createTextMessage("m6");
        ClientMessage m7 = this.createTextMessage("m7");
        ClientMessage m8 = this.createTextMessage("m8");
        ClientSession clientSession2 = this.sessionFactory.createSession(false, true, true);
        ClientProducer clientProducer2 = clientSession2.createProducer(this.atestq);
        SimpleString anewtestq = SimpleString.of((String)"anewtestq");
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)anewtestq));
        ClientProducer clientProducer3 = clientSession2.createProducer(anewtestq);
        clientProducer2.send((Message)m1);
        clientProducer2.send((Message)m2);
        clientProducer2.send((Message)m3);
        clientProducer2.send((Message)m4);
        clientProducer3.send((Message)m5);
        clientProducer3.send((Message)m6);
        clientProducer3.send((Message)m7);
        clientProducer3.send((Message)m8);
        clientSession2.close();
        clientSession2 = this.sessionFactory.createSession(true, false, false);
        ClientConsumer clientConsumer2 = clientSession2.createConsumer(anewtestq);
        clientSession2.start((Xid)xid2, 0);
        clientSession2.start();
        ClientMessage m = clientConsumer2.receive(1000L);
        m.acknowledge();
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m5");
        m = clientConsumer2.receive(1000L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m6");
        m = clientConsumer2.receive(1000L);
        m.acknowledge();
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m7");
        m = clientConsumer2.receive(1000L);
        m.acknowledge();
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m8");
        clientSession2.end((Xid)xid2, 0x4000000);
        clientSession2.prepare((Xid)xid2);
        clientSession2.close();
        clientSession2 = null;
        this.clientSession.start((Xid)xid, 0);
        this.clientSession.start();
        m = this.clientConsumer.receive(1000L);
        m.acknowledge();
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m1");
        m = this.clientConsumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m2");
        m = this.clientConsumer.receive(1000L);
        m.acknowledge();
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m3");
        m = this.clientConsumer.receive(1000L);
        m.acknowledge();
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m4");
        this.clientSession.end((Xid)xid, 0x4000000);
        this.clientSession.prepare((Xid)xid);
        if (stopServer) {
            this.stopAndRestartServer();
        } else {
            this.recreateClients();
        }
        Xid[] xids = this.clientSession.recover(0x1000000);
        this.assertEqualXids(xids, new Xid[]{xid, xid2});
        xids = this.clientSession.recover(0x800000);
        Assertions.assertEquals((int)xids.length, (int)0);
        this.clientSession.rollback((Xid)xid);
        this.clientSession.start();
        m = this.clientConsumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m1");
        m = this.clientConsumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m2");
        m = this.clientConsumer.receive(1000L);
        m.acknowledge();
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m3");
        m = this.clientConsumer.receive(1000L);
        m.acknowledge();
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m4");
    }

    protected void stopAndRestartServer() throws Exception {
        this.clientSession.close();
        this.clientSession = null;
        this.server.stop();
        this.server = null;
        this.server = this.createServer(true, this.configuration, -1, -1L, this.addressSettings);
        this.server.setMBeanServer(this.mbeanServer);
        this.server.start();
        this.createClients();
    }

    private void addSettings() {
        for (Map.Entry<String, AddressSettings> setting : this.addressSettings.entrySet()) {
            this.server.getAddressSettingsRepository().addMatch(setting.getKey(), (Object)setting.getValue());
        }
    }

    protected void recreateClients() throws Exception {
        this.clientSession.close();
        this.clientSession = null;
        this.createClients();
    }

    private ClientMessage createTextMessage(String s) {
        return this.createTextMessage(s, true);
    }

    private ClientMessage createTextMessage(String s, boolean durable) {
        ClientMessage message = this.clientSession.createMessage((byte)3, durable, 0L, System.currentTimeMillis(), (byte)1);
        message.getBodyBuffer().writeString(s);
        return message;
    }

    private ClientMessage createBytesMessage(byte[] b, boolean durable) {
        ClientMessage message = this.clientSession.createMessage((byte)4, durable, 0L, System.currentTimeMillis(), (byte)1);
        message.getBodyBuffer().writeBytes(b);
        return message;
    }

    private void createClients() throws Exception {
        this.createClients(false, true);
    }

    private void createClients(boolean createQueue, boolean commitACKs) throws Exception {
        this.locator = this.createInVMNonHALocator();
        this.sessionFactory = this.createSessionFactory(this.locator);
        this.clientSession = this.sessionFactory.createSession(true, false, commitACKs);
        if (createQueue) {
            this.clientSession.createQueue(QueueConfiguration.of((SimpleString)this.atestq));
        }
        this.clientProducer = this.clientSession.createProducer(this.atestq);
        this.clientConsumer = this.clientSession.createConsumer(this.atestq);
    }

    private void assertEqualXids(Xid[] xids, Xid ... origXids) {
        Assertions.assertEquals((int)xids.length, (int)origXids.length);
        for (Xid xid : xids) {
            boolean found = false;
            for (Xid origXid : origXids) {
                found = Arrays.equals(origXid.getBranchQualifier(), xid.getBranchQualifier());
                if (!found) continue;
                Assertions.assertEquals((int)xid.getFormatId(), (int)origXid.getFormatId());
                ActiveMQTestBase.assertEqualsByteArrays(xid.getBranchQualifier(), origXid.getBranchQualifier());
                ActiveMQTestBase.assertEqualsByteArrays(xid.getGlobalTransactionId(), origXid.getGlobalTransactionId());
                break;
            }
            if (found) continue;
            Assertions.fail((String)("correct xid not found: " + xid));
        }
    }
}

