/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.jms.client;

import jakarta.jms.MessageEOFException;
import jakarta.jms.MessageFormatException;
import java.util.ArrayList;
import org.apache.activemq.artemis.jms.client.ActiveMQStreamMessage;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ActiveMQStreamMessageTest
extends ActiveMQTestBase {
    @Test
    public void testGetType() throws Exception {
        ActiveMQStreamMessage message = new ActiveMQStreamMessage();
        Assertions.assertEquals((byte)6, (byte)message.getType());
    }

    @Test
    public void testReadBooleanFromBoolean() throws Exception {
        boolean value = RandomUtil.randomBoolean();
        ActiveMQStreamMessage message = new ActiveMQStreamMessage();
        message.writeBoolean(value);
        message.reset();
        Assertions.assertEquals((Object)value, (Object)message.readBoolean());
    }

    @Test
    public void testReadBooleanFromString() throws Exception {
        boolean value = RandomUtil.randomBoolean();
        ActiveMQStreamMessage message = new ActiveMQStreamMessage();
        message.writeString(Boolean.toString(value));
        message.reset();
        Assertions.assertEquals((Object)value, (Object)message.readBoolean());
    }

    @Test
    public void testReadBooleanFromInvalidType() throws Exception {
        this.doReadTypeFromInvalidType(Float.valueOf(RandomUtil.randomFloat()), message -> message.readBoolean());
    }

    @Test
    public void testReadBooleanFromEmptyMessage() throws Exception {
        this.doReadTypeFromEmptyMessage(new TypeReader(){

            @Override
            public Object readType(ActiveMQStreamMessage message) throws Exception {
                return message.readBoolean();
            }
        });
    }

    @Test
    public void testReadCharFromInvalidType() throws Exception {
        this.doReadTypeFromInvalidType(Float.valueOf(RandomUtil.randomFloat()), message -> Character.valueOf(message.readChar()));
    }

    @Test
    public void testReadCharFromEmptyMessage() throws Exception {
        this.doReadTypeFromEmptyMessage(message -> Character.valueOf(message.readChar()));
    }

    @Test
    public void testReadByteFromByte() throws Exception {
        byte value = RandomUtil.randomByte();
        ActiveMQStreamMessage message = new ActiveMQStreamMessage();
        message.writeByte(value);
        message.reset();
        Assertions.assertEquals((byte)value, (byte)message.readByte());
    }

    @Test
    public void testReadByteFromString() throws Exception {
        byte value = RandomUtil.randomByte();
        ActiveMQStreamMessage message = new ActiveMQStreamMessage();
        message.writeString(Byte.toString(value));
        message.reset();
        Assertions.assertEquals((byte)value, (byte)message.readByte());
    }

    @Test
    public void testReadByteFromInvalidType() throws Exception {
        this.doReadTypeFromInvalidType(Float.valueOf(RandomUtil.randomFloat()), message -> message.readByte());
    }

    @Test
    public void testReadByteFromEmptyMessage() throws Exception {
        this.doReadTypeFromEmptyMessage(message -> message.readByte());
    }

    @Test
    public void testReadBytesFromBytes() throws Exception {
        byte[] value = RandomUtil.randomBytes();
        ActiveMQStreamMessage message = new ActiveMQStreamMessage();
        message.writeBytes(value);
        message.reset();
        byte[] v = new byte[value.length];
        message.readBytes(v);
        ActiveMQTestBase.assertEqualsByteArrays(value, v);
    }

    @Test
    public void testReadBytesFromBytes_2() throws Exception {
        byte[] value = RandomUtil.randomBytes((int)512);
        ActiveMQStreamMessage message = new ActiveMQStreamMessage();
        message.writeBytes(value, 0, 256);
        message.reset();
        byte[] v = new byte[256];
        message.readBytes(v);
        ActiveMQTestBase.assertEqualsByteArrays(256, value, v);
    }

    @Test
    public void testReadBytesFromInvalidType() throws Exception {
        this.doReadTypeFromInvalidType(RandomUtil.randomBoolean(), message -> message.readByte());
    }

    @Test
    public void testReadBytesFromEmptyMessage() throws Exception {
        this.doReadTypeFromEmptyMessage(message -> {
            byte[] bytes = new byte[1];
            return message.readBytes(bytes);
        });
    }

    @Test
    public void testReadShortFromByte() throws Exception {
        byte value = RandomUtil.randomByte();
        ActiveMQStreamMessage message = new ActiveMQStreamMessage();
        message.writeByte(value);
        message.reset();
        Assertions.assertEquals((short)value, (short)message.readShort());
    }

    @Test
    public void testReadShortFromShort() throws Exception {
        short value = RandomUtil.randomShort();
        ActiveMQStreamMessage message = new ActiveMQStreamMessage();
        message.writeShort(value);
        message.reset();
        Assertions.assertEquals((short)value, (short)message.readShort());
    }

    @Test
    public void testReadShortFromString() throws Exception {
        short value = RandomUtil.randomShort();
        ActiveMQStreamMessage message = new ActiveMQStreamMessage();
        message.writeString(Short.toString(value));
        message.reset();
        Assertions.assertEquals((short)value, (short)message.readShort());
    }

    @Test
    public void testReadShortFromInvalidType() throws Exception {
        this.doReadTypeFromInvalidType(Float.valueOf(RandomUtil.randomFloat()), message -> message.readShort());
    }

    @Test
    public void testReadShortFromEmptyMessage() throws Exception {
        this.doReadTypeFromEmptyMessage(message -> message.readShort());
    }

    @Test
    public void testReadIntFromByte() throws Exception {
        byte value = RandomUtil.randomByte();
        ActiveMQStreamMessage message = new ActiveMQStreamMessage();
        message.writeByte(value);
        message.reset();
        Assertions.assertEquals((int)value, (int)message.readInt());
    }

    @Test
    public void testReadIntFromShort() throws Exception {
        short value = RandomUtil.randomShort();
        ActiveMQStreamMessage message = new ActiveMQStreamMessage();
        message.writeShort(value);
        message.reset();
        Assertions.assertEquals((int)value, (int)message.readInt());
    }

    @Test
    public void testReadIntFromInt() throws Exception {
        int value = RandomUtil.randomInt();
        ActiveMQStreamMessage message = new ActiveMQStreamMessage();
        message.writeInt(value);
        message.reset();
        Assertions.assertEquals((int)value, (int)message.readInt());
    }

    @Test
    public void testReadIntFromString() throws Exception {
        int value = RandomUtil.randomInt();
        ActiveMQStreamMessage message = new ActiveMQStreamMessage();
        message.writeString(Integer.toString(value));
        message.reset();
        Assertions.assertEquals((int)value, (int)message.readInt());
    }

    @Test
    public void testReadIntFromInvalidType() throws Exception {
        this.doReadTypeFromInvalidType(Float.valueOf(RandomUtil.randomFloat()), message -> message.readInt());
    }

    @Test
    public void testReadIntFromEmptyMessage() throws Exception {
        this.doReadTypeFromEmptyMessage(message -> message.readInt());
    }

    @Test
    public void testReadCharFromChar() throws Exception {
        char value = RandomUtil.randomChar();
        ActiveMQStreamMessage message = new ActiveMQStreamMessage();
        message.writeChar(value);
        message.reset();
        Assertions.assertEquals((char)value, (char)message.readChar());
    }

    @Test
    public void testReadCharFromNull() throws Exception {
        ActiveMQStreamMessage message = new ActiveMQStreamMessage();
        message.writeString(null);
        message.reset();
        try {
            message.readChar();
            Assertions.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testReadLongFromByte() throws Exception {
        byte value = RandomUtil.randomByte();
        ActiveMQStreamMessage message = new ActiveMQStreamMessage();
        message.writeByte(value);
        message.reset();
        Assertions.assertEquals((long)value, (long)message.readLong());
    }

    @Test
    public void testReadLongFromShort() throws Exception {
        short value = RandomUtil.randomShort();
        ActiveMQStreamMessage message = new ActiveMQStreamMessage();
        message.writeShort(value);
        message.reset();
        Assertions.assertEquals((long)value, (long)message.readLong());
    }

    @Test
    public void testReadLongFromInt() throws Exception {
        int value = RandomUtil.randomInt();
        ActiveMQStreamMessage message = new ActiveMQStreamMessage();
        message.writeInt(value);
        message.reset();
        Assertions.assertEquals((long)value, (long)message.readLong());
    }

    @Test
    public void testReadLongFromLong() throws Exception {
        long value = RandomUtil.randomLong();
        ActiveMQStreamMessage message = new ActiveMQStreamMessage();
        message.writeLong(value);
        message.reset();
        Assertions.assertEquals((long)value, (long)message.readLong());
    }

    @Test
    public void testReadLongFromString() throws Exception {
        long value = RandomUtil.randomLong();
        ActiveMQStreamMessage message = new ActiveMQStreamMessage();
        message.writeString(Long.toString(value));
        message.reset();
        Assertions.assertEquals((long)value, (long)message.readLong());
    }

    @Test
    public void testReadLongFromInvalidType() throws Exception {
        this.doReadTypeFromInvalidType(Float.valueOf(RandomUtil.randomFloat()), message -> message.readLong());
    }

    @Test
    public void testReadLongFromEmptyMessage() throws Exception {
        this.doReadTypeFromEmptyMessage(message -> message.readLong());
    }

    @Test
    public void testReadFloatFromFloat() throws Exception {
        float value = RandomUtil.randomFloat();
        ActiveMQStreamMessage message = new ActiveMQStreamMessage();
        message.writeFloat(value);
        message.reset();
        Assertions.assertEquals((double)value, (double)message.readFloat(), (double)1.0E-6);
    }

    @Test
    public void testReadFloatFromString() throws Exception {
        float value = RandomUtil.randomFloat();
        ActiveMQStreamMessage message = new ActiveMQStreamMessage();
        message.writeString(Float.toString(value));
        message.reset();
        Assertions.assertEquals((double)value, (double)message.readFloat(), (double)1.0E-6);
    }

    @Test
    public void testReadFloatFromInvalidType() throws Exception {
        this.doReadTypeFromInvalidType(RandomUtil.randomBoolean(), message -> Float.valueOf(message.readFloat()));
    }

    @Test
    public void testReadFloatFromEmptyMessage() throws Exception {
        this.doReadTypeFromEmptyMessage(message -> Float.valueOf(message.readFloat()));
    }

    @Test
    public void testReadDoubleFromFloat() throws Exception {
        float value = RandomUtil.randomFloat();
        ActiveMQStreamMessage message = new ActiveMQStreamMessage();
        message.writeFloat(value);
        message.reset();
        Assertions.assertEquals((double)Float.valueOf(value).doubleValue(), (double)message.readDouble(), (double)1.0E-6);
    }

    @Test
    public void testReadDoubleFromDouble() throws Exception {
        double value = RandomUtil.randomDouble();
        ActiveMQStreamMessage message = new ActiveMQStreamMessage();
        message.writeDouble(value);
        message.reset();
        Assertions.assertEquals((double)value, (double)message.readDouble(), (double)1.0E-6);
    }

    @Test
    public void testReadDoubleFromString() throws Exception {
        double value = RandomUtil.randomDouble();
        ActiveMQStreamMessage message = new ActiveMQStreamMessage();
        message.writeString(Double.toString(value));
        message.reset();
        Assertions.assertEquals((double)value, (double)message.readDouble(), (double)1.0E-6);
    }

    @Test
    public void testReadDoubleFromInvalidType() throws Exception {
        this.doReadTypeFromInvalidType(RandomUtil.randomBoolean(), message -> message.readDouble());
    }

    @Test
    public void testReadDoubleFromEmptyMessage() throws Exception {
        this.doReadTypeFromEmptyMessage(message -> message.readDouble());
    }

    @Test
    public void testReadStringFromBoolean() throws Exception {
        boolean value = RandomUtil.randomBoolean();
        ActiveMQStreamMessage message = new ActiveMQStreamMessage();
        message.writeBoolean(value);
        message.reset();
        Assertions.assertEquals((Object)Boolean.toString(value), (Object)message.readString());
    }

    @Test
    public void testReadStringFromChar() throws Exception {
        char value = RandomUtil.randomChar();
        ActiveMQStreamMessage message = new ActiveMQStreamMessage();
        message.writeChar(value);
        message.reset();
        Assertions.assertEquals((Object)Character.toString(value), (Object)message.readString());
    }

    @Test
    public void testReadStringFromByte() throws Exception {
        byte value = RandomUtil.randomByte();
        ActiveMQStreamMessage message = new ActiveMQStreamMessage();
        message.writeByte(value);
        message.reset();
        Assertions.assertEquals((Object)Byte.toString(value), (Object)message.readString());
    }

    @Test
    public void testString() throws Exception {
        String value = RandomUtil.randomString();
        ActiveMQStreamMessage message = new ActiveMQStreamMessage();
        message.writeString(value);
        message.reset();
        try {
            message.readByte();
            Assertions.fail((String)"must throw a NumberFormatException");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        Assertions.assertEquals((Object)value, (Object)message.readString());
    }

    @Test
    public void testReadStringFromShort() throws Exception {
        short value = RandomUtil.randomShort();
        ActiveMQStreamMessage message = new ActiveMQStreamMessage();
        message.writeShort(value);
        message.reset();
        Assertions.assertEquals((Object)Short.toString(value), (Object)message.readString());
    }

    @Test
    public void testReadStringFromInt() throws Exception {
        int value = RandomUtil.randomInt();
        ActiveMQStreamMessage message = new ActiveMQStreamMessage();
        message.writeInt(value);
        message.reset();
        Assertions.assertEquals((Object)Integer.toString(value), (Object)message.readString());
    }

    @Test
    public void testReadStringFromLong() throws Exception {
        long value = RandomUtil.randomLong();
        ActiveMQStreamMessage message = new ActiveMQStreamMessage();
        message.writeLong(value);
        message.reset();
        Assertions.assertEquals((Object)Long.toString(value), (Object)message.readString());
    }

    @Test
    public void testReadStringFromFloat() throws Exception {
        float value = RandomUtil.randomFloat();
        ActiveMQStreamMessage message = new ActiveMQStreamMessage();
        message.writeFloat(value);
        message.reset();
        Assertions.assertEquals((Object)Float.toString(value), (Object)message.readString());
    }

    @Test
    public void testReadStringFromDouble() throws Exception {
        double value = RandomUtil.randomDouble();
        ActiveMQStreamMessage message = new ActiveMQStreamMessage();
        message.writeDouble(value);
        message.reset();
        Assertions.assertEquals((Object)Double.toString(value), (Object)message.readString());
    }

    @Test
    public void testReadStringFromString() throws Exception {
        String value = RandomUtil.randomString();
        ActiveMQStreamMessage message = new ActiveMQStreamMessage();
        message.writeString(value);
        message.reset();
        Assertions.assertEquals((Object)value, (Object)message.readString());
    }

    @Test
    public void testReadStringFromNullString() throws Exception {
        ActiveMQStreamMessage message = new ActiveMQStreamMessage();
        message.writeString(null);
        message.reset();
        Assertions.assertNull((Object)message.readString());
    }

    @Test
    public void testReadStringFromEmptyMessage() throws Exception {
        this.doReadTypeFromEmptyMessage(message -> message.readString());
    }

    @Test
    public void testWriteObjectWithBoolean() throws Exception {
        this.doWriteObjectWithType(RandomUtil.randomBoolean(), message -> message.readBoolean());
    }

    @Test
    public void testWriteObjectWithChar() throws Exception {
        this.doWriteObjectWithType(Character.valueOf(RandomUtil.randomChar()), message -> Character.valueOf(message.readChar()));
    }

    @Test
    public void testWriteObjectWithByte() throws Exception {
        this.doWriteObjectWithType(RandomUtil.randomByte(), message -> message.readByte());
    }

    @Test
    public void testWriteObjectWithBytes() throws Exception {
        byte[] value = RandomUtil.randomBytes();
        this.doWriteObjectWithType(value, message -> {
            byte[] bytes = new byte[value.length];
            message.readBytes(bytes);
            return bytes;
        });
    }

    @Test
    public void testWriteObjectWithShort() throws Exception {
        this.doWriteObjectWithType(RandomUtil.randomShort(), message -> message.readShort());
    }

    @Test
    public void testWriteObjectWithInt() throws Exception {
        this.doWriteObjectWithType(RandomUtil.randomInt(), message -> message.readInt());
    }

    @Test
    public void testWriteObjectWithLong() throws Exception {
        this.doWriteObjectWithType(RandomUtil.randomLong(), message -> message.readLong());
    }

    @Test
    public void testWriteObjectWithFloat() throws Exception {
        this.doWriteObjectWithType(Float.valueOf(RandomUtil.randomFloat()), message -> Float.valueOf(message.readFloat()));
    }

    @Test
    public void testWriteObjectWithDouble() throws Exception {
        this.doWriteObjectWithType(RandomUtil.randomDouble(), message -> message.readDouble());
    }

    @Test
    public void testWriteObjectWithString() throws Exception {
        this.doWriteObjectWithType(RandomUtil.randomString(), message -> message.readString());
    }

    @Test
    public void testWriteObjectWithNull() throws Exception {
        ActiveMQStreamMessage message = new ActiveMQStreamMessage();
        message.writeObject(null);
    }

    @Test
    public void testWriteObjectWithInvalidType() throws Exception {
        ActiveMQStreamMessage message = new ActiveMQStreamMessage();
        try {
            message.writeObject(new ArrayList());
            Assertions.fail((String)"MessageFormatException");
        }
        catch (MessageFormatException messageFormatException) {
            // empty catch block
        }
    }

    @Test
    public void testReadObjectFromBoolean() throws Exception {
        boolean value = RandomUtil.randomBoolean();
        ActiveMQStreamMessage message = new ActiveMQStreamMessage();
        message.writeBoolean(value);
        message.reset();
        Assertions.assertEquals((Object)value, (Object)message.readObject());
    }

    @Test
    public void testReadObjectFromChar() throws Exception {
        char value = RandomUtil.randomChar();
        ActiveMQStreamMessage message = new ActiveMQStreamMessage();
        message.writeChar(value);
        message.reset();
        Assertions.assertEquals((Object)Character.valueOf(value), (Object)message.readObject());
    }

    @Test
    public void testReadObjectFromByte() throws Exception {
        byte value = RandomUtil.randomByte();
        ActiveMQStreamMessage message = new ActiveMQStreamMessage();
        message.writeByte(value);
        message.reset();
        Assertions.assertEquals((Object)value, (Object)message.readObject());
    }

    @Test
    public void testReadObjectFromBytes() throws Exception {
        byte[] value = RandomUtil.randomBytes();
        ActiveMQStreamMessage message = new ActiveMQStreamMessage();
        message.writeBytes(value);
        message.reset();
        byte[] v = (byte[])message.readObject();
        ActiveMQTestBase.assertEqualsByteArrays(value, v);
    }

    @Test
    public void testReadObjectFromShort() throws Exception {
        short value = RandomUtil.randomShort();
        ActiveMQStreamMessage message = new ActiveMQStreamMessage();
        message.writeShort(value);
        message.reset();
        Assertions.assertEquals((Object)value, (Object)message.readObject());
    }

    @Test
    public void testReadObjectFromInt() throws Exception {
        int value = RandomUtil.randomInt();
        ActiveMQStreamMessage message = new ActiveMQStreamMessage();
        message.writeInt(value);
        message.reset();
        Assertions.assertEquals((Object)value, (Object)message.readObject());
    }

    @Test
    public void testReadObjectFromLong() throws Exception {
        long value = RandomUtil.randomLong();
        ActiveMQStreamMessage message = new ActiveMQStreamMessage();
        message.writeLong(value);
        message.reset();
        Assertions.assertEquals((Object)value, (Object)message.readObject());
    }

    @Test
    public void testReadObjectFromFloat() throws Exception {
        float value = RandomUtil.randomFloat();
        ActiveMQStreamMessage message = new ActiveMQStreamMessage();
        message.writeFloat(value);
        message.reset();
        Assertions.assertEquals((Object)Float.valueOf(value), (Object)message.readObject());
    }

    @Test
    public void testReadObjectFromDouble() throws Exception {
        double value = RandomUtil.randomDouble();
        ActiveMQStreamMessage message = new ActiveMQStreamMessage();
        message.writeDouble(value);
        message.reset();
        Assertions.assertEquals((Object)value, (Object)message.readObject());
    }

    @Test
    public void testReadObjectFromString() throws Exception {
        String value = RandomUtil.randomString();
        ActiveMQStreamMessage message = new ActiveMQStreamMessage();
        message.writeString(value);
        message.reset();
        Assertions.assertEquals((Object)value, (Object)message.readObject());
    }

    private void doReadTypeFromEmptyMessage(TypeReader reader) throws Exception {
        ActiveMQStreamMessage message = new ActiveMQStreamMessage();
        message.reset();
        try {
            reader.readType(message);
            Assertions.fail((String)"MessageEOFException");
        }
        catch (MessageEOFException messageEOFException) {
            // empty catch block
        }
    }

    private void doReadTypeFromInvalidType(Object invalidValue, TypeReader reader) throws Exception {
        ActiveMQStreamMessage message = new ActiveMQStreamMessage();
        message.writeObject(invalidValue);
        message.reset();
        try {
            reader.readType(message);
            Assertions.fail((String)"MessageFormatException");
        }
        catch (MessageFormatException messageFormatException) {
            // empty catch block
        }
    }

    private void doWriteObjectWithType(Object value, TypeReader reader) throws Exception {
        ActiveMQStreamMessage message = new ActiveMQStreamMessage();
        message.writeObject(value);
        message.reset();
        Object v = reader.readType(message);
        if (value instanceof byte[]) {
            ActiveMQTestBase.assertEqualsByteArrays((byte[])value, (byte[])v);
        } else {
            Assertions.assertEquals((Object)value, (Object)v);
        }
    }

    private static interface TypeReader {
        public Object readType(ActiveMQStreamMessage var1) throws Exception;
    }
}

