/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.amqp.client;

import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public final class AmqpTransferTagGenerator {
    public static final int DEFAULT_TAG_POOL_SIZE = 1024;
    private long nextTagId;
    private int maxPoolSize = 1024;
    private final Set<byte[]> tagPool;

    public AmqpTransferTagGenerator() {
        this(false);
    }

    public AmqpTransferTagGenerator(boolean pool) {
        this.tagPool = pool ? new LinkedHashSet<byte[]>() : null;
    }

    public byte[] getNextTag() {
        byte[] rc;
        if (this.tagPool != null && !this.tagPool.isEmpty()) {
            Iterator<byte[]> iterator = this.tagPool.iterator();
            rc = iterator.next();
            iterator.remove();
        } else {
            rc = Long.toHexString(this.nextTagId++).getBytes(StandardCharsets.UTF_8);
        }
        return rc;
    }

    public void returnTag(byte[] data) {
        if (this.tagPool != null && this.tagPool.size() < this.maxPoolSize) {
            this.tagPool.add(data);
        }
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }
}

