/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.registry;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.wildfly.common.Assert;

public class AttributeAccess {
    private final AccessType access;
    private final Storage storage;
    private final OperationStepHandler readHandler;
    private final OperationStepHandler writeHandler;
    private final AttributeDefinition definition;

    AttributeAccess(AccessType access, Storage storage, OperationStepHandler readHandler, OperationStepHandler writeHandler, AttributeDefinition definition) {
        Assert.assertNotNull((Object)((Object)access));
        Assert.assertNotNull((Object)storage);
        this.access = access;
        this.readHandler = readHandler;
        this.writeHandler = writeHandler;
        this.storage = storage;
        this.definition = definition;
        if (definition.getFlags().contains(Flag.ALIAS)) {
            Assert.checkNotNullParam((String)"readHandler", (Object)readHandler);
        }
        if (access == AccessType.READ_WRITE) {
            Assert.checkNotNullParam((String)"writeHandler", (Object)writeHandler);
        }
    }

    public AccessType getAccessType() {
        return this.access;
    }

    public Storage getStorageType() {
        return this.storage;
    }

    public OperationStepHandler getReadHandler() {
        return this.readHandler;
    }

    public OperationStepHandler getWriteHandler() {
        return this.writeHandler;
    }

    public AttributeDefinition getAttributeDefinition() {
        return this.definition;
    }

    public Set<Flag> getFlags() {
        return this.definition.getFlags();
    }

    public static enum Flag implements Predicate<AttributeAccess>
    {
        RESTART_NONE,
        RESTART_JVM,
        RESTART_ALL_SERVICES,
        RESTART_RESOURCE_SERVICES,
        STORAGE_CONFIGURATION,
        STORAGE_RUNTIME,
        ALIAS,
        RUNTIME_SERVICE_NOT_REQUIRED,
        EXPRESSIONS_DEPRECATED,
        GAUGE_METRIC,
        COUNTER_METRIC;

        private static final Map<EnumSet<Flag>, Set<Flag>> flagSets;

        public static Set<Flag> immutableSetOf(Flag ... flags) {
            if (flags == null || flags.length == 0) {
                return Collections.emptySet();
            }
            EnumSet<Object> baseSet = flags.length == 1 ? EnumSet.of(flags[0]) : EnumSet.of(flags[0], flags);
            Set<Flag> result = flagSets.get(baseSet);
            if (result == null) {
                Set<Flag> immutable = Collections.unmodifiableSet(baseSet);
                Set<Flag> existing = flagSets.putIfAbsent(baseSet, immutable);
                result = existing == null ? immutable : existing;
            }
            return result;
        }

        @Override
        public boolean test(AttributeAccess attribute) {
            return attribute.getFlags().contains(this);
        }

        static {
            flagSets = new ConcurrentHashMap<EnumSet<Flag>, Set<Flag>>(16);
        }
    }

    public static enum Storage implements Predicate<AttributeAccess>
    {
        CONFIGURATION("configuration"),
        RUNTIME("runtime");

        private final String label;

        private Storage(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }

        @Override
        public boolean test(AttributeAccess attribute) {
            return attribute.getStorageType() == this;
        }
    }

    public static enum AccessType {
        READ_ONLY("read-only", false),
        READ_WRITE("read-write", true),
        METRIC("metric", false);

        private final String label;
        private final boolean writable;
        private static final Map<String, AccessType> MAP;

        private AccessType(String label, boolean writable) {
            this.label = label;
            this.writable = writable;
        }

        public String toString() {
            return this.label;
        }

        public static AccessType forName(String localName) {
            return MAP.get(localName);
        }

        private String getLocalName() {
            return this.label;
        }

        public boolean isWritable() {
            return this.writable;
        }

        static {
            HashMap<String, AccessType> map = new HashMap<String, AccessType>();
            for (AccessType element : AccessType.values()) {
                String name = element.getLocalName();
                if (name == null) continue;
                map.put(name, element);
            }
            MAP = map;
        }
    }
}

