/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.predicateindex;

import java.util.Iterator;
import org.infinispan.objectfilter.impl.predicateindex.AttributeNode;
import org.infinispan.objectfilter.impl.predicateindex.MatcherEvalContext;
import org.infinispan.objectfilter.impl.util.ReflectionHelper;

public final class ReflectionMatcherEvalContext
extends MatcherEvalContext<Class<?>, ReflectionHelper.PropertyAccessor, String> {
    private final Class<?> entityType;

    public ReflectionMatcherEvalContext(Object userContext, Object eventType, Object key, Object instance, Object metadata) {
        super(userContext, eventType, key, instance, metadata);
        this.entityType = instance.getClass();
    }

    @Override
    public Class<?> getEntityType() {
        return this.entityType;
    }

    @Override
    protected void processAttributes(AttributeNode<ReflectionHelper.PropertyAccessor, String> node, Object instance) {
        for (AttributeNode<ReflectionHelper.PropertyAccessor, String> childAttribute : node.getChildren()) {
            Object attributeValue;
            if (instance == null) {
                this.processAttribute(childAttribute, null);
                continue;
            }
            ReflectionHelper.PropertyAccessor accessor = childAttribute.getMetadata();
            if (accessor == null) {
                attributeValue = node.cacheMetadataProjection(this.key, instance, this.metadata, childAttribute.getAttribute());
                if (attributeValue == null) continue;
                this.processAttribute(childAttribute, attributeValue);
                continue;
            }
            if (accessor.isMultiple()) {
                Iterator<Object> valuesIt = accessor.getValueIterator(instance);
                if (valuesIt == null) {
                    this.processAttribute(childAttribute, null);
                    continue;
                }
                while (valuesIt.hasNext()) {
                    Object attributeValue2 = valuesIt.next();
                    this.processAttribute(childAttribute, attributeValue2);
                }
                continue;
            }
            attributeValue = accessor.getValue(instance);
            this.processAttribute(childAttribute, attributeValue);
        }
    }

    private void processAttribute(AttributeNode<ReflectionHelper.PropertyAccessor, String> attributeNode, Object attributeValue) {
        attributeNode.processValue(attributeValue, this);
        this.processAttributes(attributeNode, attributeValue);
    }
}

