/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.mapping.impl;

import java.util.Map;
import java.util.Optional;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.environment.bean.spi.ParameterizedBeanReference;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateOrmEntityLoadingBinder;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmPathDefinitionProvider;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoTypeMetadataContributor;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.building.spi.PojoAdditionalMetadataCollectorEntityTypeNode;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.building.spi.PojoAdditionalMetadataCollectorTypeNode;
import org.hibernate.search.mapper.pojo.model.path.spi.PojoPathDefinitionProvider;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;

final class HibernateOrmEntityTypeMetadataContributor
implements PojoTypeMetadataContributor {
    private final PojoRawTypeModel<?> typeModel;
    private final PersistentClass persistentClass;
    private final Optional<String> identifierPropertyNameOptional;

    HibernateOrmEntityTypeMetadataContributor(PojoRawTypeModel<?> typeModel, PersistentClass persistentClass, Optional<String> identifierPropertyNameOptional) {
        this.typeModel = typeModel;
        this.persistentClass = persistentClass;
        this.identifierPropertyNameOptional = identifierPropertyNameOptional;
    }

    public void contributeAdditionalMetadata(PojoAdditionalMetadataCollectorTypeNode collector) {
        if (!this.typeModel.typeIdentifier().equals((Object)collector.typeIdentifier())) {
            return;
        }
        PojoAdditionalMetadataCollectorEntityTypeNode node = collector.markAsEntity();
        node.entityName(this.persistentClass.getJpaEntityName());
        node.secondaryEntityName(this.persistentClass.getEntityName());
        node.pathDefinitionProvider((PojoPathDefinitionProvider)new HibernateOrmPathDefinitionProvider(this.typeModel, this.persistentClass));
        node.entityIdPropertyName((String)this.identifierPropertyNameOptional.orElse(null));
        node.loadingBinder(ParameterizedBeanReference.of((BeanReference)BeanReference.ofInstance((Object)new HibernateOrmEntityLoadingBinder()), Map.of()));
    }
}

