/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.concurrent.resource.definition;

import org.jboss.as.ee.concurrent.resource.definition.ManagedScheduledExecutorDefinitionInjectionSource;
import org.jboss.as.ee.logging.EeLogger;
import org.jboss.as.ee.resource.definition.ResourceDefinitionDescriptorProcessor;
import org.jboss.as.ee.resource.definition.ResourceDefinitionInjectionSource;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.metadata.javaee.spec.Environment;
import org.jboss.metadata.javaee.spec.ManagedScheduledExecutorMetaData;
import org.jboss.metadata.javaee.spec.ManagedScheduledExecutorsMetaData;
import org.jboss.metadata.javaee.spec.RemoteEnvironment;

public class ManagedScheduledExecutorDefinitionDescriptorProcessor
extends ResourceDefinitionDescriptorProcessor {
    protected void processEnvironment(RemoteEnvironment environment, ResourceDefinitionDescriptorProcessor.ResourceDefinitionInjectionSources injectionSources) throws DeploymentUnitProcessingException {
        ManagedScheduledExecutorsMetaData metaDatas;
        if (environment instanceof Environment && (metaDatas = ((Environment)environment).getManagedScheduledExecutors()) != null) {
            for (ManagedScheduledExecutorMetaData metaData : metaDatas) {
                injectionSources.addResourceDefinitionInjectionSource(this.getResourceDefinitionInjectionSource(metaData));
            }
        }
    }

    private ResourceDefinitionInjectionSource getResourceDefinitionInjectionSource(ManagedScheduledExecutorMetaData metaData) {
        Integer maxAsync;
        String name = metaData.getName();
        if (name == null || name.isEmpty()) {
            throw EeLogger.ROOT_LOGGER.elementAttributeMissing("<managed-scheduled-executor>", "name");
        }
        ManagedScheduledExecutorDefinitionInjectionSource resourceDefinitionInjectionSource = new ManagedScheduledExecutorDefinitionInjectionSource(name);
        resourceDefinitionInjectionSource.setContextServiceRef(metaData.getContextServiceRef());
        Integer hungTaskThreshold = metaData.getHungTaskThreshold();
        if (hungTaskThreshold != null) {
            resourceDefinitionInjectionSource.setHungTaskThreshold(hungTaskThreshold.intValue());
        }
        if ((maxAsync = metaData.getMaxAsync()) != null) {
            resourceDefinitionInjectionSource.setMaxAsync(maxAsync);
        }
        return resourceDefinitionInjectionSource;
    }
}

