/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import org.aesh.command.Command;
import org.aesh.command.container.CommandContainer;
import org.aesh.command.parser.CommandLineParserException;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandHandler;
import org.jboss.as.cli.CommandHandlerProvider;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.CommandRegistry;
import org.jboss.as.cli.ControllerAddress;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.handlers.CommandHandlerWithHelp;
import org.jboss.as.cli.impl.ArgumentWithoutValue;
import org.jboss.as.cli.impl.aesh.CLICommandRegistry;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.JBossModulesNameUtil;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;

class ExtensionsLoader {
    private final ModuleLoader moduleLoader;
    private final CommandContext ctx;
    private final CommandRegistry registry;
    private final CLICommandRegistry aeshRegistry;
    private ControllerAddress currentAddress;
    private List<String> loadedHandlers = Collections.emptyList();
    private List<String> loadedCommands = Collections.emptyList();
    private List<String> errors = Collections.emptyList();

    ExtensionsLoader(CommandRegistry registry, CLICommandRegistry aeshRegistry, CommandContext ctx) throws CommandLineException {
        assert (registry != null) : "command registry is null";
        assert (ctx != null) : "command context is null";
        this.moduleLoader = this.getClass().getClassLoader() instanceof ModuleClassLoader ? ModuleLoader.forClassLoader((ClassLoader)this.getClass().getClassLoader()) : null;
        this.ctx = ctx;
        this.registry = registry;
        this.aeshRegistry = aeshRegistry;
        registry.registerHandler((CommandHandler)new ExtensionCommandsHandler(), false, "extension-commands");
    }

    void resetHandlers() {
        for (String cmd : this.loadedHandlers) {
            this.registry.remove(cmd);
        }
        for (String cmd : this.loadedCommands) {
            this.aeshRegistry.removeCommand(cmd);
        }
        this.currentAddress = null;
        this.errors = Collections.emptyList();
        this.loadedHandlers = Collections.emptyList();
        this.loadedCommands = Collections.emptyList();
    }

    Set<String> getExtensions() {
        HashSet<String> all = new HashSet<String>(this.loadedHandlers);
        all.addAll(this.loadedCommands);
        return all;
    }

    List<String> getExtensionsErrors() {
        return new ArrayList<String>(this.errors);
    }

    void loadHandlers(ControllerAddress address) throws CommandLineException, CommandLineParserException {
        ModelNode response;
        ModelControllerClient client = this.ctx.getModelControllerClient();
        assert (client != null) : "client is null";
        if (this.moduleLoader == null) {
            this.ctx.printLine("Warning! The CLI is running in a non-modular environment and cannot load commands from management extensions.");
            return;
        }
        if (address != null && this.currentAddress != null && address.equals(this.currentAddress)) {
            return;
        }
        this.resetHandlers();
        this.currentAddress = address;
        ModelNode req = new ModelNode();
        req.get("address").setEmptyList();
        req.get("operation").set("read-children-resources");
        req.get("child-type").set("extension");
        try {
            response = client.execute(req);
        }
        catch (IOException e) {
            throw new CommandLineException("Extensions loader failed to read extensions", e);
        }
        if (!Util.isSuccess(response)) {
            throw new CommandLineException("Extensions loader failed to read extensions: " + Util.getFailureDescription(response));
        }
        ModelNode result = response.get("result");
        if (!result.isDefined()) {
            throw new CommandLineException("Extensions loader failed to read extensions: " + result.asString());
        }
        for (Property ext : result.asPropertyList()) {
            ModelNode module = ext.getValue().get("module");
            if (!module.isDefined()) {
                this.addError("Extension " + ext.getName() + " is missing module attribute");
                continue;
            }
            String moduleId = JBossModulesNameUtil.parseCanonicalModuleIdentifier((String)module.asString());
            try {
                ModuleClassLoader cl = this.moduleLoader.loadModule(moduleId).getClassLoader();
                ServiceLoader<CommandHandlerProvider> loader = ServiceLoader.load(CommandHandlerProvider.class, (ClassLoader)cl);
                for (CommandHandlerProvider provider : loader) {
                    try {
                        this.registry.registerHandler(provider.createCommandHandler(this.ctx), provider.isTabComplete(), provider.getNames());
                        this.addHandlers(Arrays.asList(provider.getNames()));
                    }
                    catch (CommandRegistry.RegisterHandlerException e) {
                        this.addError(e.getLocalizedMessage());
                        ArrayList<String> addedCommands = new ArrayList<String>(Arrays.asList(provider.getNames()));
                        addedCommands.removeAll(e.getNotAddedNames());
                        this.addHandlers(addedCommands);
                    }
                }
                ServiceLoader<Command> loader2 = ServiceLoader.load(Command.class, (ClassLoader)cl);
                for (Command provider : loader2) {
                    try {
                        CommandContainer container = this.aeshRegistry.addCommand(provider);
                        this.addCommand(container.getParser().getProcessedCommand().name());
                    }
                    catch (CommandLineException e) {
                        this.addError(e.getLocalizedMessage());
                    }
                }
            }
            catch (ModuleLoadException e) {
                this.addError("Module " + module.asString() + " from extension " + ext.getName() + " available on the server couldn't be loaded locally: " + e.getLocalizedMessage());
            }
        }
        if (!this.errors.isEmpty()) {
            this.ctx.printLine("Warning! There were errors trying to load extensions. For more details, please, execute 'extension-commands --errors'");
        }
    }

    private void addHandlers(List<String> names) {
        if (this.loadedHandlers.isEmpty()) {
            this.loadedHandlers = new ArrayList<String>();
        }
        this.loadedHandlers.addAll(names);
    }

    private void addCommand(String name) {
        if (this.loadedCommands.isEmpty()) {
            this.loadedCommands = new ArrayList<String>();
        }
        this.loadedCommands.add(name);
    }

    private void addError(String msg) {
        switch (this.errors.size()) {
            case 0: {
                this.errors = Collections.singletonList(msg);
                break;
            }
            case 1: {
                this.errors = new ArrayList<String>(this.errors);
            }
            default: {
                this.errors.add(msg);
            }
        }
    }

    class ExtensionCommandsHandler
    extends CommandHandlerWithHelp {
        private static final String NAME = "extension-commands";
        private final ArgumentWithoutValue errorsArg;

        ExtensionCommandsHandler() {
            super(NAME);
            this.errorsArg = new ArgumentWithoutValue(this, "--errors");
        }

        @Override
        protected void doHandle(CommandContext ctx) throws CommandLineException {
            if (this.errorsArg.isPresent(ctx.getParsedCommandLine()) && !ExtensionsLoader.this.errors.isEmpty()) {
                StringBuilder buf = new StringBuilder();
                buf.append("The following problems were encountered while looking for additional commands in extensions:\n");
                for (int i = 0; i < ExtensionsLoader.this.errors.size(); ++i) {
                    String error = ExtensionsLoader.this.errors.get(i);
                    buf.append(i + 1).append(") ").append(error).append(Util.LINE_SEPARATOR);
                }
                ctx.printLine(buf.toString());
            }
        }
    }
}

