/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.remote;

import java.time.Duration;
import java.util.function.Function;
import org.infinispan.client.hotrod.RemoteCache;
import org.wildfly.clustering.cache.CacheEntryMutator;
import org.wildfly.clustering.cache.CacheEntryMutatorFactory;
import org.wildfly.clustering.cache.infinispan.remote.RemoteCacheEntryMutator;

public class RemoteCacheEntryMutatorFactory<K, V>
implements CacheEntryMutatorFactory<K, V> {
    private final RemoteCache<K, V> cache;
    private final Function<V, Duration> maxIdle;

    public RemoteCacheEntryMutatorFactory(RemoteCache<K, V> cache) {
        this(cache, null);
    }

    public RemoteCacheEntryMutatorFactory(RemoteCache<K, V> cache, Function<V, Duration> maxIdle) {
        this.cache = cache;
        this.maxIdle = maxIdle;
    }

    public CacheEntryMutator createMutator(K key, V value) {
        return this.maxIdle != null ? new RemoteCacheEntryMutator<K, V>(this.cache, key, value, () -> this.maxIdle.apply(value)) : new RemoteCacheEntryMutator<K, V>(this.cache, key, value);
    }
}

