/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.stateful.cache.distributable;

import jakarta.ejb.ConcurrentAccessTimeoutException;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.jboss.as.ejb3.component.stateful.cache.StatefulSessionBean;
import org.jboss.as.ejb3.component.stateful.cache.StatefulSessionBeanCache;
import org.jboss.as.ejb3.component.stateful.cache.StatefulSessionBeanInstance;
import org.jboss.as.ejb3.component.stateful.cache.StatefulSessionBeanInstanceFactory;
import org.jboss.as.ejb3.component.stateful.cache.distributable.DistributableStatefulSessionBean;
import org.jboss.as.ejb3.component.stateful.cache.distributable.DistributableStatefulSessionBeanCacheConfiguration;
import org.jboss.ejb.client.Affinity;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.ejb.bean.Bean;
import org.wildfly.clustering.ejb.bean.BeanInstance;
import org.wildfly.clustering.ejb.bean.BeanManager;

public class DistributableStatefulSessionBeanCache<K, V extends StatefulSessionBeanInstance<K>>
implements StatefulSessionBeanCache<K, V> {
    private static final Object UNSET = Boolean.TRUE;
    private final BeanManager<K, V> manager;
    private final StatefulSessionBeanInstanceFactory<V> factory;

    public DistributableStatefulSessionBeanCache(DistributableStatefulSessionBeanCacheConfiguration<K, V> configuration) {
        this.manager = configuration.getBeanManager();
        this.factory = configuration.getInstanceFactory();
    }

    public boolean isStarted() {
        return this.manager.isStarted();
    }

    public void start() {
        this.manager.start();
    }

    public void stop() {
        this.manager.stop();
    }

    public Affinity getStrongAffinity() {
        return this.manager.getStrongAffinity();
    }

    public Affinity getWeakAffinity(K id) {
        return this.manager.getWeakAffinity(id);
    }

    /*
     * Loose catch block
     */
    @Override
    public StatefulSessionBean<K, V> createStatefulSessionBean() {
        boolean newGroup;
        boolean bl = newGroup = CURRENT_GROUP.get() == null;
        if (newGroup) {
            CURRENT_GROUP.set(UNSET);
        }
        try {
            boolean close = true;
            Batch batch = (Batch)this.manager.getBatchFactory().get();
            try {
                StatefulSessionBeanInstance instance = (StatefulSessionBeanInstance)this.factory.createInstance();
                Object id = instance.getId();
                if (CURRENT_GROUP.get() == UNSET) {
                    CURRENT_GROUP.set(id);
                }
                Bean bean = this.manager.createBean((BeanInstance)instance, CURRENT_GROUP.get());
                DistributableStatefulSessionBean result = new DistributableStatefulSessionBean(bean, batch.suspend());
                close = false;
                DistributableStatefulSessionBean distributableStatefulSessionBean = result;
                return distributableStatefulSessionBean;
            }
            catch (Error | RuntimeException e) {
                batch.discard();
                throw e;
            }
            finally {
                if (close) {
                    batch.close();
                }
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (newGroup) {
                CURRENT_GROUP.remove();
            }
        }
    }

    @Override
    public StatefulSessionBean<K, V> findStatefulSessionBean(K id) {
        boolean close = true;
        Batch batch = (Batch)this.manager.getBatchFactory().get();
        try {
            Bean bean = this.manager.findBean(id);
            if (bean == null) {
                StatefulSessionBean<K, V> statefulSessionBean = null;
                return statefulSessionBean;
            }
            DistributableStatefulSessionBean result = new DistributableStatefulSessionBean(bean, batch.suspend());
            close = false;
            DistributableStatefulSessionBean distributableStatefulSessionBean = result;
            return distributableStatefulSessionBean;
        }
        catch (TimeoutException e) {
            throw new ConcurrentAccessTimeoutException(e.getMessage());
        }
        catch (Error | RuntimeException e) {
            batch.discard();
            throw e;
        }
        finally {
            if (close) {
                batch.close();
            }
        }
    }

    public int getActiveCount() {
        return this.manager.getActiveCount();
    }

    public int getPassiveCount() {
        return this.manager.getPassiveCount();
    }

    @Override
    public Supplier<K> getIdentifierFactory() {
        return this.manager.getIdentifierFactory();
    }

    @Override
    public boolean isRemotable(Throwable throwable) {
        return this.manager.isRemotable(throwable);
    }
}

