/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.jgroups.subsystem.AbstractProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.SocketProtocolResourceDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.RequirementServiceBuilder;
import org.jboss.as.network.ClientMapping;
import org.jboss.as.network.SocketBinding;
import org.jboss.dmr.ModelNode;
import org.jgroups.protocols.FD_SOCK;
import org.wildfly.clustering.jgroups.spi.ProtocolConfiguration;
import org.wildfly.clustering.jgroups.spi.ProtocolStackConfiguration;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ServiceDependency;

public class LegacyFailureDetectionProtocolResourceDefinition
extends SocketProtocolResourceDefinition<FD_SOCK> {
    public LegacyFailureDetectionProtocolResourceDefinition(String name, UnaryOperator<ResourceDescriptor> configurator, ResourceServiceConfigurator parentServiceConfigurator) {
        super(name, configurator, parentServiceConfigurator);
    }

    @Override
    public Map.Entry<Function<ProtocolConfiguration<FD_SOCK>, ProtocolConfiguration<FD_SOCK>>, Consumer<RequirementServiceBuilder<?>>> resolve(OperationContext context, ModelNode model) throws OperationFailedException {
        String bindingName = SocketProtocolResourceDefinition.Attribute.SOCKET_BINDING.resolveModelAttribute((ExpressionResolver)context, model).asStringOrNull();
        String clientBindingName = SocketProtocolResourceDefinition.Attribute.CLIENT_SOCKET_BINDING.resolveModelAttribute((ExpressionResolver)context, model).asStringOrNull();
        final ServiceDependency binding = bindingName != null ? ServiceDependency.on((UnaryServiceDescriptor)SocketBinding.SERVICE_DESCRIPTOR, (String)bindingName) : ServiceDependency.of(null);
        final ServiceDependency clientBinding = clientBindingName != null ? ServiceDependency.on((UnaryServiceDescriptor)SocketBinding.SERVICE_DESCRIPTOR, (String)clientBindingName) : ServiceDependency.of(null);
        return Map.entry(new UnaryOperator<ProtocolConfiguration<FD_SOCK>>(){

            @Override
            public ProtocolConfiguration<FD_SOCK> apply(ProtocolConfiguration<FD_SOCK> configuration) {
                return new AbstractProtocolResourceDefinition.ProtocolConfigurationDecorator<FD_SOCK>(configuration){

                    @Override
                    public FD_SOCK createProtocol(ProtocolStackConfiguration stackConfiguration) {
                        SocketBinding clientSocketBinding;
                        FD_SOCK protocol = (FD_SOCK)super.createProtocol(stackConfiguration);
                        SocketBinding socketBinding = (SocketBinding)binding.get();
                        protocol.setStartPort(socketBinding != null ? socketBinding.getAbsolutePort() : 0);
                        if (socketBinding != null) {
                            protocol.setBindAddress(socketBinding.getAddress());
                            List clientMappings = socketBinding.getClientMappings();
                            if (!clientMappings.isEmpty()) {
                                ClientMapping mapping = (ClientMapping)clientMappings.get(0);
                                try {
                                    protocol.setExternalAddress(InetAddress.getByName(mapping.getDestinationAddress()));
                                    protocol.setExternalPort(mapping.getDestinationPort());
                                }
                                catch (UnknownHostException e) {
                                    throw new IllegalArgumentException(e);
                                }
                            }
                        }
                        if ((clientSocketBinding = (SocketBinding)clientBinding.get()) != null) {
                            protocol.setClientBindPort(clientSocketBinding.getSocketAddress().getPort());
                        }
                        return protocol;
                    }

                    @Override
                    public Map<String, SocketBinding> getSocketBindings() {
                        SocketBinding clientSocketBinding;
                        TreeMap<String, SocketBinding> result = new TreeMap<String, SocketBinding>();
                        SocketBinding socketBinding = (SocketBinding)binding.get();
                        if (socketBinding != null) {
                            result.put("jgroups.fd_sock.srv_sock", socketBinding);
                        }
                        if ((clientSocketBinding = (SocketBinding)clientBinding.get()) != null) {
                            result.put("jgroups.fd.ping_sock", clientSocketBinding);
                        }
                        return result;
                    }
                };
            }
        }, binding.andThen((Consumer)clientBinding));
    }
}

