/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.validation;

import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ModuleNameValidator
extends ModelTypeValidator {
    public static final ParameterValidator INSTANCE = new ModuleNameValidator();
    private static final Predicate<String> MODULE_NAME_TESTER = Pattern.compile("(?:^\\w+|\\w+[\\.\\-]\\w+|\\w+\\Q\\:\\E\\w+)+(?:\\:(?:\\w+|\\w+[\\.\\-]\\w+))?$").asMatchPredicate();

    private ModuleNameValidator() {
        super(ModelType.STRING);
    }

    @Override
    public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
        String moduleName;
        super.validateParameter(parameterName, value);
        if (value.isDefined() && !MODULE_NAME_TESTER.test(moduleName = value.asString())) {
            throw ControllerLogger.MGMT_OP_LOGGER.invalidModuleNameParameter(parameterName, moduleName);
        }
    }
}

