/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.paging.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.core.paging.PagedMessage;
import org.apache.activemq.artemis.core.paging.impl.PagingStoreImpl;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.OperationContextImpl;
import org.apache.activemq.artemis.core.server.ActiveMQScheduledComponent;
import org.apache.activemq.artemis.core.server.RouteContextList;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.utils.ArtemisCloseable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageTimedWriter
extends ActiveMQScheduledComponent {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final PagingStoreImpl pagingStore;
    private final StorageManager storageManager;
    protected final List<PageEvent> pageEvents = new ArrayList<PageEvent>();
    protected volatile int pendingTasks = 0;
    protected final boolean syncNonTX;
    private final Semaphore writeCredits;
    private final int maxCredits;
    private static final AtomicIntegerFieldUpdater<PageTimedWriter> pendingTasksUpdater = AtomicIntegerFieldUpdater.newUpdater(PageTimedWriter.class, "pendingTasks");

    public boolean hasPendingIO() {
        return pendingTasksUpdater.get(this) > 0;
    }

    public PageTimedWriter(int writeCredits, StorageManager storageManager, PagingStoreImpl pagingStore, ScheduledExecutorService scheduledExecutor, Executor executor, boolean syncNonTX, long timeSync) {
        super(scheduledExecutor, executor, timeSync, TimeUnit.NANOSECONDS, true);
        this.pagingStore = pagingStore;
        this.storageManager = storageManager;
        this.syncNonTX = syncNonTX;
        this.writeCredits = new Semaphore(writeCredits);
        this.maxCredits = writeCredits;
    }

    public int getMaxCredits() {
        return this.maxCredits;
    }

    public synchronized void stop() {
        super.stop();
        this.processMessages();
    }

    public void incrementTask() {
        pendingTasksUpdater.incrementAndGet(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(OperationContext context, PagedMessage message, Transaction tx, RouteContextList listCtx) {
        if (!this.isStarted()) {
            throw new IllegalStateException("PageWriter Service is stopped");
        }
        int credits = Math.min(message.getEncodeSize() + 6, this.maxCredits);
        this.writeCredits.acquireUninterruptibly(credits);
        PageTimedWriter pageTimedWriter = this;
        synchronized (pageTimedWriter) {
            boolean replicated = this.storageManager.isReplicated();
            PageEvent event = new PageEvent(context, message, tx, listCtx, credits, replicated);
            context.storeLineUp();
            if (replicated) {
                context.replicationLineUp();
            }
            this.pageEvents.add(event);
            this.delay();
        }
    }

    private synchronized PageEvent[] extractPendingEvents() {
        if (this.pageEvents.isEmpty()) {
            return null;
        }
        PageEvent[] pendingsWrites = new PageEvent[this.pageEvents.size()];
        pendingsWrites = this.pageEvents.toArray(pendingsWrites);
        this.pageEvents.clear();
        return pendingsWrites;
    }

    public void run() {
        ArtemisCloseable closeable = this.storageManager.closeableReadLock(true);
        if (closeable == null) {
            logger.trace("Delaying PagedTimedWriter as it's currently locked");
            this.delay();
        } else {
            try {
                this.processMessages();
            }
            finally {
                closeable.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processMessages() {
        PageEvent[] pendingEvents = this.extractPendingEvents();
        if (pendingEvents == null) {
            return;
        }
        OperationContext beforeContext = OperationContextImpl.getContext();
        try {
            boolean requireSync = false;
            PageEvent[] pageEventArray = pendingEvents;
            int n = pageEventArray.length;
            for (int i = 0; i < n; ++i) {
                PageEvent event = pageEventArray[i];
                OperationContextImpl.setContext(event.context);
                this.pagingStore.directWritePage(event.message, false, event.replicated);
                if (event.tx == null && !this.syncNonTX) continue;
                requireSync = true;
            }
            if (requireSync) {
                this.performSync();
            }
        }
        catch (Exception e) {
            try {
                logger.warn(e.getMessage(), (Throwable)e);
                PageEvent[] pageEventArray = pendingEvents;
                int n = pageEventArray.length;
                for (int event = 0; event < n; ++event) {
                    PageEvent event2 = pageEventArray[event];
                    event2.context.onError(ActiveMQExceptionType.IO_ERROR.getCode(), String.valueOf(e.getClass()) + " during ioSync for paging on " + String.valueOf(this.pagingStore.getStoreName()) + ": " + e.getMessage());
                }
            }
            catch (Throwable throwable) {
                for (PageEvent event : pendingEvents) {
                    event.context.done();
                    pendingTasksUpdater.decrementAndGet(this);
                    this.writeCredits.release(event.credits);
                }
                OperationContextImpl.setContext(beforeContext);
                throw throwable;
            }
            for (PageEvent event : pendingEvents) {
                event.context.done();
                pendingTasksUpdater.decrementAndGet(this);
                this.writeCredits.release(event.credits);
            }
            OperationContextImpl.setContext(beforeContext);
        }
        for (PageEvent event : pendingEvents) {
            event.context.done();
            pendingTasksUpdater.decrementAndGet(this);
            this.writeCredits.release(event.credits);
        }
        OperationContextImpl.setContext(beforeContext);
    }

    protected void performSync() throws Exception {
        this.pagingStore.ioSync();
    }

    public static class PageEvent {
        final boolean replicated;
        final PagedMessage message;
        final OperationContext context;
        final RouteContextList listCtx;
        final Transaction tx;
        final int credits;

        PageEvent(OperationContext context, PagedMessage message, Transaction tx, RouteContextList listCtx, int credits, boolean replicated) {
            this.context = context;
            this.message = message;
            this.listCtx = listCtx;
            this.replicated = replicated;
            this.credits = credits;
            this.tx = tx;
        }
    }
}

