/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.batch.jberet.deployment;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentResourceSupport;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.wildfly.extension.batch.jberet._private.BatchLogger;
import org.wildfly.extension.batch.jberet.deployment.BatchAttachments;
import org.wildfly.extension.batch.jberet.deployment.BatchJobExecutionResource;
import org.wildfly.extension.batch.jberet.deployment.WildFlyJobOperator;

public class BatchDeploymentResourceProcessor
implements DeploymentUnitProcessor {
    private final String subsystemName;

    public BatchDeploymentResourceProcessor(String subsystemName) {
        this.subsystemName = subsystemName;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (deploymentUnit.hasAttachment(Attachments.MODULE) && !DeploymentTypeMarker.isType((DeploymentType)DeploymentType.EAR, (DeploymentUnit)deploymentUnit) && deploymentUnit.hasAttachment(Attachments.DEPLOYMENT_ROOT)) {
            BatchLogger.LOGGER.tracef("Processing deployment '%s' for the batch deployment resources.", deploymentUnit.getName());
            DeploymentResourceSupport deploymentResourceSupport = (DeploymentResourceSupport)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_RESOURCE_SUPPORT);
            WildFlyJobOperator jobOperator = (WildFlyJobOperator)deploymentUnit.getAttachment(BatchAttachments.JOB_OPERATOR);
            for (String jobName : jobOperator.getAllJobNames()) {
                try {
                    BatchLogger.LOGGER.debugf("Added job %s to allowed jobs for deployment %s", jobName, deploymentUnit.getName());
                    PathAddress jobAddress = PathAddress.pathAddress((String)"job", (String)jobName);
                    if (deploymentResourceSupport.hasDeploymentSubModel(this.subsystemName, jobAddress)) continue;
                    deploymentResourceSupport.registerDeploymentSubResource(this.subsystemName, jobAddress, (Resource)new BatchJobExecutionResource(jobOperator, jobName));
                }
                catch (Exception e) {
                    BatchLogger.LOGGER.debugf(e, "Batch jobs as an error occurred will not be registered for runtime views on the deployment (%s).", jobName, deploymentUnit.getName());
                }
            }
        }
    }
}

