/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.subsystem.resource.capability;

import java.util.Map;
import org.jboss.as.controller.AbstractAttributeDefinitionBuilder;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.subsystem.resource.ResourceModelResolver;
import org.wildfly.subsystem.resource.SimpleResource;
import org.wildfly.subsystem.resource.capability.CapabilityReference;
import org.wildfly.subsystem.resource.capability.CapabilityReferenceResolver;
import org.wildfly.subsystem.service.ServiceDependency;

public class CapabilityReferenceAttributeDefinition<T>
extends SimpleAttributeDefinition
implements ResourceModelResolver<ServiceDependency<T>> {
    private final CapabilityReferenceResolver<T> resolver;

    CapabilityReferenceAttributeDefinition(Builder<T> builder) {
        super(builder);
        this.resolver = builder.resolver;
    }

    @Override
    public ServiceDependency<T> resolve(OperationContext context, ModelNode model) throws OperationFailedException {
        String value = this.resolveModelAttribute(context, model).asStringOrNull();
        Map.Entry<String, String[]> resolved = this.resolver.resolve(context, new SimpleResource(model), value);
        return resolved != null ? ServiceDependency.on(resolved.getKey(), this.resolver.getRequirement().getType(), resolved.getValue()) : ServiceDependency.empty();
    }

    public static class Builder<T>
    extends AbstractAttributeDefinitionBuilder<Builder<T>, CapabilityReferenceAttributeDefinition<T>> {
        final CapabilityReferenceResolver<T> resolver;

        public Builder(String attributeName, CapabilityReference<T> reference) {
            super(attributeName, ModelType.STRING);
            this.setAllowExpression(false);
            this.setAttributeParser(AttributeParser.SIMPLE);
            this.setCapabilityReference(reference);
            this.setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES});
            this.setValidator((ParameterValidator)new StringLengthValidator(1));
            this.resolver = reference;
        }

        public Builder(String attributeName, CapabilityReferenceAttributeDefinition<T> basis) {
            super(attributeName, basis);
            this.resolver = basis.resolver;
        }

        public Builder<T> setDefaultValue(ModelNode defaultValue) {
            if (defaultValue != null && defaultValue.isDefined()) {
                throw new UnsupportedOperationException();
            }
            return this;
        }

        public Builder<T> setAllowExpression(boolean allowExpression) {
            if (allowExpression) {
                throw new UnsupportedOperationException();
            }
            return this;
        }

        public CapabilityReferenceAttributeDefinition<T> build() {
            return new CapabilityReferenceAttributeDefinition(this);
        }
    }
}

