/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameter;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.artemis.utils.SpawnedVMSupport;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSender;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.apache.activemq.transport.amqp.client.AmqpValidator;
import org.apache.qpid.proton.engine.Connection;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class AmqpNoHearbeatsTest
extends AmqpClientTestSupport {
    private static final int OK = 51;
    @Parameter(index=0)
    public boolean useOverride;

    @Parameters(name="useOverride={0}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({true}, {false});
    }

    @Override
    protected void addConfiguration(ActiveMQServer server) {
        if (this.useOverride) {
            server.getConfiguration().setConnectionTTLOverride(0L);
        } else {
            server.getConfiguration().setConnectionTtlCheckInterval(500L);
        }
    }

    @Override
    protected void configureAMQPAcceptorParameters(Map<String, Object> params) {
        if (!this.useOverride) {
            params.put("amqpIdleTimeout", "0");
        }
    }

    @TestTemplate
    @Timeout(value=60L)
    public void testHeartless() throws Exception {
        AmqpClient client = this.createAmqpClient();
        Assertions.assertNotNull((Object)client);
        client.setValidator(new AmqpValidator(){

            @Override
            public void inspectOpenedResource(Connection connection) {
                Assertions.assertEquals((int)0, (int)connection.getTransport().getRemoteIdleTimeout(), (String)"idle timeout was not disabled");
            }
        });
        AmqpConnection connection = this.addConnection(client.connect());
        Assertions.assertNotNull((Object)connection);
        connection.getStateInspector().assertValid();
        connection.close();
    }

    @TestTemplate
    @Timeout(value=60L)
    public void testCloseConsumerOnConnectionReset() throws Exception {
        AmqpMessage msg;
        int i;
        AmqpClient client = this.createAmqpClient();
        Assertions.assertNotNull((Object)client);
        client.setValidator(new AmqpValidator(){

            @Override
            public void inspectOpenedResource(Connection connection) {
                Assertions.assertEquals((int)0, (int)connection.getTransport().getRemoteIdleTimeout(), (String)"idle timeout was not disabled");
            }
        });
        AmqpConnection connection = this.addConnection(client.connect());
        Assertions.assertNotNull((Object)connection);
        connection.getStateInspector().assertValid();
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        Process p = SpawnedVMSupport.spawnVM((String)AmqpNoHearbeatsTest.class.getName(), (String[])new String[]{this.getTestName(), this.getQueueName()});
        Assertions.assertEquals((int)51, (int)p.waitFor());
        AmqpSender sender = session.createSender(this.getQueueName());
        for (i = 0; i < 10; ++i) {
            msg = new AmqpMessage();
            msg.setBytes(new byte[]{0});
            sender.send(msg);
        }
        receiver.flow(20);
        for (i = 0; i < 10; ++i) {
            msg = receiver.receive(1L, TimeUnit.SECONDS);
            Assertions.assertNotNull((Object)msg);
            msg.accept();
        }
    }

    public static void main(String[] arg) {
        if (arg.length == 2 && arg[0].startsWith("testCloseConsumerOnConnectionReset")) {
            try {
                String queueName = arg[1];
                AmqpClient client = new AmqpClient(new URI("tcp://127.0.0.1:5672?transport.soLinger=0"), null, null);
                AmqpConnection connection = client.connect();
                AmqpSession session = connection.createSession();
                AmqpReceiver receiver = session.createReceiver(queueName);
                receiver.flow(10);
                System.exit(51);
            }
            catch (Throwable e) {
                e.printStackTrace();
                System.exit(-1);
            }
        } else {
            System.err.println("Test " + arg[0] + " unknown");
            System.exit(-2);
        }
    }
}

