/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpReceiverDrainTest
extends AmqpClientTestSupport {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Test
    @Timeout(value=60L)
    public void testReceiverCanDrainMessagesQueue() throws Exception {
        this.doTestReceiverCanDrainMessages(false);
    }

    @Test
    @Timeout(value=60L)
    public void testReceiverCanDrainMessagesTopic() throws Exception {
        this.doTestReceiverCanDrainMessages(true);
    }

    private void doTestReceiverCanDrainMessages(boolean topic) throws Exception {
        String destinationName = topic ? this.getTopicName() : this.getQueueName();
        int MSG_COUNT = 20;
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createReceiver(destinationName);
        this.sendMessages(destinationName, MSG_COUNT);
        Queue queueView = this.getProxyToQueue(destinationName);
        Wait.assertEquals((long)MSG_COUNT, () -> ((Queue)queueView).getMessageCount());
        Wait.assertEquals((int)0, () -> ((Queue)queueView).getDeliveringCount());
        receiver.drain(MSG_COUNT);
        for (int i = 0; i < MSG_COUNT; ++i) {
            AmqpMessage message = receiver.receive(5L, TimeUnit.SECONDS);
            Assertions.assertNotNull((Object)message, (String)("Failed to read message: " + (i + 1)));
            logger.info("Read message: {}", (Object)message.getMessageId());
            message.accept();
        }
        receiver.close();
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testPullWithNoMessageGetDrainedQueue() throws Exception {
        this.doTestPullWithNoMessageGetDrained(false);
    }

    @Test
    @Timeout(value=60L)
    public void testPullWithNoMessageGetDrainedTopic() throws Exception {
        this.doTestPullWithNoMessageGetDrained(true);
    }

    private void doTestPullWithNoMessageGetDrained(boolean topic) throws Exception {
        String destinationName = topic ? this.getTopicName() : this.getQueueName();
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createReceiver(destinationName);
        receiver.flow(10);
        Queue queueView = this.getProxyToQueue(destinationName);
        Assertions.assertEquals((long)0L, (long)queueView.getMessageCount());
        Assertions.assertEquals((long)0L, (long)queueView.getMessagesAcknowledged());
        Assertions.assertEquals((int)10, (int)receiver.getReceiver().getRemoteCredit());
        Assertions.assertNull((Object)receiver.pull(1L, TimeUnit.SECONDS));
        Assertions.assertEquals((int)0, (int)receiver.getReceiver().getRemoteCredit());
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testPullOneFromRemoteQueue() throws Exception {
        this.doTestPullOneFromRemote(false);
    }

    @Test
    @Timeout(value=60L)
    public void testPullOneFromRemoteTopic() throws Exception {
        this.doTestPullOneFromRemote(true);
    }

    private void doTestPullOneFromRemote(boolean topic) throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        String destinationName = topic ? this.getTopicName() : this.getQueueName();
        AmqpReceiver receiver = session.createReceiver(destinationName);
        int MSG_COUNT = 20;
        this.sendMessages(destinationName, MSG_COUNT);
        Queue queueView = this.getProxyToQueue(destinationName);
        Assertions.assertEquals((long)MSG_COUNT, (long)queueView.getMessageCount());
        Assertions.assertEquals((int)0, (int)queueView.getDeliveringCount());
        Assertions.assertEquals((int)0, (int)receiver.getReceiver().getRemoteCredit());
        AmqpMessage message = receiver.pull(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)message);
        message.accept();
        Assertions.assertEquals((int)0, (int)receiver.getReceiver().getRemoteCredit());
        receiver.close();
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testMultipleZeroResultPullsQueue() throws Exception {
        this.doTestMultipleZeroResultPulls(false);
    }

    @Test
    @Timeout(value=60L)
    public void testMultipleZeroResultPullsTopic() throws Exception {
        this.doTestMultipleZeroResultPulls(true);
    }

    private void doTestMultipleZeroResultPulls(boolean topic) throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        String destinationName = topic ? this.getTopicName() : this.getQueueName();
        AmqpReceiver receiver = session.createReceiver(destinationName);
        receiver.flow(10);
        Queue queueView = this.getProxyToQueue(destinationName);
        Assertions.assertEquals((long)0L, (long)queueView.getMessageCount());
        Assertions.assertEquals((int)0, (int)queueView.getDeliveringCount());
        Assertions.assertEquals((int)10, (int)receiver.getReceiver().getRemoteCredit());
        Assertions.assertNull((Object)receiver.pull(1L, TimeUnit.SECONDS));
        Assertions.assertEquals((int)0, (int)receiver.getReceiver().getRemoteCredit());
        Assertions.assertNull((Object)receiver.pull(1L, TimeUnit.SECONDS));
        Assertions.assertNull((Object)receiver.pull(1L, TimeUnit.SECONDS));
        Assertions.assertEquals((int)0, (int)receiver.getReceiver().getRemoteCredit());
        connection.close();
    }
}

