/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.apache.qpid.jms.JmsConnectionFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MessageExpirationTest
extends ActiveMQTestBase {
    private static final int EXPIRATION = 1000;
    private ActiveMQServer server;
    private ClientSession session;
    private ClientSessionFactory sf;
    private ServerLocator locator;

    @Test
    public void testMessageExpiredWithoutExpiryAddress() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.session.createProducer(address);
        ClientMessage message = this.session.createMessage(false);
        message.setExpiration(System.currentTimeMillis() + 1000L);
        producer.send((org.apache.activemq.artemis.api.core.Message)message);
        Thread.sleep(2000L);
        this.session.start();
        ClientConsumer consumer = this.session.createConsumer(queue);
        ClientMessage message2 = consumer.receiveImmediate();
        Assertions.assertNull((Object)message2);
        consumer.close();
        this.session.deleteQueue(queue);
    }

    @Test
    public void testAmqpJmsReloaded() throws Exception {
        SimpleString queue = RandomUtil.randomSimpleString();
        SimpleString expiry = RandomUtil.randomSimpleString();
        this.server.createQueue(QueueConfiguration.of((SimpleString)queue).setRoutingType(RoutingType.ANYCAST));
        this.server.createQueue(QueueConfiguration.of((SimpleString)expiry));
        this.server.getAddressSettingsRepository().addMatch(queue.toString(), (Object)new AddressSettings().setExpiryAddress(expiry));
        JmsConnectionFactory cf = new JmsConnectionFactory("amqp://localhost:61616");
        Connection connection = cf.createConnection();
        Session session = connection.createSession();
        MessageProducer producer = session.createProducer((Destination)session.createQueue(queue.toString()));
        producer.setTimeToLive(1000L);
        for (int i = 0; i < 20; ++i) {
            Message message = session.createMessage();
            producer.send(message);
        }
        connection.close();
        Wait.assertEquals((Long)20L, () -> this.server.locateQueue(queue).getMessageCount(), (long)2000L, (long)100L);
        Wait.assertEquals((Long)0L, () -> this.server.locateQueue(expiry).getMessageCount(), (long)2000L, (long)100L);
        this.server.stop();
        this.server.start();
        Thread.sleep(2000L);
        Wait.assertEquals((Long)0L, () -> this.server.locateQueue(queue).getMessageCount(), (long)2000L, (long)100L);
        Wait.assertEquals((Long)20L, () -> this.server.locateQueue(expiry).getMessageCount(), (long)2000L, (long)100L);
        connection = cf.createConnection();
        session = connection.createSession();
        MessageConsumer consumer = session.createConsumer((Destination)session.createQueue(queue.toString()));
        connection.start();
        for (int i = 0; i < 20; ++i) {
            Message message2 = consumer.receiveNoWait();
            Assertions.assertNull((Object)message2);
        }
        consumer.close();
    }

    @Test
    public void testMessageExpiredWithoutExpiryAddressWithExpiryDelayOverride() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.close();
        this.session = this.addClientSession(this.sf.createSession(false, false, false));
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.session.createProducer(address);
        ClientMessage message = this.session.createMessage(false);
        AddressSettings addressSettings = new AddressSettings().setExpiryDelay(Long.valueOf(1000L));
        this.server.getAddressSettingsRepository().addMatch(address.toString(), (Object)addressSettings);
        producer.send((org.apache.activemq.artemis.api.core.Message)message);
        message = this.session.createMessage(false);
        message.setExpiration(System.currentTimeMillis() + 3000L);
        producer.send((org.apache.activemq.artemis.api.core.Message)message);
        this.session.commit();
        this.session.start();
        ClientConsumer consumer = this.session.createConsumer(queue);
        Assertions.assertNotNull((Object)consumer.receiveImmediate());
        Assertions.assertNotNull((Object)consumer.receiveImmediate());
        this.session.stop();
        this.session.rollback();
        Thread.sleep(2000L);
        this.session.start();
        Assertions.assertNotNull((Object)consumer.receiveImmediate());
        Assertions.assertNull((Object)consumer.receiveImmediate());
        this.session.stop();
        this.session.rollback();
        Thread.sleep(2000L);
        this.session.start();
        Assertions.assertNull((Object)consumer.receiveImmediate());
        consumer.close();
        this.session.deleteQueue(queue);
    }

    @Test
    public void testMessageExpirationOnServer() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.session.createProducer(address);
        ClientConsumer consumer = this.session.createConsumer(queue);
        ClientMessage message = this.session.createMessage(false);
        message.setExpiration(System.currentTimeMillis() + 1000L);
        producer.send((org.apache.activemq.artemis.api.core.Message)message);
        Thread.sleep(2000L);
        this.session.start();
        Thread.sleep(500L);
        Assertions.assertEquals((int)0, (int)((Queue)this.server.getPostOffice().getBinding(queue).getBindable()).getDeliveringCount());
        Assertions.assertEquals((int)0, (int)this.getMessageCount((Queue)this.server.getPostOffice().getBinding(queue).getBindable()));
        ClientMessage message2 = consumer.receiveImmediate();
        Assertions.assertNull((Object)message2);
        consumer.close();
        this.session.deleteQueue(queue);
    }

    @Test
    public void testMessageExpirationOnClient() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.session.createProducer(address);
        ClientMessage message = this.session.createMessage(false);
        message.setExpiration(System.currentTimeMillis() + 1000L);
        producer.send((org.apache.activemq.artemis.api.core.Message)message);
        this.session.start();
        Thread.sleep(2000L);
        ClientConsumer consumer = this.session.createConsumer(queue);
        ClientMessage message2 = consumer.receiveImmediate();
        Assertions.assertNull((Object)message2);
        Assertions.assertEquals((int)0, (int)((Queue)this.server.getPostOffice().getBinding(queue).getBindable()).getDeliveringCount());
        Assertions.assertEquals((int)0, (int)this.getMessageCount((Queue)this.server.getPostOffice().getBinding(queue).getBindable()));
        consumer.close();
        this.session.deleteQueue(queue);
    }

    @Test
    public void testMessageExpiredWithExpiryAddress() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        SimpleString expiryAddress = RandomUtil.randomSimpleString();
        SimpleString expiryQueue = RandomUtil.randomSimpleString();
        this.server.getAddressSettingsRepository().addMatch(address.toString(), (Object)new AddressSettings().setExpiryAddress(expiryAddress));
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(false)));
        this.session.createQueue(QueueConfiguration.of((SimpleString)expiryQueue).setAddress(expiryAddress).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.session.createProducer(address);
        ClientMessage message = this.session.createMessage(false);
        message.setExpiration(System.currentTimeMillis() + 1000L);
        producer.send((org.apache.activemq.artemis.api.core.Message)message);
        Thread.sleep(2000L);
        this.session.start();
        ClientConsumer consumer = this.session.createConsumer(queue);
        ClientMessage message2 = consumer.receiveImmediate();
        Assertions.assertNull((Object)message2);
        ClientConsumer expiryConsumer = this.session.createConsumer(expiryQueue);
        ClientMessage expiredMessage = expiryConsumer.receive(500L);
        Assertions.assertNotNull((Object)expiredMessage);
        Assertions.assertNotNull((Object)expiredMessage.getObjectProperty(org.apache.activemq.artemis.api.core.Message.HDR_ACTUAL_EXPIRY_TIME));
        Assertions.assertEquals((Object)address, (Object)expiredMessage.getObjectProperty(org.apache.activemq.artemis.api.core.Message.HDR_ORIGINAL_ADDRESS));
        Assertions.assertEquals((Object)queue, (Object)expiredMessage.getObjectProperty(org.apache.activemq.artemis.api.core.Message.HDR_ORIGINAL_QUEUE));
        consumer.close();
        expiryConsumer.close();
        this.session.deleteQueue(queue);
        this.session.deleteQueue(expiryQueue);
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(true);
        this.server.getConfiguration().addAcceptorConfiguration("amqp", "tcp://127.0.0.1:61616");
        this.server.getConfiguration().setResolveProtocols(true);
        this.server.getConfiguration().setMessageExpiryScanPeriod(200L);
        this.server.start();
        this.locator = this.createInVMNonHALocator();
        this.sf = this.createSessionFactory(this.locator);
        this.session = this.addClientSession(this.sf.createSession(false, true, true));
    }
}

