/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.bridge;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.apache.activemq.artemis.api.core.BroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.BroadcastGroupConfiguration;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.UDPBroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.BridgeConfiguration;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMConnectorFactory;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnectorFactory;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.cluster.Bridge;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class BridgeWithDiscoveryGroupStartTest
extends ActiveMQTestBase {
    private final boolean netty;
    private static final int TIMEOUT = 2000;

    @Parameters(name="isNetty={0}")
    public static Collection getParameters() {
        return Arrays.asList({true}, {false});
    }

    public BridgeWithDiscoveryGroupStartTest(boolean netty) {
        this.netty = netty;
    }

    protected boolean isNetty() {
        return this.netty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    public void testStartStop() throws Exception {
        HashMap<String, Object> server0Params = new HashMap<String, Object>();
        ActiveMQServer server0 = this.createClusteredServerWithParams(this.isNetty(), 0, true, server0Params);
        HashMap<String, Object> server1Params = new HashMap<String, Object>();
        if (this.isNetty()) {
            server1Params.put("port", 61617);
        } else {
            server1Params.put("serverId", 1);
        }
        ActiveMQServer server1 = this.createClusteredServerWithParams(this.isNetty(), 1, true, server1Params);
        ServerLocator locator = null;
        try {
            ClientMessage message;
            int i;
            ClientMessage message2;
            int i2;
            HashMap<String, TransportConfiguration> connectors = new HashMap<String, TransportConfiguration>();
            TransportConfiguration server0tc = new TransportConfiguration(this.getConnector(), server0Params);
            TransportConfiguration server1tc = new TransportConfiguration(this.getConnector(), server1Params);
            connectors.put(server1tc.getName(), server1tc);
            server0.getConfiguration().setConnectorConfigurations(connectors);
            String testAddress = "testAddress";
            String queueName0 = "queue0";
            String forwardAddress = "forwardAddress";
            String queueName1 = "queue1";
            String groupAddress = BridgeWithDiscoveryGroupStartTest.getUDPDiscoveryAddress();
            int port = BridgeWithDiscoveryGroupStartTest.getUDPDiscoveryPort();
            ArrayList<String> list = new ArrayList<String>();
            list.add(server1tc.getName());
            UDPBroadcastEndpointFactory endpoint = new UDPBroadcastEndpointFactory().setGroupAddress(groupAddress).setGroupPort(port);
            BroadcastGroupConfiguration bcConfig = new BroadcastGroupConfiguration().setName("bg1").setBroadcastPeriod(250L).setConnectorInfos(list).setEndpointFactory((BroadcastEndpointFactory)endpoint);
            server0.getConfiguration().getBroadcastGroupConfigurations().add(bcConfig);
            DiscoveryGroupConfiguration dcConfig = new DiscoveryGroupConfiguration().setName("dg1").setRefreshTimeout(5000L).setDiscoveryInitialWaitTimeout(5000L).setBroadcastEndpointFactory((BroadcastEndpointFactory)endpoint);
            server0.getConfiguration().getDiscoveryGroupConfigurations().put(dcConfig.getName(), dcConfig);
            String bridgeName = "bridge1";
            ArrayList<String> staticConnectors = new ArrayList<String>();
            staticConnectors.add(server1tc.getName());
            BridgeConfiguration bridgeConfiguration = new BridgeConfiguration().setName("bridge1").setQueueName("queue0").setForwardingAddress("forwardAddress").setRetryInterval(1000L).setReconnectAttempts(0).setReconnectAttemptsOnSameNode(0).setConfirmationWindowSize(1024).setStaticConnectors(staticConnectors);
            ArrayList<BridgeConfiguration> bridgeConfigs = new ArrayList<BridgeConfiguration>();
            bridgeConfigs.add(bridgeConfiguration);
            server0.getConfiguration().setBridgeConfigurations(bridgeConfigs);
            QueueConfiguration queueConfig0 = QueueConfiguration.of((String)"queue0").setAddress("testAddress");
            ArrayList<QueueConfiguration> queueConfigs0 = new ArrayList<QueueConfiguration>();
            queueConfigs0.add(queueConfig0);
            server0.getConfiguration().setQueueConfigs(queueConfigs0);
            QueueConfiguration queueConfig1 = QueueConfiguration.of((String)"queue1").setAddress("forwardAddress");
            ArrayList<QueueConfiguration> queueConfigs1 = new ArrayList<QueueConfiguration>();
            queueConfigs1.add(queueConfig1);
            server1.getConfiguration().setQueueConfigs(queueConfigs1);
            server1.start();
            server0.start();
            locator = ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{server0tc, server1tc});
            ClientSessionFactory sf0 = locator.createSessionFactory(server0tc);
            ClientSessionFactory sf1 = locator.createSessionFactory(server1tc);
            ClientSession session0 = sf0.createSession(false, true, true);
            ClientSession session1 = sf1.createSession(false, true, true);
            ClientProducer producer0 = session0.createProducer(SimpleString.of((String)"testAddress"));
            ClientConsumer consumer1 = session1.createConsumer("queue1");
            session1.start();
            int numMessages = 10;
            SimpleString propKey = SimpleString.of((String)"testkey");
            for (i2 = 0; i2 < 10; ++i2) {
                message2 = session0.createMessage(false);
                message2.putIntProperty(propKey, i2);
                producer0.send((Message)message2);
            }
            for (i2 = 0; i2 < 10; ++i2) {
                message2 = consumer1.receive(2000L);
                Assertions.assertNotNull((Object)message2);
                Assertions.assertEquals((Object)i2, (Object)message2.getObjectProperty(propKey));
                message2.acknowledge();
            }
            Assertions.assertNull((Object)consumer1.receiveImmediate());
            Bridge bridge = (Bridge)server0.getClusterManager().getBridges().get("bridge1");
            bridge.stop();
            bridge.flushExecutor();
            for (i = 0; i < 10; ++i) {
                message = session0.createMessage(false);
                message.putIntProperty(propKey, i);
                producer0.send((Message)message);
            }
            Assertions.assertNull((Object)consumer1.receiveImmediate());
            bridge.start();
            for (i = 0; i < 10; ++i) {
                message = consumer1.receive(2000L);
                Assertions.assertNotNull((Object)message);
                Assertions.assertEquals((Object)i, (Object)message.getObjectProperty(propKey));
                message.acknowledge();
            }
            Assertions.assertNull((Object)consumer1.receiveImmediate());
            session0.close();
            session1.close();
            sf0.close();
            sf1.close();
        }
        finally {
            if (locator != null) {
                locator.close();
            }
            server0.stop();
            server1.stop();
        }
    }

    private String getConnector() {
        if (this.isNetty()) {
            return NettyConnectorFactory.class.getName();
        }
        return InVMConnectorFactory.class.getName();
    }
}

